/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.keypad;

import io.reactivex.Observable;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.PublishSubject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TextFormatter;
import javafx.scene.image.ImageView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.Window;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.utils.AudioCaller;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.popupstage.MyPopupWindow;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.CloseImageButton;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ImageButton;
import net.sipsnet.client.utils.viewers.textfieldwithsearch.TextFieldWithSearch;
import net.sipsnet.client.views.chat.utils.IOnHidePane;

public class KeyPadPane {
    private final HBox top;
    private boolean isDarkTheme = true;
    private TextFieldWithSearch textField;
    private MyPopupWindow myPopupWindow;
    private final VBox vBox = new VBox();
    private IOnHidePane iOnHidePane;
    private KeyButton dialKey;
    private final boolean isHideWhenLostFocus;
    private boolean isMovable;
    private boolean isWithMainOwner;
    private PublishSubject<String> dtmfObserver;
    private Disposable disposableDTMF;
    protected final CompositeDisposable disposables = new CompositeDisposable();
    private final Map<String, KeyButton> keys = new HashMap<String, KeyButton>();

    public MyPopupWindow getMyPopupWindow() {
        return this.myPopupWindow;
    }

    public KeyPadPane(boolean isDarkTheme, boolean isHideWhenLostFocus) {
        this.isDarkTheme = isDarkTheme;
        this.isHideWhenLostFocus = isHideWhenLostFocus;
        this.top = this.getTop();
        this.vBox.setPadding(new Insets(15.0, 15.0, 15.0, 15.0));
        this.vBox.setMaxHeight(this.isDarkTheme ? 350.0 : 400.0);
        this.vBox.setMinHeight(this.vBox.getMaxHeight());
        this.setSize(210);
        this.vBox.getChildren().add(0, (Object)this.top);
        this.vBox.getChildren().add(1, (Object)this.getTextField());
        this.initDTMFObserver();
    }

    public void setSize(int value) {
        this.vBox.getChildren().clear();
        for (int i = 4; i >= (this.isDarkTheme ? 1 : 0); --i) {
            this.vBox.getChildren().add((Object)this.getLine(i, (float)value == 300.0f));
        }
        this.vBox.setMinWidth((double)value);
        this.vBox.setMaxWidth((double)value);
        this.vBox.setPrefWidth((double)value);
        this.vBox.setMinWidth(this.vBox.getMaxWidth());
    }

    public Pane getPane() {
        return this.vBox;
    }

    public void removeTopPane() {
        this.vBox.getChildren().remove((Object)this.top);
    }

    public void setWithMainOwner(boolean withMainOwner) {
        this.isWithMainOwner = withMainOwner;
    }

    public void show(Node pane) {
        this.createPopUp();
        if (this.isHideWhenLostFocus) {
            this.addToOpenedPopupsList();
        }
        if (this.textField != null) {
            ClientSingleton.getInstance().runLater(() -> this.textField.setFocusInTextField());
        }
        if (this.isDarkTheme) {
            this.myPopupWindow.showAutoPosition(pane);
        } else {
            this.myPopupWindow.show(pane, !this.isDarkTheme);
        }
    }

    public void show() {
        this.createPopUp();
        if (this.isHideWhenLostFocus) {
            this.addToOpenedPopupsList();
        }
        this.myPopupWindow.show();
        if (this.textField != null) {
            ClientSingleton.getInstance().runLater(() -> this.textField.setFocusInTextField());
        }
    }

    public void addToOpenedPopupsList() {
        if (this.myPopupWindow != null) {
            ClientSingleton.getInstance().addToOpenedPopupsList(this.myPopupWindow);
        }
    }

    public void removeFromOpenedPopupsList() {
        if (this.myPopupWindow != null) {
            ClientSingleton.getInstance().removeFromOpenedPopupsList(this.myPopupWindow);
        }
    }

    private void createPopUp() {
        if (this.myPopupWindow != null) {
            return;
        }
        this.myPopupWindow = MyPopupWindow.getNewInstance((Pane)this.vBox, (Window)(this.isWithMainOwner ? ClientSingleton.getInstance().getParentWindow() : new Stage())).setMaxWidth(this.vBox.getMaxWidth()).setMaxHeight(this.vBox.getMaxHeight());
        if (this.isMovable) {
            this.myPopupWindow.initMotionListeners((Node)this.top);
        }
    }

    public boolean isShowing() {
        if (this.myPopupWindow == null) {
            this.createPopUp();
        }
        return this.myPopupWindow.isShowing();
    }

    private HBox getTop() {
        HBox hBox = new HBox();
        hBox.prefWidthProperty().bind((ObservableValue)this.vBox.widthProperty().subtract(20));
        hBox.setAlignment(Pos.CENTER);
        ImageView ivAvatar = new ImageView();
        ClientSingleton.getInstance().setImageToImageView(ivAvatar, "notify_emblem.png");
        hBox.getChildren().add((Object)ivAvatar);
        HBox emptyBox = new HBox();
        HBox.setHgrow((Node)emptyBox, (Priority)Priority.ALWAYS);
        hBox.getChildren().add((Object)emptyBox);
        CloseImageButton closeImageButton = new CloseImageButton();
        closeImageButton.setSize(15, 20);
        closeImageButton.setBackgroundColor("transparent");
        closeImageButton.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> {
            if (this.iOnHidePane != null) {
                this.iOnHidePane.onHidePane();
            }
            this.textField.setText("");
            this.hide();
        }));
        hBox.getChildren().add((Object)closeImageButton);
        return hBox;
    }

    public TextFieldWithSearch getTextField() {
        this.textField = new TextFieldWithSearch();
        this.textField.prefWidthProperty().bind((ObservableValue)this.vBox.widthProperty().subtract(20));
        this.textField.setAlignment(Pos.CENTER);
        this.textField.setTextWidth(190);
        this.textField.setTextFontSize(18);
        this.textField.setTextFontColor(ClientSingleton.getInstance().getStyleValue(Constants.TAB_CELL_TEXT_FILL));
        this.textField.setTextFontFamily("Arial");
        this.textField.setBackgroundColor(ClientSingleton.getInstance().getStyleValue(Constants.BASE_COLOR));
        this.textField.setInputFilter((EventHandler<KeyEvent>)((EventHandler)event -> this.sendDigitOnNext(event.getCharacter())));
        this.textField.setCornerRadius(15);
        VBox.setMargin((Node)this.textField, (Insets)new Insets(15.0, 0.0, 10.0, 0.0));
        this.textField.addListener((ChangeListener<? super String>)((ChangeListener)(event, oldValue, newValue) -> {
            if (AudioCaller.hasConnectedOrConferenceLine() || this.dialKey == null) {
                return;
            }
            Object path = "keypad/";
            if (oldValue == null || oldValue.isEmpty() && !newValue.isEmpty()) {
                path = (String)path + "dialpad_dial_on";
            } else if (!oldValue.isEmpty() && newValue.isEmpty()) {
                path = (String)path + "dialpad_dial_off";
            }
            path = (String)path + ".png";
            if (!"keypad/.png".equals(path)) {
                this.dialKey.setImagePath((String)path);
            }
        }));
        KeyCodeCombination ctrlV = new KeyCodeCombination(KeyCode.V, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
        this.textField.setOnKeyPressedHandler((EventHandler<KeyEvent>)((EventHandler)arg_0 -> this.lambda$getTextField$5((KeyCombination)ctrlV, arg_0)));
        return this.textField;
    }

    private void addDigit(String digit) {
        this.textField.setText(this.textField.getText() + digit);
        this.textField.setCaretPosition();
        this.textField.setFocusInTextField();
    }

    public void sendDigit(String digit) {
        this.addDigit(digit);
        this.sendDigitOnNext(digit);
    }

    private HBox getLine(int i, boolean withMargin) {
        HBox line = new HBox();
        line.setAlignment(Pos.CENTER);
        line.prefWidthProperty().bind((ObservableValue)this.vBox.widthProperty().subtract(20));
        Object path = "keypad/";
        String id = "";
        switch (i) {
            case 4: {
                path = (String)path + "1";
                id = "1";
                break;
            }
            case 3: {
                path = (String)path + "4";
                id = "4";
                break;
            }
            case 2: {
                path = (String)path + "7";
                id = "7";
                break;
            }
            case 1: {
                path = (String)path + "star";
                id = "*";
                break;
            }
            case 0: {
                path = "";
            }
        }
        line.getChildren().add(((String)path).isEmpty() ? new EmptyButton() : new KeyButton((String)path, (String)path + "p", id));
        path = "keypad/";
        switch (i) {
            case 4: {
                path = (String)path + "2";
                id = "2";
                break;
            }
            case 3: {
                path = (String)path + "5";
                id = "5";
                break;
            }
            case 2: {
                path = (String)path + "8";
                id = "8";
                break;
            }
            case 1: {
                path = (String)path + "0";
                id = "0";
                break;
            }
            case 0: {
                path = (String)path + (this.isDarkTheme ? "dialpad_dial_on" : "dialpad_dial_off");
                id = "dial";
            }
        }
        KeyButton keyButton = new KeyButton((String)path, (String)path + "p", id);
        if (id.equals("dial")) {
            this.dialKey = keyButton;
        } else if (withMargin) {
            HBox.setMargin((Node)keyButton, (Insets)new Insets(0.0, 20.0, 0.0, 20.0));
        }
        line.getChildren().add((Object)keyButton);
        path = "keypad/";
        switch (i) {
            case 4: {
                path = (String)path + "3";
                id = "3";
                break;
            }
            case 3: {
                path = (String)path + "6";
                id = "6";
                break;
            }
            case 2: {
                path = (String)path + "9";
                id = "9";
                break;
            }
            case 1: {
                path = (String)path + "#";
                id = "#";
                break;
            }
            case 0: {
                path = "";
            }
        }
        line.getChildren().add(((String)path).isEmpty() ? new EmptyButton() : new KeyButton((String)path, (String)path + "p", id));
        return line;
    }

    public void hide() {
        if (this.myPopupWindow != null) {
            this.myPopupWindow.hide();
        }
    }

    public void setOnHideListener(IOnHidePane iOnHidePane) {
        this.iOnHidePane = iOnHidePane;
    }

    public void setMovable(boolean movable) {
        this.isMovable = movable;
    }

    public String getText() {
        return this.textField.getText();
    }

    private void sendDigitOnNext(String digit) {
        if (digit != null && !digit.isEmpty()) {
            this.dtmfObserver.onNext((Object)digit);
        }
    }

    public void setTextPropertyListener(ChangeListener<String> changeListener) {
        this.textField.getTextProperty().addListener(changeListener);
    }

    public void setTextFormatter(TextFormatter<String> textFormatter) {
        this.textField.setTextFormatter(textFormatter);
    }

    public void setDialButtonMode(boolean isVisible) {
        if (this.dialKey != null) {
            this.dialKey.setVisible(isVisible);
        }
    }

    private void initDTMFObserver() {
        this.dtmfObserver = PublishSubject.create();
        this.disposableDTMF = this.dtmfObserver.compose(ClientSingleton.getInstance().debounceTime(100L, TimeUnit.MILLISECONDS, Schedulers.computation(), v -> {})).subscribe(v -> this.disposables.add(Observable.just((Object)v).doOnError(Throwable::printStackTrace).flatMap(str -> {
            if (str.isEmpty()) {
                return Observable.empty();
            }
            return Observable.just((Object)str);
        }).subscribe(this::onLastDigitReceived)), Throwable::printStackTrace, () -> ClientSingleton.toLog(this.getClass().getSimpleName(), "Done  @ T=" + Schedulers.computation().now(TimeUnit.MILLISECONDS)));
    }

    public void onLastDigitReceived(String str) {
        char ch = str.charAt(str.length() - 1);
        if ((Character.isDigit(ch) || ch == '#' || ch == '*' || ch == '+') && AudioCaller.hasConnectedOrConferenceLine()) {
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                try {
                    ClientSingleton.toLog(this.getClass().getSimpleName(), "send digit : " + ch);
                    clientConnector.sendDigit(ch);
                }
                catch (Exception ex) {
                    ClientSingleton.toLog(this.getClass().getSimpleName(), "send digit error : " + ch);
                    ex.printStackTrace();
                }
            });
        }
    }

    public void dispose() {
        this.disposables.dispose();
        this.disposables.clear();
    }

    public void insertFromClipboard(boolean isFromMenu) {
        Clipboard clipboard = Clipboard.getSystemClipboard();
        ClientSingleton.toLog(this.getClass().getSimpleName(), "sendDigits clipboard= " + clipboard + " hasConnectedOrConferenceLine()=" + AudioCaller.hasConnectedOrConferenceLine());
        if (clipboard != null && clipboard.getString() != null) {
            String text = clipboard.getString().trim();
            if (AudioCaller.hasConnectedOrConferenceLine()) {
                this.textField.setText("");
                boolean isMatches = text.matches("\\d*");
                ClientSingleton.toLog(this.getClass().getSimpleName(), "sendDigits " + text + " isMatches = " + isMatches);
                if (!isMatches) {
                    char[] chars = text.toCharArray();
                    StringBuilder digits = new StringBuilder();
                    for (char chr : chars) {
                        if (!Character.isDigit(chr) && chr != '#' && chr != '*') continue;
                        digits.append(chr);
                    }
                    text = digits.toString();
                    ClientSingleton.toLog(this.getClass().getSimpleName(), "sendDigits " + text);
                }
                if (text.isEmpty() || text.length() > 14) {
                    return;
                }
                this.textField.setText(text);
                char[] charBuffer = text.toCharArray();
                TimerExecutor.getInstance().start(() -> {
                    for (char c : charBuffer) {
                        this.onLastDigitReceived(String.valueOf(c));
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                });
            } else if (isFromMenu) {
                this.textField.insertText(text);
            }
        }
    }

    private /* synthetic */ void lambda$getTextField$5(KeyCombination ctrlV, KeyEvent event) {
        String number;
        if (event.isControlDown() && event.getCode() == KeyCode.V || ctrlV.match(event)) {
            this.insertFromClipboard(false);
        } else if (!AudioCaller.hasConnectedOrConferenceLine() && event.getCode() == KeyCode.ENTER && (number = this.getText()) != null && !number.isEmpty()) {
            AudioCaller.makeCall(number);
            this.hide();
        }
    }

    class EmptyButton
    extends HBox {
        public EmptyButton() {
            this.setMinWidth(52.0);
            this.setMaxWidth(52.0);
            this.setMinHeight(52.0);
            this.setMaxHeight(52.0);
            HBox.setMargin((Node)this, (Insets)new Insets(5.0, 5.0, 5.0, 5.0));
        }
    }

    class KeyButton
    extends ImageButton {
        private final String ip;
        private final String ipCl;
        private long longPressStart = -1L;

        public KeyButton(String imagePath, String imagePathCl, String id) {
            KeyPadPane.this.keys.put(id, this);
            this.ip = imagePath + ".png";
            this.ipCl = imagePathCl + ".png";
            if (!"keypad/.png".equals(this.ip) && !"keypad/.png".equals(this.ipCl)) {
                super.setImagePath(this.ip, true);
                super.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
                    if ("0".equals(id) || "*".equals(id)) {
                        this.longPressStart = -1L;
                    }
                });
                super.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> {
                    if ("dial".equals(id)) {
                        String number = KeyPadPane.this.textField.getText();
                        if (!number.isEmpty()) {
                            AudioCaller.makeCall(number);
                            KeyPadPane.this.hide();
                        }
                    } else {
                        KeyPadPane.this.addDigit(id);
                        char ch = id.charAt(id.length() - 1);
                        if (ch >= '0' && ch <= '9' || ch == '#' || ch == '*' || KeyPadPane.this.isDarkTheme || ch == '+') {
                            KeyPadPane.this.keys.values().stream().filter(keyButton -> keyButton.getId() != null && String.valueOf(ch).equals(keyButton.getId())).findAny().ifPresent(KeyButton::splashButton);
                        }
                        if (AudioCaller.hasConnectedOrConferenceLine()) {
                            KeyPadPane.this.sendDigitOnNext(id);
                        }
                        if ("0".equals(id) || "*".endsWith(id)) {
                            this.longPressStart = System.currentTimeMillis();
                            TimerExecutor.getInstance().setMyAction(() -> {
                                if (this.longPressStart != -1L) {
                                    this.longPressStart = -1L;
                                    this.changeChar();
                                }
                            }).startWithDelayInGUIThread(1000L);
                        }
                    }
                });
                super.setId(id);
            }
            super.setBorderRadius(27);
            super.setIsRounded(true);
            HBox.setHgrow((Node)this, (Priority)Priority.ALWAYS);
            HBox.setMargin((Node)this, (Insets)new Insets(5.0, 5.0, 5.0, 5.0));
        }

        private void changeChar() {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "textField.getText()=" + KeyPadPane.this.textField.getText());
            if (KeyPadPane.this.textField.getText().endsWith("*") || KeyPadPane.this.textField.getText().endsWith("0")) {
                StringBuilder stringBuilder = new StringBuilder(KeyPadPane.this.textField.getText());
                char lastChar = stringBuilder.charAt(stringBuilder.length() - 1);
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                KeyPadPane.this.textField.setText(stringBuilder.toString());
                KeyPadPane.this.addDigit(lastChar == '0' ? "+" : ",");
            }
        }

        private void splashButton() {
            ClientSingleton.getInstance().runLater(() -> super.setImagePath(this.ipCl));
            TimerExecutor.getInstance().setMyAction(() -> super.setImagePath(this.ip)).startWithDelayInGUIThread(50L);
        }
    }
}

