/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.line;

import java.util.function.Consumer;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.utils.AudioCaller;
import smile.cti.client.LineInfo;

public class CallImageButton
extends Pane
implements EventHandler<MouseEvent> {
    public static final int TYPE_EMPTY = -1;
    public static final int TYPE_HANGUP = 0;
    public static final int TYPE_ANSWER_CALL = 1;
    public static final int TYPE_ANSWER_VIDEO_CALL = 2;
    private int currentType = 0;
    private LineInfo lineInfo;
    private final ImageView imageView;
    private final Consumer consumer;

    public CallImageButton(int currentType, String initImagePath) {
        this(currentType, initImagePath, null);
    }

    public CallImageButton(int currentType, String initImagePath, Consumer consumer) {
        this.currentType = currentType;
        this.consumer = consumer;
        this.imageView = new ImageView();
        ClientSingleton.getInstance().setImageToImageView(this.imageView, initImagePath);
        this.getChildren().add((Object)this.imageView);
        ClientSingleton.getInstance().setMouseCursor((Node)this.imageView);
        this.imageView.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)this);
    }

    public void setLineInfo(LineInfo lineInfo) {
        this.lineInfo = lineInfo;
    }

    public void setImageView(String imagePath) {
        ClientSingleton.getInstance().setImageToImageView(this.imageView, imagePath);
    }

    public void handle(MouseEvent mouseEvent) {
        switch (this.currentType) {
            case -1: {
                this.consumer.accept("");
                break;
            }
            case 0: {
                AudioCaller.dropCall(this.lineInfo);
                break;
            }
            case 1: 
            case 2: {
                AudioCaller.answerCall(this.lineInfo, this.currentType == 2);
            }
        }
    }
}

