/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.login;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.beans.property.Property;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.PasswordField;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import net.sipsnet.client.UserClient;
import net.sipsnet.client.click2dial.Click2Dial;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.WhiteLabels;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.MyUtils;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ImageButton;
import net.sipsnet.client.views.login.LoginUtils;
import net.sipsnet.client.views.mainview.MainViewSceneController;

public class LoginSceneControllerNew
implements Initializable {
    public ImageButton fx_CloseButton;
    public VBox fx_Splash;
    public Label fx_lbLoading;
    public Pane fx_progressBarPane;
    public ImageView fx_imgSetting;
    public ImageView fx_imgBack;
    public TextField fx_etDomain;
    public TextField fx_etProxy;
    public Button fx_btnNext;
    public StackPane fx_CenterStackPane;
    public VBox fx_vbDomainPane;
    public StackPane fx_ButtonsStackPane;
    public VBox fx_vbLoginPane;
    public Label lSettings;
    public Label fx_lRememberMe;
    public Label fx_lBack;
    public StackPane fx_vbCenterPane;
    public VBox fx_LoginPane;
    public HBox fx_hbRememberMe;
    public ImageView fx_ivBackground;
    public StackPane fx_LoginStack;
    @FXML
    private ImageView fx_imgLogo;
    @FXML
    private ImageView fx_imgLogoBottom;
    @FXML
    private TextField fx_etLogin;
    @FXML
    private TextField fx_etTextPass;
    @FXML
    private PasswordField fx_etPass;
    @FXML
    private Button fx_btnLogin;
    @FXML
    private ImageView fx_imgRememberMe;
    @FXML
    private ImageView fx_imgEye;
    @FXML
    private CheckBox fx_cbEye;
    @FXML
    private VBox fx_bpRoot;
    private boolean isSaveParams = false;
    private boolean isShowPassword = false;

    public void initialize(URL location, ResourceBundle resources) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "initialize start");
        this.fx_btnLogin.getStylesheets().add((Object)MyUtils.getResourceUrl(MainViewSceneController.class, "/extracss/myunselectedbutton.css"));
        this.fx_btnLogin.getStyleClass().add((Object)"buttonsStyleClass");
        Theme.getInstance().applyTo(Constants.LOGIN_BUTTON_BACKGROUND_STYLE, (Labeled)this.fx_btnLogin);
        ClientSingleton.getInstance().setMouseCursor((Node)this.fx_btnLogin);
        ClientSingleton.getInstance().setImageToImageView(this.fx_imgLogo, "main_emblem.png");
        ClientSingleton.getInstance().setImageToImageView(this.fx_imgLogoBottom, "bottom_emblem.png");
        ClientSingleton.getInstance().setMouseCursor((Node)this.fx_btnLogin);
        this.fx_btnLogin.setOnAction(e -> {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "lfx_btnLogin action");
            this.login();
        });
        this.fx_etPass.setOnAction(e -> this.login());
        this.fx_etLogin.setOnKeyPressed(event -> {
            if (event.getCode().equals((Object)KeyCode.ENTER)) {
                this.fx_etPass.requestFocus();
            }
        });
        this.isSaveParams = ClientSingleton.getInstance().isSaveConnectionParameters();
        if (this.isSaveParams) {
            Click2Dial.makeCall("");
            Optional<String> login = ClientSingleton.getInstance().getStringProperty("login");
            login.ifPresent(s -> this.fx_etLogin.setText(s));
            Optional<char[]> password = ClientSingleton.getInstance().getCharArrProperty("password");
            password.ifPresent(s -> this.fx_etPass.setText(String.valueOf(s)));
        }
        this.makeRememberMe();
        this.makeEye();
        ClientSingleton.getInstance().setMouseCursor((Node)this.fx_imgRememberMe);
        ClientSingleton.getInstance().setMouseCursor((Node)this.fx_lRememberMe);
        ClientSingleton.getInstance().setMouseCursor((Node)this.fx_hbRememberMe);
        this.fx_imgRememberMe.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            this.isSaveParams = !this.isSaveParams;
            this.makeRememberMe();
        });
        this.fx_lRememberMe.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            this.isSaveParams = !this.isSaveParams;
            this.makeRememberMe();
        });
        this.fx_hbRememberMe.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            this.isSaveParams = !this.isSaveParams;
            this.makeRememberMe();
        });
        ClientSingleton.getInstance().setMouseCursor((Node)this.fx_imgEye);
        this.fx_imgEye.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            this.isShowPassword = !this.isShowPassword;
            this.makeEye();
        });
        this.fx_etTextPass.setVisible(false);
        this.fx_etTextPass.textProperty().bindBidirectional((Property)this.fx_etPass.textProperty());
        ClientSingleton.getInstance().getStyle(Constants.LOGIN_BACKGROUND_STYLE).ifPresent(style -> this.fx_CloseButton.setBackgroundColor("-fx-background-color: transparent;"));
        ClientSingleton.getInstance().setImageToImageView(this.fx_CloseButton, "login/win_close.png");
        this.fx_CloseButton.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> UserClient.exitRingotel(false)));
        LoginUtils.setCaretSkin(this.fx_etLogin);
        LoginUtils.setCaretSkin((TextField)this.fx_etPass);
        ClientSingleton.getInstance().runLater(() -> this.fx_bpRoot.requestFocus());
        ClientSingleton.getInstance().setImageToImageView(this.fx_imgSetting, "login/ic_login_settings.png");
        ClientSingleton.getInstance().setMouseCursor((Node)this.fx_imgSetting);
        this.fx_imgSetting.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> this.switchPane(true));
        this.loadDomainScene();
        this.initSplashComponents();
        Theme.getInstance().applyTo(Constants.LOGIN_LABEL_TEXT_FILL, (Labeled)this.lSettings);
        Theme.getInstance().applyTo(Constants.LOGIN_LABEL_TEXT_FILL, (Labeled)this.fx_lRememberMe);
        Theme.getInstance().applyTo(Constants.LOGIN_LABEL_TEXT_FILL, (Labeled)this.fx_lBack);
        this.fx_lbLoading.setStyle("-fx-text-fill:" + ClientSingleton.getInstance().getStyleValue(Constants.PROGRESS_INDICATOR_STYLE));
        this.switchPane(false);
        Optional<String> optionalB = ClientSingleton.getInstance().getStyle(Constants.HAS_LOGIN_BACKGROUND_IMAGE);
        if (optionalB.isPresent() && "false".equals(optionalB.get())) {
            Theme.getInstance().applyTo(Constants.LOGIN_BACKGROUND_STYLE, (Pane)this.fx_bpRoot);
            this.fx_LoginStack.getChildren().remove((Object)this.fx_ivBackground);
        } else {
            ClientSingleton.getInstance().setBackgroundImage(this.fx_ivBackground, "login/ic_login_background.png");
        }
        ClientSingleton.toLog(this.getClass().getSimpleName(), "initialize done");
    }

    private void loadDomainScene() {
        this.fx_btnNext.getStylesheets().add((Object)MyUtils.getResourceUrl(MainViewSceneController.class, "/extracss/myunselectedbutton.css"));
        this.fx_btnNext.getStyleClass().add((Object)"buttonsStyleClass");
        Theme.getInstance().applyTo(Constants.LOGIN_BUTTON_BACKGROUND_STYLE, (Labeled)this.fx_btnNext);
        ClientSingleton.getInstance().setMouseCursor((Node)this.fx_btnNext);
        Optional<String> domain = ClientSingleton.getInstance().getStringProperty("domain");
        domain.ifPresent(s -> this.fx_etDomain.setText(s));
        Optional<String> proxy = ClientSingleton.getInstance().getStringProperty("proxy");
        proxy.ifPresent(s -> this.fx_etProxy.setText(s));
        ClientSingleton.getInstance().setImageToImageView(this.fx_imgBack, "login/ic_login_arrow_back.png");
        ClientSingleton.getInstance().setMouseCursor((Node)this.fx_imgBack);
        this.fx_imgBack.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> this.switchPane(false));
        ClientSingleton.getInstance().setMouseCursor((Node)this.fx_btnNext);
        this.fx_btnNext.setOnAction(e -> {
            if (!this.fx_etProxy.getText().isEmpty()) {
                ClientSingleton.getInstance().setProperty("proxy", this.fx_etProxy.getText().trim());
            }
            this.switchPane(false);
        });
        this.fx_etProxy.setOnAction(e -> this.fx_etProxy.requestFocus());
        this.fx_etDomain.setOnKeyPressed(event -> {
            if (event.getCode().equals((Object)KeyCode.ENTER)) {
                this.fx_etProxy.requestFocus();
            }
        });
        LoginUtils.setCaretSkin(this.fx_etDomain);
        LoginUtils.setCaretSkin(this.fx_etProxy);
        this.showSplashPane(null);
    }

    private void switchPane(boolean toDomainPane) {
        if (toDomainPane) {
            this.fx_CenterStackPane.getChildren().remove((Object)this.fx_vbLoginPane);
            this.fx_ButtonsStackPane.getChildren().remove((Object)this.fx_btnLogin);
            if (!this.fx_CenterStackPane.getChildren().contains((Object)this.fx_vbDomainPane)) {
                this.fx_CenterStackPane.getChildren().add((Object)this.fx_vbDomainPane);
                this.fx_ButtonsStackPane.getChildren().add((Object)this.fx_btnNext);
            }
        } else {
            this.fx_CenterStackPane.getChildren().remove((Object)this.fx_vbDomainPane);
            this.fx_ButtonsStackPane.getChildren().remove((Object)this.fx_btnNext);
            if (!this.fx_CenterStackPane.getChildren().contains((Object)this.fx_vbLoginPane)) {
                this.fx_CenterStackPane.getChildren().add((Object)this.fx_vbLoginPane);
                this.fx_ButtonsStackPane.getChildren().add((Object)this.fx_btnLogin);
            }
        }
    }

    public void hideSplashPane() {
        this.fx_LoginPane.setVisible(true);
        this.fx_vbCenterPane.getChildren().remove((Object)this.fx_Splash);
    }

    public void showSplashPane(Map<String, Object> data) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "loginData is not null " + (data != null));
        if (data != null) {
            if (!this.fx_vbCenterPane.getChildren().contains((Object)this.fx_Splash)) {
                this.fx_vbCenterPane.getChildren().add((Object)this.fx_Splash);
            }
            this.fx_LoginPane.setVisible(false);
            this.fx_CloseButton.setVisible(false);
            TimerExecutor.getInstance().setMyAction(() -> {
                String password = (String)data.get("password");
                String login = (String)data.get("login");
                Boolean isSave = (Boolean)data.get("isSave");
                ClientSingleton.getInstance().signIn(login, password, isSave);
            }).startWithDelay(500L);
        } else {
            this.fx_vbCenterPane.getChildren().remove((Object)this.fx_Splash);
            if (!this.fx_LoginPane.isVisible()) {
                this.fx_LoginPane.setVisible(false);
                this.fx_CloseButton.setVisible(false);
            }
        }
    }

    private void initSplashComponents() {
        ProgressIndicator progressIndicator = ClientSingleton.getInstance().getProgressIndicator();
        this.fx_progressBarPane.getChildren().add((Object)progressIndicator);
        this.fx_lbLoading.setText(ClientSingleton.getInstance().getResourceBundle().getString("loading"));
    }

    private void makeEye() {
        this.fx_etTextPass.setVisible(this.isShowPassword);
        this.fx_etPass.setVisible(!this.isShowPassword);
        String imgPath = this.isShowPassword ? (WhiteLabels.isCustomIcons() ? "custom_icons/ic_login_eye_crossed.png" : "login/ic_login_eye_crossed.png") : (WhiteLabels.isCustomIcons() ? "custom_icons/ic_login_eye.png" : "login/ic_login_eye.png");
        ClientSingleton.getInstance().setImageToImageView(this.fx_imgEye, imgPath);
    }

    private void makeRememberMe() {
        ClientSingleton.getInstance().setImageToImageView(this.fx_imgRememberMe, this.isSaveParams ? "login/ic_login_check_on.png" : "login/ic_login_check_off.png");
    }

    public void login() {
        if (!this.fx_etDomain.getText().isEmpty()) {
            ClientSingleton.getInstance().setProperty("domain", this.fx_etDomain.getText().trim());
        }
        String userName = this.fx_etLogin.getText() != null ? this.fx_etLogin.getText().trim() : "";
        String userPassword = this.fx_etPass.getText();
        System.out.println("login userName is empty " + userName.isEmpty() + " userPassword is empty " + userPassword.isEmpty());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("password", userPassword);
        map.put("login", userName);
        map.put("isSave", this.isSaveParams);
        this.showSplashPane(map);
    }

    public void showDomainPane() {
        Optional<String> proxy = ClientSingleton.getInstance().getStringProperty("proxy");
        proxy.ifPresent(s -> this.fx_etProxy.setText(s));
        this.switchPane(true);
    }

    public void showLoginPane() {
        this.isSaveParams = ClientSingleton.getInstance().isSaveConnectionParameters();
        this.fx_CloseButton.setVisible(true);
        if (this.isSaveParams && this.fx_etLogin.getText().isEmpty()) {
            Optional<String> login = ClientSingleton.getInstance().getStringProperty("login");
            login.ifPresent(s -> this.fx_etLogin.setText(s));
            Optional<char[]> password = ClientSingleton.getInstance().getCharArrProperty("password");
            password.ifPresent(s -> this.fx_etPass.setText(String.valueOf(s)));
            Optional<String> domain = ClientSingleton.getInstance().getStringProperty("domain");
            domain.ifPresent(s -> this.fx_etDomain.setText(s));
            Optional<String> proxy = ClientSingleton.getInstance().getStringProperty("proxy");
            proxy.ifPresent(s -> this.fx_etProxy.setText(s));
        }
    }
}

