/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.mainview;

import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.rxjavafx.observables.JavaFxObservable;
import io.reactivex.rxjavafx.schedulers.JavaFxScheduler;
import io.reactivex.subjects.PublishSubject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.Transition;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.embed.swing.SwingNode;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.util.Duration;
import javafx.util.Pair;
import javax.net.ssl.HttpsURLConnection;
import net.sipsnet.client.JXBrowserHelper;
import net.sipsnet.client.UserClient;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.WhiteLabels;
import net.sipsnet.client.connector.observer.IGUIObservable;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.connector.utils.AudioCaller;
import net.sipsnet.client.connector.utils.ClientUtil;
import net.sipsnet.client.connector.utils.JsonMessageParser;
import net.sipsnet.client.connector.utils.resources.ImageResource;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.constants.IntentConstants;
import net.sipsnet.client.utils.MyUtils;
import net.sipsnet.client.utils.mac_menubar.StandardMacApp;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.utils.splitpane.ISplitPaneDividerSlider;
import net.sipsnet.client.utils.splitpane.MySplitPaneDividerSlider;
import net.sipsnet.client.utils.ssl.TrustSSLProvider;
import net.sipsnet.client.utils.threadpool.MyThreadPoolManager;
import net.sipsnet.client.utils.threadpool.NotificationThreadPoolManager;
import net.sipsnet.client.utils.viewers.buttoncombobox.MenuImageButton;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ImageButton;
import net.sipsnet.client.views.activityviewer.ActivityViewerController;
import net.sipsnet.client.views.callactivity.CallActivityViewController;
import net.sipsnet.client.views.calldetails.CallDetailsViewController;
import net.sipsnet.client.views.callhistory.HistoryViewerController;
import net.sipsnet.client.views.calls.audiocallnotification.CallBasePane;
import net.sipsnet.client.views.calls.audiocallnotification.CallNotificationPane;
import net.sipsnet.client.views.calls.audiocontrolls.AssistanceLinePane;
import net.sipsnet.client.views.calls.audiocontrolls.LineInfoPane;
import net.sipsnet.client.views.calls.audiocontrolls.ParkingLinePane;
import net.sipsnet.client.views.calls.chatline.ICallLineState;
import net.sipsnet.client.views.calls.videocall.VideoProcessor;
import net.sipsnet.client.views.calls.videocall.notification.ShareDesktopPane;
import net.sipsnet.client.views.calls.videocall.videoscreen.IVCScreenController;
import net.sipsnet.client.views.calls.videocall.videoscreen.VideoPaneController;
import net.sipsnet.client.views.chat.ChatPaneWithFlowListController;
import net.sipsnet.client.views.chat.interfaces.IOnCloseViewer;
import net.sipsnet.client.views.emoji.utils.EmojiUtils;
import net.sipsnet.client.views.group.createeditgroup.GroupCreatorEditor;
import net.sipsnet.client.views.group.groupprofileviewer.GroupProfileViewController;
import net.sipsnet.client.views.mainview.ringtonemode.IRingtoneMuteState;
import net.sipsnet.client.views.notification.Notification;
import net.sipsnet.client.views.profiles.createcontact.CreateContactProfileController;
import net.sipsnet.client.views.profiles.profileedit.ProfileEditController;
import net.sipsnet.client.views.profiles.profilviewer.ProfileViewController;
import net.sipsnet.client.views.speeddial.AddToSpeedDial;
import net.sipsnet.client.views.tabs.TabBaseView;
import net.sipsnet.client.views.tabs.UpdateLists;
import net.sipsnet.client.views.tabs.calls.flow.TabCallsController;
import net.sipsnet.client.views.tabs.contacts.flow.ContactHeaderCellView;
import net.sipsnet.client.views.tabs.contacts.flow.TabContactsWithGroupController;
import net.sipsnet.client.views.tabs.menu.ILoadCustomPage;
import net.sipsnet.client.views.tabs.menu.TabMenuController;
import net.sipsnet.client.views.tabs.numpad.flow.TabNumpadController;
import net.sipsnet.client.views.tabs.searchwithtextflow.search.TabSearchViewWithTextFlow;
import net.sipsnet.client.views.tabs.sessions.flow.TabSessionsController;
import net.sipsnet.client.views.tabs.speeddial.flow.TabSpeedDialController;
import net.sipsnet.client.views.tabs.speeddial.flow.utils.SpeedDialHeader;
import net.sipsnet.client.views.tabs.utils.BaseCell;
import net.sipsnet.client.views.tabs.utils.INewMessagesNotification;
import net.sipsnet.client.views.tabs.utils.ISpeedDialTabActions;
import org.json.smile.JSONException;
import smile.cti.client.ClientConnector;
import smile.cti.client.ContactInfo;
import smile.cti.client.FileInfo;
import smile.cti.client.FileTransferListener;
import smile.cti.client.LineInfo;
import smile.cti.client.MessageInfo;
import smile.cti.client.SessionInfo;
import smile.util.Utils;

public class MainViewSceneController
implements Initializable,
IGUIObservable,
IVCScreenController,
ISplitPaneDividerSlider,
IOnCloseViewer,
INewMessagesNotification,
InvalidationListener,
ISpeedDialTabActions,
ICallLineState,
ILoadCustomPage,
IRingtoneMuteState {
    private static boolean isJXBrowserExists = false;
    public StackPane fx_MainStackPane;
    public HBox fx_progressBarPane;
    public HBox fx_MacTopButtonsPane;
    public HBox fx_WinTopButtonsPane;
    public StackPane fx_BackgroundStackPane;
    public HBox fx_hbTitle;
    public VBox fx_vbAssistantLine;
    @FXML
    public VBox fx_vbListTab;
    public ScrollPane fx_spActiveLines;
    public HBox fx_hbSearch;
    public Text fx_tSearch;
    public HBox fx_ContactsGroupName;
    public HBox fx_SelectionHeader;
    public HBox fx_SelectionFooter;
    private int currentTab = 3;
    private final int lastTab = 3;
    private TabContactsWithGroupController tabAutorizedContactsController;
    private TabContactsWithGroupController tabNotAutorizedContactsController;
    private TabSessionsController tabSessionsController;
    private TabCallsController tabCallsController;
    private TabMenuController tabTabMenuController;
    private TabSpeedDialController tabSpeedDialController;
    private TabSearchViewWithTextFlow tabSearchController;
    private ChatPaneWithFlowListController chatPaneController;
    private CallNotificationPane callNotificationPane;
    private VideoPaneController videoPaneController;
    private VideoProcessor videoProcessor;
    private AnchorPane hbChatList;
    private HBox hbCallList;
    private MySplitPaneDividerSlider myChatVideoSplitPaneSlider;
    private MySplitPaneDividerSlider myProfileSplitPaneSlider;
    private final int SMALL_CHAT_WIDTH = 350;
    private final int WIN_TOP_BUTTONS_PANE_WIDTH = 170;
    private final int WIN_TOP_BUTTONS_PANE_WIDTH_ = 150;
    private final int MAC_TOP_BUTTONS_PANE_WIDTH = 100;
    private double TEXT_EMBLEM_WIDTH = 0.0;
    private final int MAX_TEXT_EMBLEM_WIDTH = 130;
    private final String CHAT_VIDEO_SPLIT = "chatVideoSplit";
    private final String PROFILE_SPLIT = "profileSplit";
    private final String CHAT_TABS_SPLIT = "chatTabsSplit";
    private VBox menuPane;
    private ShareDesktopPane shareDesktopPane;
    private boolean canMakeCallFromSearchPane;
    private List<ParkingLinePane> parkLines = new ArrayList<ParkingLinePane>();
    public static boolean isWithSpeedCall = true;
    private WebView browser;
    private ProgressIndicator fx_pbLoadIndicator;
    private final String CREATE_CONTACT_EDITOR = "CREATE_CONTACT_EDITOR";
    private final SimpleStringProperty selectedItemId = new SimpleStringProperty("");
    private SwingNode swingNode;
    private ImageButton fx_MaxButton;
    private ImageButton fx_MinButton;
    private ImageButton fx_CloseButton;
    private PublishSubject<Boolean> notificationObserver;
    private Disposable disposableNotification;
    private final SimpleIntegerProperty currentViewMode = new SimpleIntegerProperty(-1);
    private HBox topButtonsPane;
    private ImageButton fx_imgTabNumpad;
    private ImageButton fx_imgTabSearch;
    private TabNumpadController tabNumpadController;
    private int lastViewedTab;
    private int lastViewPaneMode = -1;
    private SessionWaitingForAction sessionWaitingForAction;
    private ImageButton fx_SwitchView;
    private ProfileViewController profileViewController;
    private AssistanceLinePane assistantLinePane;
    private final SimpleBooleanProperty ringtoneMuteState = new SimpleBooleanProperty(false);
    private GroupProfileViewController groupProfileViewController;
    private ProgressIndicator progressIndicator;
    private CallDetailsViewController callDetailsViewController;
    private ImageButton fx_RefreshUrlButton;
    private final Animation hideSidebar = new Transition(){
        {
            this.setCycleDuration(Duration.millis((double)100.0));
        }

        protected void interpolate(double frac) {
            double curWidth = 310.0 * (1.0 - frac);
            MainViewSceneController.this.fx_spProfileListTab.setMaxWidth(curWidth);
            MainViewSceneController.this.fx_spProfileListTab.setMinWidth(curWidth);
            if (curWidth < 50.0) {
                MainViewSceneController.this.fx_spProfileListTab.setVisible(false);
            }
        }
    };
    private final Animation showSidebar = new Transition(){
        {
            this.setCycleDuration(Duration.millis((double)100.0));
        }

        protected void interpolate(double frac) {
            double curWidth = 310.0 * frac;
            if (curWidth > 50.0 && !MainViewSceneController.this.fx_spProfileListTab.isVisible()) {
                MainViewSceneController.this.fx_spProfileListTab.setVisible(true);
            }
            MainViewSceneController.this.fx_spProfileListTab.setMaxWidth(curWidth);
            MainViewSceneController.this.fx_spProfileListTab.setMinWidth(curWidth);
        }
    };
    private Pane selectedLine;
    @FXML
    public ImageView fx_imgTextLogo;
    @FXML
    public StackPane fx_hbTabMenu;
    @FXML
    public GridPane fx_gpTabsPane;
    @FXML
    public StackPane fx_hbTabSpeedDial;
    @FXML
    public StackPane fx_hbTabContact;
    @FXML
    public StackPane fx_hbTabSession;
    @FXML
    public StackPane fx_hbTabCall;
    @FXML
    public StackPane fx_hbTabContact_NA;
    @FXML
    public VBox fx_vbParksLines;
    @FXML
    public Label fx_lbParks;
    @FXML
    public VBox fx_vbIconsBox;
    @FXML
    public ImageButton fx_imgTabSpeedDial;
    private ResourceBundle resources;
    @FXML
    public HBox fx_spSearch;
    public SplitPane fx_ChatSplit;
    public SplitPane fx_ChatWithProfileSplit;
    @FXML
    public StackPane fx_spProfileListTab;
    @FXML
    public Pane fx_RootPane;
    @FXML
    public Pane fx_ShadowPane;
    @FXML
    public VBox fx_viewTabMenu;
    @FXML
    public HBox fx_IconsPane;
    public HBox fx_ProfilesView;
    public StackPane fx_spListTab;
    @FXML
    public ImageView fx_imgTabLogo;
    @FXML
    public VBox fx_vbActiveLines;
    @FXML
    public Label fx_lbActiveLines;
    @FXML
    public AnchorPane fx_vbLists;
    @FXML
    public ImageButton fx_imgTabMenu;
    @FXML
    public ImageButton fx_imgTabContact;
    @FXML
    public ImageButton fx_imgTabSession;
    @FXML
    public ImageButton fx_imgTabCall;
    @FXML
    public ImageButton fx_imgTabContact_NA;
    @FXML
    public Label fx_SessionsNewMessages;
    @FXML
    public Label fx_CallsNewMessages;
    @FXML
    public Label fx_lbTitle;
    @FXML
    public ImageView fx_ivSearch;
    @FXML
    public ImageView fx_ivSearchPhone;
    @FXML
    public MenuImageButton fx_ivCreateMenu;
    @FXML
    public TextField fx_tfSearch;
    @FXML
    public HBox fx_hbChatPane;
    public HBox fx_WithWebView;
    public StackPane fx_spWithWebView;
    public VBox fx_vbTabsTitle;
    public HBox fx_hbTopLogo;

    public static boolean isJXBrowserExists() {
        return isJXBrowserExists;
    }

    public static void setIsJXBrowserExists(boolean mode) {
        isJXBrowserExists = mode;
    }

    public int getCurrentViewMode() {
        return this.currentViewMode.get();
    }

    public SimpleIntegerProperty currentViewModeProperty() {
        return this.currentViewMode;
    }

    @Override
    public boolean isRingtoneMuted() {
        return this.ringtoneMuteState.get();
    }

    @Override
    public void setRingtoneMuteState(boolean ringtoneMuteState) {
        this.ringtoneMuteState.set(ringtoneMuteState);
    }

    public void removeLoadingPane() {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "removeLoadingPane");
        ClientSingleton.getInstance().runLater(() -> {
            if (this.fx_MainStackPane.getChildren().remove((Object)this.fx_progressBarPane)) {
                this.fx_progressBarPane.getChildren().clear();
            }
        });
    }

    public void addLoadingPane(String text) {
        ClientSingleton.getInstance().runLater(() -> {
            VBox pane = ClientUtil.getLoadingAnchorPane(text);
            this.fx_progressBarPane.getChildren().add((Object)pane);
            if (!this.fx_MainStackPane.getChildren().contains((Object)this.fx_progressBarPane)) {
                this.fx_MainStackPane.getChildren().add((Object)this.fx_progressBarPane);
            }
        });
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.resources = resources;
        ClientSingleton.toLog(this.getClass().getSimpleName(), "initialize start");
        this.addLoadingPane("Loading ...");
        this.ringtoneMuteState.addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                ClientSingleton.getInstance().getClientConnector().ifPresent(ClientConnector::stopPlayRing);
                if (this.chatPaneController != null) {
                    this.chatPaneController.setRingtoneMuteState();
                }
                ClientSingleton.getInstance().getLineInfoPanes().forEach(LineInfoPane::setRingtoneMuteState);
                if (this.callNotificationPane != null) {
                    this.callNotificationPane.setRingtoneMuteState();
                }
            }
        });
        this.fx_spProfileListTab.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
        this.fx_vbLists.setMinWidth(300.0);
        this.fx_vbLists.setMaxWidth(300.0);
        Theme.getInstance().applyTo(Constants.BASE_COLOR, (Pane)this.fx_IconsPane);
        Theme.getInstance().applyTo(Constants.BASE_COLOR, this.fx_RootPane);
        Theme.getInstance().applyTo(Constants.TABS_TITLE_TEXT_FILL, (Labeled)this.fx_lbTitle);
        Theme.getInstance().applyTo(Constants.TABS_SEARCH_BACKGROUND, (Pane)this.fx_spSearch);
        Theme.getInstance().applyTo(Constants.CALLS_PANES_AND_SEARCH_TEXT_FILL, (Control)this.fx_tfSearch);
        this.fx_RootPane.prefWidthProperty().bind((ObservableValue)this.fx_ShadowPane.widthProperty());
        this.fx_RootPane.prefHeightProperty().bind((ObservableValue)this.fx_ShadowPane.heightProperty());
        this.fx_RootPane.setStyle("-fx-border-radius: 12; -fx-background-radius: 12;");
        this.topButtonsPane = this.getTopButtonsPane();
        if (ClientUtil.getOS() == ClientUtil.OS.MAC) {
            this.fx_WinTopButtonsPane.prefWidthProperty().bind((ObservableValue)this.fx_MacTopButtonsPane.prefWidthProperty());
            this.topButtonsPane.prefHeightProperty().bind((ObservableValue)this.fx_MacTopButtonsPane.heightProperty());
            this.fx_MacTopButtonsPane.getChildren().add((Object)this.topButtonsPane);
            this.fx_MacTopButtonsPane.setPrefWidth(100.0);
        } else {
            this.fx_MacTopButtonsPane.prefWidthProperty().bind((ObservableValue)this.fx_WinTopButtonsPane.prefWidthProperty());
            this.topButtonsPane.prefHeightProperty().bind((ObservableValue)this.fx_WinTopButtonsPane.heightProperty());
            this.fx_WinTopButtonsPane.getChildren().add((Object)this.topButtonsPane);
            this.fx_WinTopButtonsPane.setPrefWidth(170.0);
        }
        this.fx_imgTabSearch = new ImageButton();
        this.fx_imgTabSearch.setButtonWidth(32);
        this.fx_imgTabSearch.setButtonHeight(32);
        this.fx_imgTabSearch.setIsRounded(true);
        this.fx_imgTabSearch.setBackgroundColor(Theme.getInstance().isDarkTheme() ? "transparent" : "white");
        HBox.setMargin((Node)this.fx_imgTabSearch, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
        this.fx_hbTitle.getChildren().add(1, (Object)this.fx_imgTabSearch);
        this.fx_imgTabNumpad = new ImageButton();
        this.fx_imgTabNumpad.setButtonWidth(32);
        this.fx_imgTabNumpad.setButtonHeight(32);
        this.fx_imgTabNumpad.setIsRounded(true);
        this.fx_imgTabNumpad.setBackgroundColor(Theme.getInstance().isDarkTheme() ? "transparent" : "white");
        HBox.setMargin((Node)this.fx_imgTabNumpad, (Insets)new Insets(0.0, 10.0, 0.0, 10.0));
        this.fx_hbTitle.getChildren().add(2, (Object)this.fx_imgTabNumpad);
        this.fx_spSearch.getChildren().remove((Object)this.fx_ivSearchPhone);
        this.fx_spSearch.getChildren().remove((Object)this.fx_tSearch);
        ClientSingleton.getInstance().setStyledTextControl(this.fx_tSearch, false, WhiteLabels.getCustomBlueColor(), 10, true);
        this.initActiveLinePanes();
        ImageResource imageResource = ClientSingleton.getInstance().getImageResourceFromResourcesFile("text_emblem.png");
        if (imageResource.getImage() == null) {
            imageResource = ClientSingleton.getInstance().getImageResourceFromResourcesFile("other/drag_grip_2.png");
        }
        if (imageResource.getImage() != null) {
            this.TEXT_EMBLEM_WIDTH = imageResource.getFitWidth();
            if (this.currentViewMode.get() == 1 && this.TEXT_EMBLEM_WIDTH > 130.0) {
                this.fx_imgTextLogo.setFitWidth(130.0);
            } else {
                this.fx_imgTextLogo.setFitWidth(imageResource.getFitWidth() - 30.0);
            }
            this.fx_imgTextLogo.setFitHeight(imageResource.getFitHeight());
            this.fx_imgTextLogo.setImage(imageResource.getImage());
        }
        ClientSingleton.getInstance().setImageToImageView(this.fx_imgTabLogo, "title_emblem.png");
        this.initImagesAndCreateMenu();
        this.currentViewMode.addListener((observable, oldValue, newValue) -> {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "onStart currentViewMode " + newValue);
            io.reactivex.Observable.just((Object)newValue).observeOn((Scheduler)JavaFxScheduler.platform()).subscribe(value -> {
                this.switchLinesViewMode();
                if (newValue.intValue() == 0) {
                    this.createChatPane();
                } else {
                    this.removeChatPane();
                }
                ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                    try {
                        clientConnector.setProperty(Constants.CURRENT_VIEW_MODE, newValue);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
                this.fx_RootPane.layout();
            }, Throwable::printStackTrace);
        });
        this.selectedLine = new Pane();
        String color = ClientSingleton.getInstance().getStyleValue(Constants.TABS_PANE_STYLE);
        if (!color.contains("css")) {
            Theme.getInstance().applyTo(Constants.TABS_PANE_STYLE, (Pane)this.fx_viewTabMenu);
        } else {
            this.fx_hbTopLogo.getStylesheets().add((Object)this.getClass().getResource(color).toExternalForm());
            this.fx_hbTopLogo.applyCss();
            this.fx_hbTopLogo.layout();
            this.fx_viewTabMenu.getStylesheets().add((Object)this.getClass().getResource(color).toExternalForm());
            this.fx_viewTabMenu.applyCss();
            this.fx_viewTabMenu.layout();
        }
        Theme.getInstance().applyTo(Constants.SELECTED_LINE_STYLE, this.selectedLine);
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "onStart clientConnector.getProperty(Constants.LAST_VISIBLE_TAB) " + clientConnector.getProperty(Constants.LAST_VISIBLE_TAB));
            if (clientConnector.getProperty(Constants.LAST_VISIBLE_TAB) != null) {
                this.currentTab = (Integer)clientConnector.getProperty(Constants.LAST_VISIBLE_TAB);
                if (this.currentTab == 6 || this.currentTab == 7) {
                    this.currentTab = 4;
                }
                this.lastViewedTab = this.currentTab;
            }
            this.initTabButtons();
            ClientSingleton.toLog(this.getClass().getSimpleName(), "onStart currentTab " + this.currentTab);
            int currentViewPaneMode = 0;
            if (clientConnector.getProperty(Constants.CURRENT_VIEW_MODE) != null) {
                currentViewPaneMode = (Integer)clientConnector.getProperty(Constants.CURRENT_VIEW_MODE);
            }
            ClientSingleton.toLog(this.getClass().getSimpleName(), "onStart currentViewPaneMode " + currentViewPaneMode);
            this.currentViewMode.set(currentViewPaneMode);
            if (currentViewPaneMode == 0) {
                SessionInfo sessionInfo = this.getLastVisibleSession();
                ClientSingleton.toLog(this.getClass().getSimpleName(), "onStart getLastVisibleSession " + sessionInfo);
                if (sessionInfo != null) {
                    this.setSelectedItemId(sessionInfo.getSessionId());
                    this.setSelectedSessionCell(true, sessionInfo, Constants.OPEN_SESSION_WITH_PROFILE);
                    this.openProfile(sessionInfo);
                }
            }
        });
        for (LineInfoPane lineInfoPane : ClientSingleton.getInstance().getLineInfoPanes()) {
            lineInfoPane.addCallLineStateListener(this);
            lineInfoPane.addRingtoneMuteStateListener(this);
        }
        this.fx_vbTabsTitle.heightProperty().addListener((observableValue, number, newValue) -> {
            double minHeight;
            if (this.currentTab == 6 && (minHeight = 450.0 + newValue.doubleValue() + this.fx_IconsPane.getMinHeight()) > ClientSingleton.getInstance().getParentWindow().getHeight()) {
                ClientSingleton.getInstance().getParentWindow().setHeight(minHeight);
            }
        });
        this.selectedLine.getStylesheets().clear();
        StackPane.setAlignment((Node)this.selectedLine, (Pos)Pos.CENTER_RIGHT);
        this.selectedLine.setMinHeight(35.0);
        this.selectedLine.setMaxHeight(35.0);
        this.selectedLine.setMinWidth(3.0);
        this.selectedLine.setMaxWidth(3.0);
        this.fx_vbActiveLines.getChildren().clear();
        this.initSearch();
        this.initObservable();
        this.initNotificationObserver();
        EmojiUtils.readEmojiJson();
        ClientSingleton.toLog(this.getClass().getSimpleName(), "initialize done");
        this.initFxBrowser();
    }

    public void initFxBrowser() {
        if (MainViewSceneController.isJXBrowserExists() && JXBrowserHelper.getInstance().getBrowserView() == null) {
            AtomicBoolean atomicBoolean = new AtomicBoolean(false);
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                List list = clientConnector.getCustomPages();
                ClientSingleton.toLog(this.getClass().getSimpleName(), "initialize. custom pages list " + list);
                atomicBoolean.set(list != null && !list.isEmpty());
            });
            ClientSingleton.toLog(this.getClass().getSimpleName(), "initialize. has custom pages " + atomicBoolean);
            if (atomicBoolean.get()) {
                TimerExecutor.getInstance().start(() -> {
                    try {
                        JXBrowserHelper.getInstance().initJXBrowser(null, () -> TimerExecutor.getInstance().startInGUI(() -> this.fx_spWithWebView.getChildren().remove((Object)this.fx_pbLoadIndicator)));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        MainViewSceneController.setIsJXBrowserExists(false);
                    }
                });
            }
        }
    }

    private void switchLinesViewMode() {
        if (!this.fx_vbActiveLines.getChildren().isEmpty()) {
            TimerExecutor.getInstance().setMyAction(() -> {
                this.fx_vbActiveLines.getChildren().stream().filter(node -> {
                    if (node instanceof LineInfoPane) {
                        LineInfoPane lineInfoPane = (LineInfoPane)node;
                        LineInfo lineInfo = lineInfoPane.getLineInfo();
                        ClientSingleton.toLog(this.getClass().getSimpleName(), "Switch currentViewMode to " + this.currentViewMode.get() + " lineInfo= " + lineInfo);
                        if (lineInfo != null) {
                            return lineInfo.getState() != 0 && lineInfo.getState() != 8 && lineInfo.getState() != 18;
                        }
                    }
                    return false;
                }).forEach(node -> ((LineInfoPane)node).switchViewMode(this.currentViewMode.get() == 1));
                this.fx_spActiveLines.layout();
            }).startWithDelayInGUIThread(200L);
        }
    }

    private void initActiveLinePanes() {
        int MAX_ACTIVE_LINES_PANE_HEIGHT = 280;
        this.fx_spActiveLines.minWidthProperty().bind((ObservableValue)this.fx_vbLists.minWidthProperty());
        this.fx_spActiveLines.maxWidthProperty().bind((ObservableValue)this.fx_vbLists.maxWidthProperty());
        this.fx_vbActiveLines.minWidthProperty().bind((ObservableValue)this.fx_spActiveLines.minWidthProperty().subtract(5));
        this.fx_vbActiveLines.maxWidthProperty().bind((ObservableValue)this.fx_spActiveLines.maxWidthProperty().subtract(5));
        this.fx_vbParksLines.minWidthProperty().bind((ObservableValue)this.fx_spActiveLines.minWidthProperty().subtract(5));
        this.fx_vbParksLines.maxWidthProperty().bind((ObservableValue)this.fx_spActiveLines.maxWidthProperty().subtract(5));
        this.fx_vbParksLines.getChildren().addListener(c -> ClientSingleton.toLog(this.getClass().getSimpleName(), "fx_vbParksLines.getChildren()=" + this.fx_vbParksLines.getChildren().size()));
        this.fx_vbAssistantLine.minWidthProperty().bind((ObservableValue)this.fx_spActiveLines.minWidthProperty().subtract(5));
        this.fx_vbAssistantLine.maxWidthProperty().bind((ObservableValue)this.fx_spActiveLines.minWidthProperty().subtract(5));
        this.fx_spActiveLines.setMaxHeight(280.0);
        this.fx_spActiveLines.setMinHeight(0.0);
        this.fx_spActiveLines.maxHeightProperty().bind((ObservableValue)this.fx_vbActiveLines.heightProperty());
        this.fx_spActiveLines.minHeightProperty().bind((ObservableValue)this.fx_vbActiveLines.heightProperty());
        Theme.getInstance().applyTo(Constants.SCROLL_PANE_STYLE, (Control)this.fx_spActiveLines);
        this.fx_spActiveLines.setVbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.fx_vbActiveLines.heightProperty().addListener((observable, oldValue, newValue) -> {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "CActiveLine height =" + newValue);
            if (newValue.intValue() > 280) {
                this.fx_spActiveLines.maxHeightProperty().unbind();
                this.fx_spActiveLines.minHeightProperty().unbind();
                this.fx_spActiveLines.setVbarPolicy(ScrollPane.ScrollBarPolicy.ALWAYS);
                this.fx_spActiveLines.setMinHeight(280.0);
                this.fx_spActiveLines.setMaxHeight(280.0);
            } else if (!this.fx_spActiveLines.maxHeightProperty().isBound()) {
                this.fx_spActiveLines.setMinHeight(0.0);
                this.fx_spActiveLines.maxHeightProperty().bind((ObservableValue)this.fx_vbActiveLines.heightProperty());
                this.fx_spActiveLines.minHeightProperty().bind((ObservableValue)this.fx_vbActiveLines.heightProperty());
                this.fx_spActiveLines.setVbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
            }
        });
        this.fx_vbActiveLines.getChildren().addListener(list -> {
            if (!this.fx_vbActiveLines.getChildren().isEmpty()) {
                this.removeAssistantLine();
            } else {
                ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                    if (ClientSingleton.getInstance().getCurrentClientState() == 8 && clientConnector.getConnectedDeviceInfo() != null) {
                        ClientSingleton.toLog(this.getClass().getSimpleName(), "CLIENT_STATE_CHANGED getConnectedDeviceInfo=" + clientConnector.getConnectedDeviceInfo());
                        this.addAssistantLine(true);
                    }
                });
            }
        });
    }

    @Override
    public boolean switchViewModeForBrowser() {
        if (this.currentViewMode.get() == 1) {
            this.switchViewMode();
            return true;
        }
        return false;
    }

    public void switchViewMode() {
        int mode = this.currentViewMode.get() == 1 ? 0 : 1;
        this.currentViewMode.set(mode);
    }

    public void reloadChatPane() {
        if (this.currentViewMode.get() == 0) {
            this.clearSelection();
        }
    }

    private void createChatPane() {
        this.fx_SwitchView.setImagePath(this.currentViewMode.get() != 0 ? "view_full.png" : "view_half.png");
        this.fx_SwitchView.setTooltip("compact_layout_off");
        if (this.TEXT_EMBLEM_WIDTH != 0.0 && this.fx_imgTextLogo.getFitWidth() != this.TEXT_EMBLEM_WIDTH) {
            this.fx_imgTextLogo.setFitWidth(this.TEXT_EMBLEM_WIDTH);
        }
        this.initChatVideoSplitPane();
        this.initProfileSplitPane();
        this.fx_spWithWebView.prefHeightProperty().bind((ObservableValue)ClientSingleton.getInstance().getParentWindow().heightProperty());
        this.fx_hbChatPane.prefHeightProperty().bind((ObservableValue)this.fx_spWithWebView.heightProperty());
        this.fx_ChatSplit.prefWidthProperty().bind((ObservableValue)this.fx_hbChatPane.widthProperty());
        this.fx_ChatSplit.prefHeightProperty().bind((ObservableValue)this.fx_hbChatPane.heightProperty());
        if (ClientUtil.getOS() == ClientUtil.OS.MAC) {
            this.fx_MacTopButtonsPane.setMinWidth(100.0);
        } else {
            this.fx_WinTopButtonsPane.setMinWidth(170.0);
        }
        ClientSingleton.getInstance().setMinWidth(0);
        LineInfo lineInfo = AudioCaller.getActiveLine();
        if (this.sessionWaitingForAction != null) {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "onStart waitingSessionInfo " + this.sessionWaitingForAction);
            this.setSelectedSessionCell(true, this.sessionWaitingForAction.getSessionInfo(), this.sessionWaitingForAction.getAction());
            this.sessionWaitingForAction = null;
        } else if (lineInfo != null && lineInfo.getSessionInfo() != null) {
            this.setSelectedSessionCell(true, lineInfo.getSessionInfo(), Constants.OPEN_SESSION_WITH_PROFILE);
        }
    }

    private void removeChatPane() {
        TabBaseView tabBaseView;
        this.fx_SwitchView.setImagePath(this.currentViewMode.get() != 0 ? "view_full.png" : "view_half.png");
        this.fx_SwitchView.setTooltip("compact_layout_on");
        if (this.TEXT_EMBLEM_WIDTH > 130.0) {
            this.fx_imgTextLogo.setFitWidth(130.0);
        }
        this.removeLoadingPane();
        this.removeWebView();
        this.closeProfileView();
        this.clearSelection();
        this.fx_spWithWebView.prefHeightProperty().unbind();
        this.fx_hbChatPane.prefHeightProperty().unbind();
        if (this.fx_ChatSplit != null) {
            this.fx_ChatSplit.prefWidthProperty().unbind();
            this.fx_ChatSplit.prefHeightProperty().unbind();
        }
        if ((tabBaseView = this.getTabBaseView()) != null) {
            tabBaseView.clearSelection();
        }
        if (this.chatPaneController != null) {
            this.chatPaneController.clearChatList();
        }
        if (ClientUtil.getOS() == ClientUtil.OS.MAC) {
            this.fx_MacTopButtonsPane.setPrefWidth(10.0);
        } else {
            this.fx_WinTopButtonsPane.setPrefWidth(10.0);
        }
        ClientSingleton.getInstance().setMinWidth(1);
        this.initChatVideoSplitPane();
        this.initProfileSplitPane();
        if (ClientUtil.getOS() == ClientUtil.OS.MAC) {
            this.fx_MacTopButtonsPane.setMinWidth(100.0);
        } else {
            this.fx_WinTopButtonsPane.setMinWidth(150.0);
        }
    }

    public void setCurrentTab() {
        this.initImagesAndCreateMenu(this.currentTab);
        this.initParkLines();
        this.checkNewMessages();
        this.shareDesktopPane = new ShareDesktopPane();
    }

    public boolean isShareDesktopPaneShowing() {
        return this.getVideoProcessor().isDesktopShowing();
    }

    private void hideShareDesktopPane() {
        if (this.shareDesktopPane == null) {
            this.shareDesktopPane = new ShareDesktopPane();
        } else if (this.shareDesktopPane.isShowing()) {
            this.shareDesktopPane.hide();
        }
    }

    private void showShareDesktopPane() {
        if (this.shareDesktopPane == null) {
            this.shareDesktopPane = new ShareDesktopPane();
        }
        this.shareDesktopPane.show();
    }

    public SessionInfo getLastVisibleSession() {
        AtomicReference sessionInfo = new AtomicReference();
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "onStart clientConnector.getProperty(Constants.LAST_VISIBLE_TAB) " + clientConnector.getProperty(Constants.LAST_VISIBLE_TAB));
            if (clientConnector.getProperty(Constants.LAST_VISIBLE_SESSION) != null) {
                String sessionId = clientConnector.getProperty(Constants.LAST_VISIBLE_SESSION).toString();
                ClientSingleton.toLog(this.getClass().getSimpleName(), "onStart sessionId " + sessionId);
                if (!sessionId.isEmpty()) {
                    sessionInfo.set(clientConnector.getSessionInfo(sessionId));
                }
            }
        });
        if (sessionInfo.get() == null) {
            TimerExecutor.getInstance().setMyAction(this::removeLoadingPane).startWithDelay(1000L);
        }
        return (SessionInfo)sessionInfo.get();
    }

    private void setSelectedSessionCell(boolean mode, SessionInfo sessionInfo, int openMode) {
        TimerExecutor.getInstance().setMyAction(() -> {
            if (sessionInfo != null) {
                if (mode) {
                    this.setSelectedSessionCell(false);
                }
                this.setSelectedItemId(sessionInfo.getSessionId());
            }
            this.setSelectedSessionCell(mode);
            if (sessionInfo != null) {
                this.openChatSession(sessionInfo, openMode, true);
            }
            ClientSingleton.getInstance().removeLoadingPane();
        }).startWithDelayInGUIThread(100L);
    }

    private void setSelectedSessionCell(boolean mode) {
        if (this.tabAutorizedContactsController != null) {
            this.tabAutorizedContactsController.setTabSelectedItem(mode);
        }
        if (this.tabNotAutorizedContactsController != null) {
            this.tabNotAutorizedContactsController.setTabSelectedItem(mode);
        }
        if (this.tabSessionsController != null) {
            this.tabSessionsController.setTabSelectedItem(mode);
        }
        if (this.tabCallsController != null) {
            this.tabCallsController.setTabSelectedItem(mode);
        }
    }

    private void initSplitPanes() {
        if (this.fx_ChatWithProfileSplit != null) {
            return;
        }
        this.fx_ChatWithProfileSplit = new SplitPane();
        HBox.setHgrow((Node)this.fx_ChatWithProfileSplit, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)this.fx_ChatWithProfileSplit, (Priority)Priority.ALWAYS);
        this.fx_ChatSplit = new SplitPane();
        HBox.setHgrow((Node)this.fx_ChatSplit, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)this.fx_ChatSplit, (Priority)Priority.ALWAYS);
        this.fx_ProfilesView = new HBox();
        this.fx_ProfilesView.setMaxWidth(0.0);
        this.fx_ProfilesView.setPadding(new Insets(0.0, 0.0, 0.0, 5.0));
        this.fx_ProfilesView.getChildren().addListener(change -> {
            if (this.fx_ProfilesView.getChildren().isEmpty()) {
                this.fx_ProfilesView.setMaxWidth(0.0);
            } else {
                this.fx_ProfilesView.setMaxWidth(50000.0);
            }
        });
        ClientSingleton.getInstance().setBackground((Pane)this.fx_ProfilesView, "chat/chat_background.png");
        this.fx_ChatWithProfileSplit.getItems().addAll((Object[])new Node[]{this.fx_ChatSplit, this.fx_ProfilesView});
        this.fx_ChatWithProfileSplit.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
    }

    private void initProfileSplitPane() {
        if (this.myProfileSplitPaneSlider != null) {
            return;
        }
        this.myProfileSplitPaneSlider = new MySplitPaneDividerSlider(this.fx_ChatWithProfileSplit, 0, MySplitPaneDividerSlider.Direction.RIGHT, this);
        this.myProfileSplitPaneSlider.setId("profileSplit");
        this.fx_hbChatPane.heightProperty().addListener((observableValue, oldValue, newValue) -> this.myProfileSplitPaneSlider.onResizeSplit());
        this.fx_hbChatPane.widthProperty().addListener((observableValue, oldValue, newValue) -> this.myProfileSplitPaneSlider.onResizeSplit());
        this.myProfileSplitPaneSlider.moveDividerToEndPosition();
    }

    public VideoProcessor getVideoProcessor() {
        if (this.videoProcessor == null) {
            this.videoProcessor = new VideoProcessor();
        }
        return this.videoProcessor;
    }

    private void initChatVideoSplitPane() {
        if (this.chatPaneController != null) {
            return;
        }
        ClientSingleton.getInstance().setBackgroundInCenter((Pane)this.fx_spWithWebView, "ic_welcome_picture.png");
        ClientSingleton.toLog(this.getClass().getSimpleName(), "initialize initChatVideoSplitPane work 0_0");
        this.initSplitPanes();
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fxml/chat/chatpanewithlist.fxml"));
        loader.setResources(this.resources);
        try {
            this.hbChatList = (AnchorPane)loader.load();
            this.hbChatList.setId("hbChatList");
            this.chatPaneController = (ChatPaneWithFlowListController)loader.getController();
            this.chatPaneController.addRingtoneMuteState(this);
            this.chatPaneController.setINewMessagesNotification(this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        loader = new FXMLLoader(this.getClass().getResource("/fxml/videopanewithchat/videochatpane.fxml"));
        loader.setResources(this.resources);
        try {
            this.hbCallList = (HBox)loader.load();
            this.hbCallList.setId("hbCallList");
            this.videoPaneController = (VideoPaneController)loader.getController();
            this.videoPaneController.setVideoProcessor(this.getVideoProcessor());
            this.getCallNotificationPane().setCheckNewMessagesNotification(this);
            this.hbCallList.prefHeightProperty().bind((ObservableValue)this.fx_ChatSplit.heightProperty());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ClientSingleton.toLog(this.getClass().getSimpleName(), "initialize initChatVideoSplitPane work 0_1");
        if (this.hbChatList != null && this.hbCallList != null) {
            this.fx_ChatSplit.getItems().addAll((Object[])new Node[]{this.hbCallList, this.hbChatList});
        }
        this.fx_ChatSplit.setVisible(false);
        this.myChatVideoSplitPaneSlider = new MySplitPaneDividerSlider(this.fx_ChatSplit, 0, MySplitPaneDividerSlider.Direction.RIGHT, this);
        this.myChatVideoSplitPaneSlider.setId("chatVideoSplit");
        this.myChatVideoSplitPaneSlider.initDividerOnStartPosition();
        this.fx_hbChatPane.heightProperty().addListener((observableValue, oldValue, newValue) -> this.myChatVideoSplitPaneSlider.onResizeSplit());
        this.fx_hbChatPane.widthProperty().addListener((observableValue, oldValue, newValue) -> this.myChatVideoSplitPaneSlider.onResizeSplit());
        this.videoPaneController.setIvcScreenController(this);
        this.videoPaneController.setLineInfo(AudioCaller.getActiveLine());
        if (this.videoPaneController != null && this.chatPaneController != null && this.chatPaneController.getSessionInfo() != null) {
            this.videoPaneController.setSessionInfo(this.chatPaneController.getSessionInfo());
        }
        if (this.chatPaneController != null) {
            this.chatPaneController.setIvcScreenController(this);
        }
        ClientSingleton.toLog(this.getClass().getSimpleName(), "initialize initChatVideoSplitPane work 0_10");
    }

    private void openChatSession(SessionInfo sessionInfo, boolean isMoveOnTop) {
        this.openChatSession(sessionInfo, Constants.OPEN_SESSION_WITH_PROFILE, isMoveOnTop);
    }

    private void openChatSession(SessionInfo sessionInfo, int openMode, boolean isMoveOnTop) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "openChatSession start");
        if (!this.fx_hbChatPane.getChildren().contains((Object)this.fx_ChatWithProfileSplit)) {
            this.fx_hbChatPane.getChildren().add((Object)this.fx_ChatWithProfileSplit);
            this.fx_ChatWithProfileSplit.prefWidthProperty().bind((ObservableValue)this.fx_hbChatPane.widthProperty());
        }
        if (this.hbChatList != null && this.hbCallList != null && !this.fx_ChatSplit.getItems().contains((Object)this.hbCallList)) {
            this.fx_ChatSplit.getItems().addAll((Object[])new Node[]{this.hbCallList, this.hbChatList});
        }
        try {
            if (this.chatPaneController == null) {
                this.initChatVideoSplitPane();
            }
            this.chatPaneController.openNewChat(sessionInfo);
            this.sendRead();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.openVideoPane(null);
        if (!this.fx_ChatSplit.isVisible()) {
            this.fx_ChatSplit.setVisible(true);
        }
        if (!this.fx_hbChatPane.isVisible()) {
            this.fx_hbChatPane.setVisible(true);
        }
        if (this.videoPaneController != null) {
            this.videoPaneController.setSessionInfo(sessionInfo);
        }
        if (isMoveOnTop) {
            this.viewToFront();
        }
        TimerExecutor.getInstance().setMyAction(() -> {
            if (openMode == Constants.OPEN_SESSION_WITH_PROFILE_EDITOR) {
                this.createProfileEditor((ContactInfo)sessionInfo.getParties().get(0));
            } else if (openMode == Constants.OPEN_SESSION_WITH_CALL_HISTORY) {
                this.openCallHistory(sessionInfo);
            } else if (openMode == Constants.OPEN_SESSION_WITH_ACTIVITY) {
                this.openCallActivity(sessionInfo);
            } else if (this.fx_ProfilesView.getChildren().isEmpty()) {
                if (this.chatPaneController != null && this.chatPaneController.getChatPaneWidth() >= 815.0) {
                    this.openProfile(sessionInfo);
                } else {
                    this.closeProfileView();
                }
            } else {
                this.openProfile(sessionInfo);
            }
            this.removeWebView();
            this.switchCallNotificationVisibility();
        }).startWithDelayInGUIThread(200L);
        ClientSingleton.toLog(this.getClass().getSimpleName(), "openChatSession done ClientSingleton.getInstance().isFocused() " + ClientSingleton.getInstance().isFocused());
    }

    private void openVideoPane(LineInfo lineInfo) {
        if (this.chatPaneController == null || this.myChatVideoSplitPaneSlider == null) {
            return;
        }
        if (lineInfo == null) {
            lineInfo = AudioCaller.getActiveLine();
        }
        if (lineInfo != null) {
            SessionInfo sessionInfo1 = ClientSingleton.getInstance().getSessionInfo(lineInfo);
            if (sessionInfo1 != null) {
                if (ClientSingleton.getInstance().isMyVideoEnabledFlag(lineInfo)) {
                    if (this.chatPaneController.equalsCurrentSessionInfo(sessionInfo1)) {
                        ClientSingleton.getInstance().runLater(() -> this.myChatVideoSplitPaneSlider.moveDividerToEndPosition());
                    } else {
                        this.myChatVideoSplitPaneSlider.moveDividerToStartPosition();
                    }
                } else {
                    this.myChatVideoSplitPaneSlider.moveDividerToStartPosition();
                }
            } else {
                this.myChatVideoSplitPaneSlider.moveDividerToStartPosition();
            }
        } else {
            this.myChatVideoSplitPaneSlider.moveDividerToStartPosition();
        }
    }

    private void addTabMenuController() {
        if (this.tabTabMenuController == null) {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fxml/profiles/userprofile.fxml"));
            loader.setResources(this.resources);
            try {
                this.menuPane = (VBox)loader.load();
                this.tabTabMenuController = (TabMenuController)loader.getController();
                this.menuPane.prefHeightProperty().bind((ObservableValue)this.fx_RootPane.prefHeightProperty());
                this.menuPane.prefHeightProperty().bind((ObservableValue)this.fx_RootPane.heightProperty());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.tabTabMenuController.setILoadCustomPage(this);
        }
        this.setClientStateInMenuTab();
        if (this.fx_spProfileListTab.getChildren().size() == 1) {
            if (this.menuPane.getOpacity() == 0.0) {
                this.menuPane.setOpacity(1.0);
            }
            this.addPaneToLists((Pane)this.menuPane);
        }
    }

    private void addPaneToLists(Pane pane) {
        FadeTransition ft;
        if (this.fx_spProfileListTab.getChildren().size() > 1) {
            ft = new FadeTransition(Duration.millis((double)100.0), (Node)this.menuPane);
            ft.setFromValue(1.0);
            ft.setToValue(0.0);
            ft.play();
            this.fx_spProfileListTab.getChildren().remove((Object)this.menuPane);
        }
        this.fx_vbLists.getChildren().clear();
        this.fx_vbLists.getChildren().add((Object)pane);
        AnchorPane.setLeftAnchor((Node)pane, (Double)0.0);
        AnchorPane.setTopAnchor((Node)pane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)pane, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)pane, (Double)0.0);
        if (pane.getOpacity() != 1.0 && pane instanceof TabSpeedDialController) {
            ft = new FadeTransition(Duration.millis((double)500.0), (Node)pane);
            ft.setFromValue(0.0);
            ft.setToValue(1.0);
            ft.play();
        }
    }

    private void addCallsList() {
        if (this.tabCallsController == null) {
            this.tabCallsController = new TabCallsController(this);
        }
        this.tabCallsController.switchToCallsTab();
        this.addPaneToLists((Pane)this.tabCallsController);
    }

    private void addSessionsList() {
        if (this.tabSessionsController == null) {
            this.tabSessionsController = new TabSessionsController(this);
        }
        this.tabSessionsController.updateList();
        this.addPaneToLists((Pane)this.tabSessionsController);
    }

    private void addAutorizedContactsList() {
        if (this.tabAutorizedContactsController == null) {
            this.tabAutorizedContactsController = new TabContactsWithGroupController(this, 1);
        }
        this.tabAutorizedContactsController.setContactsList();
        this.addPaneToLists((Pane)this.tabAutorizedContactsController);
    }

    private void addNotAutorizedContactsList() {
        if (this.tabNotAutorizedContactsController == null) {
            this.tabNotAutorizedContactsController = new TabContactsWithGroupController(this, 2);
        }
        this.tabNotAutorizedContactsController.setContactsList();
        this.addPaneToLists((Pane)this.tabNotAutorizedContactsController);
    }

    private void addSpeedDialList() {
        if (this.tabSpeedDialController == null) {
            this.tabSpeedDialController = new TabSpeedDialController();
        }
        this.tabSpeedDialController.refreshList();
        this.addPaneToLists((Pane)this.tabSpeedDialController);
    }

    private void addNumpadList() {
        if (this.tabNumpadController == null) {
            this.tabNumpadController = new TabNumpadController(this);
        }
        this.addPaneToLists((Pane)this.tabNumpadController);
        this.tabNumpadController.setFocus();
    }

    private void addSearchList() {
        if (this.tabSearchController == null) {
            this.tabSearchController = new TabSearchViewWithTextFlow(() -> this.fx_tfSearch.getText(), () -> ClientSingleton.getInstance().runLater(this::removeSearchProgressIndicator), this);
        }
        this.addPaneToLists((Pane)this.tabSearchController);
        this.currentTab = 7;
    }

    private void removeSearchProgressIndicator() {
        this.fx_hbSearch.getChildren().remove((Object)this.progressIndicator);
        if (!this.fx_hbSearch.getChildren().contains((Object)this.fx_ivSearch)) {
            this.fx_hbSearch.getChildren().add(0, (Object)this.fx_ivSearch);
        }
    }

    public int getCurrentTab() {
        return this.currentTab;
    }

    public void initImagesAndCreateMenu(int currentTab) {
        this.fx_hbTabContact.getChildren().remove((Object)this.selectedLine);
        this.fx_hbTabContact_NA.getChildren().remove((Object)this.selectedLine);
        this.fx_hbTabSession.getChildren().remove((Object)this.selectedLine);
        this.fx_hbTabCall.getChildren().remove((Object)this.selectedLine);
        this.fx_hbTabSpeedDial.getChildren().remove((Object)this.selectedLine);
        TabBaseView tabBaseView = this.getTabBaseView();
        if (tabBaseView != null) {
            if (tabBaseView instanceof TabContactsWithGroupController) {
                this.setContactsGroupView(null);
                ((TabContactsWithGroupController)tabBaseView).saveScrollPosition();
            }
            if (!this.fx_tfSearch.getText().isEmpty()) {
                tabBaseView.updateList();
                this.fx_tfSearch.setText("");
            } else if (this.currentTab != currentTab) {
                tabBaseView.disposeTab();
            }
        } else {
            this.fx_tfSearch.setText("");
            if (this.chatPaneController != null) {
                this.chatPaneController.refreshCellsBackground();
            }
            if (this.currentTab == 7 && this.tabSearchController != null) {
                this.tabSearchController.disposeTab();
            }
            if (!this.fx_hbSearch.getChildren().contains((Object)this.fx_ivSearch)) {
                this.fx_hbSearch.getChildren().clear();
                this.fx_hbSearch.getChildren().add(0, (Object)this.fx_ivSearch);
            } else if (this.fx_ivSearch.getFitWidth() != 16.0) {
                this.setSearchImage();
            }
        }
        if (this.currentTab != currentTab) {
            if (this.currentTab == 7) {
                this.setSearchImage();
                if (this.tabSearchController != null) {
                    this.tabSearchController.setHeadersCollapse();
                }
            } else if (currentTab == 7) {
                this.addClearSearchImage();
            }
        }
        this.currentTab = currentTab;
        StackPane currentParent = null;
        switch (currentTab) {
            case 1: {
                this.fx_lbTitle.setText(this.resources.getString("contacts_users"));
                currentParent = this.fx_hbTabContact;
                this.addAutorizedContactsList();
                break;
            }
            case 2: {
                this.fx_lbTitle.setText(this.resources.getString("tab_contacts"));
                currentParent = this.fx_hbTabContact_NA;
                this.addNotAutorizedContactsList();
                break;
            }
            case 3: {
                this.fx_lbTitle.setText(this.resources.getString("tab_sessions"));
                currentParent = this.fx_hbTabSession;
                this.addSessionsList();
                break;
            }
            case 4: {
                this.fx_lbTitle.setText(this.resources.getString("tab_calls"));
                currentParent = this.fx_hbTabCall;
                this.addCallsList();
                break;
            }
            case 0: {
                currentParent = this.fx_hbTabMenu;
                this.addTabMenuController();
                break;
            }
            case 5: {
                this.fx_lbTitle.setText(this.resources.getString("tab_speed_dial"));
                currentParent = this.fx_hbTabSpeedDial;
                this.addSpeedDialList();
                break;
            }
            case 6: {
                this.fx_lbTitle.setText(this.resources.getString("tab_numpad_dial"));
                this.addNumpadList();
                break;
            }
            case 7: {
                this.fx_lbTitle.setText(this.resources.getString("filter"));
                this.addSearchList();
                break;
            }
            default: {
                this.fx_lbTitle.setText("");
            }
        }
        if (currentTab != 4 && this.tabCallsController != null) {
            this.tabCallsController.removeMultiSelectionMode();
        }
        if (currentTab != 2 && this.tabNotAutorizedContactsController != null) {
            this.tabNotAutorizedContactsController.removeMultiSelectionMode();
        }
        if (currentTab == 0) {
            this.fx_vbTabsTitle.getChildren().remove((Object)this.fx_hbTitle);
            this.fx_vbTabsTitle.getChildren().remove((Object)this.fx_spSearch);
            this.addPaneToParent((Pane)currentParent, (Node)this.selectedLine);
        } else {
            if (!this.fx_vbTabsTitle.getChildren().contains((Object)this.fx_hbTitle)) {
                this.fx_vbTabsTitle.getChildren().add(0, (Object)this.fx_hbTitle);
            }
            if (currentTab != 6) {
                this.addPaneToParent((Pane)currentParent, (Node)this.selectedLine);
                if (!this.fx_vbTabsTitle.getChildren().contains((Object)this.fx_spSearch)) {
                    this.fx_vbTabsTitle.getChildren().add((Object)this.fx_spSearch);
                }
                if (this.tabNumpadController != null) {
                    this.tabNumpadController.dispose();
                }
            } else {
                this.fx_vbTabsTitle.getChildren().remove((Object)this.fx_spSearch);
                this.tabNumpadController.setNumpadMode();
            }
        }
        this.fx_imgTabContact.setImagePath(currentTab == 1 ? "tab/res_tabs_on/tab_contacts_on.png" : "tab/default_tabs_off/tab_contacts_off.png");
        this.fx_imgTabContact_NA.setImagePath(currentTab == 2 ? "tab/res_tabs_on/tab_contacts_tel_on.png" : "tab/default_tabs_off/tab_contacts_tel_off.png");
        this.resizeImage(this.fx_imgTabContact_NA);
        this.fx_imgTabSession.setImagePath(currentTab == 3 ? "tab/res_tabs_on/tab_sessions_on.png" : "tab/default_tabs_off/tab_sessions_off.png");
        this.fx_imgTabCall.setImagePath(currentTab == 4 ? "tab/res_tabs_on/tab_phone_on.png" : "tab/default_tabs_off/tab_phone_off.png");
        this.resizeImage(this.fx_imgTabContact_NA);
        if (currentTab == 6) {
            this.fx_imgTabNumpad.setImagePath("tab/numpad_white.png");
            Theme.getInstance().applyTo(Constants.BUTTON_BACKGROUND_STYLE, this.fx_imgTabNumpad);
        } else if (Theme.getInstance().isDarkTheme()) {
            this.fx_imgTabNumpad.setImagePath("tab/numpad_white.png");
            Theme.getInstance().applyTo(Constants.SECOND_BASE_COLOR, this.fx_imgTabNumpad);
        } else {
            this.fx_imgTabNumpad.setImagePath("tab/numpad_dark.png");
            this.fx_imgTabNumpad.setBackgroundColor("white");
        }
        if (currentTab == 7) {
            this.fx_imgTabSearch.setImagePath("tab/search_tab_on.png");
            Theme.getInstance().applyTo(Constants.BUTTON_BACKGROUND_STYLE, this.fx_imgTabSearch);
        } else if (Theme.getInstance().isDarkTheme()) {
            this.fx_imgTabSearch.setImagePath("tab/search_tab_on.png");
            Theme.getInstance().applyTo(Constants.SECOND_BASE_COLOR, this.fx_imgTabSearch);
        } else {
            this.fx_imgTabSearch.setImagePath("tab/search_tab_off.png");
            this.fx_imgTabSearch.setBackgroundColor("white");
        }
        if (isWithSpeedCall) {
            this.fx_imgTabSpeedDial.setImagePath(currentTab == 5 ? "tab/res_tabs_on/tab_speeddial_on.png" : "tab/default_tabs_off/tab_speeddial_off.png");
        }
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            String imagePath = this.getStateImage(ClientSingleton.getInstance().getCurrentClientState());
            this.fx_imgTabMenu.setImagePath(imagePath);
        });
        ClientSingleton.getInstance().setProperty(Constants.LAST_VISIBLE_TAB, this.currentTab);
        ClientSingleton.toLog(this.getClass().getSimpleName(), "Current tab is " + currentTab);
    }

    private void resizeImage(ImageButton imageButton) {
    }

    private String getStateImage(int state) {
        String img;
        switch (state) {
            case 4: {
                if (ClientSingleton.getInstance().getConnectedSipDevice() != null && ClientSingleton.getInstance().isPhoneConnected()) {
                    img = this.currentTab == 0 ? "tab/res_tabs_on/menu/menu_status_phone_on.png" : "tab/res_tabs_on/menu/menu_status_phone.png";
                    break;
                }
                img = this.currentTab == 0 ? "tab/res_tabs_on/menu/menu_status_atthedesk_on.png" : "tab/res_tabs_on/menu/menu_status_atthedesk.png";
                break;
            }
            case 0: {
                img = this.currentTab == 0 ? "tab/res_tabs_on/menu/menu_status_offline_on.png" : "tab/res_tabs_on/menu/menu_status_offline.png";
                break;
            }
            case 2: {
                img = this.currentTab == 0 ? "tab/res_tabs_on/menu/menu_status_away_on.png" : "tab/res_tabs_on/menu/menu_status_away.png";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                img = this.currentTab == 0 ? "tab/res_tabs_on/menu/menu_status_busy_on.png" : "tab/res_tabs_on/menu/menu_status_busy.png";
                break;
            }
            case 5: {
                img = this.currentTab == 0 ? "tab/res_tabs_on/menu/menu_status_dc_on.png" : "tab/res_tabs_on/menu/menu_status_dc.png";
                break;
            }
            default: {
                img = this.currentTab == 0 ? "tab/res_tabs_on/menu/menu_status_online_on.png" : "tab/res_tabs_on/menu/menu_status_online.png";
            }
        }
        return img;
    }

    public void switchNumpadTab() {
        if (this.currentTab != 6) {
            this.lastViewedTab = this.currentTab;
            this.initImagesAndCreateMenu(6);
        } else {
            this.initImagesAndCreateMenu(this.lastViewedTab);
        }
    }

    public void switchSearchTab() {
        if (this.currentTab != 7) {
            this.lastViewedTab = this.currentTab;
            this.initImagesAndCreateMenu(7);
            this.fx_tfSearch.requestFocus();
        } else {
            this.initImagesAndCreateMenu(this.lastViewedTab);
        }
    }

    public void initTabButtons() {
        this.fx_imgTabNumpad.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> this.switchNumpadTab()));
        ClientSingleton.getInstance().setMouseCursor((Node)this.fx_imgTabNumpad);
        this.fx_imgTabSearch.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> this.switchSearchTab()));
        ClientSingleton.getInstance().setMouseCursor((Node)this.fx_imgTabSearch);
        this.fx_imgTabMenu.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> {
            event.consume();
            this.initImagesAndCreateMenu(0);
        }));
        ClientSingleton.getInstance().setMouseCursor((Node)this.fx_imgTabMenu);
        ClientSingleton.toLog(this.getClass().getSimpleName(), "initTabButtons canSeeUsers=" + ClientSingleton.getInstance().canSeeUsers() + " canChat=" + ClientSingleton.getInstance().canChat() + " canSendSms=" + ClientSingleton.getInstance().canSendSms() + " canVideo=" + ClientSingleton.getInstance().canVideo());
        if (!(ClientSingleton.getInstance().canSeeUsers() || ClientSingleton.getInstance().canChat() || ClientSingleton.getInstance().canSendSms())) {
            this.fx_gpTabsPane.getChildren().removeIf(node -> GridPane.getRowIndex((Node)node) == 1);
            GridPane.setRowIndex((Node)this.fx_hbTabSession, (Integer)1);
            this.fx_gpTabsPane.getChildren().removeIf(node -> GridPane.getRowIndex((Node)node) == 1);
            GridPane.setRowIndex((Node)this.fx_hbTabCall, (Integer)1);
            GridPane.setRowIndex((Node)this.fx_hbTabContact_NA, (Integer)2);
            this.fx_viewTabMenu.layout();
        } else if (!ClientSingleton.getInstance().canSeeUsers()) {
            this.fx_gpTabsPane.getChildren().removeIf(node -> GridPane.getRowIndex((Node)node) == 1);
            GridPane.setRowIndex((Node)this.fx_hbTabSession, (Integer)1);
            GridPane.setRowIndex((Node)this.fx_hbTabCall, (Integer)2);
            GridPane.setRowIndex((Node)this.fx_hbTabContact_NA, (Integer)3);
            this.fx_viewTabMenu.layout();
        } else if (!ClientSingleton.getInstance().canChat() && !ClientSingleton.getInstance().canSendSms()) {
            this.fx_gpTabsPane.getChildren().removeIf(node -> GridPane.getRowIndex((Node)node) == 2);
            GridPane.setRowIndex((Node)this.fx_hbTabCall, (Integer)2);
            GridPane.setRowIndex((Node)this.fx_hbTabContact_NA, (Integer)3);
            this.fx_viewTabMenu.layout();
            this.fx_imgTabContact.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> {
                event.consume();
                this.initImagesAndCreateMenu(1);
            }));
            ClientSingleton.getInstance().setMouseCursor((Node)this.fx_imgTabContact);
        } else {
            this.fx_imgTabContact.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> {
                event.consume();
                this.initImagesAndCreateMenu(1);
            }));
            ClientSingleton.getInstance().setMouseCursor((Node)this.fx_imgTabContact);
        }
        this.fx_imgTabContact_NA.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> {
            event.consume();
            this.initImagesAndCreateMenu(2);
        }));
        ClientSingleton.getInstance().setMouseCursor((Node)this.fx_imgTabContact_NA);
        this.fx_imgTabSession.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> {
            event.consume();
            if (this.currentTab == 3 && this.tabSessionsController != null) {
                this.tabSessionsController.setFirstVisibleCell();
            } else {
                this.initImagesAndCreateMenu(3);
            }
        }));
        ClientSingleton.getInstance().setMouseCursor((Node)this.fx_imgTabSession);
        this.fx_imgTabCall.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> {
            event.consume();
            this.initImagesAndCreateMenu(4);
        }));
        if (isWithSpeedCall) {
            ClientSingleton.getInstance().setMouseCursor((Node)this.fx_imgTabSpeedDial);
            this.fx_imgTabSpeedDial.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> this.initImagesAndCreateMenu(5)));
        }
        ClientSingleton.getInstance().setMouseCursor((Node)this.fx_imgTabCall);
    }

    private void initImagesAndCreateMenu() {
        ContactInfo contactInfo;
        String imageName = this.currentTab == 1 ? "tab/res_tabs_on/tab_contacts_on.png" : "tab/default_tabs_off/tab_contacts_off.png";
        ClientSingleton.getInstance().setImageToImageView(this.fx_imgTabContact, imageName);
        imageName = this.currentTab == 2 ? "tab/res_tabs_on/tab_contacts_tel_on.png" : "tab/default_tabs_off/tab_contacts_tel_off.png";
        ClientSingleton.getInstance().setImageToImageView(this.fx_imgTabContact_NA, imageName);
        this.fx_imgTabContact_NA.setFixImageWidth(20);
        this.fx_imgTabContact_NA.setFixImageHeight(20);
        imageName = this.currentTab == 3 ? "tab/res_tabs_on/tab_sessions_on.png" : "tab/default_tabs_off/tab_sessions_off.png";
        ClientSingleton.getInstance().setImageToImageView(this.fx_imgTabSession, imageName);
        imageName = this.currentTab == 4 ? "tab/res_tabs_on/tab_phone_on.png" : "tab/default_tabs_off/tab_phone_off.png";
        ClientSingleton.getInstance().setImageToImageView(this.fx_imgTabCall, imageName);
        this.resizeImage(this.fx_imgTabCall);
        if (isWithSpeedCall) {
            imageName = this.currentTab == 5 ? "tab/res_tabs_on/tab_speeddial_on.png" : "tab/default_tabs_off/tab_speeddial_off.png";
            ClientSingleton.getInstance().setImageToImageView(this.fx_imgTabSpeedDial, imageName);
        }
        Optional<ClientConnector> clientConnector = ClientSingleton.getInstance().getClientConnector();
        imageName = "tab/res_tabs_on/menu_status_offline.png";
        if (clientConnector.isPresent() && (contactInfo = clientConnector.get().getUserInfo(false)) != null) {
            imageName = this.getStateImage(ClientSingleton.getInstance().getCurrentClientState());
        }
        ClientSingleton.getInstance().setImageToImageView(this.fx_imgTabMenu, imageName);
        ClientSingleton.toLog(this.getClass().getSimpleName(), "setTabImages done");
        if (ClientSingleton.getInstance().getClientConnector().get().canSeeUsers()) {
            this.fx_ivCreateMenu.addMenuItem((Object)this.resources.getString("group_create_group"), (EventHandler<MouseEvent>)((EventHandler)event -> {
                GroupCreatorEditor groupCreatorEditor = new GroupCreatorEditor();
                groupCreatorEditor.show();
            }));
        }
        this.fx_ivCreateMenu.addMenuItem((Object)this.resources.getString("create_contact"), (EventHandler<MouseEvent>)((EventHandler)event -> {
            CreateContactProfileController createContactProfileController = new CreateContactProfileController();
            createContactProfileController.show();
        }));
        if (ClientSingleton.getInstance().canChat() || ClientSingleton.getInstance().canSendSms()) {
            this.fx_ivCreateMenu.addMenuItem((Object)this.resources.getString("chat_create"), (EventHandler<MouseEvent>)((EventHandler)event -> ClientSingleton.getInstance().createChat()));
        }
        if (isWithSpeedCall) {
            this.fx_ivCreateMenu.addMenuItem((Object)this.resources.getString("speed_call_list"), (EventHandler<MouseEvent>)((EventHandler)event -> new AddToSpeedDial()));
        }
        imageName = "search/plus_button.png";
        ClientSingleton.getInstance().setImageToImageView(this.fx_ivCreateMenu, imageName);
    }

    private void initSearch() {
        this.progressIndicator = ClientSingleton.getInstance().getProgressIndicator();
        this.progressIndicator.setMaxWidth(14.0);
        this.progressIndicator.setMaxHeight(14.0);
        ClientSingleton.getInstance().setImageToImageView(this.fx_ivSearch, "search/searchbar_search.png");
        ClientSingleton.getInstance().setImageToImageView(this.fx_ivSearchPhone, "search/searchbar_phone.png");
        ClientSingleton.getInstance().setMouseCursor((Node)this.fx_ivSearch);
        ClientSingleton.getInstance().setMouseCursor((Node)this.fx_ivSearchPhone);
        ClientSingleton.getInstance().setMouseCursor((Node)this.fx_tSearch);
        this.fx_tSearch.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            if (this.currentTab == 7 && !this.getInputTextFromSearch().isEmpty()) {
                this.addSearchProgressIndicator();
                if (this.tabSearchController != null) {
                    this.tabSearchController.clearFoundedLists();
                    this.tabSearchController.setInputText(this.getInputTextFromSearch(), true);
                }
            }
        });
        this.fx_ivSearch.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            if (!this.getInputTextFromSearch().isEmpty()) {
                this.fx_tfSearch.setText("");
            }
        });
        this.fx_ivSearchPhone.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            if (this.canMakeCallFromSearchPane) {
                this.makeCallFromSearch();
            }
        });
        this.fx_tfSearch.setPromptText(this.resources.getString("search_or_call"));
        this.fx_tfSearch.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.ENTER && !this.getInputTextFromSearch().isEmpty()) {
                if (this.currentTab == 7) {
                    this.addSearchProgressIndicator();
                    if (this.tabSearchController != null) {
                        this.tabSearchController.clearFoundedLists();
                        this.tabSearchController.setInputText(this.getInputTextFromSearch(), true);
                    }
                } else if (this.canMakeCallFromSearchPane) {
                    this.makeCallFromSearch();
                }
            }
        });
        this.fx_tfSearch.textProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue.isEmpty() && newValue.isEmpty()) {
                return;
            }
            if (this.currentTab != 7) {
                if (oldValue.isEmpty()) {
                    this.canMakeCallFromSearchPane = true;
                    if (!this.fx_spSearch.getChildren().contains((Object)this.fx_ivSearchPhone)) {
                        this.fx_spSearch.getChildren().add((Object)this.fx_ivSearchPhone);
                    }
                } else if (newValue.isEmpty()) {
                    this.canMakeCallFromSearchPane = false;
                    this.fx_spSearch.getChildren().remove((Object)this.fx_ivSearchPhone);
                    if (this.tabNotAutorizedContactsController != null) {
                        this.tabNotAutorizedContactsController.clearServiceList();
                    }
                    this.refreshLists();
                }
            } else if (newValue.isEmpty()) {
                this.fx_spSearch.getChildren().remove((Object)this.fx_tSearch);
                if (this.tabSearchController != null) {
                    this.tabSearchController.setInputText("", false);
                }
            } else if (!this.fx_spSearch.getChildren().contains((Object)this.fx_tSearch)) {
                this.fx_spSearch.getChildren().add((Object)this.fx_tSearch);
            }
        });
        PublishSubject inputedText = PublishSubject.create();
        inputedText.observeOn(UpdateLists.scheduler).debounce(200L, TimeUnit.MILLISECONDS).switchMap(inputText -> {
            if (this.currentTab == 7) {
                return io.reactivex.Observable.empty();
            }
            if (inputText.isEmpty()) {
                if (this.fx_ivSearch.getFitHeight() != 16.0) {
                    TimerExecutor.getInstance().startInGUI(() -> {
                        this.setSearchImage();
                        this.removeSearchProgressIndicator();
                    });
                }
                return io.reactivex.Observable.empty();
            }
            TimerExecutor.getInstance().startInGUI(this::addClearSearchImage);
            TabBaseView tabBaseView = this.getTabBaseView();
            if (tabBaseView != null) {
                return io.reactivex.Observable.just(tabBaseView.getListOnSearch((String)inputText));
            }
            if (this.currentTab == 5 && this.tabSpeedDialController != null) {
                this.tabSpeedDialController.refreshList((String)inputText);
            }
            return io.reactivex.Observable.empty();
        }).observeOn((Scheduler)JavaFxScheduler.platform()).doOnError(throwable -> {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "ERROR1237");
            throwable.printStackTrace();
        }).subscribe(list -> {
            TabBaseView tabBaseView = this.getTabBaseView();
            if (tabBaseView != null) {
                tabBaseView.setListOnSearch(list);
            }
        });
        JavaFxObservable.valuesOf((ObservableValue)this.fx_tfSearch.textProperty()).subscribe((Observer)inputedText);
    }

    private void addClearSearchImage() {
        if (this.fx_ivSearch.getFitHeight() != 10.0) {
            ClientSingleton.getInstance().setImageToImageView(this.fx_ivSearch, "search/clear_search_text.png");
            this.fx_ivSearch.setFitWidth(10.0);
            this.fx_ivSearch.setFitHeight(10.0);
            if (this.currentTab == 7) {
                this.addSearchProgressIndicator();
            }
        }
    }

    private void addSearchProgressIndicator() {
        this.fx_hbSearch.getChildren().remove((Object)this.fx_ivSearch);
        if (!this.fx_hbSearch.getChildren().contains((Object)this.progressIndicator)) {
            this.fx_hbSearch.getChildren().add(0, (Object)this.progressIndicator);
            TimerExecutor.getInstance().setMyAction(() -> {
                if (this.currentTab == 7 && this.fx_hbSearch.getChildren().contains((Object)this.progressIndicator)) {
                    this.removeSearchProgressIndicator();
                }
            }).startWithDelayInGUIThread(2500L);
        }
    }

    private void setSearchImage() {
        ClientSingleton.getInstance().setImageToImageView(this.fx_ivSearch, "search/searchbar_search.png");
        this.fx_ivSearch.setFitWidth(16.0);
        this.fx_ivSearch.setFitHeight(16.0);
    }

    private void makeCallFromSearch() {
        String number = this.fx_tfSearch.getText();
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        TabBaseView tabBaseView = this.getTabBaseView();
        if (tabBaseView != null) {
            tabBaseView.getItemObject(number).ifPresent(o -> {
                if (o instanceof ContactInfo) {
                    AudioCaller.makeCall((ContactInfo)o);
                } else if (((SessionInfo)o).getSessionId() != null) {
                    SessionInfo sessionInfo = ClientSingleton.getInstance().getClientConnector().get().getSessionInfo(((SessionInfo)o).getSessionId());
                    AudioCaller.makeCall(sessionInfo, false);
                    atomicBoolean.set(true);
                }
            });
        }
        if (!atomicBoolean.get()) {
            AudioCaller.makeCall(number);
        }
        this.fx_tfSearch.setText("");
        this.fx_spSearch.getChildren().remove((Object)this.fx_ivSearchPhone);
    }

    private TabBaseView getTabBaseView() {
        TabBaseView tabBaseView = null;
        switch (this.currentTab) {
            case 2: {
                tabBaseView = this.tabNotAutorizedContactsController;
                break;
            }
            case 1: {
                tabBaseView = this.tabAutorizedContactsController;
                break;
            }
            case 3: {
                tabBaseView = this.tabSessionsController;
                break;
            }
            case 4: {
                tabBaseView = this.tabCallsController;
            }
        }
        return tabBaseView;
    }

    private void refreshLists() {
        switch (this.currentTab) {
            case 2: {
                if (this.tabNotAutorizedContactsController == null) break;
                this.tabNotAutorizedContactsController.updateList();
                break;
            }
            case 1: {
                if (this.tabAutorizedContactsController == null) break;
                this.tabAutorizedContactsController.updateList();
                break;
            }
            case 3: {
                if (this.tabSessionsController == null) break;
                this.tabSessionsController.updateList();
                break;
            }
            case 4: {
                if (this.tabCallsController == null) break;
                this.tabCallsController.updateList();
                break;
            }
            case 5: {
                if (this.tabSpeedDialController == null) break;
                this.tabSpeedDialController.refreshList();
            }
        }
    }

    @Override
    public void onNotifiedMessage(String action, Map<String, Object> data) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "action=" + action + " data=" + data + " lastAction=" + ClientSingleton.getInstance().getLastAction());
        SessionInfo sessionInfo = null;
        if (data != null && (sessionInfo = (SessionInfo)data.get("sessionInfo")) != null && this.needNotification(sessionInfo)) {
            this.checkNewMessages();
        }
        if (action.equals("Load_Updates")) {
            this.addLoadingPane("Loading updates ....");
            List updates = (List)data.get("updates");
            File targetDir = (File)data.get("targetDir");
            String startExeName = (String)data.get("startExeName");
            ClientSingleton.getInstance().closeServices();
            boolean reload = ClientSingleton.getInstance().getClientConnector().get().loadUpdates(updates, targetDir, startExeName, "v2");
            ClientSingleton.toLog(this.getClass().getSimpleName(), "Load updates ... done");
            if (!reload) {
                ClientSingleton.getInstance().initObservers();
                ClientSingleton.getInstance().startServices();
            } else {
                UserClient.onExit(true);
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (ClientUtil.getOS() == ClientUtil.OS.WINDOWS) {
                    File bindir = new File(System.getProperty("user.dir"), "bin");
                    Utils.setWindowsAllPermissions((File)bindir);
                }
                Runtime runProcess = Runtime.getRuntime();
                String[] url = new String[3];
                if (ClientUtil.getOS() == ClientUtil.OS.WINDOWS) {
                    url[0] = "cmd";
                    url[1] = "/c";
                    url[2] = "\"" + System.getProperty("user.dir") + "\\" + startExeName + ".exe\" startAfterUpdate";
                } else {
                    url[0] = "/bin/sh";
                    url[1] = "-c";
                    url[2] = "\"" + System.getProperty("user.dir") + "/ucc\"";
                }
                ClientSingleton.toLog(this.getClass().getSimpleName(), "Restart path=" + url[2]);
                try {
                    runProcess.exec(url);
                }
                catch (Throwable e) {
                    ClientSingleton.toLog(this.getClass().getSimpleName(), e.toString());
                }
                NotificationThreadPoolManager.getInstance().shutDownNow();
                MyThreadPoolManager.getInstance().shutDownNow();
                ClientSingleton.getInstance().shutDownClientObserver();
                Platform.exit();
            }
        } else if (!action.equals(Constants.SEARCH_CALLS_EXT) && !action.equals(Constants.SEARCH_SESSIONS_EXT)) {
            if (action.equals("ON_EXIT")) {
                TimerExecutor.getInstance().startInGUI(this::removeWebView);
                TimerExecutor.getInstance().start(() -> ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                    if (!clientConnector.onExit(true)) {
                        clientConnector.onExit(false);
                    }
                    ClientSingleton.getInstance().setNotRegistered(true);
                }));
                ClientSingleton.getInstance().runLater(() -> ClientSingleton.getInstance().loadRegistrationScene());
            } else if (action.equals(IntentConstants.SESSION_CREATED)) {
                String lastAction = ClientSingleton.getInstance().getLastAction();
                ClientSingleton.toLog(this.getClass().getSimpleName(), "SESSION_CREATED lastAction = " + lastAction + " sessionInfo=" + sessionInfo);
                if (IntentConstants.SESSION_CREATED.equals(lastAction) || IntentConstants.SESSION_CREATED_CALL.equals(lastAction)) {
                    ClientSingleton.getInstance().setLastAction("");
                    if (sessionInfo != null && this.chatPaneController != null) {
                        SessionInfo session = sessionInfo;
                        ClientSingleton.getInstance().runLater(() -> {
                            try {
                                this.chatPaneController.openChat(session);
                                TimerExecutor.getInstance().start(() -> ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> clientConnector.getMessages(session)));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        });
                    }
                }
            } else if (action.equals(IntentConstants.SESSION_REMOVED)) {
                this.sessionRemoved();
            } else if (action.equals(IntentConstants.CONTACT_ADDED)) {
                String lastAction = ClientSingleton.getInstance().getLastAction();
                if (IntentConstants.CONTACT_ADDED.equals(lastAction)) {
                    ClientSingleton.getInstance().setLastAction("");
                    if (this.currentViewMode.get() == 1) {
                        return;
                    }
                    ContactInfo contactInfo = (ContactInfo)data.get("contactInfo");
                    sessionInfo = ClientSingleton.getInstance().getSessionInfo(contactInfo, true);
                    if (sessionInfo == null) {
                        try {
                            sessionInfo = ClientSingleton.getInstance().getClientConnector().get().getSession(List.of(contactInfo));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (sessionInfo != null) {
                        SessionInfo si = sessionInfo;
                        ClientSingleton.getInstance().runLater(() -> {
                            if (si.getSessionId() == null) {
                                this.clearSelection();
                            } else {
                                this.setSelectedItemId(si);
                            }
                            int tab = this.currentTab == 2 ? -1 : 2;
                            this.openChatSession(si, true);
                            if (tab != -1 && tab != this.currentTab) {
                                this.initImagesAndCreateMenu(tab);
                            } else {
                                this.tabNotAutorizedContactsController.updateList();
                            }
                            this.removeLoadingPane();
                        });
                    } else {
                        this.removeLoadingPane();
                    }
                }
            } else if (action.equals(IntentConstants.CONTACT_REMOVED)) {
                if (this.currentTab == 2) {
                    if (data != null && data.containsKey("contactInfo")) {
                        ContactInfo contactInfo = (ContactInfo)data.get("contactInfo");
                        ClientSingleton.getInstance().runLater(() -> {
                            this.setSelectedItemId("");
                            this.csAction();
                            this.tabNotAutorizedContactsController.contactInfoRemoved(contactInfo);
                        });
                    } else {
                        this.clearSelection();
                    }
                } else {
                    this.clearSelection();
                }
            } else {
                ClientSingleton.getInstance().runLater(() -> this.onAction(action, data));
            }
        }
    }

    private void assistantStateChanged(String assistant_state) {
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            String assistantSipDevice = clientConnector.getSIPDevice();
            if (assistantSipDevice != null) {
                Notification.getInstance(this).closeNotification();
                Notification.getInstance(this).addNotification(assistantSipDevice, ClientSingleton.getInstance().getString(assistant_state), !assistant_state.equals("assistant_state_dialing"), "activity/activity_outgoingcall_icon@2x.png");
            }
        });
    }

    @Override
    public String getInputTextFromSearch() {
        return this.fx_tfSearch.getText();
    }

    @Override
    public void openSession(BaseCell baseCell) {
        if (baseCell.getSessionInfo() != null) {
            this.openSession(baseCell.getSessionInfo(), -1, Constants.OPEN_SESSION_WITH_PROFILE);
        } else {
            this.openSession(baseCell.getContactInfo(), -1, Constants.OPEN_SESSION_WITH_PROFILE);
        }
    }

    @Override
    public void openSessionEditor(BaseCell baseCell) {
        if (baseCell.getSessionInfo() != null) {
            this.openSession(baseCell.getSessionInfo(), -1, Constants.OPEN_SESSION_WITH_PROFILE_EDITOR);
        } else {
            this.openSession(baseCell.getContactInfo(), -1, Constants.OPEN_SESSION_WITH_PROFILE_EDITOR);
        }
    }

    private void openSession(Map<String, Object> data) {
        int tab;
        int openMode = Constants.OPEN_SESSION_WITH_PROFILE;
        if (data.containsKey(Constants.OPEN_SESSION_MODE)) {
            openMode = (Integer)data.get(Constants.OPEN_SESSION_MODE);
        }
        SessionInfo sessionInfo = (SessionInfo)data.get("sessionInfo");
        ClientSingleton.toLog(this.getClass().getSimpleName(), "Open chat. Try to find session  = " + sessionInfo + " openMode=" + openMode);
        int n = tab = data.get("tab") == null ? -1 : (Integer)data.get("tab");
        if (sessionInfo != null) {
            MessageInfo messageInfo = (MessageInfo)data.get("messageInfo");
            if (messageInfo != null) {
                this.openSessionAfterSearch(sessionInfo, messageInfo);
            } else if (this.currentTab == 7) {
                this.openSessionAfterSearch(sessionInfo, null);
            } else {
                this.openSession(sessionInfo, tab, openMode);
            }
        } else if (data.get("contactInfo") != null) {
            this.openSession((ContactInfo)data.get("contactInfo"), tab, openMode);
        }
    }

    private void openSessionAfterSearch(SessionInfo sessionInfo, MessageInfo messageInfo) {
        this.setSelectedItemId(sessionInfo);
        if (this.currentViewMode.get() == 1) {
            this.sessionWaitingForAction = new SessionWaitingForAction(sessionInfo, Constants.OPEN_SESSION_WITH_PROFILE);
            this.currentViewMode.set(0);
        } else {
            int delay;
            boolean notEquals = this.isSessionsNotEquals(sessionInfo);
            int n = delay = this.chatPaneController == null || this.chatPaneController.getSessionInfo() == null || notEquals ? 700 : 500;
            if (notEquals) {
                this.openChatSession(sessionInfo, Constants.OPEN_SESSION_WITH_PROFILE, false);
                if (messageInfo != null) {
                    TimerExecutor.getInstance().setMyAction(() -> this.chatPaneController.findAfterSearch(messageInfo)).startWithDelayInGUIThread(delay);
                }
            } else if (messageInfo != null) {
                this.chatPaneController.findAfterSearch(messageInfo);
            }
        }
    }

    private boolean isSessionsNotEquals(SessionInfo sessionInfo) {
        return this.chatPaneController == null || this.chatPaneController.getSessionInfo() == null || this.chatPaneController.getSessionInfo().getSessionId() == null || sessionInfo.getSessionId() == null || !this.chatPaneController.getSessionInfo().getSessionId().equals(sessionInfo.getSessionId());
    }

    private void open(int tab) {
        this.setSelectedSessionCell(false);
        ClientSingleton.toLog(this.getClass().getSimpleName(), "onOpenSession tab=" + tab + " currentTab=" + this.currentTab);
        if (tab != -1 && this.currentTab != tab) {
            ClientSingleton.getInstance().runLater(() -> this.initImagesAndCreateMenu(tab));
        }
        this.setSelectedSessionCell(true);
        ClientSingleton.getInstance().showWindow();
        this.getCallNotificationPane().setShowing(null, false);
        this.removeLoadingPane();
    }

    private <T> void openSession(T value, int tab, int openMode) {
        if (value == null) {
            return;
        }
        boolean withResize = this.currentViewMode.get() == 1;
        ClientSingleton.toLog(this.getClass().getSimpleName(), "openSession value=" + value + " clazz=" + value.getClass() + " withResize=" + withResize);
        SessionInfo sessionInfo = null;
        if (value instanceof SessionInfo) {
            sessionInfo = (SessionInfo)value;
            this.setSelectedItemId(sessionInfo);
            if (this.tabSessionsController != null) {
                this.tabSessionsController.updateHandler(sessionInfo, 1);
            }
            if (this.tabCallsController != null) {
                this.tabCallsController.updateHandler(sessionInfo);
            }
        } else {
            ContactInfo contactInfo = (ContactInfo)value;
            sessionInfo = ClientSingleton.getInstance().getSessionInfo(contactInfo);
            ClientSingleton.toLog(this.getClass().getSimpleName(), "openSession contactInfo=" + contactInfo + " sessionInfo=" + sessionInfo + (String)(sessionInfo == null ? "" : " sessionInfo.getSessionId() = " + sessionInfo.getSessionId()));
            if (sessionInfo == null) {
                sessionInfo = ClientSingleton.getInstance().getClientConnector().get().getSession(contactInfo);
                ClientSingleton.toLog(this.getClass().getSimpleName(), "openSession created sessionInfo=" + sessionInfo);
            }
            this.setSelectedItemId(sessionInfo.getSessionId() == null ? ClientSingleton.getInstance().getUserID(contactInfo) : sessionInfo.getSessionId());
        }
        if (!withResize) {
            this.openChatSession(sessionInfo, openMode, true);
        } else {
            this.sessionWaitingForAction = new SessionWaitingForAction(sessionInfo, openMode);
            this.currentViewMode.set(0);
        }
        if (tab != -1) {
            this.open(tab);
        }
    }

    private void viewToFront() {
        ClientSingleton.getInstance().showWindow();
    }

    @Override
    public void sessionRemoved() {
        this.clearSelection();
        this.updateSessionsLists();
    }

    private void updateSessionsLists() {
        if (this.currentTab == 3) {
            if (this.tabSessionsController != null) {
                this.tabSessionsController.updateList();
            }
        } else if (this.currentTab == 4) {
            this.tabCallsController.updateList();
        }
    }

    private void updateSessionsTabs(SessionInfo sessionInfo) {
        if (sessionInfo == null) {
            return;
        }
        if (this.tabSessionsController != null) {
            this.tabSessionsController.updateHandler(sessionInfo, 1);
        }
        if (this.tabCallsController != null) {
            this.tabCallsController.updateHandler(sessionInfo);
        }
    }

    private void onAction(String action, Map<String, Object> data) {
        MessageInfo messageInfo;
        ClientSingleton.toLog(this.getClass().getSimpleName(), "onAction action=" + action + " data=" + data);
        SessionInfo sessionInfo = null;
        if (data != null) {
            sessionInfo = (SessionInfo)data.get("sessionInfo");
        }
        if (action.equals(Constants.PHONE_DEVICE_ADDED)) {
            String deviceInfo = (String)data.get(Constants.DEVICE_INFO);
            Notification.getInstance(this).addNotification(ClientSingleton.getInstance().getString("chat_call_line_menu5"), deviceInfo + " " + ClientSingleton.getInstance().getString("audio_device_was_added"), true, "notification/device_connected.png", 0);
        } else if (action.equals(Constants.PHONE_DEVICE_REMOVED)) {
            String deviceInfo = (String)data.get(Constants.DEVICE_INFO);
            Notification.getInstance(this).addNotification(ClientSingleton.getInstance().getString("chat_call_line_menu5"), deviceInfo + " " + ClientSingleton.getInstance().getString("audio_device_was_removed"), true, "notification/device_disconnected.png", 1);
        } else if (action.equals(Constants.ASSISTANT_STATE_DIALING)) {
            this.addAssistantLine(false);
        } else if (action.equals(Constants.ASSISTANT_STATE_CONNECTED)) {
            this.assistantStateChanged("assistant_state_connected");
        } else if (action.equals(Constants.ASSISTANT_HIDE_NITIFICATION)) {
            Notification.getInstance(this).closeNotification();
        } else if (action.equals(Constants.ASSISTANT_STATE_NO_ANSWERED)) {
            this.removeAssistantLine();
            this.assistantStateChanged("assistant_state_no_answered");
        } else if (action.equals(Constants.ASSISTANT_STATE_EXCEPTION)) {
            this.removeAssistantLine();
            this.assistantStateChanged("assistant_state_exception");
        } else if (action.equals(Constants.ASSISTANT_STATUS_UNREGISTERED) || action.equals(Constants.ASSISTANT_STATUS_REGISTERED)) {
            Object deviceInfo = (String)data.get(Constants.DEVICE_INFO);
            if (deviceInfo != null && ((String)deviceInfo).length() > 30) {
                deviceInfo = ((String)deviceInfo).substring(0, 30) + "...";
            }
            if (action.equals(Constants.ASSISTANT_STATUS_REGISTERED)) {
                Notification.getInstance(this).addNotification(ClientSingleton.getInstance().getString("chat_call_line_menu6"), (String)deviceInfo + " " + ClientSingleton.getInstance().getString("audio_device_was_added"), true, "notification/phone_connected.png");
            } else {
                Notification.getInstance(this).addNotification(ClientSingleton.getInstance().getString("chat_call_line_menu6"), (String)deviceInfo + " " + ClientSingleton.getInstance().getString("audio_device_was_removed"), true, "notification/phone_disconnected.png");
                String imagePath = this.getStateImage(ClientSingleton.getInstance().getCurrentClientState());
                this.fx_imgTabMenu.setImagePath(imagePath);
            }
            if (this.tabTabMenuController != null) {
                this.tabTabMenuController.setAssistanceDeviceState();
            }
        } else if (action.equals(Constants.SHARE_DESKTOP)) {
            ClientSingleton.getInstance().setIconified(true);
            this.getCallNotificationPane().setShowing(null, false);
            this.showShareDesktopPane();
        } else if (action.equals(Constants.OPEN_SESSION)) {
            this.openSession(data);
        } else if (action.equals(Constants.OPEN_PROFILE_EDITOR)) {
            ContactInfo contactInfo = (ContactInfo)data.get("contactInfo");
            if (contactInfo != null) {
                sessionInfo = ClientSingleton.getInstance().getSessionInfo(contactInfo, true);
                if (sessionInfo == null) {
                    sessionInfo = ClientSingleton.getInstance().getClientConnector().get().getSession(contactInfo);
                }
                if (this.currentViewMode.get() == 1) {
                    this.switchViewMode();
                    SessionInfo si = sessionInfo;
                    TimerExecutor.getInstance().setMyAction(() -> this.openChatSession(si, Constants.OPEN_SESSION_WITH_PROFILE_EDITOR, true)).startWithDelayInGUIThread(500L);
                } else {
                    this.openChatSession(sessionInfo, Constants.OPEN_SESSION_WITH_PROFILE_EDITOR, true);
                }
            }
        } else if (action.equals(Constants.DISMISS_SHARE_DESKTOP)) {
            if (this.isShareDesktopPaneShowing()) {
                this.getVideoProcessor().setShowingDesktop(false);
            } else {
                this.hideShareDesktopPane();
                LineInfo lineInfo = AudioCaller.getActiveLine();
                if (lineInfo != null) {
                    TimerExecutor.getInstance().setMyAction(() -> {
                        if (AudioCaller.getActiveLine() != null) {
                            ClientSingleton.getInstance().showWindow();
                        }
                    }).startWithDelayInGUIThread(300L);
                }
            }
        } else if (action.equals(Constants.RESIZE_TABS_PANE)) {
            if (this.fx_spProfileListTab.getMaxWidth() == 310.0) {
                if (!ClientSingleton.getInstance().isFullVideoScreenMode()) {
                    this.hideTabsPane();
                }
            } else {
                this.showTabsPane();
            }
        } else if (action.equals(Constants.OPEN_CALL_DETAILS)) {
            MessageInfo messageInfo2 = (MessageInfo)data.get("messageInfo");
            this.openCallDetail(messageInfo2);
        } else if (action.equals(Constants.OPEN_CALL_ACTIVITY)) {
            LineInfo lineInfo = (LineInfo)data.get("lineInfo");
            this.openCallDetail(lineInfo);
        } else if (action.equals(Constants.START_VIDEO)) {
            LineInfo lineInfo = (LineInfo)data.get("lineInfo");
            if (lineInfo != null) {
                try {
                    SessionInfo sessionInfo1;
                    ClientSingleton.getInstance().setMyVideoEnabledFlag(lineInfo, true);
                    if (this.currentViewMode.get() == 1) {
                        this.switchViewMode();
                    }
                    if (this.fx_ChatSplit.isVisible() && (sessionInfo1 = ClientSingleton.getInstance().getSessionInfo(lineInfo)) != null) {
                        if (this.chatPaneController.equalsCurrentSessionInfo(sessionInfo1)) {
                            this.myChatVideoSplitPaneSlider.moveDividerToEndPosition();
                        } else {
                            this.myChatVideoSplitPaneSlider.moveDividerToStartPosition();
                        }
                    }
                    if (this.videoPaneController != null) {
                        this.videoPaneController.setLineInfo(lineInfo);
                    }
                    ClientSingleton.getInstance().getClientConnector().get().startVideo();
                    ClientSingleton.toLog(this.getClass().getSimpleName(), "Constants.START_VIDEO startVideo");
                    if (!ClientSingleton.getInstance().isFocused()) {
                        this.getCallNotificationPane().addVideoPane(lineInfo);
                    }
                    ClientSingleton.toLog(this.getClass().getSimpleName(), "Constants.START_VIDEO TimerExecutor.getInstance()");
                    TimerExecutor.getInstance().setMyAction(() -> {
                        ClientSingleton.toLog(this.getClass().getSimpleName(), "Constants.START_VIDEO isCapturing = " + this.getVideoProcessor().isCapturing());
                        if (!this.getVideoProcessor().isCapturing()) {
                            this.getVideoProcessor().setCapturing(true);
                        }
                    }).startWithDelay(1000L);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        } else if (action.equals(IntentConstants.LINE_INFO_RECORD_LINE)) {
            LineInfo lineInfo = (LineInfo)data.get("lineInfo");
            this.getCallNotificationPane().onRecordCall(lineInfo, (Boolean)data.get("isRecording"));
            ClientSingleton.getInstance().getLineInfoPanes().stream().filter(lineInfoPane -> lineInfoPane.getLineInfo() != null && lineInfo.hashCode() == lineInfoPane.getLineInfo().hashCode()).findAny().ifPresent(LineInfoPane::onRecordCall);
        } else if (action.equals(IntentConstants.LINE_INFO_MUTE_LINE)) {
            this.getCallNotificationPane().onMute();
            ClientSingleton.getInstance().getLineInfoPanes().stream().filter(lineInfoPane -> lineInfoPane.getLineInfo() != null && (lineInfoPane.getLineInfo().getState() == 3 || lineInfoPane.getLineInfo().getState() == 5 || lineInfoPane.getLineInfo().getState() == 4 || lineInfoPane.getLineInfo().getState() == 10 || lineInfoPane.getLineInfo().getState() == 16)).forEach(LineInfoPane::onMute);
            if (this.shareDesktopPane != null) {
                this.shareDesktopPane.onMute();
            }
            ClientSingleton.getInstance().setUsbMute();
        } else if (action.equals(Constants.OPEN_PROFILE)) {
            ContactInfo contactInfo = (ContactInfo)data.get("contactInfo");
            if (contactInfo != null) {
                this.openSession(contactInfo, -1, Constants.OPEN_SESSION_WITH_PROFILE);
            } else if (sessionInfo != null && sessionInfo.isGroup()) {
                this.openGroupViewer(sessionInfo);
            }
        } else if (action.equals(Constants.DO_NOT_DISTURB_) || action.equals(Constants.DO_NOT_DISTURB)) {
            if (this.tabSessionsController != null && sessionInfo != null) {
                this.tabSessionsController.setMute(sessionInfo);
            }
        } else if (data.containsKey("messageInfo") && (messageInfo = (MessageInfo)data.get("messageInfo")).getType() != 14 && (messageInfo.getStatus() == 1 || messageInfo.getStatus() == 12)) {
            ClientSingleton.getInstance().getSessionInfo(messageInfo.getSessionId()).ifPresent(mSessionInfo -> {
                if (this.needNotification((SessionInfo)mSessionInfo)) {
                    boolean noDisturb;
                    boolean bl = noDisturb = mSessionInfo.getProperty("nodisturb") != null && (Boolean)mSessionInfo.getProperty("nodisturb") != false;
                    if (!noDisturb) {
                        Notification.getInstance(this).addNotification(messageInfo);
                    }
                } else {
                    ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                        clientConnector.sendRead(mSessionInfo);
                        if (this.tabSessionsController != null) {
                            this.tabSessionsController.updateHandler((SessionInfo)mSessionInfo, 1);
                        }
                    });
                }
            });
        }
    }

    private CallNotificationPane getCallNotificationPane() {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "getCallNotificationPane=" + this.callNotificationPane);
        if (this.callNotificationPane == null) {
            this.callNotificationPane = new CallNotificationPane(this.getVideoProcessor(), this);
            this.callNotificationPane.setCheckNewMessagesNotification(this);
        }
        return this.callNotificationPane;
    }

    public void onMessagesLoaded(List<MessageInfo> list, SessionInfo sessionInfo, String lastAction) {
        if (this.chatPaneController != null && this.chatPaneController.equalsCurrentSessionInfo(sessionInfo)) {
            this.chatPaneController.messagesLoaded(list, lastAction);
        }
    }

    public void onMessagesLoaded(List<MessageInfo> list, SessionInfo sessionInfo) {
        if (this.chatPaneController != null) {
            if (this.chatPaneController.equalsCurrentSessionInfo(sessionInfo)) {
                this.chatPaneController.messagesLoaded(list);
                this.sendRead();
            } else {
                this.checkNewMessages();
            }
        }
        if (this.tabSessionsController != null) {
            this.tabSessionsController.updateList();
        }
    }

    public void onMessageRemoved(SessionInfo sessionInfo, MessageInfo messageInfo) {
        if (this.chatPaneController != null && this.chatPaneController.equalsCurrentSessionInfo(sessionInfo)) {
            if (messageInfo.getType() == 14) {
                this.chatPaneController.setState();
            } else {
                this.chatPaneController.onMessageRemoved(sessionInfo, messageInfo);
            }
        }
        this.checkNewMessages();
        if (messageInfo.getType() != 14) {
            if (this.currentTab == 3) {
                this.tabSessionsController.updateList();
            } else if (this.currentTab == 4) {
                this.tabCallsController.updateList();
            }
        }
    }

    public void onMessageUpdated(SessionInfo sessionInfo, MessageInfo messageInfo) {
        if (this.chatPaneController != null) {
            this.chatPaneController.onMessageUpdated(sessionInfo, messageInfo);
        }
    }

    public void onMessageReceived(SessionInfo sessionInfo, MessageInfo messageInfo) {
        if (sessionInfo == null || messageInfo == null) {
            return;
        }
        if (this.currentViewMode.get() == 0) {
            if (messageInfo.getType() != 14) {
                if (this.chatPaneController != null) {
                    try {
                        this.chatPaneController.onMessageReceived(sessionInfo, messageInfo);
                    }
                    catch (IndexOutOfBoundsException e) {
                        ClientSingleton.toLog(this.getClass().getSimpleName(), "Error on adding message e : " + e.getMessage());
                        TimerExecutor.getInstance().setMyAction(() -> {
                            try {
                                this.chatPaneController.onMessageReceived(sessionInfo, messageInfo);
                            }
                            catch (IndexOutOfBoundsException ex) {
                                ClientSingleton.toLog(this.getClass().getSimpleName(), "Error on adding message : " + ex.getMessage());
                                this.chatPaneController.refreshList();
                            }
                        }).startWithDelay(500L);
                    }
                }
                this.sendRead();
            } else if (this.chatPaneController != null) {
                ClientSingleton.getInstance().runLater(() -> this.chatPaneController.receivedMassageOnTyping(sessionInfo, messageInfo));
            }
        }
        if (messageInfo.getType() == 8) {
            LineInfo lineInfo = AudioCaller.getActiveLine();
            if (lineInfo != null && (lineInfo.isVideoEnabled() || ClientSingleton.getInstance().isMyVideoEnabledFlag(lineInfo))) {
                this.getVideoProcessor().setCapturing(false);
            }
            this.makeCallRecordCopy(messageInfo);
            if (this.currentTab == 4) {
                this.tabCallsController.updateList();
            }
        } else if (this.tabSessionsController != null && this.getInputTextFromSearch().isEmpty() && sessionInfo.getMessages().size() > 1) {
            this.tabSessionsController.onMessageReceivedOrUpdated(sessionInfo, messageInfo);
        }
        boolean isCheckNewMessages = this.needNotification(sessionInfo);
        ClientSingleton.toLog(this.getClass().getSimpleName(), "needNotification message status = " + messageInfo.getStatus() + " content = " + messageInfo.getContent());
        if (isCheckNewMessages && (messageInfo.getStatus() == 1 || messageInfo.getStatus() == 12)) {
            boolean noDisturb = sessionInfo.getProperty("nodisturb") != null && (Boolean)sessionInfo.getProperty("nodisturb") != false;
            ClientSingleton.toLog(this.getClass().getSimpleName(), "needNotification noDisturb = " + noDisturb + " " + ClientSingleton.getInstance().getCurrentClientState());
            if (!noDisturb) {
                this.addNotification(messageInfo);
            }
        }
    }

    private void addNotification(MessageInfo messageInfo) {
        ClientSingleton.getInstance().runLater(() -> Notification.getInstance(this).addNotification(messageInfo));
    }

    public void onSessionEventReceived(SessionInfo sessionInfo, int event) {
        if (sessionInfo == null) {
            return;
        }
        if (event == 7 || event == 5 && sessionInfo.getStatus() == 5) {
            if (this.getSelectedItemId().isPresent()) {
                this.clearSelection();
                if (this.currentTab == 3) {
                    if (this.tabSessionsController != null) {
                        this.tabSessionsController.onRemoveSession(sessionInfo);
                    }
                } else if (this.currentTab == 4) {
                    this.tabCallsController.onRemoveSession(sessionInfo);
                }
            }
            if (event == 7) {
                TimerExecutor.getInstance().setMyAction(() -> {
                    if (this.chatPaneController != null) {
                        this.chatPaneController.refreshList(-1);
                    }
                }).startWithDelay(500L);
            }
        } else if (event == 1 || event == 4) {
            ClientSingleton.getInstance().runLater(() -> {
                if (this.tabSessionsController != null) {
                    this.tabSessionsController.setNewName(sessionInfo);
                }
                if (this.tabCallsController != null) {
                    this.tabCallsController.setNewName(sessionInfo);
                }
            });
        } else if (event == 101) {
            this.updateSessionsTabs(sessionInfo);
            this.checkNewMessages();
        }
    }

    private void makeCallRecordCopy(MessageInfo messageInfo) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "makeCallRecordCopy messageInfo.getActivity()=" + messageInfo.getActivity());
        if (messageInfo.getActivity() == null || messageInfo.getActivity().getFile() == null || messageInfo.getActivity().getFile().isEmpty()) {
            return;
        }
        ClientSingleton.toLog(this.getClass().getSimpleName(), "makeCallRecordCopy messageInfo.getContent()=" + messageInfo.getContent());
        SimpleDateFormat sdf = new SimpleDateFormat("HHmmss");
        String fName = sdf.format(new Date(messageInfo.getTime()));
        String recordFile = messageInfo.getActivity().getFile();
        File callRecordFile = new File(recordFile);
        AtomicReference<String> fileName = new AtomicReference<String>(callRecordFile.getName());
        try {
            Pair<String, String> pair = JsonMessageParser.getCallerCalled(messageInfo);
            String stringBuilder = (String)pair.getKey() + "_" + (String)pair.getValue() + "_" + fName + ".wav";
            fileName.set(stringBuilder);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        ClientSingleton.toLog(this.getClass().getSimpleName(), "makeCallRecordCopy callRecordFile=" + callRecordFile + " fileName=" + fileName);
        ClientSingleton.toLog(this.getClass().getSimpleName(), "makeCallRecordCopy callRecordFile.exists()=" + callRecordFile.exists());
        if (!callRecordFile.exists()) {
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                Map localProperties = clientConnector.getProperties();
                boolean isSaveCallRecords = false;
                if (localProperties.get(Constants.SAVE_CALL_RECORDS) != null) {
                    isSaveCallRecords = (Boolean)localProperties.get(Constants.SAVE_CALL_RECORDS);
                }
                if (!isSaveCallRecords) {
                    return;
                }
                if (localProperties.get(Constants.SAVE_CALL_RECORDS_PATH) == null) {
                    return;
                }
                clientConnector.getRecord(recordFile, new FileTransferListener(){
                    final /* synthetic */ ClientConnector val$clientConnector;
                    final /* synthetic */ Map val$localProperties;
                    final /* synthetic */ MessageInfo val$messageInfo;
                    final /* synthetic */ AtomicReference val$fileName;
                    {
                        this.val$clientConnector = clientConnector;
                        this.val$localProperties = map;
                        this.val$messageInfo = messageInfo;
                        this.val$fileName = atomicReference;
                    }

                    public void transferStarted(FileInfo fileInfo) {
                    }

                    public void transferProgress(FileInfo fileInfo) {
                    }

                    public void transferEnded(FileInfo fileInfo) {
                        File file = null;
                        try {
                            file = this.val$clientConnector.getFile(fileInfo);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        if (file == null) {
                            return;
                        }
                        StringBuilder stringBuilderPath = new StringBuilder(this.val$localProperties.get(Constants.SAVE_CALL_RECORDS_PATH).toString());
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        String fName = sdf.format(new Date(this.val$messageInfo.getTime()));
                        stringBuilderPath.append(File.separator).append(fName);
                        Path path = Paths.get(stringBuilderPath.toString(), new String[0]);
                        try {
                            Path path1 = Files.createDirectories(path, new FileAttribute[0]);
                            ClientSingleton.toLog(this.getClass().getSimpleName(), "makeCallRecordCopy path1=" + path1);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        File newFile = new File(stringBuilderPath.toString(), (String)this.val$fileName.get());
                        ClientSingleton.toLog(this.getClass().getSimpleName(), "makeCallRecordCopy newFile=" + newFile);
                        try (FileInputStream fis = new FileInputStream(file);
                             FileOutputStream fos = new FileOutputStream(newFile);){
                            int n;
                            byte[] b = new byte[4096];
                            while ((n = fis.read(b)) != -1) {
                                fos.write(b, 0, n);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            });
        }
    }

    @Override
    public void identityChanged(LineInfo lineInfo) {
    }

    @Override
    public void setLineViewState(LineInfo lineInfo) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "setLineViewState 1 lineInfo=" + lineInfo + " state=" + lineInfo.getState() + " ClientSingleton.getInstance().isMyVideoEnabledFlag(lineInfo)=" + ClientSingleton.getInstance().isMyVideoEnabledFlag(lineInfo) + " fx_vbParksLines.getChildren()=" + this.fx_vbParksLines.getChildren().size());
        if (lineInfo.getState() != 8 && lineInfo.getState() != 0 && lineInfo.getState() != 18 && !this.fx_vbAssistantLine.getChildren().isEmpty()) {
            this.removeAssistantLine();
        }
        if (lineInfo.getState() != 2 && this.isRingtoneMuted()) {
            this.setRingtoneMuteState(false);
        }
        switch (lineInfo.getState()) {
            case 2: {
                break;
            }
            case 3: {
                if (this.currentViewMode.get() == 1 && AudioCaller.getWorkingLinesCount() == 2) {
                    ClientSingleton.getInstance().getLineInfoPanes().stream().filter(lineInfoPane -> lineInfoPane.getLineInfo() != null && lineInfoPane.getLineInfo().getState() == 4).findAny().ifPresent(LineInfoPane::invalidateLinePane);
                }
                if (ClientSingleton.getInstance().isMyVideoEnabledFlag(lineInfo)) {
                    this.lastViewPaneMode = this.currentViewMode.get();
                    if (ClientSingleton.getInstance().isFocused()) {
                        if (this.currentViewMode.get() == 1) {
                            this.openSession(lineInfo.getSessionInfo(), -1, Constants.OPEN_SESSION_WITH_PROFILE);
                        } else if (this.getSelectedItemId().isEmpty()) {
                            this.openSession(lineInfo.getSessionInfo(), -1, Constants.OPEN_SESSION_WITH_PROFILE);
                        }
                    }
                    if (this.fx_ChatSplit.isVisible()) {
                        this.openVideoPane(lineInfo);
                    }
                    if (this.videoPaneController == null) break;
                    this.getVideoProcessor().setOutputFrameSize();
                    this.videoPaneController.setCapturing();
                    this.videoPaneController.setLineInfo(lineInfo);
                    break;
                }
                ClientSingleton.getInstance().getBooleanProperty(Constants.OPEN_CHAT_AFTER_ANSWER).ifPresent(b -> {
                    if (b.booleanValue()) {
                        TimerExecutor.getInstance().setMyAction(() -> this.openSession(lineInfo.getSessionInfo(), -1, Constants.OPEN_SESSION_WITH_PROFILE)).startWithDelayInGUIThread(100L);
                    }
                });
                break;
            }
            case 4: {
                break;
            }
            case 0: 
            case 8: 
            case 18: {
                if (this.myChatVideoSplitPaneSlider != null && !this.myChatVideoSplitPaneSlider.isDividerOnStartPosition()) {
                    this.myChatVideoSplitPaneSlider.moveDividerToStartPosition();
                }
                if (this.videoPaneController != null && this.videoPaneController.getLineInfo() != null) {
                    this.videoPaneController.setLineInfo(null);
                    this.getVideoProcessor().clearDesktopShowing();
                    ClientSingleton.getInstance().clearFullVideoScreen();
                    if (this.lastViewPaneMode == 1) {
                        this.currentViewMode.set(this.lastViewPaneMode);
                        this.lastViewPaneMode = -1;
                    }
                }
                this.getVideoProcessor().setCapturing(false);
                if (this.fx_spProfileListTab.getMaxWidth() != 310.0) {
                    this.showTabsPane();
                }
                boolean isShareDesktopShowing = false;
                if (this.shareDesktopPane != null) {
                    isShareDesktopShowing = this.shareDesktopPane.isShowing();
                }
                this.hideShareDesktopPane();
                if (isShareDesktopShowing) {
                    TimerExecutor.getInstance().setMyAction(() -> ClientSingleton.getInstance().showWindow()).startWithDelayInGUIThread(300L);
                }
                ClientSingleton.getInstance().closeContactListView();
                this.setClientStateInMenuTab();
                if (AudioCaller.getWorkingLinesCount() != 1) break;
                this.fx_vbActiveLines.getChildren().stream().filter(node -> {
                    if (node instanceof LineInfoPane) {
                        LineInfoPane lineInfoPane = (LineInfoPane)node;
                        LineInfo lineInfo1 = lineInfoPane.getLineInfo();
                        return lineInfo1 != null && lineInfo1.getState() != 0 && lineInfo1.getState() != 18 && lineInfo1.getState() != 8;
                    }
                    return false;
                }).peek(node -> ClientSingleton.toLog(this.getClass().getSimpleName(), "LineInfoPane lineInfo=" + ((LineInfoPane)node).getLineInfo())).forEach(node -> ((LineInfoPane)node).invalidateLinePane());
            }
        }
        if (this.currentTab == 6) {
            this.tabNumpadController.setNumpadMode();
        }
        this.switchCallNotificationVisibility(lineInfo);
        ClientSingleton.toLog(this.getClass().getSimpleName(), "setLineViewState 2 lineInfo=" + lineInfo + " state=" + lineInfo.getState());
    }

    public void switchCallNotificationVisibility() {
        LineInfo lineInfo = AudioCaller.getActiveLine();
        if (lineInfo != null) {
            this.switchCallNotificationVisibility(lineInfo);
        }
    }

    private void switchCallNotificationVisibility(LineInfo lineInfo) {
        boolean isSetShowing;
        int workingLineCount = AudioCaller.getWorkingLinesCount();
        if (lineInfo != null && lineInfo.getState() == 2) {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "SwitchCallNotificationVisibility callNotificationPane == null=" + (this.getCallNotificationPane() == null) + " chatPaneController.isCallPanesVisible()=" + (Serializable)(this.chatPaneController == null ? "null" : Boolean.valueOf(this.chatPaneController.isCallPanesVisible())) + " ClientSingleton.getInstance().isOpenedPopupsListEmpty()=" + ClientSingleton.getInstance().isOpenedPopupsListEmpty() + "\nCallBasePane.getIncomingNotificationMode()=" + CallBasePane.getCallViewNotificationMode() + "\nClientSingleton.getInstance().getParentWindow().isFocused()=" + ClientSingleton.getInstance().getParentWindow().isFocused() + "\nneedNotification(sessionInfo)=" + this.needNotification(lineInfo.getSessionInfo()) + "\nvideoProcessor.isDesktopShowing()=" + this.getVideoProcessor().isDesktopShowing() + " lineInfo = " + lineInfo);
        }
        if (lineInfo == null || AudioCaller.getWorkingLinesCount() == 0) {
            this.getCallNotificationPane().setShowing(lineInfo, false);
            return;
        }
        ClientSingleton.toLog(this.getClass().getSimpleName(), "switchCallNotificationVisibility lineInfo.getState() = " + lineInfo.getState() + " currentViewMode.get()=" + this.currentViewMode.get());
        if (this.currentViewMode.get() == 1) {
            isSetShowing = CallBasePane.getCallViewNotificationMode() == 2 ? false : !ClientSingleton.getInstance().isFocused();
        } else if ((lineInfo.getState() == 2 || lineInfo.getState() == 1) && CallBasePane.getCallViewNotificationMode() == 2) {
            isSetShowing = false;
        } else if ((lineInfo.getState() == 2 || lineInfo.getState() == 1) && CallBasePane.getCallViewNotificationMode() == 2) {
            isSetShowing = false;
        } else {
            SessionInfo sessionInfo = ClientSingleton.getInstance().getSessionInfo(lineInfo);
            isSetShowing = this.needNotification(sessionInfo);
        }
        ClientSingleton.toLog(this.getClass().getSimpleName(), "switchCallNotificationVisibility isFocused()=" + ClientSingleton.getInstance().getParentWindow().isFocused() + " isSetShowing=" + isSetShowing);
        if (isSetShowing) {
            this.getCallNotificationPane().showCallNotification(lineInfo);
        } else {
            this.getCallNotificationPane().setShowing(lineInfo, false);
            this.switchLinesViewMode();
        }
    }

    private boolean needNotification(SessionInfo sessionInfo) {
        if (sessionInfo == null) {
            return true;
        }
        boolean isSetShowing = false;
        ClientSingleton.toLog(this.getClass().getSimpleName(), "needNotification sessionInfo=" + sessionInfo + " ClientSingleton.getInstance().isFocused() : " + ClientSingleton.getInstance().isFocused());
        if (!ClientSingleton.getInstance().isFocused() || this.browser != null && this.fx_spWithWebView.getChildren().contains((Object)this.browser) || MainViewSceneController.isJXBrowserExists() && JXBrowserHelper.getInstance().getBrowserView() != null && this.fx_spWithWebView.getChildren().contains((Object)JXBrowserHelper.getInstance().getBrowserView())) {
            isSetShowing = true;
        } else if (this.chatPaneController != null) {
            AtomicBoolean atomicBoolean = new AtomicBoolean();
            ClientSingleton.getInstance().getLineInfoPanes().forEach(lineInfoPane -> {
                SessionInfo sessionInfo1;
                LineInfo lineInfo = lineInfoPane.getLineInfo();
                if (lineInfo != null && (sessionInfo1 = lineInfo.getSessionInfo()) != null && !atomicBoolean.get() && this.chatPaneController.equalsCurrentSessionInfo(sessionInfo1)) {
                    atomicBoolean.set(true);
                }
            });
            ClientSingleton.toLog(this.getClass().getSimpleName(), "needNotification equalsCurrentSessionInfo=" + atomicBoolean.get());
            isSetShowing = !atomicBoolean.get();
        } else {
            isSetShowing = true;
        }
        ClientSingleton.toLog(this.getClass().getSimpleName(), "needNotification : " + isSetShowing);
        return isSetShowing;
    }

    public void addToActiveLines(LineInfoPane lineInfoPane) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "addToActiveLines 1 lineInfo=" + lineInfoPane.getLineInfo() + " lines =  " + this.fx_vbActiveLines.getChildren().size());
        this.addPaneToParent((Pane)this.fx_vbActiveLines, (Node)lineInfoPane, 0);
        this.fx_spActiveLines.layout();
        ClientSingleton.toLog(this.getClass().getSimpleName(), "addToActiveLines 2 lineInfo=" + lineInfoPane.getLineInfo() + " lines =  " + this.fx_vbActiveLines.getChildren().size());
    }

    public void initParkLines() {
        this.parkLines.clear();
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            this.parkLines = ClientSingleton.getInstance().getContactInfoStream().filter(ContactInfo::isSlot).map(ParkingLinePane::new).collect(Collectors.toList());
        });
        ClientSingleton.toLog(this.getClass().getSimpleName(), "initParkLines parkLines=" + this.parkLines);
        this.addToParksLines();
    }

    public void contactInfoStateChanged(ContactInfo contactInfo) {
        ClientSingleton.getInstance().runLater(() -> this.onStateChanged(contactInfo));
    }

    private void onStateChanged(ContactInfo contactInfo) {
        SessionInfo sessionInfo;
        if (this.chatPaneController != null) {
            this.chatPaneController.contactStateChanged(contactInfo);
        }
        if (contactInfo != null) {
            this.addToParksLines();
        }
        if (this.tabAutorizedContactsController != null) {
            this.tabAutorizedContactsController.updateHandler(ClientSingleton.getInstance().getUserID(contactInfo));
        }
        if (this.tabNotAutorizedContactsController != null) {
            this.tabNotAutorizedContactsController.updateHandler(ClientSingleton.getInstance().getUserID(contactInfo));
        }
        if (this.tabSessionsController != null && (sessionInfo = ClientSingleton.getInstance().getSessionInfo(contactInfo, true)) != null) {
            this.tabSessionsController.updateHandler(sessionInfo, 0);
        }
        if (this.tabSpeedDialController != null) {
            this.tabSpeedDialController.updateSpeedDialHandler(contactInfo);
        }
        ClientSingleton.toLog(this.getClass().getSimpleName(), "onStateChanged contactInfo = " + contactInfo + " fx_ProfilesView.isEmpty = " + this.fx_ProfilesView.getChildren().isEmpty());
        if (!this.fx_ProfilesView.getChildren().isEmpty()) {
            Node child = (Node)this.fx_ProfilesView.getChildren().get(0);
            ClientSingleton.toLog(this.getClass().getSimpleName(), "onStateChanged child.getId() = " + child.getId());
            if ("GroupProfileViewController".equals(child.getId()) && this.chatPaneController != null) {
                ClientSingleton.toLog(this.getClass().getSimpleName(), "onStateChanged chatPaneController.getCurrentSessionInfo() = " + this.chatPaneController.getCurrentSessionInfo());
                this.groupProfileViewController.contactInfoStateChanged(contactInfo);
            }
        }
    }

    private void addAssistantLine(boolean isConnected) {
        if (this.assistantLinePane == null) {
            this.assistantLinePane = new AssistanceLinePane();
        }
        if (!this.fx_vbAssistantLine.getChildren().contains((Object)this.assistantLinePane)) {
            this.addPaneToParent((Pane)this.fx_vbAssistantLine, (Node)this.assistantLinePane);
        }
        if (!isConnected) {
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                String assistantSipDevice = clientConnector.getSIPDevice();
                this.assistantLinePane.setContactStateTitle(ClientSingleton.getInstance().getString("connecting_via") + " " + assistantSipDevice);
                this.assistantLinePane.removeCallButton();
            });
        } else {
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                String assistantSipDevice = clientConnector.getConnectedDeviceInfo();
                Object text = "";
                text = assistantSipDevice != null ? ClientSingleton.getInstance().getString("connected_via") + " " + assistantSipDevice : ClientSingleton.getInstance().getString("call_detail_connected");
                this.assistantLinePane.setContactStateTitle((String)text);
                this.assistantLinePane.addCallButton();
            });
        }
    }

    private void removeAssistantLine() {
        if (this.assistantLinePane != null) {
            this.fx_vbAssistantLine.getChildren().remove((Object)this.assistantLinePane);
        }
    }

    public void addToParksLines() {
        this.fx_vbParksLines.getChildren().clear();
        for (ParkingLinePane parkingLinePane : this.parkLines) {
            if (parkingLinePane.getState() != 8) continue;
            this.addPaneToParent((Pane)this.fx_vbParksLines, (Node)parkingLinePane);
        }
        if (!this.fx_vbParksLines.getChildren().isEmpty() && !this.fx_vbParksLines.getChildren().contains((Object)this.fx_lbParks)) {
            this.fx_vbParksLines.getChildren().add(0, (Object)this.fx_lbParks);
            this.fx_lbParks.setText(ClientSingleton.getInstance().getString("contacts_parking"));
        }
    }

    public void removeFromActiveLines(LineInfoPane lineInfoPane) {
        this.fx_vbActiveLines.getChildren().remove((Object)lineInfoPane);
        this.fx_spActiveLines.layout();
    }

    public String getString(String name) {
        return this.resources.getString(name);
    }

    private void setClientStateInMenuTab() {
        this.setClientStateInMenuTab(ClientSingleton.getInstance().getCurrentClientState());
    }

    private void setClientStateInMenuTab(int state) {
        if (this.tabTabMenuController != null && this.currentTab == 0) {
            this.tabTabMenuController.setClientState(state);
        }
    }

    @Override
    public boolean isNeedNotifyOnNewMessage(SessionInfo sessionInfo) {
        return this.needNotification(sessionInfo);
    }

    @Override
    public void checkNewMessages() {
        this.notificationObserver.onNext((Object)true);
    }

    @Override
    public void invalidateCallsNewMessages() {
        this.checkNewMessages();
    }

    @Override
    public void invalidateSessionsNewMessages() {
        this.checkNewMessages();
    }

    private void setChatSimpleView(boolean mode) {
        if (this.chatPaneController != null) {
            if (!mode && !this.chatPaneController.isSimpleViewMode()) {
                return;
            }
            this.chatPaneController.setSimpleViewMode(mode);
        }
    }

    private void openGroupViewer(SessionInfo sessionInfo) {
        if (this.groupProfileViewController == null) {
            this.groupProfileViewController = new GroupProfileViewController(this.resources, this);
        }
        Pane node = this.groupProfileViewController.getNode(sessionInfo);
        if (this.fx_ProfilesView.getChildren().isEmpty()) {
            this.openProfileView((Node)node);
        } else if (!this.fx_ProfilesView.getChildren().isEmpty()) {
            Node child = (Node)this.fx_ProfilesView.getChildren().get(0);
            if (!"GroupProfileViewController".equals(child.getId()) || sessionInfo.getSessionId().equals(this.groupProfileViewController.getSessionId())) {
                this.openProfileView((Node)node);
            }
        } else {
            this.closeProfileView();
        }
    }

    private void openProfileViewer(ContactInfo contactInfo) {
        if (this.profileViewController == null) {
            this.profileViewController = new ProfileViewController(this.resources, this);
        }
        this.profileViewController.initProfileViewer(contactInfo);
        this.openProfileView((Node)this.profileViewController.getNode());
    }

    private void openCallDetail(MessageInfo messageInfo) {
        this.callDetailsViewController = new CallDetailsViewController(this.resources, messageInfo, this);
        this.openProfileView(this.callDetailsViewController.getNode());
    }

    @Override
    public void stopPlayerInCallDetailsViewController() {
        if (this.callDetailsViewController != null) {
            this.callDetailsViewController.stopPlaying();
        }
    }

    @Override
    public void setContactsGroupView(ContactHeaderCellView contactHeaderCellView) {
        ClientSingleton.getInstance().runLater(() -> {
            if (contactHeaderCellView == null) {
                this.fx_ContactsGroupName.getChildren().clear();
            } else if (this.fx_ContactsGroupName.getChildren().isEmpty()) {
                this.fx_ContactsGroupName.getChildren().add((Object)contactHeaderCellView);
            }
        });
    }

    @Override
    public void setSelectionHeader(Pane pane) {
        if (pane == null) {
            this.fx_SelectionHeader.getChildren().clear();
        } else if (this.fx_SelectionHeader.getChildren().isEmpty()) {
            this.fx_SelectionHeader.getChildren().add((Object)pane);
        }
    }

    @Override
    public void setSelectionFooter(Pane pane) {
        if (pane == null) {
            this.fx_SelectionFooter.getChildren().clear();
        } else if (this.fx_SelectionFooter.getChildren().isEmpty()) {
            this.fx_SelectionFooter.getChildren().add((Object)pane);
        }
    }

    private void openCallDetail(LineInfo lineInfo) {
        CallActivityViewController callActivityViewController = new CallActivityViewController(this, lineInfo);
        this.openProfileView((Node)callActivityViewController.getNode());
    }

    private void openProfileView(Node node) {
        if (!this.fx_ProfilesView.getChildren().isEmpty() && this.fx_ProfilesView.getChildren().get(0) instanceof CallActivityViewController) {
            ((CallActivityViewController)this.fx_ProfilesView.getChildren().get(0)).removeSessionInfoListener();
        }
        this.fx_ProfilesView.getChildren().clear();
        this.addPaneToParent((Pane)this.fx_ProfilesView, node);
        if (this.fx_ProfilesView.getMaxWidth() != 300.0) {
            this.fx_ProfilesView.setMaxWidth(300.0);
        }
        if (this.myProfileSplitPaneSlider == null) {
            this.initProfileSplitPane();
        }
        if (!this.myProfileSplitPaneSlider.isAimContentVisible()) {
            double rightPos = this.fx_hbChatPane.getWidth() != 0.0 ? 300.0 / this.fx_hbChatPane.getWidth() : 0.47;
            double leftPos = 1.0 - rightPos;
            this.myProfileSplitPaneSlider.moveDivider(true, leftPos, 300.0);
            if (this.videoPaneController != null && !this.videoPaneController.getCurrentInfoMode()) {
                this.videoPaneController.setInfoPaneImages(0);
            }
            if (this.chatPaneController != null) {
                this.chatPaneController.clearInfoPaneImages();
            }
        }
    }

    private void closeProfileView() {
        if (this.myProfileSplitPaneSlider == null) {
            return;
        }
        if (this.myProfileSplitPaneSlider.isAimContentVisible()) {
            this.myProfileSplitPaneSlider.moveDividerToEndPosition();
            if (this.videoPaneController != null) {
                this.videoPaneController.setInfoButtonImage(false);
            }
        }
        if (this.chatPaneController != null) {
            this.chatPaneController.setInfoPaneImages();
        }
        if (!this.fx_ProfilesView.getChildren().isEmpty() && this.fx_ProfilesView.getChildren().get(0) instanceof CallActivityViewController) {
            ((CallActivityViewController)this.fx_ProfilesView.getChildren().get(0)).removeSessionInfoListener();
        }
    }

    @Override
    public void closePaneView() {
        this.closeProfileView();
    }

    @Override
    public void openChatView() {
        double rightPos = this.fx_ChatSplit.getWidth() != 0.0 ? 350.0 / this.fx_ChatSplit.getWidth() : 0.35;
        double leftPos = 1.0 - rightPos;
        this.myChatVideoSplitPaneSlider.moveDivider(true, leftPos, 350.0);
    }

    @Override
    public void closeChatView() {
        this.myChatVideoSplitPaneSlider.moveDividerToEndPosition();
    }

    public void openCallActivity(SessionInfo sessionInfo) {
        Optional<LineInfoPane> optionalLineInfoPane = ClientSingleton.getInstance().getLineInfoPanes().stream().filter(lineInfoPane -> lineInfoPane.getLineInfo() != null && lineInfoPane.getLineInfo().getSessionInfo() != null && lineInfoPane.getLineInfo().getSessionInfo().getSessionId() != null && sessionInfo.getSessionId().equals(lineInfoPane.getLineInfo().getSessionInfo().getSessionId())).findAny();
        optionalLineInfoPane.ifPresent(lineInfoPane -> this.openCallActivity(lineInfoPane.getLineInfo()));
    }

    @Override
    public void openCallActivity(LineInfo lineInfo) {
        if (lineInfo.getSessionInfo() != null) {
            CallActivityViewController callActivityViewController = new CallActivityViewController(this, lineInfo);
            Pane node = callActivityViewController.getNode();
            this.openProfileView((Node)node);
            if (this.chatPaneController != null) {
                this.chatPaneController.setInfoPaneImages(2);
            }
        }
    }

    @Override
    public void openCallHistory(LineInfo lineInfo) {
        if (lineInfo.getSessionInfo() != null) {
            this.openCallHistory(lineInfo.getSessionInfo());
        }
    }

    public void openCallHistory(SessionInfo sessionInfo) {
        VBox node;
        if (sessionInfo.getParties().size() == 1 && !((ContactInfo)sessionInfo.getParties().get(0)).isUser()) {
            ContactInfo contactInfo = (ContactInfo)sessionInfo.getParties().iterator().next();
            ActivityViewerController activityViewerController = new ActivityViewerController(this, contactInfo);
            node = activityViewerController.getNode();
        } else {
            HistoryViewerController historyViewerController = new HistoryViewerController(this, sessionInfo);
            node = historyViewerController.getNode();
            if (node != null) {
                node.setMinWidth(265.0);
                node.setMaxWidth(265.0);
                int elementCount = node.getChildren().size();
                node.setMinHeight((double)(elementCount * 32));
            }
        }
        if (node != null) {
            this.openProfileView((Node)node);
            if (this.chatPaneController != null) {
                this.chatPaneController.setInfoPaneImages(1);
            }
        }
    }

    public void openProfile() {
        if (this.fx_ProfilesView.getChildren().isEmpty()) {
            this.getSelectedItemId().flatMap(id -> ClientSingleton.getInstance().getSessionInfo((String)id)).ifPresent(sessionInfo -> {
                if (this.currentViewMode.get() == 1) {
                    this.currentViewMode.set(0);
                } else {
                    this.openProfile((SessionInfo)sessionInfo);
                }
            });
        } else {
            this.closeProfileView();
        }
    }

    @Override
    public void openProfile(SessionInfo sessionInfo) {
        if (sessionInfo == null) {
            return;
        }
        if (sessionInfo.isGroup()) {
            this.openGroupViewer(sessionInfo);
        } else {
            Optional<ContactInfo> oContactInfo = ClientSingleton.getInstance().getContactInfoFromSession(sessionInfo);
            oContactInfo.ifPresent(this::openProfileViewer);
        }
    }

    @Override
    public void dividerOpened(String id) {
        if ("chatVideoSplit".equals(id)) {
            if (this.myChatVideoSplitPaneSlider.isDividerOnStartPosition()) {
                this.setChatSimpleView(false);
            }
            if (this.fx_ProfilesView.getChildren().isEmpty()) {
                this.chatPaneController.setInfoButtonImage();
            }
        } else if (this.videoPaneController != null && this.videoPaneController.isChatOpened()) {
            double rightPos = this.fx_ChatSplit.getWidth() != 0.0 ? 350.0 / this.fx_ChatSplit.getWidth() : 0.35;
            double leftPos = 1.0 - rightPos;
            this.myChatVideoSplitPaneSlider.moveDivider(true, leftPos, 350.0);
        }
    }

    @Override
    public void dividerClosed(String id) {
        if ("chatVideoSplit".equals(id)) {
            this.setChatSimpleView(true);
            if (this.chatPaneController != null) {
                this.chatPaneController.removeFromOldMessages();
            }
        } else {
            LineInfo lineInfo = AudioCaller.getActiveLine();
            if (this.myChatVideoSplitPaneSlider != null && lineInfo != null && ClientSingleton.getInstance().isMyVideoEnabledFlag(lineInfo) && this.videoPaneController != null && !this.videoPaneController.isChatOpened()) {
                this.myChatVideoSplitPaneSlider.moveDividerToEndPosition();
            }
            if (this.chatPaneController != null) {
                this.chatPaneController.setInfoButtonImage();
            }
            this.fx_ProfilesView.getChildren().clear();
        }
    }

    @Override
    public void onCloseViewer() {
        this.closeProfileView();
    }

    @Override
    public void reopenProfileEditor(ContactInfo contactInfo) {
        TimerExecutor.getInstance().setMyAction(() -> {
            if (this.tabSessionsController != null) {
                this.tabSessionsController.setNewName(contactInfo);
            }
            if (this.tabCallsController != null) {
                this.tabCallsController.setNewName(contactInfo);
            }
            this.openProfileViewer(contactInfo);
        }).startWithDelayInGUIThread(100L);
    }

    @Override
    public void createProfileEditor(ContactInfo contactInfo) {
        ClientSingleton.getInstance().runLater(() -> this.onCreateProfileEditor(contactInfo));
    }

    private void onCreateProfileEditor(ContactInfo contactInfo) {
        AtomicBoolean isNotShowContactName = new AtomicBoolean(contactInfo.getName() == null || contactInfo.getName().isEmpty() || contactInfo.getState() == -1 && contactInfo.getStatus() == 0);
        ClientSingleton.toLog(this.getClass().getSimpleName(), "createProfileEditor name " + contactInfo.getName() + " isNotShowContactName=" + isNotShowContactName + " state=" + contactInfo.getState() + " status=" + contactInfo.getStatus());
        ProfileEditController profileViewController = new ProfileEditController(this.resources, this);
        profileViewController.initProfileViewer(contactInfo, isNotShowContactName.get());
        this.openProfileView((Node)profileViewController.getNode());
        profileViewController.setTextFieldFocus();
        if (this.chatPaneController != null) {
            this.chatPaneController.clearInfoPaneImages();
        }
    }

    @Override
    public void createActivitiesViewer(ContactInfo contactInfo) {
        ActivityViewerController activityViewerController = new ActivityViewerController(this, contactInfo);
        this.fx_ProfilesView.getChildren().clear();
        this.addPaneToParent((Pane)this.fx_ProfilesView, (Node)activityViewerController.getNode());
    }

    private void showTabsPane() {
        if (this.showSidebar.statusProperty().get() == Animation.Status.STOPPED && this.hideSidebar.statusProperty().get() == Animation.Status.STOPPED) {
            this.showSidebar.play();
        }
        boolean update = false;
        if (!this.fx_vbIconsBox.getChildren().contains((Object)this.fx_IconsPane)) {
            update = true;
            this.fx_vbIconsBox.getChildren().add(0, (Object)this.fx_IconsPane);
        }
        if (!this.fx_RootPane.getChildren().contains((Object)this.fx_viewTabMenu)) {
            update = true;
            this.fx_RootPane.getChildren().add(0, (Object)this.fx_viewTabMenu);
        }
        if (update) {
            this.fx_RootPane.applyCss();
            this.fx_RootPane.layout();
        }
    }

    private void hideTabsPane() {
        if (this.showSidebar.statusProperty().get() == Animation.Status.STOPPED && this.hideSidebar.statusProperty().get() == Animation.Status.STOPPED) {
            this.hideSidebar.play();
        }
        this.fx_vbIconsBox.getChildren().remove((Object)this.fx_IconsPane);
        this.fx_RootPane.getChildren().remove((Object)this.fx_viewTabMenu);
        this.fx_RootPane.applyCss();
        this.fx_RootPane.layout();
    }

    public void invalidated(Observable observable) {
    }

    @Override
    public void refreshSpeedDialList() {
        if (this.tabSpeedDialController != null) {
            this.tabSpeedDialController.refreshList();
        }
    }

    @Override
    public void removeCells(SpeedDialHeader speedDialHeader) {
    }

    @Override
    public void addCells(SpeedDialHeader speedDialHeader) {
    }

    @Override
    public void loadCustomPage(HBox urlBox, boolean isSwitched) {
        this.loadUrl(urlBox, isSwitched);
    }

    public void loadUrl(Object url, boolean isSwitched) {
        if (this.fx_pbLoadIndicator == null) {
            this.fx_pbLoadIndicator = ClientSingleton.getInstance().getProgressIndicator();
            this.fx_spWithWebView.getStylesheets().add((Object)this.getClass().getResource("/extracss/wvscrollbar.css").toExternalForm());
        }
        if (MainViewSceneController.isJXBrowserExists()) {
            if (JXBrowserHelper.getInstance().getBrowserView() == null) {
                if (JXBrowserHelper.getInstance().isProcessing()) {
                    JXBrowserHelper.getInstance().setOnInitiated(() -> this.loadInJxBrowserUrl(url));
                    this.addLoadingPane(ClientSingleton.getInstance().getString("initialising_browser"));
                    return;
                }
                TimerExecutor.getInstance().start(() -> {
                    try {
                        JXBrowserHelper.getInstance().initJXBrowser(() -> this.loadInJxBrowserUrl(url), () -> TimerExecutor.getInstance().startInGUI(() -> this.fx_spWithWebView.getChildren().remove((Object)this.fx_pbLoadIndicator)));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        MainViewSceneController.setIsJXBrowserExists(false);
                        String u = url instanceof HBox ? ((HBox)url).getId() : url.toString();
                        this.loadInWebView(u);
                    }
                });
            } else {
                this.loadInJxBrowserUrl(url);
            }
        } else {
            String u = url instanceof HBox ? ((HBox)url).getId() : url.toString();
            this.loadInWebView(u);
        }
    }

    private void loadInJxBrowserUrl(Object url) {
        TimerExecutor.getInstance().startInGUI(() -> {
            if (!this.fx_spWithWebView.getChildren().contains((Object)JXBrowserHelper.getInstance().getBrowserView())) {
                try {
                    JXBrowserHelper.getInstance().bindTo(this.fx_spWithWebView);
                    this.fx_hbChatPane.setVisible(false);
                    this.addPaneToParent((Pane)this.fx_spWithWebView, (Node)JXBrowserHelper.getInstance().getBrowserView());
                    if (!this.fx_spWithWebView.getChildren().contains((Object)this.fx_pbLoadIndicator)) {
                        this.addPaneToParent((Pane)this.fx_spWithWebView, (Node)this.fx_pbLoadIndicator);
                    }
                }
                catch (Exception e) {
                    MyUtils.showBrowserAlert();
                    e.printStackTrace();
                }
            }
        });
        JXBrowserHelper.getInstance().loadUrl(url);
    }

    private void loadInWebView(String url) {
        TimerExecutor.getInstance().startInGUI(() -> {
            if (this.browser == null) {
                TrustSSLProvider trustAllSSLProvider = new TrustSSLProvider();
                ClientSingleton.toLog(this.getClass().getSimpleName(), "WebView trustAllSSLProvider " + trustAllSSLProvider);
                HttpsURLConnection.setDefaultSSLSocketFactory(trustAllSSLProvider.getSslSocketFactory());
                HttpsURLConnection.setDefaultHostnameVerifier(trustAllSSLProvider.getHostNameVerifier());
                this.browser = new WebView();
                this.browser.setStyle("-fx-background-color:#ffffff");
                this.fx_pbLoadIndicator = ClientSingleton.getInstance().getProgressIndicator();
                WebEngine webEngine = this.browser.getEngine();
                webEngine.setOnError(event -> ClientSingleton.toLog(this.getClass().getSimpleName(), "WebView " + event.getMessage()));
                webEngine.setOnAlert(event -> ClientSingleton.toLog(this.getClass().getSimpleName(), "WebView " + (String)event.getData()));
                webEngine.setUserAgent("Mozilla/5.0 (Windows NT 6.2; WOW64) AppleWebKit/537.36 Chrome/44.0.2403.155 Safari/537.36");
                webEngine.setJavaScriptEnabled(true);
                webEngine.onResizedProperty().addListener((observable, oldValue, newValue) -> ClientSingleton.toLog(this.getClass().getSimpleName(), "WebView onResizedProperty = " + newValue));
                webEngine.onVisibilityChangedProperty().addListener((observable, oldValue, newValue) -> ClientSingleton.toLog(this.getClass().getSimpleName(), "WebView onVisibilityChangedProperty = " + newValue));
                Worker worker = webEngine.getLoadWorker();
                webEngine.locationProperty().addListener((observable, oldValue, newValue) -> ClientSingleton.toLog(this.getClass().getSimpleName(), "WebView locationProperty " + newValue));
                worker.runningProperty().addListener((observable, oldValue, newValue) -> ClientSingleton.toLog(this.getClass().getSimpleName(), "WebView runningProperty :  " + newValue));
                worker.stateProperty().addListener((observable, oldValue, newValue) -> {
                    ClientSingleton.toLog(this.getClass().getSimpleName(), "WebView stateProperty : " + newValue);
                    if (newValue == Worker.State.SUCCEEDED || newValue == Worker.State.FAILED) {
                        ClientSingleton.toLog(this.getClass().getSimpleName(), "WebView exception : " + worker.exceptionProperty().getValue());
                        this.fx_spWithWebView.getChildren().remove((Object)this.fx_pbLoadIndicator);
                        if (newValue == Worker.State.FAILED) {
                            worker.getException().printStackTrace();
                        }
                    }
                });
                worker.exceptionProperty().addListener((ChangeListener)new ChangeListener<Throwable>(){

                    public void changed(ObservableValue<? extends Throwable> ov, Throwable t, Throwable t1) {
                        ClientSingleton.toLog(this.getClass().getSimpleName(), "WebView Received exception: " + (t1 == null ? "null" : t1.getMessage()));
                    }
                });
                worker.progressProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                    public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                        ClientSingleton.toLog(this.getClass().getSimpleName(), "WebView progressProperty: " + newValue);
                    }
                });
                worker.messageProperty().addListener((ChangeListener)new ChangeListener<String>(){

                    public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                        ClientSingleton.toLog(this.getClass().getSimpleName(), "WebView messageProperty: " + newValue);
                    }
                });
            }
            this.browser.prefHeightProperty().bind((ObservableValue)this.fx_spWithWebView.heightProperty());
            this.browser.prefWidthProperty().bind((ObservableValue)this.fx_spWithWebView.widthProperty());
            if (!this.fx_spWithWebView.getChildren().contains((Object)this.browser)) {
                this.fx_hbChatPane.setVisible(false);
                this.addPaneToParent((Pane)this.fx_spWithWebView, (Node)this.browser);
            }
            if (!this.fx_spWithWebView.getChildren().contains((Object)this.fx_pbLoadIndicator)) {
                this.addPaneToParent((Pane)this.fx_spWithWebView, (Node)this.fx_pbLoadIndicator);
            }
            this.browser.getEngine().load(url);
        });
    }

    private void removeWebView() {
        if (!this.fx_hbChatPane.isVisible()) {
            this.fx_hbChatPane.setVisible(true);
        }
        if (MainViewSceneController.isJXBrowserExists()) {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "JXBrowserHelper.getInstance().getBrowserView() = " + JXBrowserHelper.getInstance().getBrowserView() + " fx_hbChatPane.isVisible()=" + this.fx_hbChatPane.isVisible());
            if (JXBrowserHelper.getInstance().getBrowserView() != null) {
                this.fx_spWithWebView.getChildren().remove((Object)this.fx_pbLoadIndicator);
                this.fx_spWithWebView.getChildren().remove((Object)JXBrowserHelper.getInstance().getBrowserView());
                JXBrowserHelper.getInstance().closeBrowser();
            }
        } else {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "browser() browser = " + this.browser);
            if (this.browser != null) {
                this.fx_spWithWebView.getChildren().remove((Object)this.fx_pbLoadIndicator);
                this.fx_spWithWebView.getChildren().remove((Object)this.browser);
                this.browser.getEngine().load("about:blank");
                CookieHandler.setDefault(new CookieManager());
                this.browser.prefHeightProperty().unbind();
                this.browser.prefWidthProperty().unbind();
            }
        }
    }

    private void addPaneToParent(Pane parent, Node child, int index) {
        if (parent != null && !parent.getChildren().contains((Object)child)) {
            parent.getChildren().add(index, (Object)child);
        }
    }

    private void addPaneToParent(Pane parent, Node child) {
        if (parent != null && !parent.getChildren().contains((Object)child)) {
            parent.getChildren().add((Object)child);
        }
    }

    @Override
    public Optional<String> getSelectedItemId() {
        if (this.selectedItemId.get() == null || this.selectedItemId.get().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.selectedItemId.get());
    }

    private void setSelectedItemId(SessionInfo sessionInfo) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "setSelectedItemId sessionInfo = " + sessionInfo + " itemId=" + sessionInfo.getSessionId());
        String itemId = sessionInfo.getSessionId() == null ? (sessionInfo.getParties().size() == 1 ? ((ContactInfo)sessionInfo.getParties().get(0)).getId() : String.valueOf(sessionInfo.hashCode())) : sessionInfo.getSessionId();
        this.setSelectedItemId(itemId);
    }

    private void setSelectedItemId(String itemId) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "setSelectedItemId itemId=" + itemId);
        this.selectedItemId.set(itemId);
    }

    @Override
    public void clearSelection() {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "clearSelection getSelectedItemId = " + this.getSelectedItemId());
        this.setSelectedItemId("");
        ClientSingleton.getInstance().runLater(this::csAction);
    }

    private void csAction() {
        if (this.fx_ProfilesView != null && !this.fx_ProfilesView.getChildren().isEmpty()) {
            this.closeProfileView();
            if (this.chatPaneController != null) {
                this.chatPaneController.clearInfoPaneImages();
            }
        }
        if (this.chatPaneController != null) {
            this.chatPaneController.clearSessionInfo();
        }
        this.fx_hbChatPane.getChildren().clear();
        this.fx_hbChatPane.setVisible(false);
        this.removeLoadingPane();
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            try {
                clientConnector.setProperty(Constants.LAST_VISIBLE_SESSION, (Object)"");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        ClientSingleton.toLog(this.getClass().getSimpleName(), "clearSelection fx_hbChatPane fx_hbChatPane.getChildren().size() = " + this.fx_hbChatPane.getChildren().size());
    }

    private void initObservable() {
        String[] actions = new String[]{IntentConstants.LINE_INFO_RECORD_LINE, IntentConstants.LINE_INFO_MUTE_LINE, IntentConstants.CONTACT_REMOVED, IntentConstants.SESSION_CREATED, IntentConstants.SESSION_REMOVED, IntentConstants.CONTACT_ADDED, Constants.START_VIDEO, Constants.OPEN_SESSION, Constants.SEARCH_SESSIONS_EXT, Constants.SEARCH_CALLS_EXT, Constants.RESIZE_TABS_PANE, Constants.SHARE_DESKTOP, Constants.DISMISS_SHARE_DESKTOP, Constants.OPEN_CALL_DETAILS, Constants.OPEN_CALL_ACTIVITY, Constants.OPEN_PROFILE, Constants.OPEN_PROFILE_EDITOR, Constants.DO_NOT_DISTURB_, Constants.DO_NOT_DISTURB, "ON_EXIT", Constants.ASSISTANT_STATUS_REGISTERED, Constants.ASSISTANT_STATUS_UNREGISTERED, Constants.ASSISTANT_STATE_DIALING, Constants.ASSISTANT_STATE_CONNECTED, Constants.ASSISTANT_STATE_NO_ANSWERED, Constants.ASSISTANT_HIDE_NITIFICATION, Constants.ASSISTANT_STATE_EXCEPTION, Constants.PHONE_DEVICE_ADDED, Constants.PHONE_DEVICE_REMOVED, "Load_Updates"};
        ClientSingleton.getInstance().addObserver(this, actions);
    }

    public void sessionUpdated(SessionInfo sessionInfo) {
        if (this.chatPaneController != null) {
            this.chatPaneController.sessionUpdated(sessionInfo);
        }
    }

    private HBox getTopButtonsPane() {
        String backgroundColor;
        int imageWidth = ClientUtil.getOS() == ClientUtil.OS.MAC ? 25 : 50;
        HBox hBox = new HBox();
        hBox.setAlignment(Pos.CENTER);
        this.fx_CloseButton = new ImageButton();
        HBox.setHgrow((Node)this.fx_CloseButton, (Priority)Priority.ALWAYS);
        this.fx_CloseButton.setPrefWidth(imageWidth);
        this.fx_CloseButton.setIsRounded(true);
        this.fx_CloseButton.setBackgroundColor("transparent");
        String imageName = "";
        if (ClientUtil.getOS() == ClientUtil.OS.MAC) {
            imageName = "mac_close.png";
        } else {
            this.fx_CloseButton.setFocusedCustomStyle("-fx-background-color: red;-fx-background-insets: 0 0 0 0;-fx-border-radius: 0 10 0 0;    -fx-background-radius: 0 10 0 0;");
            imageName = "win_close.png";
        }
        ClientSingleton.getInstance().setImageToImageView(this.fx_CloseButton, imageName);
        String string = backgroundColor = Theme.getInstance().isDarkTheme() ? "#595959" : "#d9e0ef";
        if (ClientUtil.getOS() == ClientUtil.OS.MAC) {
            this.fx_CloseButton.setOnMouseClicked(event -> {
                try {
                    StandardMacApp.hide();
                }
                catch (Exception | NoSuchMethodError e) {
                    ClientSingleton.getInstance().setIconified(true);
                    e.printStackTrace();
                }
            });
        } else {
            this.fx_CloseButton.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> {
                event.consume();
                ClientSingleton.toLog(this.getClass().getSimpleName(), "fx_CloseButton hide");
                ClientSingleton.getInstance().setStatusBarIcon(0);
                TimerExecutor.getInstance().setMyAction(() -> {
                    ClientSingleton.toLog(this.getClass().getSimpleName(), "fx_CloseButton hide push");
                    ClientSingleton.getInstance().getParentWindow().hide();
                }).startWithDelayInGUIThread(1000L);
            }));
        }
        this.fx_CloseButton.setReleaseFocusAfterClick(true);
        this.fx_MinButton = new ImageButton();
        HBox.setHgrow((Node)this.fx_MinButton, (Priority)Priority.ALWAYS);
        this.fx_MinButton.setPrefWidth(imageWidth);
        this.fx_MinButton.setIsRounded(true);
        this.fx_MinButton.setBackgroundColor("transparent");
        if (ClientUtil.getOS() == ClientUtil.OS.MAC) {
            imageName = "mac_min.png";
        } else {
            this.fx_MinButton.setFocusedBackgroundColor(backgroundColor);
            imageName = "win_min.png";
        }
        ClientSingleton.getInstance().setImageToImageView(this.fx_MinButton, imageName);
        if (ClientUtil.getOS() == ClientUtil.OS.MAC) {
            this.fx_MinButton.setOnMouseClicked(event -> ClientSingleton.getInstance().setIconified(true));
        } else {
            this.fx_MinButton.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> {
                event.consume();
                ClientSingleton.getInstance().setIconified(true);
            }));
        }
        this.fx_MinButton.setReleaseFocusAfterClick(true);
        this.fx_MaxButton = new ImageButton();
        HBox.setHgrow((Node)this.fx_MaxButton, (Priority)Priority.ALWAYS);
        this.fx_MaxButton.setPrefWidth(imageWidth);
        this.fx_MaxButton.setIsRounded(true);
        this.fx_MaxButton.setBackgroundColor("transparent");
        if (ClientUtil.getOS() == ClientUtil.OS.MAC) {
            imageName = "mac_max.png";
        } else {
            this.fx_MaxButton.setFocusedBackgroundColor(backgroundColor);
            imageName = "win_max.png";
        }
        ClientSingleton.getInstance().setImageToImageView(this.fx_MaxButton, imageName);
        this.fx_MaxButton.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> {
            event.consume();
            if (this.currentViewMode.get() == 1) {
                this.switchViewMode();
            }
            ClientSingleton.getInstance().setFullScreen();
        }));
        this.fx_MaxButton.setReleaseFocusAfterClick(true);
        this.fx_MinButton.prefHeightProperty().bind((ObservableValue)hBox.heightProperty());
        this.fx_MaxButton.prefHeightProperty().bind((ObservableValue)hBox.heightProperty());
        this.fx_CloseButton.prefHeightProperty().bind((ObservableValue)hBox.heightProperty());
        this.fx_SwitchView = new ImageButton();
        HBox.setHgrow((Node)this.fx_SwitchView, (Priority)Priority.ALWAYS);
        this.fx_SwitchView.prefHeightProperty().bind((ObservableValue)hBox.heightProperty());
        this.fx_SwitchView.setPrefWidth(imageWidth);
        this.fx_SwitchView.setIsRounded(true);
        this.fx_SwitchView.setBackgroundColor("transparent");
        this.fx_SwitchView.setImagePath(this.currentViewMode.get() == 0 ? "view_full.png" : "view_half.png");
        if (ClientUtil.getOS() == ClientUtil.OS.WINDOWS) {
            this.fx_SwitchView.setFocusedBackgroundColor(backgroundColor);
        }
        this.fx_SwitchView.setOnMouseClicked(event -> this.switchViewMode());
        hBox.widthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                ClientSingleton.toLog(this.getClass().getSimpleName(), "hBox.widthProperty()=" + newValue);
            }
        });
        if (ClientUtil.getOS() == ClientUtil.OS.MAC) {
            hBox.getChildren().addAll((Object[])new Node[]{this.fx_CloseButton, this.fx_MinButton, this.fx_MaxButton, this.fx_SwitchView});
            this.fx_MacTopButtonsPane.setMinWidth(100.0);
        } else {
            hBox.getChildren().addAll((Object[])new Node[]{this.fx_SwitchView, this.fx_MinButton, this.fx_MaxButton, this.fx_CloseButton});
            this.fx_WinTopButtonsPane.setMinWidth(170.0);
        }
        if (ClientUtil.getOS() == ClientUtil.OS.MAC) {
            EventHandler enteredEvent = event -> {
                this.fx_MaxButton.setImagePath("mac_max_h.png");
                this.fx_MinButton.setImagePath("mac_min_h.png");
                this.fx_CloseButton.setImagePath("mac_close_h.png");
            };
            EventHandler exitedEvent = event -> {
                this.fx_MaxButton.setImagePath("mac_max.png");
                this.fx_MinButton.setImagePath("mac_min.png");
                this.fx_CloseButton.setImagePath("mac_close.png");
            };
            hBox.addEventHandler(MouseEvent.MOUSE_ENTERED, enteredEvent);
            hBox.addEventHandler(MouseEvent.MOUSE_EXITED, exitedEvent);
        }
        return hBox;
    }

    public void setTopButtonsImages(boolean isFocused) {
        if (isFocused) {
            this.fx_MaxButton.setImagePath("mac_max.png");
            this.fx_MinButton.setImagePath("mac_min.png");
            this.fx_CloseButton.setImagePath("mac_close.png");
        } else {
            this.fx_MaxButton.setImagePath("mac_nofocus.png");
            this.fx_MinButton.setImagePath("mac_nofocus.png");
            this.fx_CloseButton.setImagePath("mac_nofocus.png");
        }
    }

    private void sendRead() {
        if (!ClientSingleton.getInstance().isFocused()) {
            return;
        }
        if (this.chatPaneController != null) {
            this.chatPaneController.sendRead();
        }
        TimerExecutor.getInstance().setMyAction(() -> {
            if (this.fx_tfSearch != null && this.fx_tfSearch.getText().isEmpty()) {
                this.updateSessionsLists();
            }
            this.checkNewMessages();
        }).startWithDelayInGUIThread(500L);
    }

    public void onFocusGained() {
        if (this.chatPaneController != null) {
            this.chatPaneController.setRefreshingList(false);
            this.chatPaneController.stopAllPlayers();
        }
        this.sendRead();
    }

    private void initNotificationObserver() {
        this.notificationObserver = PublishSubject.create();
        this.disposableNotification = this.notificationObserver.debounce(500L, TimeUnit.MILLISECONDS).switchMap(withoutCheck1 -> {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "Notification: new messages");
            Optional<ClientConnector> optionalClientConnector = ClientSingleton.getInstance().getClientConnector();
            if (!optionalClientConnector.isPresent()) {
                return io.reactivex.Observable.empty();
            }
            int count = 0;
            List<SessionInfo> sessionsList = ClientSingleton.getInstance().getCalls();
            ArrayList callList = new ArrayList();
            try {
                callList.addAll(sessionsList.stream().filter(sessionInfo -> ClientSingleton.getInstance().getMissedCallsCount((SessionInfo)sessionInfo) > 0L).collect(Collectors.toList()));
            }
            catch (ConcurrentModificationException ex) {
                ex.printStackTrace();
            }
            ArrayList sessionIds = new ArrayList();
            if (!callList.isEmpty()) {
                sessionIds.addAll(callList.stream().map(SessionInfo::getSessionId).collect(Collectors.toList()));
            }
            count += callList.size();
            Stream<SessionInfo> stream1 = ClientSingleton.getInstance().getSessionInfoStream();
            List list = stream1.filter(sessionInfo -> ClientSingleton.getInstance().getNewMessagesCount((SessionInfo)sessionInfo) > 0L && !sessionIds.contains(sessionInfo.getSessionId())).collect(Collectors.toList());
            ClientSingleton.toLog(this.getClass().getSimpleName(), "Notification:  calls = " + callList.size() + " messages = " + list.size() + " total = " + (count += list.size()));
            ClientSingleton.getInstance().setStatusBarIcon(count);
            return io.reactivex.Observable.just((Object)new Pair((Object)callList.isEmpty(), (Object)list.isEmpty()));
        }).observeOn((Scheduler)JavaFxScheduler.platform()).subscribe(pair -> {
            this.fx_CallsNewMessages.setVisible((Boolean)pair.getKey() == false);
            this.fx_SessionsNewMessages.setVisible((Boolean)pair.getValue() == false);
        }, Throwable::printStackTrace);
    }

    public void onUsersAvatarUpdated() {
        if (this.chatPaneController != null) {
            this.chatPaneController.onUpdateAvatars();
        }
    }

    public void setFocus() {
        this.fx_tfSearch.requestFocus();
    }

    public SessionInfo getCurrentSessionInfo() {
        if (this.chatPaneController == null) {
            return null;
        }
        return this.chatPaneController.getSessionInfo();
    }

    public void chatFireScrollEvent(ScrollEvent scrollEvent) {
        this.chatPaneController.chatFireScrollEvent(scrollEvent);
    }

    public void invalidateViews() {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "invalidateViews start");
        Platform.runLater(() -> {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "invalidateViews start in GUI thread");
            this.invalidate();
        });
    }

    private void invalidate() {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "invalidate start : currentViewMode.get() = " + this.currentViewMode.get() + " chatPaneController=" + this.chatPaneController);
        if (this.currentViewMode.get() == 0 && this.chatPaneController != null) {
            this.chatPaneController.invalidateChatView();
            this.chatPaneController = null;
            ClientSingleton.toLog(this.getClass().getSimpleName(), "invalidate chatPaneController = " + this.chatPaneController);
            ClientSingleton.getInstance().releaseViewResources((Pane)this.hbChatList);
            this.hbCallList.prefHeightProperty().unbind();
            ClientSingleton.toLog(this.getClass().getSimpleName(), "invalidate hbChatList = " + this.hbChatList);
            ClientSingleton.getInstance().releaseViewResources((Pane)this.hbCallList);
            ClientSingleton.toLog(this.getClass().getSimpleName(), "invalidate hbCallList = " + this.hbCallList);
            this.fx_ChatSplit.getItems().clear();
            this.fx_ProfilesView.getChildren().clear();
            this.myProfileSplitPaneSlider = null;
            ClientSingleton.toLog(this.getClass().getSimpleName(), "invalidate myProfileSplitPaneSlider = " + this.myProfileSplitPaneSlider);
            this.initChatVideoSplitPane();
            this.initProfileSplitPane();
            ClientSingleton.toLog(this.getClass().getSimpleName(), "invalidate getSelectedItemId() = " + this.getSelectedItemId());
            this.fx_hbChatPane.getChildren().clear();
            if (this.getSelectedItemId().isPresent()) {
                String id = this.getSelectedItemId().get();
                ClientSingleton.toLog(this.getClass().getSimpleName(), "invalidate getSelectedItemId() = " + id);
                Optional<SessionInfo> sessionInfo = ClientSingleton.getInstance().getSessionInfo(id);
                ClientSingleton.toLog(this.getClass().getSimpleName(), "invalidate sessionInfo = " + sessionInfo);
                if (sessionInfo.isEmpty()) {
                    Optional<ContactInfo> contactInfo = ClientSingleton.getInstance().getContactInfoByUserId(id);
                    ClientSingleton.toLog(this.getClass().getSimpleName(), "invalidate contactInfo = " + contactInfo);
                    if (contactInfo.isPresent()) {
                        SessionInfo session = ClientSingleton.getInstance().getSessionInfo(contactInfo.get());
                        ClientSingleton.toLog(this.getClass().getSimpleName(), "invalidate session = " + session);
                        if (session != null) {
                            sessionInfo = Optional.of(session);
                        }
                    }
                }
                sessionInfo.ifPresent(info -> this.openChatSession((SessionInfo)info, false));
            }
        }
        TabBaseView tabBaseView = this.getTabBaseView();
        ClientSingleton.toLog(this.getClass().getSimpleName(), "invalidate tabBaseView = " + tabBaseView + " currentTab=" + this.currentTab);
        if (tabBaseView != null) {
            tabBaseView.dispose();
            switch (this.currentTab) {
                case 1: {
                    this.tabAutorizedContactsController = null;
                    this.addAutorizedContactsList();
                    break;
                }
                case 2: {
                    this.tabNotAutorizedContactsController.removeMultiSelectionMode();
                    this.tabNotAutorizedContactsController = null;
                    this.addNotAutorizedContactsList();
                    break;
                }
                case 3: {
                    this.tabSessionsController = null;
                    this.addSessionsList();
                    break;
                }
                case 4: {
                    this.tabCallsController.removeMultiSelectionMode();
                    this.tabCallsController = null;
                    this.addCallsList();
                }
            }
        }
        ClientSingleton.toLog(this.getClass().getSimpleName(), "invalidate: done");
    }

    public void reloadMenuTab() {
        if (this.tabTabMenuController != null) {
            this.tabTabMenuController.loadMenuTab();
        }
    }

    public void clientStateChanged(int state) {
        TimerExecutor.getInstance().setMyAction(() -> {
            this.fx_imgTabMenu.setImagePath(this.getStateImage(state));
            this.setClientStateInMenuTab(state);
            String deviceInfo = ClientSingleton.getInstance().getClientConnector().get().getConnectedDeviceInfo();
            ClientSingleton.toLog(this.getClass().getSimpleName(), "clientStateChanged state=" + state + " deviceInfo=" + deviceInfo);
            if (state == 8 && deviceInfo != null && this.fx_vbActiveLines.getChildren().isEmpty()) {
                this.addAssistantLine(true);
            } else {
                this.removeAssistantLine();
            }
        }).startWithDelayInGUIThread(100L);
    }

    public void clearChatMessagePane() {
        if (this.chatPaneController != null) {
            this.chatPaneController.clearChatMessagePane();
        }
    }

    public void closePanes() {
        if (this.chatPaneController != null) {
            this.chatPaneController.clearPanes();
        }
    }

    public void searchUpdated() {
        if (this.currentTab == 7 && this.tabSearchController != null) {
            this.tabSearchController.searchUpdated();
        }
    }

    public void searchInChat() {
        if (this.chatPaneController != null) {
            this.chatPaneController.openSearchPane();
        }
    }

    public void contactGroupsListChanged() {
        ClientSingleton.toLog("ClientListener", "contactGroupsListChanged (currentTab == MainViewModel.TAB_CONTACT_NA && tabNotAutorizedContactsController != null) = " + (this.currentTab == 2 && this.tabNotAutorizedContactsController != null));
        if (this.currentTab == 2 && this.tabNotAutorizedContactsController != null) {
            this.tabNotAutorizedContactsController.contactGroupsListChanged();
        }
    }

    public void setServiceContacts(String serviceId, List<ContactInfo> list) {
        if (this.currentTab == 2 && this.tabNotAutorizedContactsController != null) {
            this.tabNotAutorizedContactsController.setServiceContacts(serviceId, list);
        }
        ClientSingleton.getInstance().updateTransferView(serviceId);
    }

    class SessionWaitingForAction {
        SessionInfo sessionInfo = null;
        int action = -1;

        public SessionWaitingForAction(SessionInfo sessionInfo, int action) {
            this.sessionInfo = sessionInfo;
            this.action = action;
        }

        public SessionInfo getSessionInfo() {
            return this.sessionInfo;
        }

        public int getAction() {
            return this.action;
        }

        public String toString() {
            return "SessionWaitingForAction{sessionInfo=" + this.sessionInfo + ", action=" + this.action + "}";
        }
    }
}

