/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.notification;

import io.reactivex.Observable;
import io.reactivex.Scheduler;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.rxjavafx.schedulers.JavaFxScheduler;
import io.reactivex.subjects.PublishSubject;
import java.util.concurrent.TimeUnit;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.utils.ClientUtil;
import net.sipsnet.client.utils.popupstage.MyPopupWindow;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.views.notification.NotificationPane;
import net.sipsnet.client.views.tabs.utils.ICheckNewMessagesNotification;
import smile.cti.client.MessageInfo;

public class Notification
extends VBox {
    private final SimpleBooleanProperty isShowing = new SimpleBooleanProperty(false);
    private MyPopupWindow myPopupWindow;
    private final int EXPANDED_WIDTH = 400;
    private final ICheckNewMessagesNotification iCheckNewMessagesNotification;
    private Stage primaryStage;
    private PublishSubject<Boolean> resizeObserver;
    private Disposable disposableResize;
    private final CompositeDisposable disposables = new CompositeDisposable();
    private static Notification singleton;

    private boolean isIsShowing() {
        return this.isShowing.get();
    }

    private void setIsShowing(boolean isShowing) {
        this.isShowing.set(isShowing);
    }

    private Notification(ICheckNewMessagesNotification iCheckNewMessagesNotification) {
        this.iCheckNewMessagesNotification = iCheckNewMessagesNotification;
        this.initPopupWindow();
        this.initResizeObserver();
        this.myPopupWindow.showAtPosition(30.0, true);
        this.getChildren().addListener(change -> this.resizeNotificationsPane());
    }

    public void addNotification(MessageInfo messageInfo) {
        if (ClientSingleton.getInstance().getCurrentClientState() == 3) {
            return;
        }
        NotificationPane notificationPaneNewNew = new NotificationPane(this);
        notificationPaneNewNew.buildAndShow(messageInfo);
    }

    public void addNotification(String name, String content, boolean isWithTimer, String imageName, int mode) {
        if (ClientSingleton.getInstance().getCurrentClientState() == 3) {
            return;
        }
        NotificationPane notificationPaneNewNew = new NotificationPane(this);
        notificationPaneNewNew.buildAndShow(name, content, isWithTimer, imageName, mode);
    }

    public void addNotification(String name, String content, boolean isWithTimer, String imageName) {
        if (ClientSingleton.getInstance().getCurrentClientState() == 3) {
            return;
        }
        NotificationPane notificationPaneNewNew = new NotificationPane(this);
        notificationPaneNewNew.buildAndShow(name, content, isWithTimer, imageName);
    }

    public void addNotificationPane(NotificationPane notification) {
        this.getChildren().add((Object)notification);
    }

    public void removeNotification(NotificationPane notification) {
        this.getChildren().remove((Object)notification);
    }

    public void resizeNotificationsPane() {
        this.resizeObserver.onNext((Object)true);
    }

    private int resizePane() {
        int height = 0;
        for (Node node : this.getChildren()) {
            NotificationPane notificationPaneNew = (NotificationPane)node;
            height = (int)((double)height + (notificationPaneNew.getMinHeight() + (double)(ClientUtil.getOS() == ClientUtil.OS.WINDOWS ? 10 : 0)));
        }
        return height;
    }

    public void closeNotification() {
        for (Node node : this.getChildren()) {
            NotificationPane notificationPaneNew = (NotificationPane)node;
            notificationPaneNew.closeNotificationPane();
        }
    }

    public static synchronized Notification getInstance(ICheckNewMessagesNotification iCheckNewMessagesNotification) {
        if (singleton == null) {
            singleton = new Notification(iCheckNewMessagesNotification);
        }
        return singleton;
    }

    public boolean isShowing() {
        return this.isIsShowing();
    }

    private void initPopupWindow() {
        VBox rootPane = new VBox(new Node[]{this});
        rootPane.setStyle("-fx-background-color:transparent");
        rootPane.setMaxWidth(this.getMaxWidth());
        rootPane.setMinWidth(this.getMinWidth());
        rootPane.setPrefWidth(this.getPrefWidth());
        rootPane.setMaxHeight(this.getMaxHeight());
        rootPane.setMinHeight(this.getMaxHeight());
        rootPane.setPrefHeight(this.getMaxHeight());
        rootPane.setMaxWidth(420.0);
        rootPane.setSpacing(5.0);
        this.primaryStage = new Stage();
        this.primaryStage.setTitle("");
        this.primaryStage.initModality(Modality.NONE);
        this.primaryStage.initStyle(StageStyle.UTILITY);
        this.primaryStage.setOpacity(0.0);
        this.primaryStage.setHeight(0.0);
        this.primaryStage.setWidth(0.0);
        if (ClientUtil.getOS() == ClientUtil.OS.WINDOWS) {
            this.primaryStage.show();
        }
        this.myPopupWindow = MyPopupWindow.getNewInstance((Pane)rootPane, (Window)this.primaryStage, true).setAlwaysOnTop(false).setNoneModality().initMotionListeners((Node)this);
    }

    private void initResizeObserver() {
        this.resizeObserver = PublishSubject.create();
        this.disposables.add(this.resizeObserver.debounce(200L, TimeUnit.MILLISECONDS).switchMap(pair -> {
            int height = this.getChildren().isEmpty() ? 0 : this.resizePane();
            return Observable.just((Object)height);
        }).observeOn((Scheduler)JavaFxScheduler.platform()).subscribe(height -> {
            this.setMaxHeight(height.intValue());
            this.setMinHeight(height.intValue());
            this.layout();
            this.myPopupWindow.setMaxHeight(height.intValue());
            if (!this.isIsShowing() && this.getChildren().size() == 1) {
                this.myPopupWindow.showAtPosition(height.intValue(), true, false);
                this.myPopupWindow.printPosition();
                this.setIsShowing(true);
            } else if (this.isIsShowing() && this.getChildren().isEmpty()) {
                this.myPopupWindow.hideToRight(false, false);
                this.setIsShowing(false);
                TimerExecutor.getInstance().setMyAction(this.iCheckNewMessagesNotification::checkNewMessages).startWithDelay(1000L);
            } else {
                this.myPopupWindow.goToYLocation((int)height);
            }
        }, Throwable::printStackTrace));
    }
}

