/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.profiles.profileedit;

import java.util.List;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.RemoveImageButton;
import net.sipsnet.client.utils.viewers.combobox.IContextMenuActionListener;
import net.sipsnet.client.utils.viewers.combobox.MyContextComboBox;

public class EditDataPaneBaseWithContextMenu
extends HBox
implements IContextMenuActionListener {
    private final SimpleIntegerProperty labelFontSize = new SimpleIntegerProperty((Object)12, "labelFontSize");
    private final SimpleStringProperty labelFontFamily = new SimpleStringProperty((Object)"Roboto", "labelFontFamily");
    private final SimpleStringProperty labelFontColor = new SimpleStringProperty((Object)"gray", "labelFontColor");
    private final SimpleStringProperty underlineColor = new SimpleStringProperty((Object)"#dce0ec", "labelFontColor");
    private final SimpleBooleanProperty isEditable = new SimpleBooleanProperty((Object)true, "isEditable");
    private final SimpleBooleanProperty withRemoveButton = new SimpleBooleanProperty((Object)true, "withRemoveButton");
    private final HBox textBox;
    private final Pane parentPane;
    private final HBox hBoxImage;
    private final boolean withCheckMenu;
    private final TextField textField;
    private MyContextComboBox myComboBox;
    private final ChangeListener<Number> fontSizeListener = (observable, oldValue, newValue) -> this.setTextFieldStyle();
    private final ChangeListener<String> fontFamilyListener = (observable, oldValue, newValue) -> this.setTextFieldStyle();
    private final ChangeListener<String> fontColorListener = (observable, oldValue, newValue) -> this.setTextFieldStyle();
    private final ChangeListener<String> underlineColorListener = (observable, oldValue, newValue) -> this.setTextFieldStyle();
    private final ChangeListener<Boolean> withRemoveButtonListener = (observable, oldValue, newValue) -> this.addRemoveButton();

    public void setText(String text) {
        this.textField.setText(text);
    }

    public String getText() {
        return this.textField.getText();
    }

    public String getKey() {
        return this.textField.getId();
    }

    public void setTextField(String text) {
        this.textField.setText(text);
    }

    public EditDataPaneBaseWithContextMenu(boolean withCheckMenu, Pane parentPane) {
        this.parentPane = parentPane;
        this.withCheckMenu = withCheckMenu;
        this.minHeight(30.0);
        this.setDefaultFont();
        this.textBox = new HBox();
        HBox.setHgrow((Node)this.textBox, (Priority)Priority.ALWAYS);
        this.textBox.minHeight(30.0);
        this.textBox.setAlignment(Pos.CENTER);
        this.textField = new TextField();
        this.textBox.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        this.textField.prefWidthProperty().bind((ObservableValue)this.textBox.widthProperty().subtract(10));
        this.setTextFieldStyle();
        this.hBoxImage = new HBox();
        this.hBoxImage.setMinWidth(0.0);
        this.hBoxImage.setMinHeight(0.0);
        this.textBox.getChildren().addAll((Object[])new Node[]{this.textField, this.hBoxImage});
    }

    public void setTextFieldEditable(boolean mode) {
        if (this.myComboBox != null) {
            this.myComboBox.setEditable(mode);
        }
        this.textField.setEditable(mode);
        if (!mode) {
            this.hBoxImage.getChildren().clear();
        }
    }

    public void setMenuLabelRounded(boolean mode) {
        this.myComboBox.setRoundedCorners(mode);
    }

    public void setMenuLabelBackgroundColor(String color) {
        this.myComboBox.setBackgroundColor(color);
    }

    protected void initComponents(Pane boxPane) {
        boxPane.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        HBox.setHgrow((Node)this, (Priority)Priority.ALWAYS);
        HBox.setMargin((Node)this, (Insets)new Insets(5.0, 0.0, 5.0, 0.0));
        this.setLabelFontColor(ClientSingleton.getInstance().getStyleValue(Constants.TAB_CELL_TEXT_FILL));
        this.setLabelFontSize(10);
        if (this.withCheckMenu) {
            this.myComboBox = MyContextComboBox.getInstance().setBackgroundColor(ClientSingleton.getInstance().getStyleValue(Constants.BASE_COLOR)).build();
            HBox.setMargin((Node)this.myComboBox, (Insets)new Insets(0.0, 5.0, 0.0, 0.0));
            this.myComboBox.prefWidthProperty().bind((ObservableValue)this.widthProperty().subtract(50));
            boxPane.getChildren().add((Object)this.myComboBox);
        }
        this.addRemoveButton();
        boxPane.getChildren().add((Object)this.textBox);
        this.getChildren().add((Object)boxPane);
    }

    public void setInputNumbersFilter() {
        this.textField.addEventFilter(KeyEvent.KEY_TYPED, event -> {
            char[] ar = event.getCharacter().toCharArray();
            char ch = ar[event.getCharacter().toCharArray().length - 1];
            if ((ch < '0' || ch > '9') && ch != '#' && ch != '*') {
                event.consume();
            }
        });
    }

    private void addRemoveButton() {
        if (this.isWithRemoveButton()) {
            this.hBoxImage.setMinWidth(30.0);
            this.hBoxImage.setMinHeight(30.0);
            this.hBoxImage.setAlignment(Pos.CENTER);
            RemoveImageButton imageView = new RemoveImageButton();
            imageView.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> {
                if (this.parentPane != null) {
                    this.parentPane.getChildren().remove((Object)this);
                }
            }));
            this.hBoxImage.getChildren().add((Object)imageView);
        }
    }

    protected void setDefaultFont() {
        this.labelFontSize.set(13);
        this.labelFontFamily.set("Roboto");
        this.labelFontColor.set("#656a7c");
        this.underlineColor.set("#dce0ec");
        this.isEditable.set(true);
        this.labelFontSize.addListener(this.fontSizeListener);
        this.labelFontFamily.addListener(this.fontFamilyListener);
        this.labelFontColor.addListener(this.fontColorListener);
        this.underlineColor.addListener(this.underlineColorListener);
        this.withRemoveButton.addListener(this.withRemoveButtonListener);
        this.isEditable.addListener((observable, oldValue, newValue) -> {
            this.textField.setEditable(newValue.booleanValue());
            if (!newValue.booleanValue()) {
                this.textField.setText("");
            }
        });
    }

    private void setTextFieldStyle() {
        if (this.textField == null) {
            return;
        }
        String style = "-fx-text-fill:" + this.labelFontColor.get() + ";\n-fx-font-size: " + this.labelFontSize.get() + "pt;\n-fx-font-family: " + this.labelFontFamily.get() + ";\n-fx-line-height: 1.19;\n-fx-border-color: " + this.underlineColor.get() + ";\n-fx-border-insets: 0 0 1 0; \n-fx-border-width: 0 0 1 0; \n-fx-padding: 0.333333em 0 0.333333em 0;-fx-background-color: transparent;\n";
        this.textField.setStyle(style);
    }

    public void setSelectedValue(String title, String label) {
        this.textField.setId(title);
        this.textField.setText(label);
        if (this.myComboBox != null) {
            this.myComboBox.setSelectedItem(title);
        }
    }

    public void addItemsList(List<?> items) {
        if (this.myComboBox != null) {
            this.myComboBox.addItemsListToMenu(items, this);
        }
    }

    public boolean isIsEditable() {
        return this.isEditable.get();
    }

    public SimpleBooleanProperty isEditableProperty() {
        return this.isEditable;
    }

    public void setIsEditable(boolean isEditable) {
        this.isEditable.set(isEditable);
    }

    public String getUnderlineColor() {
        return this.underlineColor.get();
    }

    public SimpleStringProperty underlineColorProperty() {
        return this.underlineColor;
    }

    public void setUnderlineColor(String underlineColor) {
        this.underlineColor.set(underlineColor);
    }

    public int getLabelFontSize() {
        return this.labelFontSize.get();
    }

    public SimpleIntegerProperty labelFontSizeProperty() {
        return this.labelFontSize;
    }

    public void setLabelFontSize(int labelFontSize) {
        this.labelFontSize.set(labelFontSize);
    }

    public String getLabelFontFamily() {
        return this.labelFontFamily.get();
    }

    public SimpleStringProperty labelFontFamilyProperty() {
        return this.labelFontFamily;
    }

    public void setLabelFontFamily(String labelFontFamily) {
        this.labelFontFamily.set(labelFontFamily);
    }

    public String getLabelFontColor() {
        return this.labelFontColor.get();
    }

    public SimpleStringProperty labelFontColorProperty() {
        return this.labelFontColor;
    }

    public boolean isWithRemoveButton() {
        return this.withRemoveButton.get();
    }

    public SimpleBooleanProperty withRemoveButtonProperty() {
        return this.withRemoveButton;
    }

    public void setWithRemoveButton(boolean withRemoveButton) {
        this.withRemoveButton.set(withRemoveButton);
    }

    public void setLabelFontColor(String labelFontColor) {
        this.labelFontColor.set(labelFontColor);
    }

    @Override
    public void actionPerformed(String title, int index) {
        if (this.myComboBox != null && this.myComboBox.getSelectedItem() != null) {
            this.textField.setId(title);
        }
    }

    public void setLabelStyle(String styleValue) {
        this.textField.setStyle(styleValue);
    }
}

