/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.profiles.profilviewer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.skin.ScrollPaneSkin;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import net.sipsnet.client.click2dial.GetSelectedText;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.WhiteLabels;
import net.sipsnet.client.connector.observer.IGUIObservable;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.connector.utils.AudioCaller;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.constants.IntentConstants;
import net.sipsnet.client.utils.threadpool.MyThreadPoolManager;
import net.sipsnet.client.utils.viewers.RichTextViwer.MyTextArea;
import net.sipsnet.client.utils.viewers.avatar.AvatarPane;
import net.sipsnet.client.utils.viewers.buttoncombobox.ContextMenuImageButton;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ArrowImageButton;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.CloseImageButton;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.SwitchImageButton;
import net.sipsnet.client.utils.viewers.contextmenu.MyContextMenu;
import net.sipsnet.client.utils.viewers.richtext.MyStyledTextArea;
import net.sipsnet.client.views.chat.interfaces.IOnCloseViewer;
import net.sipsnet.client.views.profiles.listener.ArrowClickedListener;
import net.sipsnet.client.views.profiles.listener.IArrowClickedAction;
import net.sipsnet.client.views.profiles.utils.DetailValue;
import net.sipsnet.client.views.profiles.utils.TypeConstantsRT;
import org.fxmisc.flowless.VirtualizedScrollPane;
import smile.cti.client.ContactInfo;

public class ProfileViewController
implements IArrowClickedAction,
IGUIObservable {
    private final IOnCloseViewer iOnCloseViewer;
    private final Map<String, List<Pane>> mapDetails = new HashMap<String, List<Pane>>();
    private final boolean withExitButton;
    @FXML
    private ScrollPane fx_spProfilePane;
    @FXML
    private Pane fx_ParentInfo;
    private Node tagsNode;
    private ContactInfo contactInfo;
    private int oldContactStatus;
    public static final int SUBTRACT_PADDING = 10;
    private MyContextMenu myContextMenu;
    @FXML
    private VBox fx_GroupInfo;
    @FXML
    private Pane fx_InfoPane;
    @FXML
    private Pane fx_AvatarViewPane;
    private MyTextArea fx_taComment;
    private VirtualizedScrollPane<MyStyledTextArea> virtualizedScrollPane;
    @FXML
    private Pane fx_AvatarPane;
    @FXML
    private SwitchImageButton fx_ivFavorite;
    @FXML
    private VBox fx_scrollMainPane;
    @FXML
    private ContextMenuImageButton fx_MenuImage;
    @FXML
    private HBox fx_AvatarImage;
    @FXML
    private Label fx_ContactName;
    @FXML
    private Label fx_GroupName;
    @FXML
    private Label fx_SharedLabel;
    @FXML
    private VBox fx_Shared;
    @FXML
    private ImageView fx_PhoneImage;
    @FXML
    private ArrowImageButton fx_PhoneArrowImage;
    @FXML
    private Label fx_PhoneTitle;
    @FXML
    private VBox fx_PhoneData;
    @FXML
    private HBox fx_hbForCloseButton;
    @FXML
    private ImageView fx_EmailImage;
    @FXML
    private ArrowImageButton fx_EmailArrowImage;
    @FXML
    private Label fx_EmailTitle;
    @FXML
    private VBox fx_EmailData;
    @FXML
    private ImageView fx_ShareImage;
    @FXML
    private ImageView fx_OtherImage;
    @FXML
    private ArrowImageButton fx_OtherArrowImage;
    @FXML
    private Label fx_OtherTitle;
    @FXML
    private VBox fx_OtherData;
    @FXML
    private ImageView fx_TagImage;
    @FXML
    private ArrowImageButton fx_TagArrowImage;
    @FXML
    private Label fx_TagTitle;
    @FXML
    private VBox fx_TagData;
    @FXML
    private ImageView fx_NoteImage;
    @FXML
    private ArrowImageButton fx_NoteArrowImage;
    @FXML
    private Label fx_NoteTitle;
    @FXML
    private Label fx_LNoteData;
    @FXML
    private VBox fx_NoteData;
    @FXML
    private VBox fx_vbProfilePane;
    @FXML
    private VBox fx_LinksViewPane;
    @FXML
    private VBox fx_PhoneViewPane;
    @FXML
    private VBox fx_EmailViewPane;
    @FXML
    private VBox fx_OtherViewPane;
    @FXML
    private VBox fx_TagViewPane;
    @FXML
    private VBox fx_NoteViewPane;

    public ProfileViewController() {
        this(ClientSingleton.getInstance().getResourceBundle(), null, false);
    }

    public ProfileViewController(ResourceBundle resourceBundle, IOnCloseViewer iOnCloseViewer) {
        this(resourceBundle, iOnCloseViewer, false);
    }

    public ProfileViewController(ResourceBundle resourceBundle, IOnCloseViewer iOnCloseViewer, boolean withExitButton) {
        this.withExitButton = withExitButton;
        this.iOnCloseViewer = iOnCloseViewer;
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fxml/profiles/profileviewer.fxml"));
        loader.setResources(resourceBundle);
        loader.setController((Object)this);
        try {
            this.fx_scrollMainPane = (VBox)loader.load();
            loader.setController((Object)this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StackPane.setAlignment((Node)this.fx_AvatarImage, (Pos)Pos.TOP_CENTER);
        this.initObservable();
        if (withExitButton) {
            HBox closeBox = new HBox();
            HBox.setHgrow((Node)closeBox, (Priority)Priority.ALWAYS);
            this.fx_hbForCloseButton.getChildren().add((Object)closeBox);
            closeBox.setMinWidth(20.0);
            closeBox.setAlignment(Pos.TOP_RIGHT);
            CloseImageButton closeImageButton = new CloseImageButton();
            closeImageButton.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> iOnCloseViewer.onCloseViewer()));
            HBox.setMargin((Node)closeBox, (Insets)new Insets(0.0, 5.0, 0.0, 0.0));
            closeBox.getChildren().add((Object)closeImageButton);
        }
        this.fx_scrollMainPane.setPadding(new Insets(0.0, 5.0, 0.0, 0.0));
        this.fx_AvatarViewPane.setPadding(new Insets(0.0, 5.0, 0.0, 0.0));
        this.fx_LinksViewPane.prefWidthProperty().bind((ObservableValue)this.fx_vbProfilePane.widthProperty());
        this.fx_ivFavorite.setOnMouseClickedEvent((EventHandler<MouseEvent>)((EventHandler)event -> {
            event.consume();
            boolean isFavorite = !this.contactInfo.isFavorite();
            this.contactInfo.setFavorite(isFavorite);
            this.fx_ivFavorite.setImagePath(this.contactInfo.isFavorite() ? "profiles/star_yellow.png" : "profiles/star_grey.png", true);
            ClientSingleton.getInstance().doNotify(IntentConstants.CONTACT_STATUS_CHANGED);
            MyThreadPoolManager.getInstance().execute(() -> ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                try {
                    clientConnector.updateContactStatus(this.contactInfo, this.contactInfo.getStatus());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }));
        }));
        Theme.getInstance().applyProfilesPaneTo(this.fx_AvatarViewPane);
        Theme.getInstance().applyProfilesPaneTo((Pane)this.fx_LinksViewPane);
        Theme.getInstance().applyProfilesPaneTo((Pane)this.fx_PhoneViewPane);
        Theme.getInstance().applyProfilesPaneTo((Pane)this.fx_EmailViewPane);
        Theme.getInstance().applyProfilesPaneTo((Pane)this.fx_TagViewPane);
        Theme.getInstance().applyProfilesPaneTo((Pane)this.fx_OtherViewPane);
        Theme.getInstance().applyProfilesPaneTo((Pane)this.fx_NoteViewPane);
        Theme.getInstance().applyTo(Constants.TABS_TITLE_TEXT_FILL, (Labeled)this.fx_ContactName);
        Theme.getInstance().applyTo(Constants.TAB_CELL_TEXT_FILL, (Labeled)this.fx_GroupName);
        Theme.getInstance().applyTo(Constants.TAB_CELL_TEXT_FILL, (Labeled)this.fx_SharedLabel);
        Theme.getInstance().applyTo(Constants.SCROLL_PANE_SECOND_STYLE, (Control)this.fx_spProfilePane);
        Theme.getInstance().applyTo(Constants.TABS_VIRTUALIZED_SCROLL, (Pane)this.fx_GroupInfo);
        this.fx_spProfilePane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.fx_spProfilePane.setFitToWidth(true);
        this.fx_GroupInfo.prefWidthProperty().bind((ObservableValue)this.fx_AvatarViewPane.widthProperty().subtract(5));
        this.fx_GroupName.setWrapText(true);
        this.fx_ContactName.setWrapText(true);
        this.fx_spProfilePane.skinProperty().addListener((observable, oldValue, newValue) -> {
            ScrollBar scrollBar;
            if (newValue != null && (scrollBar = ((ScrollPaneSkin)newValue).getVerticalScrollBar()) != null) {
                scrollBar.visibleProperty().addListener((observable1, oldValue1, newValue1) -> {
                    this.setPaneInScrollPaneWidth((Pane)this.fx_PhoneViewPane, (boolean)newValue1);
                    this.setPaneInScrollPaneWidth((Pane)this.fx_LinksViewPane, (boolean)newValue1);
                    this.setPaneInScrollPaneWidth((Pane)this.fx_EmailViewPane, (boolean)newValue1);
                    this.setPaneInScrollPaneWidth((Pane)this.fx_TagViewPane, (boolean)newValue1);
                    this.setPaneInScrollPaneWidth((Pane)this.fx_OtherViewPane, (boolean)newValue1);
                    this.setPaneInScrollPaneWidth((Pane)this.fx_NoteViewPane, (boolean)newValue1);
                });
            }
        });
        this.initComponents();
    }

    private void setPaneInScrollPaneWidth(Pane pane, boolean isScrollBarVisible) {
        pane.maxWidthProperty().unbind();
        pane.maxWidthProperty().unbind();
        if (isScrollBarVisible) {
            pane.maxWidthProperty().bind((ObservableValue)this.fx_vbProfilePane.widthProperty().subtract(5));
            pane.minWidthProperty().bind((ObservableValue)this.fx_vbProfilePane.widthProperty().subtract(5));
        } else {
            pane.maxWidthProperty().bind((ObservableValue)this.fx_vbProfilePane.widthProperty());
            pane.minWidthProperty().bind((ObservableValue)this.fx_vbProfilePane.widthProperty());
        }
    }

    public void initProfileViewer(ContactInfo contactInfo) {
        String name;
        this.fx_LinksViewPane.getChildren().clear();
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            List links = clientConnector.getContactLinks(contactInfo);
            if (links.isEmpty() && contactInfo.getProperty("page") != null) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("title", contactInfo.getProperty("serviceid"));
                map.put("url", contactInfo.getProperty("page"));
                links.add(map);
            }
            ClientSingleton.toLog(this.getClass().getSimpleName(), "links=" + links);
            for (int i = 0; i < links.size(); ++i) {
                Map link = (Map)links.get(i);
                link.put("open_url", "");
                Pane node = ClientSingleton.getInstance().addServiceLocation(link);
                node.prefWidthProperty().bind((ObservableValue)this.fx_LinksViewPane.widthProperty().subtract(10));
                this.fx_LinksViewPane.getChildren().add(0, (Object)node);
            }
            if (this.fx_LinksViewPane.getChildren().isEmpty()) {
                VBox.setMargin((Node)this.fx_LinksViewPane, (Insets)new Insets(0.0, 0.0, 0.0, 0.0));
            } else {
                VBox.setMargin((Node)this.fx_LinksViewPane, (Insets)new Insets(0.0, 0.0, 10.0, 0.0));
            }
            if (links.isEmpty()) {
                this.fx_vbProfilePane.getChildren().remove((Object)this.fx_LinksViewPane);
            } else if (!this.fx_vbProfilePane.getChildren().contains((Object)this.fx_LinksViewPane)) {
                this.fx_vbProfilePane.getChildren().add((Object)this.fx_LinksViewPane);
            }
        });
        this.fx_PhoneData.getChildren().clear();
        this.fx_EmailData.getChildren().clear();
        this.fx_OtherData.getChildren().clear();
        this.fx_TagData.getChildren().clear();
        this.fx_AvatarImage.getChildren().clear();
        if (!this.fx_vbProfilePane.getChildren().contains((Object)this.fx_PhoneViewPane)) {
            this.fx_vbProfilePane.getChildren().add((Object)this.fx_PhoneViewPane);
        }
        if (!this.fx_vbProfilePane.getChildren().contains((Object)this.fx_EmailViewPane)) {
            this.fx_vbProfilePane.getChildren().add((Object)this.fx_EmailViewPane);
        }
        if (!this.fx_vbProfilePane.getChildren().contains((Object)this.fx_OtherViewPane)) {
            this.fx_vbProfilePane.getChildren().add((Object)this.fx_OtherViewPane);
        }
        if (!this.fx_vbProfilePane.getChildren().contains((Object)this.fx_TagViewPane)) {
            this.fx_vbProfilePane.getChildren().add((Object)this.fx_TagViewPane);
        }
        if (!this.fx_vbProfilePane.getChildren().contains((Object)this.fx_NoteViewPane)) {
            this.fx_vbProfilePane.getChildren().add((Object)this.fx_NoteViewPane);
        }
        this.contactInfo = contactInfo;
        this.oldContactStatus = contactInfo.getStatus();
        ClientSingleton.toLog(this.getClass().getSimpleName(), "ProfileViewController contactInfo=" + contactInfo + " name=[" + contactInfo.getName() + "] status=" + contactInfo.getStatus() + " state=" + contactInfo.getState());
        ClientSingleton.toLog(this.getClass().getSimpleName(), "getUserDetails detailLists=" + contactInfo.getUserDetails());
        ClientSingleton.toLog(this.getClass().getSimpleName(), "getCustomDetails detailLists=" + contactInfo.getCustomDetails());
        this.fx_MenuImage.setMenuWidth(110);
        if (ClientSingleton.getInstance().isMemberOfList(contactInfo) || this.withExitButton) {
            this.fx_ParentInfo.getChildren().remove((Object)this.fx_Shared);
            this.fx_MenuImage.setVisible(false);
        } else {
            if (!this.fx_MenuImage.isVisible()) {
                this.fx_MenuImage.setVisible(true);
            }
            this.fx_MenuImage.clear();
            if (this.iOnCloseViewer != null) {
                if (this.isNewContact()) {
                    this.fx_MenuImage.addMenuItem(ClientSingleton.getInstance().getString("add_contact"), (EventHandler<ActionEvent>)((EventHandler)action -> {
                        this.fx_MenuImage.hideMenu();
                        this.iOnCloseViewer.createProfileEditor(contactInfo);
                    }));
                } else if (contactInfo.getUserID() != null) {
                    this.fx_MenuImage.addMenuItem(ClientSingleton.getInstance().getString("edit_contact"), (EventHandler<ActionEvent>)((EventHandler)action -> {
                        this.fx_MenuImage.hideMenu();
                        this.iOnCloseViewer.createProfileEditor(contactInfo);
                    }));
                }
                if (AudioCaller.getWorkingLinesCount() == 0) {
                    this.fx_MenuImage.addMenuItem(ClientSingleton.getInstance().getString("call_history_contact"), (EventHandler<ActionEvent>)((EventHandler)action -> {
                        this.fx_MenuImage.hideMenu();
                        this.iOnCloseViewer.createActivitiesViewer(contactInfo);
                    }));
                }
                if (ClientSingleton.getInstance().canShareContact(contactInfo)) {
                    this.fx_MenuImage.addMenuItem(ClientSingleton.getInstance().getString("cell_menu_item6"), (EventHandler<ActionEvent>)((EventHandler)event -> {
                        ClientSingleton.getInstance().shareContact(contactInfo);
                        this.fx_MenuImage.hideMenu();
                    }));
                }
            }
            if (ClientSingleton.getInstance().isSharedContact(contactInfo)) {
                if (!this.fx_ParentInfo.getChildren().contains((Object)this.fx_Shared)) {
                    this.fx_ParentInfo.getChildren().add((Object)this.fx_Shared);
                }
                this.fx_SharedLabel.setText(ClientSingleton.getInstance().getString("share_shared").toLowerCase());
            } else {
                this.fx_ParentInfo.getChildren().remove((Object)this.fx_Shared);
            }
        }
        boolean isFavoriteImageVisible = contactInfo.getState() != -1 || contactInfo.getStatus() != -1;
        ClientSingleton.toLog(this.getClass().getSimpleName(), "contactInfo.isFavorite()=" + contactInfo.isFavorite() + " isFavoriteImageVisible=" + isFavoriteImageVisible);
        this.fx_ivFavorite.setVisible(isFavoriteImageVisible);
        if (isFavoriteImageVisible) {
            this.fx_ivFavorite.setImagePath(contactInfo.isFavorite() ? "profiles/star_yellow.png" : "profiles/star_grey.png", true);
        }
        if ((name = contactInfo.toString()).split(" ").length == 2) {
            name = name.replace(" ", "\n");
        }
        this.fx_ContactName.setText(name);
        List detailLists = contactInfo.getUserDetails();
        List customDetailLists = contactInfo.getCustomDetails();
        String extension = "";
        Optional<Object> prop = Optional.ofNullable(contactInfo.getProperty("extension"));
        ClientSingleton.toLog(this.getClass().getSimpleName(), "getCustomDetails extension=" + prop);
        if (!prop.isPresent()) {
            prop = Optional.ofNullable(contactInfo.getProperty("ext"));
            ClientSingleton.toLog(this.getClass().getSimpleName(), "getCustomDetails ext=" + prop);
            if (prop.isPresent()) {
                extension = (String)prop.get();
            }
        } else {
            extension = prop.get().toString();
        }
        if (!extension.isEmpty()) {
            DetailValue detailValue = new DetailValue("contacts_extensions", "Phone", 0);
            detailValue.setValue(extension);
            Pane pane = this.getDetailPane(detailValue);
            pane.maxWidthProperty().bind((ObservableValue)this.fx_PhoneData.widthProperty().subtract(10));
            this.fx_PhoneData.getChildren().add((Object)pane);
        }
        Object group = "";
        prop = Optional.ofNullable(contactInfo.getProperty("group"));
        if (prop.isPresent()) {
            group = (String)prop.get();
        } else {
            ContactInfo.Detail detail = TypeConstantsRT.getUserContactDetail(contactInfo, "JobTitle");
            if (detail == null && (detail = TypeConstantsRT.getUserContactDetail(contactInfo, "Position")) == null && (detail = TypeConstantsRT.getCustomContactDetail(contactInfo, "JobTitle")) == null) {
                detail = TypeConstantsRT.getCustomContactDetail(contactInfo, "Position");
            }
            if (detail != null) {
                group = (String)group + detail.getValue().toString();
            }
            if ((detail = TypeConstantsRT.getUserContactDetail(contactInfo, "Company")) == null && (detail = TypeConstantsRT.getUserContactDetail(contactInfo, "Organization")) == null && (detail = TypeConstantsRT.getCustomContactDetail(contactInfo, "Company")) == null) {
                detail = TypeConstantsRT.getCustomContactDetail(contactInfo, "Organization");
            }
            if (detail != null) {
                group = (String)group + (((String)group).isEmpty() ? "" : "\n") + detail.getValue();
            }
        }
        if (!((String)group).isEmpty()) {
            this.fx_GroupName.setText((String)group);
            if (!this.fx_InfoPane.getChildren().contains((Object)this.fx_GroupName)) {
                this.fx_InfoPane.getChildren().add(0, (Object)this.fx_GroupName);
            }
        } else {
            this.fx_GroupName.setText("");
            this.fx_InfoPane.getChildren().remove((Object)this.fx_GroupName);
        }
        List<DetailValue> detailValues = TypeConstantsRT.getDetails(detailLists, contactInfo);
        for (DetailValue detailValue : detailValues) {
            Pane pane;
            if (detailValue.getDetailViewType() == 0) {
                pane = this.getDetailPane(detailValue);
                pane.maxWidthProperty().bind((ObservableValue)this.fx_PhoneData.widthProperty().subtract(10));
                this.fx_PhoneData.getChildren().add((Object)pane);
                continue;
            }
            if (detailValue.getDetailViewType() == 1) {
                pane = this.getDetailPane(detailValue);
                pane.prefWidthProperty().bind((ObservableValue)this.fx_EmailData.widthProperty().subtract(10));
                this.fx_EmailData.getChildren().add((Object)pane);
                continue;
            }
            if (detailValue.getLabel().equals("Company") || detailValue.getLabel().equals("Organization") || detailValue.getLabel().equals("JobTitle") || detailValue.getLabel().equals("Position")) continue;
            pane = this.getDetailPane(detailValue);
            pane.prefWidthProperty().bind((ObservableValue)this.fx_OtherData.widthProperty().subtract(10));
            this.fx_OtherData.getChildren().add((Object)pane);
        }
        List<DetailValue> customDetailValues = TypeConstantsRT.getDetails(customDetailLists, contactInfo, true);
        for (DetailValue detailValue : customDetailValues) {
            Pane pane;
            if (detailValue.getDetailViewType() == 0) {
                pane = this.getDetailPane(detailValue);
                pane.prefWidthProperty().bind((ObservableValue)this.fx_PhoneData.widthProperty().subtract(10));
                this.fx_PhoneData.getChildren().add((Object)pane);
                continue;
            }
            if (detailValue.getDetailViewType() == 1) {
                pane = this.getDetailPane(detailValue);
                pane.prefWidthProperty().bind((ObservableValue)this.fx_EmailData.widthProperty().subtract(10));
                this.fx_EmailData.getChildren().add((Object)pane);
                continue;
            }
            if (!((String)group).isEmpty() && ((String)group).contains(detailValue.getValue())) continue;
            pane = this.getDetailPane(detailValue);
            pane.prefWidthProperty().bind((ObservableValue)this.fx_OtherData.widthProperty().subtract(10));
            this.fx_OtherData.getChildren().add((Object)pane);
        }
        ArrayList arrayList = new ArrayList(contactInfo.getUserTags());
        ClientSingleton.toLog(this.getClass().getSimpleName(), "getUserTags=" + arrayList);
        arrayList.addAll(contactInfo.getCustomTags());
        ClientSingleton.toLog(this.getClass().getSimpleName(), "+getCustomTags=" + arrayList);
        if (arrayList != null && !arrayList.isEmpty()) {
            double maxWidth = 210.0;
            double currentWidth = 0.0;
            VBox tagsPane = new VBox();
            HBox hBox = new HBox();
            for (String tag : arrayList) {
                Node node = this.getTag(tag);
                Text text = new Text(" #" + tag + " ");
                double tagWidth = text.getLayoutBounds().getWidth();
                if ((currentWidth += tagWidth) > maxWidth) {
                    tagsPane.getChildren().add((Object)hBox);
                    hBox = new HBox();
                    currentWidth = 0.0;
                }
                hBox.getChildren().add((Object)node);
            }
            tagsPane.getChildren().add((Object)hBox);
            this.fx_TagData.getChildren().add((Object)tagsPane);
        } else {
            this.fx_vbProfilePane.getChildren().remove((Object)this.fx_TagViewPane);
        }
        if (this.fx_PhoneData.getChildren().isEmpty()) {
            this.fx_vbProfilePane.getChildren().remove((Object)this.fx_PhoneViewPane);
        }
        if (this.fx_EmailData.getChildren().isEmpty()) {
            this.fx_vbProfilePane.getChildren().remove((Object)this.fx_EmailViewPane);
        }
        if (this.fx_OtherData.getChildren().isEmpty()) {
            this.fx_vbProfilePane.getChildren().remove((Object)this.fx_OtherViewPane);
        }
        this.fx_AvatarImage.getChildren().clear();
        this.fx_AvatarImage.getChildren().add((Object)AvatarPane.getInstance(contactInfo, 65, 36, true));
        ContactInfo.Detail detail = contactInfo.getDescriptionDetail();
        String description = "";
        if (detail != null && detail.getValue() != null && !detail.getValue().toString().isEmpty()) {
            description = detail.getValue().toString();
        }
        if (!description.isEmpty()) {
            if (this.virtualizedScrollPane == null) {
                this.virtualizedScrollPane = ClientSingleton.getInstance().addTextAreaToPane((Pane)this.fx_GroupInfo, description);
                this.fx_GroupInfo.getChildren().clear();
                this.fx_GroupInfo.getChildren().add(this.virtualizedScrollPane);
            } else {
                ((MyStyledTextArea)((Object)this.virtualizedScrollPane.getChildrenUnmodifiable().get(0))).setContentToStyledTextArea(description);
            }
            String style = " -fx-background-color: %s;-fx-border-insets:  0;-fx-background-insets: 0; -fx-control-inner-background: #f1f2f5;    -fx-border-radius: 10 10 10 10;    -fx-background-radius: 10 10 10 10;";
            String color = ClientSingleton.getInstance().getStyleValue(Theme.getInstance().isDarkTheme() ? Constants.BASE_COLOR : Constants.SECOND_BASE_COLOR);
            this.fx_GroupInfo.setStyle(Theme.getInstance().formatedString(style, color));
            if (!this.fx_AvatarViewPane.getChildren().contains((Object)this.fx_GroupInfo)) {
                this.fx_AvatarViewPane.getChildren().add((Object)this.fx_GroupInfo);
            }
        } else {
            this.fx_AvatarViewPane.getChildren().remove((Object)this.fx_GroupInfo);
            this.fx_GroupInfo.setStyle(null);
        }
        ContactInfo.Detail customAbout = contactInfo.getCustomDetail("About");
        if (customAbout != null && customAbout.getValue() != null && !customAbout.getValue().toString().isEmpty()) {
            this.fx_LNoteData.setText(customAbout.getValue().toString());
        } else {
            this.fx_vbProfilePane.getChildren().remove((Object)this.fx_NoteViewPane);
        }
        this.fx_AvatarViewPane.applyCss();
        this.fx_AvatarViewPane.layout();
        this.fx_scrollMainPane.applyCss();
        this.fx_scrollMainPane.layout();
        ClientSingleton.toLog(this.getClass().getSimpleName(), "done");
    }

    private boolean hasInUserDetail(DetailValue detailValue) {
        if (detailValue.getLabel().equals("Company") || detailValue.getLabel().equals("Organization")) {
            return TypeConstantsRT.getUserContactDetail(this.contactInfo, "Company") != null || TypeConstantsRT.getUserContactDetail(this.contactInfo, "Organization") != null;
        }
        if (detailValue.getLabel().equals("JobTitle") || detailValue.getLabel().equals("Position")) {
            return TypeConstantsRT.getUserContactDetail(this.contactInfo, "JobTitle") != null || TypeConstantsRT.getUserContactDetail(this.contactInfo, "Position") != null;
        }
        return false;
    }

    public Pane getNode() {
        return this.fx_scrollMainPane;
    }

    @Override
    public void addNodesListToCache(String key, List<Pane> node) {
        this.mapDetails.put(key, node);
    }

    @Override
    public List<Pane> getNodesListFromCache(String key) {
        return this.mapDetails.get(key);
    }

    private void initComponents() {
        ClientSingleton.getInstance().setImageToImageView(this.fx_PhoneImage, "profiles/phone.png");
        ClientSingleton.getInstance().setImageToImageView(this.fx_EmailImage, "profiles/email.png");
        ClientSingleton.getInstance().setImageToImageView(this.fx_TagImage, "profiles/tags.png");
        ClientSingleton.getInstance().setImageToImageView(this.fx_NoteImage, "profiles/notes.png");
        ClientSingleton.getInstance().setImageToImageView(this.fx_OtherImage, "profiles/notes.png");
        ClientSingleton.getInstance().setImageToImageView(this.fx_ShareImage, "chat/filter/filter_links_off.png");
        this.fx_vbProfilePane.prefWidthProperty().bind((ObservableValue)this.fx_scrollMainPane.widthProperty().subtract(8));
        this.fx_PhoneData.prefWidthProperty().bind((ObservableValue)this.fx_vbProfilePane.widthProperty().subtract(8));
        this.fx_EmailData.prefWidthProperty().bind((ObservableValue)this.fx_vbProfilePane.widthProperty().subtract(8));
        this.fx_OtherData.prefWidthProperty().bind((ObservableValue)this.fx_vbProfilePane.widthProperty().subtract(8));
        this.fx_NoteData.prefWidthProperty().bind((ObservableValue)this.fx_vbProfilePane.widthProperty().subtract(8));
        this.fx_TagData.prefWidthProperty().bind((ObservableValue)this.fx_vbProfilePane.widthProperty().subtract(8));
        this.fx_PhoneArrowImage.setId(String.valueOf(0));
        ArrowClickedListener arrowClickedListener = new ArrowClickedListener(this, (Pane)this.fx_PhoneData);
        this.fx_PhoneArrowImage.addMouseEventHandler(arrowClickedListener);
        this.fx_TagArrowImage.setId(String.valueOf(2));
        arrowClickedListener = new ArrowClickedListener(this, (Pane)this.fx_TagData);
        this.fx_TagArrowImage.addMouseEventHandler(arrowClickedListener);
        this.fx_EmailArrowImage.setId(String.valueOf(1));
        arrowClickedListener = new ArrowClickedListener(this, (Pane)this.fx_EmailData);
        this.fx_EmailArrowImage.addMouseEventHandler(arrowClickedListener);
        this.fx_NoteArrowImage.setId("NOTE_TYPE");
        arrowClickedListener = new ArrowClickedListener(this, (Pane)this.fx_NoteData);
        this.fx_NoteArrowImage.addMouseEventHandler(arrowClickedListener);
        this.fx_OtherArrowImage.setId(String.valueOf(3));
        arrowClickedListener = new ArrowClickedListener(this, (Pane)this.fx_OtherData);
        this.fx_OtherArrowImage.addMouseEventHandler(arrowClickedListener);
        this.fx_PhoneTitle.setText(ClientSingleton.getInstance().getString("profile_phones"));
        this.fx_EmailTitle.setText(ClientSingleton.getInstance().getString("profile_emails"));
        this.fx_TagTitle.setText(ClientSingleton.getInstance().getString("profile_tags"));
        this.fx_NoteTitle.setText(ClientSingleton.getInstance().getString("profile_note"));
        this.fx_OtherTitle.setText(ClientSingleton.getInstance().getString("profile_other"));
        Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)this.fx_PhoneTitle);
        Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)this.fx_EmailTitle);
        Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)this.fx_TagTitle);
        Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)this.fx_NoteTitle);
        Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)this.fx_OtherTitle);
    }

    private Node getTag(String tag) {
        Label label = new Label(" #" + tag + " ");
        label.setStyle("-fx-text-fill: white;-fx-border-radius: 8 8 8 8;-fx-background-radius: 8 8 8 8;-fx-background-insets: 0 0 0 0;-fx-background-color:" + WhiteLabels.getCustomBlueColor() + ";");
        HBox.setMargin((Node)label, (Insets)new Insets(3.0, 3.0, 5.0, 0.0));
        return label;
    }

    private Pane getDetailPane(DetailValue detailValue) {
        HBox textFlow = new HBox();
        VBox.setMargin((Node)textFlow, (Insets)new Insets(3.0, 5.0, 3.0, 0.0));
        final Text value = new Text(detailValue.getValue());
        if (detailValue.getDetailViewType() != 1) {
            Text key = new Text(detailValue.getLabel() + ":");
            try {
                ClientSingleton.getInstance().setStyledTextFont(key, false, Theme.getInstance().isDarkTheme() ? "white" : "#646A7E", 9);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            textFlow.getChildren().add((Object)key);
            HBox.setMargin((Node)value, (Insets)new Insets(0.0, 0.0, 0.0, 5.0));
        }
        final HBox hBox = new HBox();
        hBox.prefWidthProperty().bind((ObservableValue)textFlow.widthProperty().subtract(10));
        textFlow.getChildren().add((Object)hBox);
        HBox.setHgrow((Node)value, (Priority)Priority.ALWAYS);
        hBox.widthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number number, Number newValue) {
                hBox.widthProperty().removeListener((ChangeListener)this);
                value.setWrappingWidth((double)newValue.intValue());
                value.maxWidth(newValue.doubleValue() - 50.0);
            }
        });
        hBox.getChildren().add((Object)value);
        try {
            ClientSingleton.getInstance().setStyledTextFont(value, detailValue.getDetailViewType() == 0 || detailValue.getDetailViewType() == 1, WhiteLabels.getCustomBlueColor(), 9);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (detailValue.getDetailViewType() == 0 || detailValue.getDetailViewType() == 1 || detailValue.getDetailViewType() == 3 && detailValue.getLabel().toLowerCase().contains("web")) {
            value.setOnMouseEntered(event -> value.setCursor(Cursor.HAND));
            value.setOnMouseReleased(event -> value.setCursor(Cursor.DEFAULT));
            value.setOnMousePressed(event -> {
                Text text = (Text)event.getSource();
                if (detailValue.getDetailViewType() == 0) {
                    this.myContextMenu = new MyContextMenu();
                    this.myContextMenu.setWithSelection(false);
                    this.myContextMenu.addMenuItem((Object)ClientSingleton.getInstance().getString("call_menu_dial"), (EventHandler<MouseEvent>)((EventHandler)event1 -> {
                        AudioCaller.makeCall(text.getText(), false);
                        this.hideContextMenu();
                    }));
                    List trunks = ClientSingleton.getInstance().getClientConnector().get().getTrunks(null);
                    if (trunks != null && trunks.size() > 1) {
                        this.myContextMenu.addMenuItem((Object)ClientSingleton.getInstance().getString("call_menu_dial_as"), (EventHandler<MouseEvent>)((EventHandler)event1 -> {
                            AudioCaller.makeCall(text.getText(), trunks);
                            this.hideContextMenu();
                        }));
                    }
                    this.myContextMenu.addMenuItem((Object)ClientSingleton.getInstance().getString("call_menu_copy"), (EventHandler<MouseEvent>)((EventHandler)event1 -> {
                        try {
                            GetSelectedText.setClipboardText(text.getText());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        this.hideContextMenu();
                    }));
                    this.myContextMenu.show(event.getScreenX(), event.getScreenY());
                } else if (detailValue.getDetailViewType() == 3 && detailValue.getLabel().toLowerCase().contains("web")) {
                    this.myContextMenu = new MyContextMenu();
                    this.myContextMenu.setWithSelection(false);
                    this.myContextMenu.addMenuItem((Object)ClientSingleton.getInstance().getString("linkItem1"), (EventHandler<MouseEvent>)((EventHandler)event1 -> {
                        ClientSingleton.getInstance().openWebBrowser(text.getText());
                        this.hideContextMenu();
                    }));
                    this.myContextMenu.addMenuItem((Object)ClientSingleton.getInstance().getString("linkItem2"), (EventHandler<MouseEvent>)((EventHandler)event1 -> {
                        try {
                            GetSelectedText.setClipboardText(text.getText());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        this.hideContextMenu();
                    }));
                    this.myContextMenu.show(event.getScreenX(), event.getScreenY());
                } else {
                    this.myContextMenu = new MyContextMenu();
                    this.myContextMenu.setWithSelection(false);
                    this.myContextMenu.addMenuItem((Object)ClientSingleton.getInstance().getString("cell_menu_email"), (EventHandler<MouseEvent>)((EventHandler)event1 -> {
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        data.put("serviceAction", text.getText());
                        ClientSingleton.getInstance().doNotify(Constants.OPEN_EMAIL_APP, data);
                        this.hideContextMenu();
                    }));
                    this.myContextMenu.addMenuItem((Object)ClientSingleton.getInstance().getString("message_menu_copy"), (EventHandler<MouseEvent>)((EventHandler)event1 -> {
                        try {
                            GetSelectedText.setClipboardText(text.getText());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        this.hideContextMenu();
                    }));
                    this.myContextMenu.show(event.getScreenX(), event.getScreenY());
                }
            });
        }
        return textFlow;
    }

    private void hideContextMenu() {
        if (this.myContextMenu != null) {
            if (this.myContextMenu.isShowing()) {
                this.myContextMenu.hide();
            }
            this.myContextMenu.clear();
        }
    }

    private double getTextHeight(String content) {
        Text text = new Text(content);
        text.setWrappingWidth(150.0);
        double height = text.getBoundsInLocal().getHeight();
        return height + 10.0;
    }

    private boolean isNewContact() {
        return "".equals(this.contactInfo.getName()) || this.contactInfo.getStatus() == 0;
    }

    public void setMaxWidth(int defaultPanelWidth) {
        this.fx_scrollMainPane.setMaxWidth((double)(defaultPanelWidth + 5));
        this.fx_scrollMainPane.setMinWidth((double)(defaultPanelWidth + 5));
    }

    private void initObservable() {
        String[] actions = new String[]{IntentConstants.CONTACT_DATA_UPDATED};
        ClientSingleton.getInstance().addObserver(this, actions);
    }

    @Override
    public void onNotifiedMessage(String action, Map<String, Object> data) {
        ContactInfo contactInfo1;
        if (action.equals(IntentConstants.CONTACT_DATA_UPDATED) && (contactInfo1 = (ContactInfo)data.get("contactInfo")) != null && contactInfo1.getUserID() != null && this.contactInfo.getUserID() != null && this.contactInfo.getUserID().equals(contactInfo1.getUserID())) {
            ClientSingleton.getInstance().runLater(() -> this.initProfileViewer(contactInfo1));
        }
    }
}

