/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.profiles.userprofile;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.Image;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.imageio.ImageIO;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.popupstage.MyPopupWindow;
import net.sipsnet.client.utils.threadpool.MyThreadPoolManager;
import net.sipsnet.client.utils.viewers.avatar.AvatarPane;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.AddImageButton;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.CloseImageButton;
import net.sipsnet.client.utils.viewers.buttons.labelbutton.MyLabelButton;
import net.sipsnet.client.utils.viewers.contextmenu.MyContextMenu;
import net.sipsnet.client.utils.viewers.label.MyLabel;
import net.sipsnet.client.views.profiles.ProfileUtils;
import net.sipsnet.client.views.profiles.profileedit.EditDataPaneV;
import net.sipsnet.client.views.profiles.utils.DetailValue;
import net.sipsnet.client.views.profiles.utils.TypeConstantsRT;
import smile.cti.client.ClientConnector;
import smile.cti.client.ContactInfo;

public class UserProfileEditorController
extends ProfileUtils {
    private MyPopupWindow myPopupWindow;
    @FXML
    public EditDataPaneV fx_edpUserName;
    @FXML
    public EditDataPaneV fx_edTags;
    @FXML
    private AddImageButton fx_AddData;
    @FXML
    private CloseImageButton fx_CloseStage;
    @FXML
    private VBox fx_LeftPane;
    @FXML
    private MyLabelButton fx_SaveButton;
    @FXML
    public MyLabel fx_lbUploadImage;
    @FXML
    public EditDataPaneV fx_edCompanyTitle;
    @FXML
    public ScrollPane fx_DataScrollPane;
    @FXML
    public MyLabel fx_myAddDetails;
    public MyLabel fx_lbExtends;
    public HBox fx_AvatarImage;
    public EditDataPaneV fx_edJobTitle;
    public HBox fx_MainPane;
    private ContactInfo contactInfo;
    private File pictureImagePath;
    private MyContextMenu myRemoveAvatar;
    private AvatarPane avatarPane;
    private boolean isAvatarRemoved;
    private boolean isFirstPhoneAdded = false;
    private boolean isFirstEmailAdded = false;

    public UserProfileEditorController() {
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fxml/profiles/userprofileeditor.fxml"));
        loader.setResources(ClientSingleton.getInstance().getResourceBundle());
        loader.setController((Object)this);
        try {
            this.fx_MainPane = (HBox)loader.load();
            loader.setController((Object)this);
            String style = "-fx-background-color: #dae0ee;-fx-border-radius: 8 0 0 8;-fx-background-radius: 8 0 0 8;";
            this.fx_LeftPane.setStyle(style);
            this.initProfileViewer();
            this.myPopupWindow = MyPopupWindow.getNewInstance((Pane)this.fx_MainPane);
            Theme.getInstance().applyTo(Constants.SCROLL_PANE_SECOND_STYLE, (Control)this.fx_DataScrollPane);
            this.fx_DataPane.minWidthProperty().bind((ObservableValue)this.fx_RightPane.widthProperty().subtract(10));
            ClientSingleton.getInstance().getStyle(Constants.BLUE_ALTERNATIVE_COLOR).ifPresent(color -> this.fx_myAddDetails.setLabelFontColor((String)color));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void show() {
        this.myPopupWindow.show();
    }

    private void initProfileViewer() {
        this.contactInfo = ClientSingleton.getInstance().getUserInfo();
        ClientSingleton.toLog(this.getClass().getSimpleName(), "initProfileViewer contactInfo name=" + this.contactInfo + " hashCode=" + this.contactInfo.hashCode());
        this.fx_edpUserName.setTextToEditField(this.contactInfo.toString());
        this.fx_edpUserName.maxWidthProperty().bind((ObservableValue)this.fx_LeftPane.prefWidthProperty().subtract(10));
        this.fx_edTags.maxWidthProperty().bind((ObservableValue)this.fx_LeftPane.prefWidthProperty().subtract(10));
        this.fx_DataPane.prefWidthProperty().bind((ObservableValue)this.fx_RightPane.prefWidthProperty().subtract(10));
        Optional<String> ext = Optional.ofNullable(Optional.ofNullable((String)this.contactInfo.getProperty("extension")).orElse((String)this.contactInfo.getProperty("ext")));
        this.fx_lbExtends.setText(ext.orElse(""));
        List detailLists = this.contactInfo.getUserDetails();
        List<DetailValue> detailValues = TypeConstantsRT.getDetails(detailLists, this.contactInfo);
        this.fx_AvatarImage.getChildren().clear();
        this.addData(detailValues);
        detailLists = this.contactInfo.getCustomDetails();
        List<DetailValue> customDetailValues = TypeConstantsRT.getDetails(detailLists, this.contactInfo);
        this.addData(customDetailValues);
        int index = this.isFirstPhoneAdded && this.isFirstEmailAdded ? 2 : (this.isFirstPhoneAdded || this.isFirstEmailAdded ? 1 : -1);
        this.addAboutPane(index);
        List tags = this.contactInfo.getUserTags();
        StringBuilder stringBuilder = new StringBuilder();
        String text = "";
        if (tags != null && !tags.isEmpty()) {
            for (String tag : tags) {
                stringBuilder.append(tag);
                stringBuilder.append(" ");
            }
            text = stringBuilder.toString();
        }
        this.fx_edTags.setTextToEditField(text);
        this.avatarPane = this.getAvatarPane();
        this.fx_AvatarImage.getChildren().add((Object)this.avatarPane);
        this.fx_AddData.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> this.addDetailPane(null)));
        this.fx_CloseStage.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> this.myPopupWindow.hide()));
        this.fx_CloseStage.setBackgroundColor("transparent");
        ClientSingleton.getInstance().setMouseCursor((Node)this.fx_lbUploadImage);
        this.fx_lbUploadImage.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            Image writableImage = this.getFile();
            if (writableImage != null) {
                this.avatarPane.setImageView(130, writableImage);
            }
        });
        this.fx_SaveButton.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> this.update()));
        ContactInfo.Detail detail = this.contactInfo.getUserDetail("JobTitle");
        if (detail != null && detail.getValue() != null) {
            this.fx_edJobTitle.setTextToEditField((String)detail.getValue());
        } else {
            detail = this.contactInfo.getUserDetail("Position");
            if (detail != null && detail.getValue() != null) {
                this.fx_edJobTitle.setTextToEditField((String)detail.getValue());
            }
        }
        detail = this.contactInfo.getUserDetail("Company");
        if (detail != null && detail.getValue() != null) {
            this.fx_edCompanyTitle.setTextToEditField((String)detail.getValue());
        }
        if ((detail = this.contactInfo.getUserDetail("About")) != null && detail.getValue() != null) {
            this.aboutDataPane.setTextToEditField((String)detail.getValue());
        }
        this.fx_edJobTitle.setPromptToEditField(ClientSingleton.getInstance().getString("prompt_job_title"));
        this.fx_edCompanyTitle.setPromptToEditField(ClientSingleton.getInstance().getString("prompt_company_name"));
        this.fx_edTags.setPromptToEditField(ClientSingleton.getInstance().getString("prompt_tags"));
    }

    private void addData(List<DetailValue> detailValues) {
        for (DetailValue detailValue : detailValues) {
            if (detailValue.getDetailViewType() != 0) continue;
            if (!this.isFirstPhoneAdded) {
                this.addPhoneDetailPane(detailValue);
                this.isFirstPhoneAdded = true;
                continue;
            }
            this.addDetailPane(detailValue);
        }
        if (!this.isFirstPhoneAdded) {
            this.addPhoneDetailPane(null);
            this.isFirstPhoneAdded = true;
        }
        for (DetailValue detailValue : detailValues) {
            if (detailValue.getDetailViewType() != 1) continue;
            if (!this.isFirstEmailAdded) {
                if (this.isFirstPhoneAdded) {
                    this.addEmailDetailPane(1, detailValue);
                } else {
                    this.addEmailDetailPane(-1, detailValue);
                }
                this.isFirstEmailAdded = true;
                continue;
            }
            this.addDetailPane(detailValue);
        }
        if (!this.isFirstEmailAdded) {
            this.addEmailDetailPane(-1, null);
            this.isFirstEmailAdded = true;
        }
    }

    private void addPhoneDetailPane(DetailValue detailValue) {
        EditDataPaneV editDataPaneV = this.addDetailPaneParameters(false, 4);
        editDataPaneV.setPromptToEditField(ClientSingleton.getInstance().getString("prompt_enter_phone"));
        if (detailValue != null) {
            editDataPaneV.setSelectedValue(detailValue.getLabel(), detailValue.getValue());
        }
    }

    private void addEmailDetailPane(int index, DetailValue detailValue) {
        EditDataPaneV editDataPaneV = this.addDetailPaneParameters(index, false, 10);
        editDataPaneV.setPromptToEditField(ClientSingleton.getInstance().getString("prompt_enter_email"));
        if (detailValue != null) {
            editDataPaneV.setSelectedValue(detailValue.getLabel(), detailValue.getValue());
        }
    }

    private AvatarPane getAvatarPane() {
        AvatarPane avatarPane = AvatarPane.getInstance(this.contactInfo, 135, "#f3f4f7", 36, true);
        avatarPane.setMouseListeners((EventHandler<MouseEvent>)((EventHandler)event -> {
            if (event.getButton() == MouseButton.SECONDARY && this.contactInfo.hasAvatar()) {
                this.showRemoveAvatarMenu((MouseEvent)event);
            } else {
                Image writableImage = this.getFile();
                if (writableImage != null) {
                    avatarPane.setImageView(writableImage);
                }
            }
        }));
        avatarPane.setMaxWidth(135.0);
        avatarPane.setMaxHeight(135.0);
        return avatarPane;
    }

    private void hideRemoveAvatarMenu() {
        if (this.myRemoveAvatar != null) {
            if (this.myRemoveAvatar.isShowing()) {
                this.myRemoveAvatar.hide();
            }
            this.myRemoveAvatar.clear();
        }
    }

    private void showRemoveAvatarMenu(MouseEvent mouseEvent) {
        this.hideRemoveAvatarMenu();
        this.myRemoveAvatar = new MyContextMenu();
        this.myRemoveAvatar.setWithSelection(false);
        this.myRemoveAvatar.addMenuItem((Object)ClientSingleton.getInstance().getString("profile_remove_avatar"), (EventHandler<MouseEvent>)((EventHandler)event1 -> {
            this.hideRemoveAvatarMenu();
            this.avatarPane.setLabelView();
            this.isAvatarRemoved = true;
            this.pictureImagePath = null;
        }));
        this.myRemoveAvatar.show(mouseEvent.getScreenX(), mouseEvent.getScreenY());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Image getFile() {
        int avatarSize = 256;
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(ClientSingleton.getInstance().getPackageName());
        fileChooser.setInitialDirectory(new File(System.getProperty("user.home")));
        Stage stage = (Stage)ClientSingleton.getInstance().getMainViewModel().getParentWindow().getScene().getWindow();
        if (stage == null) return null;
        File file = fileChooser.showOpenDialog((Window)stage);
        ClientSingleton.toLog(this.getClass().getSimpleName(), "file=" + file + (String)(file != null ? " file.getAbsolutePath()=" + file.getAbsolutePath() : ""));
        try (FileInputStream inputStream = new FileInputStream(file.getAbsolutePath());){
            Image image = new Image((InputStream)inputStream);
            int width = (int)image.getWidth();
            int height = (int)image.getHeight();
            if (width < height) {
                height = avatarSize * height / width;
                width = avatarSize;
            } else {
                width = avatarSize * width / height;
                height = avatarSize;
            }
            Optional<Image> writableImage = ClientSingleton.getInstance().getImageFromFile(file, width, height);
            if (!writableImage.isPresent()) return null;
            image = writableImage.get();
            PixelReader pixelReader = image.getPixelReader();
            byte[] buffer = new byte[avatarSize * avatarSize * 4];
            int offsetX = width < height ? 0 : (width - avatarSize) / 2;
            int offsetY = width < height ? (height - avatarSize) / 2 : 0;
            pixelReader.getPixels(offsetX, offsetY, avatarSize, avatarSize, PixelFormat.getByteBgraInstance(), buffer, 0, 4 * avatarSize);
            WritableImage targetImage = new WritableImage(avatarSize, avatarSize);
            PixelWriter pixelWriter = targetImage.getPixelWriter();
            pixelWriter.setPixels(0, 0, avatarSize, avatarSize, (PixelFormat)PixelFormat.getByteBgraInstance(), buffer, 0, 4 * avatarSize);
            File tmpFile = File.createTempFile(String.valueOf(System.currentTimeMillis()), "jpg");
            tmpFile.deleteOnExit();
            BufferedImage bImage = SwingFXUtils.fromFXImage((Image)targetImage, null);
            try {
                ImageIO.write((RenderedImage)bImage, "png", tmpFile);
                this.pictureImagePath = tmpFile;
            }
            catch (IOException e) {
                this.pictureImagePath = file;
            }
            this.isAvatarRemoved = false;
            WritableImage writableImage2 = targetImage;
            return writableImage2;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private void update() {
        MyThreadPoolManager.getInstance().execute(() -> {
            String about;
            String text;
            List list = this.contactInfo.getUserDetails();
            for (int i = list.size() - 1; i >= 0; --i) {
                this.removeDetail((ContactInfo.Detail)list.get(i));
            }
            this.addDetail((Pane)this.fx_DataPane);
            ClientConnector clientConnector = ClientSingleton.getInstance().getClientConnector().get();
            if (this.isAvatarRemoved) {
                try {
                    clientConnector.setAvatar(this.contactInfo, null);
                    ClientSingleton.getInstance().removeAvatar(this.contactInfo.getUserID());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (this.pictureImagePath != null) {
                try {
                    clientConnector.setAvatar(this.contactInfo, this.pictureImagePath);
                    ClientSingleton.getInstance().removeAvatar(this.contactInfo.getUserID());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!this.fx_edTags.getText().isEmpty()) {
                String[] str;
                ArrayList<String> tags = new ArrayList<String>();
                for (String s : str = this.fx_edTags.getText().split("#")) {
                    String tag = s.trim();
                    if (tag.length() <= 0) continue;
                    tags.add(tag);
                }
                this.contactInfo.setUserTags(tags);
            }
            if (!(text = this.fx_edJobTitle.getText()).isEmpty()) {
                this.contactInfo.addUserDetail("Position", (Object)text);
            }
            if (!(text = this.fx_edCompanyTitle.getText()).isEmpty()) {
                this.contactInfo.addUserDetail("Company", (Object)text);
            }
            if (!(about = this.aboutDataPane.getText()).isEmpty()) {
                this.contactInfo.addUserDetail("About", (Object)about);
            }
            String name = this.fx_edpUserName.getText();
            ClientSingleton.toLog(this.getClass().getSimpleName(), "contactInfo name=" + name + " withImage=" + (this.pictureImagePath != null || this.isAvatarRemoved));
            this.contactInfo.setName(name);
            try {
                ClientSingleton.toLog(this.getClass().getSimpleName(), "setUserInfo contactInfo=" + this.contactInfo + " hashCode=" + this.contactInfo.hashCode());
                clientConnector.setUserInfo(this.contactInfo, this.pictureImagePath != null || this.isAvatarRemoved);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("state", this.contactInfo.getState());
            if (this.pictureImagePath != null) {
                data.put("pictureImagePath", this.pictureImagePath.getAbsolutePath());
            }
            ClientSingleton.getInstance().doNotify(Constants.PROFILE_UPDATED, data);
            ClientSingleton.getInstance().getMainViewModel().clientStateChanged(this.contactInfo.getState());
            ClientSingleton.getInstance().runLater(() -> this.myPopupWindow.hide());
        });
    }

    private void addDetail(Pane pane) {
        for (int i = 0; i < pane.getChildren().size(); ++i) {
            EditDataPaneV editDataPaneV = (EditDataPaneV)pane.getChildren().get(i);
            try {
                ClientSingleton.toLog(this.getClass().getSimpleName(), "addDetail key=" + editDataPaneV.getKey() + " value=" + editDataPaneV.getText());
                this.contactInfo.addUserDetail(editDataPaneV.getKey(), (Object)editDataPaneV.getText());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void removeDetail(ContactInfo.Detail fn) {
        this.contactInfo.removeUserDetail(fn);
    }

    private static final int read2bytes(InputStream in) throws IOException {
        return in.read() << 8 | in.read();
    }

    private static final int readByte(InputStream in) throws IOException {
        return in.read();
    }

    public static int getRotation(InputStream in) throws IOException {
        int number_of_tags;
        int offset;
        int i;
        int[] exif_data = new int[100];
        boolean n_flag = false;
        int set_flag = 0;
        boolean is_motorola = false;
        for (int i2 = 0; i2 < 4; ++i2) {
            exif_data[i2] = UserProfileEditorController.readByte(in);
        }
        if (exif_data[0] != 255 || exif_data[1] != 216 || exif_data[2] != 255 || exif_data[3] != 225) {
            return -2;
        }
        int length = UserProfileEditorController.read2bytes(in);
        if (length < 8) {
            return -1;
        }
        length -= 8;
        for (i = 0; i < 6; ++i) {
            exif_data[i] = in.read();
        }
        if (exif_data[0] != 69 || exif_data[1] != 120 || exif_data[2] != 105 || exif_data[3] != 102 || exif_data[4] != 0 || exif_data[5] != 0) {
            return -1;
        }
        length = length > exif_data.length ? exif_data.length : length;
        for (i = 0; i < length; ++i) {
            exif_data[i] = in.read();
        }
        if (length < 12) {
            return -1;
        }
        if (exif_data[0] == 73 && exif_data[1] == 73) {
            is_motorola = false;
        } else if (exif_data[0] == 77 && exif_data[1] == 77) {
            is_motorola = true;
        } else {
            return -1;
        }
        if (is_motorola) {
            if (exif_data[2] != 0) {
                return -1;
            }
            if (exif_data[3] != 42) {
                return -1;
            }
        } else {
            if (exif_data[3] != 0) {
                return -1;
            }
            if (exif_data[2] != 42) {
                return -1;
            }
        }
        if (is_motorola) {
            if (exif_data[4] != 0) {
                return -1;
            }
            if (exif_data[5] != 0) {
                return -1;
            }
            offset = exif_data[6];
            offset <<= 8;
            offset += exif_data[7];
        } else {
            if (exif_data[7] != 0) {
                return -1;
            }
            if (exif_data[6] != 0) {
                return -1;
            }
            offset = exif_data[5];
            offset <<= 8;
            offset += exif_data[4];
        }
        if (offset > length - 2) {
            return -1;
        }
        if (is_motorola) {
            number_of_tags = exif_data[offset];
            number_of_tags <<= 8;
            number_of_tags += exif_data[offset + 1];
        } else {
            number_of_tags = exif_data[offset + 1];
            number_of_tags <<= 8;
            number_of_tags += exif_data[offset];
        }
        if (number_of_tags == 0) {
            return -1;
        }
        offset += 2;
        while (true) {
            int tagnum;
            if (offset > length - 12) {
                return -1;
            }
            if (is_motorola) {
                tagnum = exif_data[offset];
                tagnum <<= 8;
                tagnum += exif_data[offset + 1];
            } else {
                tagnum = exif_data[offset + 1];
                tagnum <<= 8;
                tagnum += exif_data[offset];
            }
            if (tagnum == 274) break;
            if (--number_of_tags == 0) {
                return -1;
            }
            offset += 12;
        }
        if (is_motorola) {
            if (exif_data[offset + 8] != 0) {
                return -1;
            }
            set_flag = exif_data[offset + 9];
        } else {
            if (exif_data[offset + 9] != 0) {
                return -1;
            }
            set_flag = exif_data[offset + 8];
        }
        if (set_flag > 8) {
            return -1;
        }
        if (n_flag) {
            System.out.println("set_flag " + set_flag);
        } else {
            System.out.println("set_flag " + set_flag);
        }
        return set_flag;
    }
}

