/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.profiles.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.views.profiles.utils.DetailValue;
import smile.cti.client.ContactInfo;

public class TypeConstantsRT {
    public static List<String> tagsOfPhones = Arrays.asList("SIP", "Mobile", "BusinessMobile", "PrivateMobile", "Phone", "BusinessPhone", "PrivatePhone");
    public static DetailValue[] detailValues = new DetailValue[]{new DetailValue("SIP", "SIP", 0), new DetailValue("Mobile", "Mobile", 0), new DetailValue("Business Mobile", "BusinessMobile", 0), new DetailValue("Private Mobile", "PrivateMobile", 0), new DetailValue("Phone", "Phone", 0), new DetailValue("Business Phone", "BusinessPhone", 0), new DetailValue("Private Phone", "PrivatePhone", 0), new DetailValue("Email", "Email", 1), new DetailValue("Fax", "Fax", 0), new DetailValue("Web", "Web", 1), new DetailValue("Business Fax", "BusinessFax", 0), new DetailValue("Private Fax", "PrivateFax", 0), new DetailValue("Business Email", "BusinessEmail", 1), new DetailValue("Private Email", "PrivateEmail", 1), new DetailValue("Business Web", "BusinessWeb", 3), new DetailValue("Private Web", "PrivateWeb", 3), new DetailValue("Organization", "Organization", 3), new DetailValue("Branch", "Branch", 3), new DetailValue("Department", "Department", 3), new DetailValue("Position", "Position", 3), new DetailValue("Address", "Address", 3), new DetailValue("Business Address", "BusinessAddress", 3), new DetailValue("Private Address", "PrivateAddress", 3)};

    public static String contains(String label, String[] list) {
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].equalsIgnoreCase(label)) continue;
            return list[i];
        }
        return null;
    }

    public static List<DetailValue> getDetails(List<ContactInfo.Detail> detailLists, ContactInfo contactInfo) {
        return TypeConstantsRT.getDetails(detailLists, contactInfo, false);
    }

    public static List<DetailValue> getDetails(List<ContactInfo.Detail> detailLists, ContactInfo contactInfo, boolean isAllData) {
        List<DetailValue> details = new ArrayList<DetailValue>();
        if (detailLists == null || detailLists.isEmpty()) {
            return details;
        }
        ArrayList<DetailValue> contactTypes = new ArrayList<DetailValue>();
        ArrayList<DetailValue> contactJobs = new ArrayList<DetailValue>();
        ArrayList<DetailValue> contactAddresses = new ArrayList<DetailValue>();
        for (ContactInfo.Detail detail : detailLists) {
            DetailValue detailValue;
            String value;
            String label = detail.getLabel();
            Object object = detail.getValue();
            if (!isAllData && (label.equals("Company") || label.equals("JobTitle") || label.equals("Position") || label.equals("About") || label.equals("About".toLowerCase())) || object == null || (value = object.toString()).isEmpty() || (detailValue = TypeConstantsRT.containsContactDetail(label)) == null) continue;
            detailValue.setEditable(detail.isEditable());
            detailValue.setAdmin(contactInfo.isAdmin());
            detailValue.setValue(value);
            if (detailValue.getDetailViewType() == 0) {
                contactTypes.add(detailValue);
                continue;
            }
            if (detailValue.getDetailViewType() == 1) {
                contactJobs.add(detailValue);
                continue;
            }
            contactAddresses.add(detailValue);
        }
        details = Stream.concat(contactTypes.stream(), contactJobs.stream()).collect(Collectors.toList());
        if (!contactAddresses.isEmpty()) {
            details = Stream.concat(details.stream(), contactAddresses.stream()).collect(Collectors.toList());
            Collectors.toList();
        }
        return details;
    }

    public static DetailValue containsContactDetail(String label) {
        List list = Arrays.stream(detailValues).filter(en -> en.getKey().equalsIgnoreCase(label) || en.getCode().equalsIgnoreCase(label)).collect(Collectors.toList());
        if (list.isEmpty()) {
            return null;
        }
        return ((DetailValue)list.get(0)).clone();
    }

    public static List<DetailValue> getContactDetailList(int detailSupType) {
        return Arrays.stream(detailValues).filter(en -> en.getDetailViewType() == detailSupType).collect(Collectors.toList());
    }

    public static ContactInfo.Detail getUserContactDetail(ContactInfo contactInfo, String key) {
        ContactInfo.Detail detail = contactInfo.getUserDetail(key);
        return detail != null ? detail.clone() : null;
    }

    public static ContactInfo.Detail getCustomContactDetail(ContactInfo contactInfo, String key) {
        ContactInfo.Detail detail = contactInfo.getCustomDetail(key);
        return detail != null ? detail.clone() : null;
    }

    public static ContactInfo.Detail getContactDetail(ContactInfo contactInfo, String key) {
        ContactInfo.Detail detail = contactInfo.getUserDetail(key);
        if (detail == null) {
            detail = contactInfo.getCustomDetail(key);
        }
        return detail != null ? detail.clone() : null;
    }

    public static ContactInfo.Detail getContactForEditDetail(ContactInfo contactInfo, String key) {
        if (ClientSingleton.getInstance().getUserID(contactInfo).equals(ClientSingleton.getInstance().getClientConnector().get().getUserId())) {
            ContactInfo.Detail detail = contactInfo.getUserDetail(key);
            return detail != null ? detail.clone() : null;
        }
        ContactInfo.Detail detail = contactInfo.getCustomDetail(key);
        return detail != null ? detail.clone() : null;
    }
}

