/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.servicescontacts;

import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javafx.stage.Window;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.utils.MyAction;
import net.sipsnet.client.utils.popupstage.MyPopupWindow;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.CloseImageButton;
import net.sipsnet.client.utils.viewers.label.MyLabel;

public class ServicesContactsController {
    @FXML
    private VBox fx_RootPane;
    @FXML
    private StackPane fx_spRootPane;
    @FXML
    private AnchorPane fx_ServicesContactsList;
    @FXML
    private AnchorPane fx_ContactProfileView;
    @FXML
    private GridPane fx_GridPane;
    @FXML
    private HBox fx_hbTitle;
    private WebView browser;
    private ProgressIndicator fx_pbLoadIndicator;
    private MyPopupWindow myPopupWindow;
    private String location;
    private String title;
    private MyAction myAction;
    private MyAction myActionOnClose;

    private ServicesContactsController() {
    }

    public static ServicesContactsController getInstance() {
        return new ServicesContactsController();
    }

    public ServicesContactsController setLocation(String location) {
        this.location = location;
        return this;
    }

    public ServicesContactsController setTitle(String title) {
        this.title = title;
        return this;
    }

    public ServicesContactsController setAction(MyAction myAction) {
        this.myAction = myAction;
        return this;
    }

    public ServicesContactsController setActionOnClose(MyAction myAction) {
        this.myActionOnClose = myAction;
        return this;
    }

    public void buildAndShow() {
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fxml/servicescontacts/servicescontacts.fxml"));
        loader.setResources(ClientSingleton.getInstance().getResourceBundle());
        try {
            this.fx_RootPane = (VBox)loader.load();
            this.fx_RootPane.setStyle("-fx-border-radius: 13; -fx-background-radius: 13;-fx-effect: dropshadow(gaussian, rgba(0, 0, 0, 0.2), 12, 0.0, 0, 8);-fx-background-color: white;");
            this.fx_spRootPane = (StackPane)loader.getNamespace().get((Object)"fx_spRootPane");
            this.fx_ServicesContactsList = (AnchorPane)loader.getNamespace().get((Object)"fx_ServicesContactsList");
            this.fx_ContactProfileView = (AnchorPane)loader.getNamespace().get((Object)"fx_ContactProfileView");
            this.fx_GridPane = (GridPane)loader.getNamespace().get((Object)"fx_GridPane");
            this.fx_hbTitle = (HBox)loader.getNamespace().get((Object)"fx_hbTitle");
            this.fx_hbTitle.prefWidthProperty().bind((ObservableValue)this.fx_RootPane.prefWidthProperty());
            this.fx_spRootPane.prefWidthProperty().bind((ObservableValue)this.fx_RootPane.prefWidthProperty());
            this.fx_spRootPane.setStyle("fx-background-color: red;");
            HBox hbAvatarBox = new HBox();
            hbAvatarBox.setMinHeight(40.0);
            hbAvatarBox.prefHeight(40.0);
            hbAvatarBox.setFillHeight(true);
            hbAvatarBox.setAlignment(Pos.CENTER);
            ImageView ivAvatar = new ImageView();
            ClientSingleton.getInstance().setImageToImageView(ivAvatar, "notify_emblem.png");
            MyLabel myLabel = new MyLabel();
            myLabel.prefWidthProperty().bind((ObservableValue)this.fx_hbTitle.prefWidthProperty());
            myLabel.setIsUnderline(true);
            myLabel.setText(this.title);
            myLabel.setAlignment(Pos.CENTER);
            myLabel.setBackgroundColor("white");
            myLabel.setLabelFontSize(12);
            myLabel.setLabelFontFamily("HelveticaNeue");
            myLabel.setLabelMarginLeft(10);
            HBox.setHgrow((Node)myLabel, (Priority)Priority.ALWAYS);
            HBox closeBox = new HBox();
            closeBox.setAlignment(Pos.CENTER_RIGHT);
            CloseImageButton closeImageButton = new CloseImageButton(true);
            closeImageButton.setSize(20, 20);
            closeImageButton.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)mouseEvent -> {
                this.myPopupWindow.hide();
                if (this.myActionOnClose != null) {
                    this.myActionOnClose.execute();
                }
                this.fx_hbTitle.prefWidthProperty().unbind();
                this.fx_spRootPane.prefWidthProperty().unbind();
                this.fx_spRootPane.prefHeightProperty().unbind();
                ClientSingleton.getInstance().releaseViewResources((Pane)this.fx_RootPane);
            }));
            closeBox.getChildren().add((Object)closeImageButton);
            closeImageButton.requestFocus();
            this.fx_hbTitle.getChildren().addAll((Object[])new Node[]{hbAvatarBox, myLabel, closeBox});
            ClientSingleton.getInstance().runLater(() -> {
                this.initWebView();
                this.show();
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initWebView() {
        this.browser = new WebView();
        this.browser.getStylesheets().add((Object)this.getClass().getResource("/extracss/wvscrollbar.css").toExternalForm());
        this.fx_pbLoadIndicator = ClientSingleton.getInstance().getProgressIndicator();
        WebEngine webEngine = this.browser.getEngine();
        webEngine.setUserAgent(ClientSingleton.getInstance().getPackageName());
        webEngine.setJavaScriptEnabled(true);
        Worker worker = webEngine.getLoadWorker();
        worker.stateProperty().addListener((observable, oldValue, newValue) -> {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "newValue=" + newValue + " webEngine.getLocation()=" + webEngine.getLocation());
            if (newValue == Worker.State.SUCCEEDED || newValue == Worker.State.FAILED) {
                String location;
                this.fx_spRootPane.getChildren().remove((Object)this.fx_pbLoadIndicator);
                if (newValue == Worker.State.SUCCEEDED && ((location = webEngine.getLocation()).contains("ringotel.net/account") || location.startsWith("https://shell.ringotel.co/"))) {
                    this.hide();
                    if (this.myAction != null) {
                        this.myAction.execute();
                    }
                }
            }
        });
        this.browser.prefHeightProperty().bind((ObservableValue)this.fx_spRootPane.heightProperty());
        this.browser.prefWidthProperty().bind((ObservableValue)this.fx_spRootPane.widthProperty());
        if (!this.fx_spRootPane.getChildren().contains((Object)this.browser)) {
            this.fx_spRootPane.getChildren().addAll((Object[])new Node[]{this.browser, this.fx_pbLoadIndicator});
        }
        this.browser.getEngine().load(this.location);
    }

    private void show() {
        this.myPopupWindow = MyPopupWindow.getNewInstance((Pane)this.fx_RootPane, (Window)new Stage()).setAlwaysOnTop(true).initMotionListeners((Node)this.fx_hbTitle);
        this.myPopupWindow.showAndWait();
    }

    private void hide() {
        this.myPopupWindow.hide();
    }
}

