/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.settings;

import java.util.Optional;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.constants.Constants;

public class MyRadioButton
extends HBox {
    private final Label label;
    private String borderColor = "#969aae";
    private Optional<String> dotColor = ClientSingleton.getInstance().getStyle(Constants.BUTTON_BACKGROUND_STYLE);
    private boolean isSelected;
    private final SimpleIntegerProperty dotRadius = new SimpleIntegerProperty();
    private final SimpleIntegerProperty radioRadius = new SimpleIntegerProperty();

    public void setBorderColor(String unselectedBorderColor) {
        this.borderColor = unselectedBorderColor;
    }

    public void setDotColor(String selectedDotColor) {
        this.dotColor = Optional.of("-fx-background-color:" + selectedDotColor);
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean isSelected) {
        String unSelectedPaneStyle = "-fx-border-radius: " + this.getRadioRadius() + " " + this.getRadioRadius() + " " + this.getRadioRadius() + " " + this.getRadioRadius() + "; -fx-background-radius: " + this.getRadioRadius() + " " + this.getRadioRadius() + " " + this.getRadioRadius() + " " + this.getRadioRadius() + "; -fx-background-color: #ffffff;-fx-border-color: " + this.borderColor + ";-fx-border-width: 1";
        String selectedPaneStyle = "-fx-border-radius: " + this.getRadioRadius() + " " + this.getRadioRadius() + " " + this.getRadioRadius() + " " + this.getRadioRadius() + "; -fx-background-radius:" + this.getRadioRadius() + " " + this.getRadioRadius() + " " + this.getRadioRadius() + " " + this.getRadioRadius() + "; -fx-background-color: #ffffff;-fx-border-color: " + this.borderColor + ";-fx-border-width: 1";
        String unSelectedLabelPaneStyle = "-fx-border-radius:" + this.getDotRadius() + "; -fx-background-radius: " + this.getDotRadius() + "; -fx-background-color: #ffffff;";
        String selectedLabelPaneStyle = "-fx-border-radius:" + this.getDotRadius() + "; -fx-background-radius: " + this.getDotRadius() + "; -fx-background-color:" + this.dotColor.get();
        this.setStyle(isSelected ? selectedPaneStyle : unSelectedPaneStyle);
        this.label.setStyle(isSelected ? selectedLabelPaneStyle : unSelectedLabelPaneStyle);
        this.isSelected = isSelected;
    }

    public int getDotRadius() {
        return this.dotRadius.get();
    }

    public SimpleIntegerProperty dotRadiusProperty() {
        return this.dotRadius;
    }

    public void setDotRadius(int dotRadius) {
        this.dotRadius.set(dotRadius);
    }

    public int getRadioRadius() {
        return this.radioRadius.get();
    }

    public SimpleIntegerProperty radioRadiusProperty() {
        return this.radioRadius;
    }

    public void setRadioRadius(int radioRadius) {
        this.radioRadius.set(radioRadius);
    }

    public MyRadioButton() {
        this.label = new Label();
        this.getChildren().add((Object)this.label);
        this.setAlignment(Pos.CENTER);
        this.radioRadius.addListener((event, oldValue, newValue) -> {
            this.setMinWidth(newValue.doubleValue());
            this.setMinHeight(newValue.doubleValue());
            this.setMaxWidth(newValue.doubleValue());
            this.setMaxHeight(newValue.doubleValue());
            this.setPrefWidth(newValue.doubleValue());
            this.setPrefHeight(newValue.doubleValue());
        });
        this.dotRadius.addListener((event, oldValue, newValue) -> {
            this.label.setMinWidth(newValue.doubleValue());
            this.label.setMinHeight(newValue.doubleValue());
            this.label.setMaxWidth(newValue.doubleValue());
            this.label.setMaxHeight(newValue.doubleValue());
            this.label.setPrefWidth(newValue.doubleValue());
            this.label.setPrefHeight(newValue.doubleValue());
        });
        ClientSingleton.getInstance().setMouseCursor((Node)this);
        this.radioRadius.set(19);
        this.dotRadius.set(13);
        this.setSelected(false);
    }
}

