/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.settings;

import ezvcard.Ezvcard;
import ezvcard.VCard;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;
import javafx.stage.FileChooser;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.WhiteLabels;
import net.sipsnet.client.connector.observer.IGUIObservable;
import net.sipsnet.client.connector.utils.ClientUtil;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.constants.IntentConstants;
import net.sipsnet.client.utils.MyAction;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.utils.threadpool.MyThreadPoolManager;
import net.sipsnet.client.utils.viewers.MyAlert;
import net.sipsnet.client.utils.viewers.RichTextViwer.MyTextArea;
import net.sipsnet.client.utils.viewers.phonesmenu.MyPhonesMenu;
import net.sipsnet.client.utils.viewers.richtext.MyStyledTextArea;
import net.sipsnet.client.views.profiles.utils.TypeConstantsRT;
import net.sipsnet.client.views.settings.exportcontacts.ExportToCVS;
import net.sipsnet.client.views.settings.exportcontacts.ExportToVCF;
import net.sipsnet.client.views.settings.importcontacts.csv_google.GoogleContactsImport;
import net.sipsnet.client.views.settings.importcontacts.csv_outlookexpress.OutlookExpressImport;
import net.sipsnet.client.views.settings.importcontacts.vcf_converter.CVFImport;
import smile.cti.client.ContactInfo;

public class SettingUtil
implements IGUIObservable {
    private Text textTitle;
    private Label progressLabel;
    private final MyAlert myAlert = new MyAlert();
    private boolean down = false;
    private Consumer<List<ContactInfo>> onConsumerClose;
    private MyAction onClose;
    private long linesCount = -1L;
    private final List<ContactInfo> allContacts = new ArrayList<ContactInfo>();
    private final List<String> tags = Arrays.asList("Name", "displayname", "FirstName", "LastName", "FullName", "About");

    private SettingUtil() {
        this.initObservable();
    }

    private void initObservable() {
        String[] actions = new String[]{IntentConstants.CONTACT_LIST_UPDATED};
        ClientSingleton.getInstance().addObserver(this, actions);
    }

    public static SettingUtil getInstance() {
        return new SettingUtil();
    }

    public void importContacts(MyAction onStart, MyAction onClose) {
        this.importContacts(onStart, null, onClose);
    }

    public void importContacts(MyAction onStart, Consumer<List<ContactInfo>> onConsumerClose) {
        this.importContacts(onStart, onConsumerClose, null);
    }

    public void importContacts(MyAction onStart, Consumer<List<ContactInfo>> onConsumerClose, MyAction onClose) {
        this.onClose = onClose;
        this.onConsumerClose = onConsumerClose;
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(ClientSingleton.getInstance().getPackageName());
        fileChooser.setInitialDirectory(new File(System.getProperty("user.home")));
        FileChooser.ExtensionFilter fileExtensions = new FileChooser.ExtensionFilter("Choice the file", new String[]{"*.csv", "*.vcf"});
        fileChooser.getExtensionFilters().add((Object)fileExtensions);
        File selectedFile = fileChooser.showOpenDialog(null);
        if (selectedFile != null) {
            boolean isHeaderChecked;
            ClientSingleton.toLog(this.getClass().getSimpleName(), "importContacts start");
            String fileName = selectedFile.getAbsolutePath();
            Path path = Paths.get(fileName, new String[0]);
            HBox hBox = this.getImportAlertHeader(ClientSingleton.getInstance().getString("import_alert1"));
            ArrayList<VCard> vCards = new ArrayList<VCard>();
            if (fileName.endsWith("vcf")) {
                StringBuffer vcfStringBuffer = new StringBuffer();
                try (Stream<String> fileStream = Files.lines(path);){
                    fileStream.forEach(line -> vcfStringBuffer.append((String)line).append("\n"));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                vCards.addAll(Ezvcard.parse(vcfStringBuffer.toString()).all());
                this.linesCount = vCards.size();
                isHeaderChecked = true;
            } else {
                try (Stream<String> fileStream = Files.lines(path);){
                    this.linesCount = fileStream.count() - 1L;
                }
                catch (IOException e) {
                    this.onErrorAlert(e.getMessage());
                }
                ClientSingleton.toLog(this.getClass().getSimpleName(), "linesCount " + this.linesCount);
                Optional<String> firstString = null;
                try (Stream<String> fileStream = Files.lines(path);){
                    firstString = fileStream.findFirst();
                }
                catch (IOException e) {
                    this.onErrorAlert(e.getMessage());
                }
                isHeaderChecked = this.checkHeaderLine(firstString);
            }
            if (!isHeaderChecked || this.linesCount <= 0L) {
                this.myAlert.setHeader(hBox).setContentPane((Pane)this.onCheckAction(selectedFile)).addPositiveButton(ClientSingleton.getInstance().getString("notify_exit"), (EventHandler<MouseEvent>)((EventHandler)event -> this.closeAlarm())).setAlwaysOnTop(true).buildDialogAndShow();
            } else {
                ClientSingleton.toLog(this.getClass().getSimpleName(), "importContacts linesCount = " + this.linesCount);
                onStart.execute();
                this.myAlert.setHeader(hBox).setContentPane(this.getPane(this.linesCount + " " + ClientSingleton.getInstance().getString("import_alert2_"), ClientSingleton.getInstance().getString("import_alert5"))).addNegativeButton(ClientSingleton.getInstance().getString("cancel"), (EventHandler<MouseEvent>)((EventHandler)mouseEvent -> this.closeAlarm()), false).addPositiveButton(ClientSingleton.getInstance().getString("alert_dialog_title3"), (EventHandler<MouseEvent>)((EventHandler)mouseEvent -> {
                    if (vCards.isEmpty()) {
                        this.onConfirmAction(path);
                    } else {
                        this.onConfirmAction(vCards);
                    }
                })).setAlwaysOnTop(true).buildDialogAndShow();
            }
        }
    }

    private void onConfirmAction(List<VCard> vCards) {
        MyThreadPoolManager.getInstance().execute(() -> {
            block4: {
                List<ContactInfo> contacts = null;
                try {
                    contacts = CVFImport.convertToContactInfo(vCards);
                    ClientSingleton.toLog(this.getClass().getSimpleName(), "importContacts send contacts = " + contacts.size());
                    if ((long)contacts.size() >= this.linesCount) {
                        if (!contacts.isEmpty()) {
                            ClientSingleton.getInstance().getClientConnector().get().uploadContacts(new ArrayList<ContactInfo>(contacts), false);
                            TimerExecutor.getInstance().setMyAction(this::onUpdated).startWithDelay(10000L);
                        }
                        break block4;
                    }
                    throw new RuntimeException("Exported " + contacts + " contacts");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.onErrorAlert(e.getMessage());
                }
            }
            ClientSingleton.getInstance().removeObserver(this, new String[]{IntentConstants.CONTACT_LIST_UPDATED});
        });
    }

    private void onUpdated() {
        ClientSingleton.getInstance().runLater(() -> {
            this.myAlert.setTextAndGoToScreenOnTheScreen(ClientSingleton.getInstance().getString("import_alert8"));
            this.myAlert.addPositiveButton(ClientSingleton.getInstance().getString("notify_exit"), (EventHandler<MouseEvent>)((EventHandler)event -> this.closeAlarm(this.allContacts)));
            this.textTitle.setText("");
        });
    }

    private void onConfirmAction(Path path) {
        this.textTitle.setText(ClientSingleton.getInstance().getString("import_alert7"));
        this.myAlert.clearFooter();
        this.myAlert.addNegativeButton(ClientSingleton.getInstance().getString("cancel"), (EventHandler<MouseEvent>)((EventHandler)event -> {
            this.down = true;
            ClientSingleton.toLog(this.getClass().getSimpleName(), "importContacts down = " + this.down);
        }), false);
        this.myAlert.setNewContentPane(this.getPaneWithProgressIndicator());
        MyThreadPoolManager.getInstance().execute(() -> {
            boolean isError;
            AtomicLong convertedCount;
            ArrayList contacts;
            block12: {
                contacts = new ArrayList();
                DecimalFormat df = new DecimalFormat("#.0");
                convertedCount = new AtomicLong(1L);
                isError = false;
                AtomicBoolean isNameKeyInside = new AtomicBoolean();
                AtomicReference keys = new AtomicReference();
                try (Stream<String> fileStream = Files.lines(path);){
                    AtomicBoolean isFirstLine = new AtomicBoolean(true);
                    AtomicReference googleContactsConverter = new AtomicReference();
                    AtomicReference outlookExpressConverterAtomicReference = new AtomicReference();
                    fileStream.forEach(line -> {
                        if (this.down) {
                            throw new RuntimeException("break;");
                        }
                        if (isFirstLine.get()) {
                            ClientSingleton.toLog(this.getClass().getSimpleName(), "importContacts OutlookExpressImport.isOutLookExpressCVS(line) = " + OutlookExpressImport.isOutLookExpressCVS(line));
                            isNameKeyInside.set(line.contains("name"));
                            keys.set(line.toLowerCase().split(","));
                            isFirstLine.set(false);
                            if (line.contains("Phone 1 - Type")) {
                                googleContactsConverter.set(new GoogleContactsImport());
                            } else if (OutlookExpressImport.isOutLookExpressCVS(line)) {
                                outlookExpressConverterAtomicReference.set(new OutlookExpressImport());
                            }
                        } else {
                            String label;
                            try {
                                ContactInfo contactInfo = googleContactsConverter.get() != null ? ((GoogleContactsImport)googleContactsConverter.get()).convertToContactInfo((String)line, (String[])keys.get()) : (outlookExpressConverterAtomicReference.get() != null ? ((OutlookExpressImport)outlookExpressConverterAtomicReference.get()).convertToContactInfo((String)line, (String[])keys.get()) : this.convertToContactInfo((String)line, (String[])keys.get(), isNameKeyInside));
                                if (contactInfo != null) {
                                    contacts.add(contactInfo);
                                }
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                            if (this.linesCount < 100L) {
                                convertedCount.getAndIncrement();
                                label = df.format((double)convertedCount.get() / (double)this.linesCount * 100.0) + " %";
                                ClientSingleton.getInstance().runLater(() -> this.progressLabel.setText(label));
                                try {
                                    Thread.sleep(5L);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                            } else if (convertedCount.getAndIncrement() % (long)(this.linesCount < 1000L ? 10 : 100) == 0L) {
                                label = df.format((double)convertedCount.get() / (double)this.linesCount * 100.0) + " %";
                                ClientSingleton.getInstance().runLater(() -> this.progressLabel.setText(label));
                            }
                            if (this.down) {
                                throw new RuntimeException("break;");
                            }
                            if (this.linesCount > 100L && contacts.size() % 100 == 0) {
                                try {
                                    Thread.sleep(10L);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                                ClientSingleton.getInstance().getClientConnector().get().uploadContacts(new ArrayList(contacts), false);
                                this.allContacts.addAll(contacts);
                                contacts.clear();
                            }
                        }
                    });
                }
                catch (IOException | RuntimeException e) {
                    e.printStackTrace();
                    String error = e.getMessage();
                    if (error.contains("break;")) break block12;
                    this.onErrorAlert(e.getMessage());
                    isError = true;
                }
            }
            ClientSingleton.toLog(this.getClass().getSimpleName(), "importContacts send contacts = " + contacts.size());
            ClientSingleton.toLog(this.getClass().getSimpleName(), "importContacts i = " + convertedCount.get());
            if (convertedCount.get() >= this.linesCount) {
                if (!contacts.isEmpty()) {
                    this.allContacts.addAll(contacts);
                    ClientSingleton.getInstance().getClientConnector().get().uploadContacts(new ArrayList(contacts), false);
                    TimerExecutor.getInstance().setMyAction(this::onUpdated).startWithDelay(10000L);
                }
            } else if (!isError) {
                this.allContacts.clear();
                TimerExecutor.getInstance().setMyAction(this::closeAlarm).startWithDelayInGUIThread(500L);
            }
        });
    }

    private VBox onCheckAction(File file) {
        this.textTitle.setText(ClientSingleton.getInstance().getString("import_alert1"));
        VBox vBox = new VBox();
        vBox.setPrefHeight(200.0);
        vBox.setPrefWidth(160.0);
        TextFlow tfFirstLine = new TextFlow();
        tfFirstLine.setPrefHeight(32.0);
        tfFirstLine.setMinHeight(64.0);
        tfFirstLine.setPadding(new Insets(20.0, 0.0, 0.0, 0.0));
        tfFirstLine.setTextAlignment(TextAlignment.CENTER);
        tfFirstLine.prefWidthProperty().bind((ObservableValue)vBox.widthProperty());
        Text firstLineText = new Text(ClientSingleton.getInstance().getString("import_alert2"));
        try {
            ClientSingleton.getInstance().setStyledTextFont(firstLineText, false, MyStyledTextArea.getFontColor(), 11, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        tfFirstLine.getChildren().add((Object)firstLineText);
        vBox.getChildren().add((Object)tfFirstLine);
        TextFlow tfSecondLine = new TextFlow();
        tfSecondLine.setTextAlignment(TextAlignment.CENTER);
        tfSecondLine.prefWidthProperty().bind((ObservableValue)vBox.widthProperty());
        Text secondLineText = new Text(ClientSingleton.getInstance().getString("import_alert3") + " ");
        try {
            ClientSingleton.getInstance().setStyledTextFont(secondLineText, false, MyStyledTextArea.getFontColor(), 11, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        tfSecondLine.getChildren().add((Object)secondLineText);
        Text secondLineText_ = new Text(ClientSingleton.getInstance().getString("import_alert4"));
        try {
            ClientSingleton.getInstance().setStyledTextFont(secondLineText_, false, WhiteLabels.getCustomBlueColor(), 11, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ClientSingleton.getInstance().setMouseCursor((Node)secondLineText_);
        secondLineText_.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> {
            TimerExecutor.getInstance().setMyAction(() -> this.closeAlarm()).startWithDelay(500L);
            ClientSingleton.getInstance().openFile(file);
        });
        tfSecondLine.getChildren().add((Object)secondLineText_);
        vBox.getChildren().add((Object)tfSecondLine);
        return vBox;
    }

    private void onErrorAlert(String error) {
        ClientSingleton.getInstance().runLater(() -> {
            if (this.textTitle == null) {
                HBox hBox = this.getImportAlertHeader(ClientSingleton.getInstance().getString("import_alert6"));
                this.myAlert.setHeader(hBox).addPositiveButton(ClientSingleton.getInstance().getString("notify_exit"), (EventHandler<MouseEvent>)((EventHandler)event -> this.closeAlarm())).setAlwaysOnTop(true);
                this.myAlert.setTextAndGoToScreenOnTheScreen(error);
                this.myAlert.buildDialogAndShow();
            } else {
                this.textTitle.setText(ClientSingleton.getInstance().getString("import_alert6"));
                this.myAlert.setTextAndGoToScreenOnTheScreen(error);
                this.myAlert.addPositiveButton(ClientSingleton.getInstance().getString("notify_exit"), (EventHandler<MouseEvent>)((EventHandler)event -> this.closeAlarm()));
            }
        });
    }

    private void closeAlarm() {
        this.closeAlarm(new ArrayList<ContactInfo>());
    }

    private void closeAlarm(List<ContactInfo> list) {
        if (this.onClose != null) {
            this.onClose.execute();
        } else if (this.onConsumerClose != null && !list.isEmpty()) {
            TimerExecutor.getInstance().start(() -> this.onConsumerClose.accept(list));
        }
        ClientSingleton.getInstance().runLater(this.myAlert::close);
    }

    private HBox getImportAlertHeader(String title) {
        HBox titleLine = new HBox();
        titleLine.setPadding(new Insets(10.0, 0.0, 0.0, 0.0));
        titleLine.setPrefHeight(32.0);
        titleLine.setMinHeight(32.0);
        titleLine.setMaxHeight(32.0);
        titleLine.setAlignment(Pos.CENTER);
        HBox.setHgrow((Node)titleLine, (Priority)Priority.ALWAYS);
        this.textTitle = new Text(title);
        try {
            ClientSingleton.getInstance().setStyledTextFont(this.textTitle, false, Constants.colorForSmallFont, 10, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        titleLine.getChildren().add((Object)this.textTitle);
        return titleLine;
    }

    private void setTitle(String title) {
        this.textTitle.setText(title);
    }

    private Pane getPane(String firstLine, String secondLine) {
        VBox vBox = new VBox();
        vBox.setPrefHeight(200.0);
        vBox.setPrefWidth(160.0);
        TextFlow tfFirstLine = new TextFlow();
        tfFirstLine.setPrefHeight(32.0);
        tfFirstLine.setMinHeight(64.0);
        tfFirstLine.setPadding(new Insets(20.0, 0.0, 0.0, 0.0));
        tfFirstLine.setTextAlignment(TextAlignment.CENTER);
        tfFirstLine.prefWidthProperty().bind((ObservableValue)vBox.widthProperty());
        Text firstLineText = new Text(firstLine);
        try {
            ClientSingleton.getInstance().setStyledTextFont(firstLineText, false, MyStyledTextArea.getFontColor(), 11, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        tfFirstLine.getChildren().add((Object)firstLineText);
        vBox.getChildren().add((Object)tfFirstLine);
        VBox textPane = new VBox();
        MyTextArea myTextArea = new MyTextArea(secondLine, (Pane)textPane);
        VBox.setVgrow((Node)myTextArea, (Priority)Priority.ALWAYS);
        myTextArea.setAlertBackground();
        myTextArea.prefWidthProperty().bind((ObservableValue)textPane.widthProperty());
        textPane.getChildren().clear();
        textPane.setAlignment(Pos.CENTER);
        textPane.getChildren().add((Object)myTextArea);
        int textHeight = ClientSingleton.getInstance().getContentTextHeight(300, secondLine) + 40;
        myTextArea.setMinHeight(textHeight);
        textPane.setMinHeight(0.0);
        textPane.setPrefHeight((double)textHeight);
        textPane.setMaxHeight(Double.MAX_VALUE);
        textPane.setPadding(new Insets(0.0, 0.0, 10.0, 0.0));
        vBox.getChildren().add((Object)textPane);
        return vBox;
    }

    private Pane getPaneWithProgressIndicator() {
        VBox vBox = new VBox();
        vBox.setPrefHeight(200.0);
        vBox.setPrefWidth(160.0);
        StackPane textPane = new StackPane();
        this.progressLabel = new Label();
        this.progressLabel.setTextFill((Paint)Color.web((String)Constants.colorForSmallFont));
        this.progressLabel.setFont(new Font("Arial", 10.0));
        textPane.getChildren().add((Object)this.progressLabel);
        ProgressIndicator progressIndicator = ClientSingleton.getInstance().getProgressIndicator();
        progressIndicator.setMaxWidth(60.0);
        progressIndicator.setMaxHeight(60.0);
        textPane.getChildren().add((Object)ClientSingleton.getInstance().getProgressIndicator());
        VBox.setVgrow((Node)textPane, (Priority)Priority.ALWAYS);
        textPane.setAlignment(Pos.CENTER);
        vBox.getChildren().add((Object)textPane);
        return vBox;
    }

    private boolean checkHeaderLine(Optional<String> line) {
        String[] headers;
        if (line == null || line.isEmpty()) {
            return false;
        }
        for (String header : headers = line.get().split(",")) {
            if (header.equalsIgnoreCase("link_title") || header.equalsIgnoreCase("link_url")) {
                return true;
            }
            if (!this.tags.stream().noneMatch(h -> h.equalsIgnoreCase(header.toLowerCase())) || TypeConstantsRT.containsContactDetail(header) != null || GoogleContactsImport.containsContactDetail(header) || OutlookExpressImport.containsContactDetail(header)) continue;
            return false;
        }
        return true;
    }

    private ContactInfo convertToContactInfo(String line, String[] keys, AtomicBoolean isNameKeyInside) throws Exception {
        AtomicReference<String[]> values = new AtomicReference<String[]>();
        values.set(line.split(","));
        ContactInfo contactInfo = ContactInfo.createContact(null);
        contactInfo.setLocalId(String.valueOf(contactInfo.hashCode()));
        IntStream.range(0, keys.length).forEach(index -> {
            String value;
            String key = keys[index].trim();
            String string = value = index < ((String[])values.get()).length ? ((String[])values.get())[index].trim() : "";
            if (!value.isEmpty()) {
                if (key.equalsIgnoreCase("name")) {
                    contactInfo.setName(value);
                } else if (key.equalsIgnoreCase("firstname") && !isNameKeyInside.get()) {
                    if (contactInfo.getName() == null || contactInfo.getName().isEmpty()) {
                        contactInfo.setName(value);
                    } else {
                        contactInfo.setName(value + " " + contactInfo.getName());
                    }
                } else if (key.equalsIgnoreCase("lastname") && !isNameKeyInside.get()) {
                    if (contactInfo.getName() == null || contactInfo.getName().isEmpty()) {
                        contactInfo.setName(value);
                    } else {
                        contactInfo.setName(contactInfo.getName() + " " + value);
                    }
                } else {
                    contactInfo.addCustomDetail(key, (Object)value);
                }
            }
        });
        if ("Unknown".equals(contactInfo.toString()) && contactInfo.getPhoneDetails().isEmpty() && contactInfo.getEmailDetails().isEmpty()) {
            return null;
        }
        return contactInfo;
    }

    public void exportContacts(StackPane spSettingsPane, HBox fx_progressBarPane, MyAction onClose) {
        List<String> menuItems = List.of(ClientSingleton.getInstance().getString("settings_export_contacts_to_csv"), ClientSingleton.getInstance().getString("settings_export_contacts_to_vcf"));
        String item = MyPhonesMenu.getInstance().setTitle("Export").showAndWait(menuItems);
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(ClientSingleton.getInstance().getPackageName());
        fileChooser.setInitialDirectory(new File(System.getProperty("user.home")));
        String extension = item == null || item.contains("csv") ? "*.csv" : "*.vcf";
        FileChooser.ExtensionFilter fileExtensions = new FileChooser.ExtensionFilter("Choice or create the file", new String[]{extension});
        fileChooser.getExtensionFilters().add((Object)fileExtensions);
        File selectedFile = fileChooser.showSaveDialog(null);
        if (selectedFile != null) {
            if (!selectedFile.exists()) {
                try {
                    ClientSingleton.toLog(this.getClass().getSimpleName(), "File " + selectedFile.getAbsolutePath() + " was created : " + selectedFile.createNewFile());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            VBox pane = ClientUtil.getLoadingAnchorPane(ClientSingleton.getInstance().getString("activity_save"));
            fx_progressBarPane.getChildren().add((Object)pane);
            if (!spSettingsPane.getChildren().contains((Object)fx_progressBarPane)) {
                spSettingsPane.getChildren().add((Object)fx_progressBarPane);
            }
            if (extension.equals("*.csv")) {
                ExportToCVS.processExport(spSettingsPane, fx_progressBarPane, onClose, selectedFile);
            } else {
                ExportToVCF.processExport(spSettingsPane, fx_progressBarPane, onClose, selectedFile);
            }
        }
    }

    @Override
    public void onNotifiedMessage(String action, Map<String, Object> data) {
        if (IntentConstants.CONTACT_LIST_UPDATED.equals(action)) {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "CONTACT_LIST_UPDATED allContacts.size()=" + this.allContacts.size() + " linesCount=" + this.linesCount);
            if ((long)this.allContacts.size() >= this.linesCount) {
                this.onUpdated();
            }
        }
    }
}

