/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.settings.exportcontacts;

import ezvcard.VCard;
import ezvcard.parameter.EmailType;
import ezvcard.parameter.TelephoneType;
import ezvcard.property.FormattedName;
import ezvcard.property.StructuredName;
import ezvcard.property.Url;
import io.reactivex.Observable;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.utils.MyAction;
import net.sipsnet.client.utils.threadpool.MyThreadPoolManager;
import net.sipsnet.client.views.profiles.utils.DetailValue;
import net.sipsnet.client.views.profiles.utils.TypeConstantsRT;
import net.sipsnet.client.views.tabs.UpdateLists;
import smile.cti.client.ContactInfo;

public class ExportToVCF {
    public static void processExport(StackPane spSettingsPane, HBox fx_progressBarPane, MyAction onClose, File selectedFile) {
        Observable.just((Object)selectedFile).observeOn(Schedulers.from((Executor)MyThreadPoolManager.getInstance().getThreadPoolExecutor())).doOnError(ExportToVCF.onError()).flatMap(file -> {
            List<ContactInfo> contacts = ClientSingleton.getInstance().getContactInfoStream().filter(UpdateLists::isContactNotAutirized).collect(Collectors.toList());
            if (contacts.isEmpty()) {
                return Observable.empty();
            }
            try (BufferedWriter writer = Files.newBufferedWriter(Paths.get(selectedFile.getAbsolutePath(), new String[0]), new OpenOption[0]);){
                contacts.forEach(contactInfo -> {
                    VCard vCard = new VCard();
                    ExportToVCF.addName(vCard, contactInfo);
                    ExportToVCF.addOrganization(vCard, contactInfo);
                    ExportToVCF.addNotes(vCard, contactInfo);
                    ExportToVCF.addLinks(vCard, contactInfo);
                    ExportToVCF.addDetails(vCard, contactInfo);
                    try {
                        writer.write(vCard.write());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
            }
            return Observable.just(contacts);
        }).subscribe(contacts -> ClientSingleton.getInstance().runLater(() -> {
            spSettingsPane.getChildren().remove((Object)fx_progressBarPane);
            fx_progressBarPane.getChildren().clear();
            onClose.execute();
        }), ExportToVCF.onError());
    }

    private static void addName(VCard vCard, ContactInfo contactInfo) {
        ContactInfo.Detail detail = contactInfo.getUserDetail("LastName");
        if (detail == null) {
            detail = contactInfo.getCustomDetail("LastName");
        }
        String lastName = "";
        if (detail != null && detail.getValue() != null) {
            lastName = detail.getValue().toString();
        }
        if ((detail = contactInfo.getUserDetail("FirstName")) == null) {
            detail = contactInfo.getCustomDetail("FirstName");
        }
        String firstName = "";
        if (detail != null && detail.getValue() != null) {
            firstName = detail.getValue().toString();
        }
        StructuredName structuredName = new StructuredName();
        if (!lastName.isEmpty()) {
            structuredName.setFamily(lastName);
        }
        if (!firstName.isEmpty()) {
            structuredName.setGiven(firstName);
        }
        if (firstName.isEmpty() && lastName.isEmpty()) {
            structuredName.setGiven(contactInfo.toString());
        }
        vCard.setStructuredName(structuredName);
        FormattedName formattedName = new FormattedName(contactInfo.toString());
        vCard.addFormattedName(formattedName);
    }

    private static void addDetails(VCard vCard, ContactInfo contactInfo) {
        ArrayList<ContactInfo.Detail> details = new ArrayList<ContactInfo.Detail>(contactInfo.getUserDetails());
        details.addAll(contactInfo.getCustomDetails());
        List<DetailValue> detailValueList = TypeConstantsRT.getDetails(details, contactInfo, true);
        detailValueList.forEach(detailValue -> ExportToVCF.addDetail(vCard, detailValue));
    }

    private static void addLinks(VCard vCard, ContactInfo contactInfo) {
        List links = ClientSingleton.getInstance().getClientConnector().get().getContactLinks(contactInfo);
        if (!links.isEmpty()) {
            for (int i = 0; i < links.size(); ++i) {
                HashMap map = (HashMap)links.get(i);
                Url url = new Url(map.get("url").toString());
                url.setType("work");
                vCard.addUrl(url);
            }
        }
    }

    private static void addOrganization(VCard vCard, ContactInfo contactInfo) {
        ContactInfo.Detail detail = contactInfo.getUserDetail("Organization");
        if (detail == null) {
            detail = contactInfo.getCustomDetail("Organization");
        }
        String organization = "";
        if (detail != null && detail.getValue() != null) {
            organization = detail.getValue().toString();
        }
        if ((detail = contactInfo.getUserDetail("Department")) == null) {
            detail = contactInfo.getCustomDetail("Department");
        }
        String department = "";
        if (detail != null && detail.getValue() != null) {
            department = detail.getValue().toString();
        }
        vCard.setOrganization(organization, department);
        detail = contactInfo.getUserDetail("Position");
        if (detail == null) {
            detail = contactInfo.getCustomDetail("Position");
        }
        String position = "";
        if (detail != null && detail.getValue() != null) {
            position = detail.getValue().toString();
        }
        vCard.addTitle(position);
    }

    private static void addNotes(VCard vCard, ContactInfo contactInfo) {
        Object about = "";
        ContactInfo.Detail detail = contactInfo.getUserDetail("About");
        if (detail != null) {
            about = detail.getValue().toString();
        }
        if ((detail = contactInfo.getCustomDetail("About")) != null) {
            if (((String)about).isEmpty()) {
                about = (String)about + "\n";
            }
            about = (String)about + detail.getValue().toString();
        }
        if (!((String)about).isEmpty()) {
            vCard.addNote((String)about);
        }
    }

    private static void addDetail(VCard vCard, DetailValue detailValue) {
        if (detailValue.getValue() == null || detailValue.getValue().trim().isEmpty()) {
            return;
        }
        if (detailValue.getLabel().toLowerCase().contains("mobile")) {
            if (detailValue.getCode().equals("PrivateMobile")) {
                vCard.addTelephoneNumber(detailValue.getValue(), TelephoneType.CELL, TelephoneType.HOME, TelephoneType.VOICE);
            } else if (detailValue.getCode().equals("BusinessMobile")) {
                vCard.addTelephoneNumber(detailValue.getValue(), TelephoneType.CELL, TelephoneType.WORK, TelephoneType.VOICE);
            } else {
                vCard.addTelephoneNumber(detailValue.getValue(), TelephoneType.CELL, TelephoneType.VOICE);
            }
        } else if (detailValue.getLabel().toLowerCase().contains("phone")) {
            if (detailValue.getCode().equals("PrivatePhone")) {
                vCard.addTelephoneNumber(detailValue.getValue(), TelephoneType.HOME, TelephoneType.VOICE);
            } else if (detailValue.getCode().equals("BusinessPhone")) {
                vCard.addTelephoneNumber(detailValue.getValue(), TelephoneType.WORK, TelephoneType.VOICE);
            }
        } else if (detailValue.getLabel().toLowerCase().contains("fax")) {
            if (detailValue.getCode().equals("PrivateFax")) {
                vCard.addTelephoneNumber(detailValue.getValue(), TelephoneType.FAX, TelephoneType.HOME);
            } else if (detailValue.getCode().equals("BusinessFax")) {
                vCard.addTelephoneNumber(detailValue.getValue(), TelephoneType.FAX, TelephoneType.WORK);
            }
        } else if (detailValue.getLabel().toLowerCase().contains("email")) {
            if (detailValue.getCode().equals("PrivateEmail")) {
                vCard.addEmail(detailValue.getValue(), EmailType.HOME);
            } else if (detailValue.getCode().equals("BusinessEmail")) {
                vCard.addEmail(detailValue.getLabel(), EmailType.WORK);
            } else {
                vCard.addEmail(detailValue.getValue(), new EmailType[0]);
            }
        } else if (detailValue.getLabel().toLowerCase().contains("web")) {
            Url url = new Url(detailValue.getValue());
            if (detailValue.getCode().equals("PrivateWeb")) {
                url.setType("home");
            } else {
                url.setType("work");
            }
            vCard.addUrl(url);
        }
    }

    private static Consumer<? super Throwable> onError() {
        return throwable -> {
            ClientSingleton.toLog("ExportToCVS", "error import contacts : " + throwable.getMessage());
            ClientSingleton.getInstance().removeLoadingPane();
        };
    }
}

