/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.settings.importcontacts.csv_outlookexpress;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.IntStream;
import smile.cti.client.ContactInfo;

public class OutlookExpressImport {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean containsContactDetail(String header) {
        List<String> phones = List.of("Primary Phone", "Business Phone", "Business Phone 2", "Company Main Phone", "Home Phone", "Home Phone 2", "Car Phone", "Other Phone", "Assistant's Phone", "Mobile Phone");
        List<String> faxes = List.of("Business Fax", "Home Fax", "Other Fax");
        List<String> emails = List.of("E-mail Address", "E-mail Type", "E-mail Display Name", "E-mail 2 Address", "E-mail 2 Type", "E-mail 2 Display Name", "E-mail 3 Address", "E-mail 3 Type", "E-mail 3 Display Name");
        List<String> headers = List.of("Title", "First Name", "Middle Name", "Last Name", "Company", "Department", "Job Title", "Callback", "Radio Phone", "TTY/TDD Phone", "Pager", "Telex", "Web Page", "Suffix", "Account", "ISDN", "Anniversary", "Assistant's Name", "Billing Information", "Birthday", "Business Address", "PO Box", "Categories", "Children", "Directory Server", "Business Street", "Business Street 2", "Business Street 3", "Business City", "Business State", "Business Postal Code", "Business Country/Region", "Home Street", "Home Street 2", "Home Street 3", "Home City", "Home State", "Home Postal Code", "Home Country/Region", "Other Street", "Other Street 2", "Other Street 3", "Other City", "Other State", "Other Postal Code", "Other Country/Region", "Gender", "Government ID Number", "Hobby", "Home Address PO Box", "Business Address PO Box", "Initials", "Internet Free Busy", "Keywords", "Language", "Location", "Manager's Name", "Mileage", "Notes", "Office Location", "Organizational ID Number", "Other Address PO Box", "Priority", "Private", "Profession", "Referred By", "Sensitivity", "Spouse", "User 1", "User 2", "User 3", "User 4");
        if (OutlookExpressImport.containsIgnoreCase(header, "Title")) return true;
        if (headers.contains(header)) return true;
        if (header.startsWith("Address")) return true;
        if (header.contains("Phone")) {
            if (phones.stream().anyMatch(header::contains)) return true;
        }
        if (header.contains("Fax")) {
            if (faxes.stream().anyMatch(header::contains)) return true;
        }
        if (!header.contains("E-mail")) return false;
        if (!emails.stream().anyMatch(header::contains)) return false;
        return true;
    }

    public static boolean isOutLookExpressCVS(String key) {
        return OutlookExpressImport.containsIgnoreCase(key, "Title") && OutlookExpressImport.containsIgnoreCase(key, "First Name") && OutlookExpressImport.containsIgnoreCase(key, "Middle Name") && OutlookExpressImport.containsIgnoreCase(key, "Middle Name");
    }

    private String getRingotelTag(String key) {
        if (OutlookExpressImport.containsIgnoreCase(key, "Phone")) {
            if (OutlookExpressImport.containsIgnoreCase(key, "Business")) {
                return "BusinessPhone";
            }
            if (OutlookExpressImport.containsIgnoreCase(key, "Home")) {
                return "BusinessPhone";
            }
            if (OutlookExpressImport.containsIgnoreCase(key, "Mobile")) {
                return "Mobile";
            }
            return "Phone";
        }
        if (OutlookExpressImport.containsIgnoreCase(key, "Fax")) {
            if (OutlookExpressImport.containsIgnoreCase(key, "Business")) {
                return "BusinessFax";
            }
            if (OutlookExpressImport.containsIgnoreCase(key, "Home")) {
                return "PrivateFax";
            }
            return "Fax";
        }
        if (OutlookExpressImport.containsIgnoreCase(key, "E-mail Address")) {
            return "Email";
        }
        if (OutlookExpressImport.containsIgnoreCase(key, "Notes")) {
            return "About";
        }
        if (OutlookExpressImport.containsIgnoreCase(key, "Company")) {
            return "Organization";
        }
        if (OutlookExpressImport.containsIgnoreCase(key, "Department")) {
            return "Department";
        }
        if (OutlookExpressImport.containsIgnoreCase(key, "Job Title")) {
            return "Position";
        }
        if (OutlookExpressImport.containsIgnoreCase(key, "Web Page")) {
            return "Web";
        }
        if (OutlookExpressImport.containsIgnoreCase(key, "First Name")) {
            return "FirstName";
        }
        if (OutlookExpressImport.containsIgnoreCase(key, "Last Name")) {
            return "LastName";
        }
        return null;
    }

    private static boolean containsIgnoreCase(String key1, String key2) {
        return key1.toLowerCase().contains(key2.toLowerCase());
    }

    public ContactInfo convertToContactInfo(String line, String[] keys) {
        AtomicReference<String[]> values = new AtomicReference<String[]>(line.split(","));
        ContactInfo contactInfo = ContactInfo.createContact(null);
        IntStream.range(0, keys.length).forEach(index -> {
            String tag;
            String value;
            String key = keys[index].trim();
            String string = value = index < ((String[])values.get()).length ? ((String[])values.get())[index].trim() : "";
            if (!value.isEmpty() && (tag = this.getRingotelTag(key)) != null) {
                contactInfo.addCustomDetail(tag, (Object)value);
            }
        });
        ContactInfo.Detail firstNameDetail = contactInfo.getFirstNameDetail();
        ContactInfo.Detail lastNameDetail = contactInfo.getLastNameDetail();
        String firstName = "";
        if (firstNameDetail != null && firstNameDetail.getValue() != null) {
            firstName = firstNameDetail.getValue().toString();
        }
        String lastName = "";
        if (lastNameDetail != null && lastNameDetail.getValue() != null) {
            lastName = lastNameDetail.getValue().toString();
        }
        Object name = !firstName.isEmpty() ? firstName + " " : "";
        if (!((String)(name = (String)name + (!lastName.isEmpty() ? lastName : ""))).isEmpty()) {
            contactInfo.setName((String)name);
        } else {
            name = contactInfo.getPrimaryPhoneNumber();
            if (name == null) {
                name = contactInfo.getPrimaryEmail();
            }
            if (name != null) {
                contactInfo.setName((String)name);
            }
        }
        if ("Unknown".equals(contactInfo.toString()) && contactInfo.getPhoneDetails().isEmpty() && contactInfo.getEmailDetails().isEmpty()) {
            return null;
        }
        return contactInfo;
    }
}

