/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.tabs;

import io.reactivex.Scheduler;
import io.reactivex.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.util.Pair;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.utils.threadpool.SingleThreadPoolManager;
import net.sipsnet.client.views.chat.cell.MessageInfoDate;
import net.sipsnet.client.views.tabs.calls.flow.utils.CallDateHandler;
import net.sipsnet.client.views.tabs.calls.flow.utils.CallHandler;
import net.sipsnet.client.views.tabs.calls.flow.utils.CallSessionHeader;
import net.sipsnet.client.views.tabs.contacts.flow.util.ContactInfoHeader;
import net.sipsnet.client.views.tabs.sessions.flow.utils.SessionInfoHeader;
import smile.cti.client.ClientConnector;
import smile.cti.client.ContactInfo;
import smile.cti.client.MessageInfo;
import smile.cti.client.SessionInfo;

public class UpdateLists {
    private static final String TAG = "UpdateLists";
    public static Scheduler scheduler = Schedulers.from((Executor)SingleThreadPoolManager.getInstance().getThreadPoolExecutor());

    public static List<MessageInfo> getMessagesList(SessionInfo sessionInfo, int filterMode, String prefix) {
        ClientSingleton.toLog(TAG, "updateChatList sessionInfo = " + sessionInfo);
        ArrayList<MessageInfo> messageInfoNodeList = new ArrayList<MessageInfo>();
        if (sessionInfo == null) {
            return messageInfoNodeList;
        }
        ClientSingleton.toLog(TAG, "updateChatList sessionInfo.getMessages().size() = " + sessionInfo.getMessages().size() + " filterMode=" + filterMode);
        Collections.sort(sessionInfo.getMessages());
        Optional<ClientConnector> optionalClientConnector = ClientSingleton.getInstance().getClientConnector();
        Function<MessageInfo, String> classifier = messageInfo -> {
            if (optionalClientConnector.isPresent()) {
                return ClientSingleton.getInstance().getDateWMonthString(messageInfo.getTime());
            }
            return "";
        };
        ArrayList list = new ArrayList();
        HashMap<String, Object> filterMap = new HashMap<String, Object>();
        if (filterMode == 0) {
            list.addAll(sessionInfo.getMessages());
        } else {
            if (prefix.isEmpty()) {
                if (filterMode == 1) {
                    filterMap.put("type", 8);
                } else if (filterMode == 4) {
                    filterMap.put("type", 2);
                } else if (filterMode == 2) {
                    filterMap.put("code", 1);
                } else if (filterMode == 3) {
                    filterMap.put("code", 8);
                }
            } else {
                filterMap.put("find", prefix);
            }
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                ClientSingleton.toLog(TAG, "updateChatList filterMap = " + filterMap + " " + sessionInfo.getFirstMessage().getTime());
                try {
                    List tmpList = clientConnector.findMessages(sessionInfo, filterMap);
                    ClientSingleton.toLog(TAG, "updateChatList findMessages = " + tmpList.size());
                    list.addAll(tmpList.stream().sorted().collect(Collectors.toList()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        ClientSingleton.toLog(TAG, "updateChatList list = " + list.size());
        Supplier<TreeMap> mapFactory = () -> new TreeMap(Comparator.reverseOrder());
        Collector downStream = Collectors.toList();
        Collector<MessageInfo, ?, TreeMap> collector = Collectors.groupingBy(classifier, mapFactory, downStream);
        TreeMap map = list.stream().collect(collector);
        map.forEach((key, value) -> {
            for (int index = value.size() - 1; index >= 0; --index) {
                MessageInfo messageInfo = (MessageInfo)value.get(index);
                messageInfoNodeList.add(messageInfo);
            }
            messageInfoNodeList.add(new MessageInfoDate((String)key));
        });
        ClientSingleton.toLog(TAG, "messageInfoNodeList = " + messageInfoNodeList.size());
        return messageInfoNodeList;
    }

    public static Pair<AtomicReference<MessageInfoDate>, List<MessageInfo>> addDateCells(List<MessageInfo> list) {
        ArrayList messageInfoNodeList = new ArrayList();
        Function<MessageInfo, String> classifier = messageInfo -> ClientSingleton.getInstance().getDateWMonthString(messageInfo.getTime());
        ClientSingleton.toLog(TAG, "addDateCells list = " + list.size());
        Supplier<TreeMap> mapFactory = () -> new TreeMap(Comparator.reverseOrder());
        Collector downStream = Collectors.toList();
        Collector<MessageInfo, ?, TreeMap> collector = Collectors.groupingBy(classifier, mapFactory, downStream);
        TreeMap map = list.stream().collect(collector);
        AtomicReference lastDate = new AtomicReference();
        map.descendingMap().forEach((key, value) -> {
            MessageInfoDate lastDateM = new MessageInfoDate((String)key);
            lastDate.set(lastDateM);
            messageInfoNodeList.add(lastDateM);
            for (int index = value.size() - 1; index >= 0; --index) {
                MessageInfo messageInfo = (MessageInfo)value.get(index);
                messageInfoNodeList.add(messageInfo);
            }
        });
        ClientSingleton.toLog(TAG, "addDateCells messageInfoNodeList = " + messageInfoNodeList.size());
        return new Pair(lastDate, messageInfoNodeList);
    }

    public static List<ContactInfo> updateContactsList(List<ContactInfoHeader> headers, boolean isAutorizedContacts) {
        ArrayList<ContactInfo> items = new ArrayList<ContactInfo>();
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            List<ContactInfo> members;
            Function<ContactInfo, Integer> classifier1;
            List contactsList;
            Stream<ContactInfo> stream1 = ClientSingleton.getInstance().getContactInfoStream();
            long st1 = System.currentTimeMillis();
            if (isAutorizedContacts) {
                contactsList = stream1.distinct().filter(UpdateLists.getAutorizedContacts()).filter(contactInfo -> !ClientSingleton.getInstance().getUserID((ContactInfo)contactInfo).equals(clientConnector.getUserId())).collect(Collectors.toList());
                classifier1 = contactInfoCell -> {
                    if (contactInfoCell.isFavorite()) {
                        return 0;
                    }
                    if (contactInfoCell.isUser()) {
                        return 1;
                    }
                    return 2;
                };
            } else {
                contactsList = stream1.distinct().filter(UpdateLists.getNotAutorizedContacts()).collect(Collectors.toList());
                classifier1 = contactInfo -> {
                    if (contactInfo.isFavorite()) {
                        return 0;
                    }
                    return 3;
                };
            }
            Collector<ContactInfo, ?, Map<Integer, List<ContactInfo>>> collector1 = Collectors.groupingBy(classifier1);
            Map<Integer, List<ContactInfo>> map1 = contactsList.stream().collect(collector1);
            List<ContactInfo> favorites = map1.get(0);
            if (favorites != null && !favorites.isEmpty() && (members = map1.get(isAutorizedContacts ? 1 : 3)) != null && !members.isEmpty()) {
                favorites.forEach(contactInfo -> members.removeIf(contactInfo1 -> ClientSingleton.getInstance().getUserID((ContactInfo)contactInfo).equals(ClientSingleton.getInstance().getUserID((ContactInfo)contactInfo1))));
            }
            ArrayList<String> groupIds = new ArrayList<String>();
            ContactInfoHeader contactsHeader = null;
            for (ContactInfoHeader contactInfoHeader : headers) {
                List<ContactInfo> list = map1.get(contactInfoHeader.getType());
                if (contactInfoHeader.getType() == 5) {
                    if (list == null) {
                        groupIds.addAll(contactInfoHeader.getMemberLists().stream().map(contactInfo -> ClientSingleton.getInstance().getUserID((ContactInfo)contactInfo)).collect(Collectors.toList()));
                    } else {
                        groupIds.addAll(list.stream().map(contactInfo -> ClientSingleton.getInstance().getUserID((ContactInfo)contactInfo)).collect(Collectors.toList()));
                    }
                } else if (contactInfoHeader.getType() == 3) {
                    contactsHeader = contactInfoHeader;
                }
                items.add(contactInfoHeader);
                if (contactInfoHeader.getType() == 0 || contactInfoHeader.getType() == 6) {
                    if (list == null || list.isEmpty()) {
                        items.remove((Object)contactInfoHeader);
                    }
                } else if (contactInfoHeader.getType() == 4) {
                    List<ContactInfo> list2 = list = contactInfoHeader.getMemberLists().isEmpty() ? null : contactInfoHeader.getMemberLists();
                }
                if (list == null) continue;
                List<ContactInfo> membersList = new ArrayList<ContactInfo>(list).stream().filter(ClientSingleton.getInstance().distinctByKey(contactInfo -> ClientSingleton.getInstance().getUserID((ContactInfo)contactInfo))).sorted().collect(Collectors.toList());
                contactInfoHeader.setMemberLists(membersList);
                if (contactInfoHeader.isCollapse() && contactInfoHeader.getType() != 3) continue;
                items.addAll(membersList);
            }
            if (contactsHeader != null) {
                contactsHeader.removeMembers(groupIds);
                for (int i = items.size() - 1; i >= 0; --i) {
                    ContactInfo contactInfo2 = (ContactInfo)items.get(i);
                    if (!groupIds.contains(ClientSingleton.getInstance().getUserID(contactInfo2)) || isAutorizedContacts || contactInfo2.isFavorite()) continue;
                    items.remove(i);
                }
            }
        });
        return items;
    }

    public static List<SessionInfo> updateSessionsList(List<SessionInfoHeader> headers) {
        ArrayList<SessionInfo> items = new ArrayList<SessionInfo>();
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            Function<SessionInfo, Boolean> classifier = sessionInfo -> {
                if (ClientSingleton.getInstance().isPinnedChat((SessionInfo)sessionInfo)) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            };
            Collector<SessionInfo, ?, Map<Boolean, List<SessionInfo>>> collector = Collectors.groupingBy(classifier);
            Stream<SessionInfo> stream = ClientSingleton.getInstance().getSessionInfoStream();
            Map<Boolean, List<SessionInfo>> map = stream.filter(sessionInfo -> sessionInfo.getSessionId() != null && sessionInfo.getStatus() != 10 && sessionInfo.getStatus() != 5 && sessionInfo.getStatus() != 4 && !sessionInfo.isSlot()).filter(sessionInfo -> sessionInfo.getLastChatMessage() != null).collect(collector);
            boolean hasPinnedSessions = map.get(Boolean.TRUE) != null;
            for (SessionInfoHeader sessionInfoHeader : headers) {
                long st1 = System.currentTimeMillis();
                List<SessionInfo> list = map.get(sessionInfoHeader.getType() == 0);
                if (hasPinnedSessions) {
                    items.add(sessionInfoHeader);
                }
                if (list == null || list.isEmpty()) continue;
                List<SessionInfo> membersList = list.stream().filter(ClientSingleton.getInstance().distinctByKey(SessionInfo::getSessionId)).sorted((o1, o2) -> {
                    MessageInfo lMessageInfo = o1.getLastChatMessage();
                    MessageInfo rMessageInfo = o2.getLastChatMessage();
                    try {
                        if (rMessageInfo == null || lMessageInfo == null) {
                            return -1;
                        }
                        return lMessageInfo.getTime() < rMessageInfo.getTime() ? 1 : (lMessageInfo.getTime() == rMessageInfo.getTime() ? 0 : -1);
                    }
                    catch (Exception ex) {
                        ClientSingleton.toLog(TAG, "Error : sort rMessageInfo=" + rMessageInfo + " lMessageInfo=" + lMessageInfo);
                        return -1;
                    }
                }).collect(Collectors.toList());
                if (hasPinnedSessions) {
                    sessionInfoHeader.setMemberLists(membersList);
                    if (sessionInfoHeader.isCollapse()) continue;
                    items.addAll(membersList);
                    continue;
                }
                items.addAll(membersList);
            }
            stream = ClientSingleton.getInstance().getSessionInfoStream();
            List emptyGroup = stream.filter(sessionInfo -> sessionInfo.getSessionId() != null && sessionInfo.getStatus() != 10 && sessionInfo.getStatus() != 5 && sessionInfo.getStatus() != 4 && !sessionInfo.isSlot()).filter(sessionInfo -> sessionInfo.isGroup() && sessionInfo.getLastChatMessage() == null).sorted(Comparator.comparing(SessionInfo::toString)).collect(Collectors.toList());
            if (!emptyGroup.isEmpty()) {
                if (hasPinnedSessions) {
                    for (SessionInfoHeader sessionInfoHeader : headers) {
                        if (sessionInfoHeader.getType() != 1) continue;
                        List<SessionInfo> members = sessionInfoHeader.getMemberLists();
                        members.addAll(emptyGroup);
                        sessionInfoHeader.setMemberLists(members);
                        if (sessionInfoHeader.isCollapse()) continue;
                        items.addAll(emptyGroup);
                    }
                } else {
                    items.addAll(emptyGroup);
                }
            }
        });
        return items;
    }

    public static List<SessionInfo> updateCallsList(CallSessionHeader callSessionHeader) {
        List<SessionInfo> calls = ClientSingleton.getInstance().getCalls();
        return UpdateLists.updateCallsList(callSessionHeader, calls);
    }

    public static List<SessionInfo> updateCallsList(String prefix) {
        List<SessionInfo> calls = ClientSingleton.getInstance().getCalls(prefix);
        return UpdateLists.updateCallsList(null, calls);
    }

    private static List<SessionInfo> updateCallsList(CallSessionHeader callSessionHeader, List<SessionInfo> calls) {
        ArrayList<SessionInfo> sessionInfoList = new ArrayList<SessionInfo>();
        Function<SessionInfo, String> classifier = callsInfoCell -> ClientSingleton.getInstance().getDateWMonthString(UpdateLists.getLastCallTime(callsInfoCell));
        Supplier<TreeMap> mapFactory = () -> new TreeMap(Collections.reverseOrder());
        Collector downStream = Collectors.toList();
        Collector<SessionInfo, ?, TreeMap> collector = Collectors.groupingBy(classifier, mapFactory, downStream);
        TreeMap treeMap = callSessionHeader == null || !callSessionHeader.isCollapse() ? calls.stream().collect(collector) : calls.stream().filter(sessionInfo -> {
            MessageInfo messageInfo = sessionInfo.getLastCall();
            if (messageInfo == null || messageInfo.getStatus() != 5) {
                return false;
            }
            return messageInfo.getContent().contains("\"duration\":0");
        }).collect(collector);
        if (callSessionHeader != null) {
            sessionInfoList.add(callSessionHeader);
        }
        treeMap.forEach((key, value) -> {
            CallDateHandler date = new CallDateHandler((String)key);
            date.setCallsCount(value.size());
            sessionInfoList.add(date);
            List list = value.stream().filter(ClientSingleton.getInstance().distinctByKey(SessionInfo::getSessionId)).filter(sessionInfo -> !sessionInfo.isSlot()).map(sessionInfo -> new CallHandler((SessionInfo)sessionInfo, date.getSessionId())).sorted((sessionInfo1, sessionInfo2) -> (int)(sessionInfo2.getLastCall().getTime() - sessionInfo1.getLastCall().getTime())).collect(Collectors.toList());
            sessionInfoList.addAll(list);
            list.clear();
        });
        treeMap.clear();
        calls.clear();
        return sessionInfoList;
    }

    private static long getLastCallTime(SessionInfo sessionInfo) {
        if (sessionInfo.getLastMessage() != null) {
            return sessionInfo.getLastCall().getTime();
        }
        return 0L;
    }

    public static Predicate<? super ContactInfo> getAutorizedContacts() {
        return UpdateLists::isContactAutirized;
    }

    public static Predicate<? super ContactInfo> getNotAutorizedContacts() {
        return UpdateLists::isContactNotAutirized;
    }

    public static boolean isContactAutirized(ContactInfo contactInfo) {
        return !contactInfo.isFeature() && !contactInfo.isSlot() && contactInfo.getStatus() != 0 && (contactInfo.isUser() || contactInfo.isPhone()) && contactInfo.getName() != null && !contactInfo.getName().isEmpty() && contactInfo.toString() != null && !contactInfo.toString().isEmpty() && contactInfo.getStatus() != 3 && !"".equals(contactInfo.getName()) && contactInfo.getGlobalId() != null;
    }

    public static boolean isContactNotAutirized(ContactInfo contactInfo) {
        return contactInfo.getStatus() != 0 && !contactInfo.isFeature() && !contactInfo.isUser() && !contactInfo.isPhone() && contactInfo.getName() != null && !contactInfo.getName().isEmpty() && contactInfo.toString() != null && !contactInfo.toString().isEmpty() && contactInfo.getStatus() != 3 && !"".equals(contactInfo.getName());
    }
}

