/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.tabs.calls.flow;

import java.util.Objects;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.views.tabs.calls.flow.CallCellView;
import net.sipsnet.client.views.tabs.calls.flow.CallDateCellView;
import net.sipsnet.client.views.tabs.calls.flow.CallHeaderCellView;
import net.sipsnet.client.views.tabs.calls.flow.TabCallsController;
import net.sipsnet.client.views.tabs.calls.flow.utils.CallDateHandler;
import net.sipsnet.client.views.tabs.calls.flow.utils.CallHandler;
import net.sipsnet.client.views.tabs.calls.flow.utils.CallSessionHeader;
import net.sipsnet.client.views.tabs.utils.BaseCell;
import net.sipsnet.client.views.tabs.utils.ICallsTabActions;
import net.sipsnet.client.views.tabs.utils.INewMessagesNotification;
import org.fxmisc.flowless.Cell;
import smile.cti.client.SessionInfo;

public class CallCell
implements Cell<SessionInfo, Node> {
    private final INewMessagesNotification iNewMessagesNotification;
    private final ICallsTabActions iCallsTabActions;
    private Pane sessionCell;

    public CallCell(SessionInfo sessionInfo, ICallsTabActions iCallsTabActions, INewMessagesNotification iNewMessagesNotification) {
        this.iCallsTabActions = iCallsTabActions;
        this.iNewMessagesNotification = iNewMessagesNotification;
        this.initCell(sessionInfo);
    }

    private void initCell(SessionInfo sessionInfo) {
        try {
            if (sessionInfo instanceof CallSessionHeader || sessionInfo instanceof CallDateHandler) {
                this.dispose();
                if (sessionInfo instanceof CallSessionHeader) {
                    CallSessionHeader callSessionHeader = (CallSessionHeader)sessionInfo;
                    this.sessionCell = new CallHeaderCellView(this.iCallsTabActions, callSessionHeader);
                } else {
                    CallDateHandler dateHandler = (CallDateHandler)sessionInfo;
                    this.sessionCell = new CallDateCellView(this.iCallsTabActions, dateHandler);
                }
                ClientSingleton.getInstance().setFocusNotTraversable(this.sessionCell);
                this.sessionCell.prefWidthProperty().bind((ObservableValue)((TabCallsController)this.iCallsTabActions).widthProperty().subtract(10));
            } else {
                this.createCallCell((CallHandler)sessionInfo);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void createCallCell(CallHandler sessionInfo) {
        if (this.sessionCell instanceof CallCellView) {
            ((CallCellView)this.sessionCell).bindCallHandler(sessionInfo);
        } else {
            this.dispose();
            this.sessionCell = new CallCellView(BaseCell.ITEM_MODE.CALL_ITEM, this.iCallsTabActions, sessionInfo, this.iNewMessagesNotification);
            ClientSingleton.getInstance().setFocusNotTraversable(this.sessionCell);
            this.sessionCell.prefWidthProperty().bind((ObservableValue)((TabCallsController)this.iCallsTabActions).widthProperty().subtract(10));
        }
        if (this.iNewMessagesNotification != null) {
            this.iNewMessagesNotification.getSelectedItemId().ifPresent(sessionInfoId -> {
                CallCellView aCell = (CallCellView)this.sessionCell;
                try {
                    aCell.setSelectedCellStyle(Objects.equals(sessionInfoId, aCell.getSessionInfo().getSessionId()));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            });
        }
    }

    public Pane getNode() {
        return this.sessionCell;
    }

    public boolean isReusable() {
        return false;
    }

    public void updateItem(SessionInfo sessionInfo) {
        this.initCell(sessionInfo);
    }

    public void dispose() {
        if (this.sessionCell != null) {
            if (this.sessionCell instanceof CallCellView) {
                ((CallCellView)this.sessionCell).dispose();
            } else if (this.sessionCell instanceof CallDateCellView) {
                ((CallDateCellView)this.sessionCell).dispose();
            } else {
                ClientSingleton.getInstance().releaseViewResources(this.sessionCell);
            }
            this.sessionCell.prefWidthProperty().unbind();
            this.sessionCell = null;
        }
    }
}

