/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.tabs.calls.flow;

import java.util.Optional;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.util.Pair;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.utils.JsonMessageParser;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.MyAction;
import net.sipsnet.client.views.tabs.calls.flow.utils.CallHandler;
import net.sipsnet.client.views.tabs.utils.BaseCell;
import net.sipsnet.client.views.tabs.utils.INewMessagesNotification;
import net.sipsnet.client.views.tabs.utils.IRemovebleCellInterface;
import org.json.smile.JSONException;
import smile.cti.client.SessionInfo;

public class CallCellView
extends BaseCell {
    private final Label lastCallDuration = new Label();
    private final HBox fx_hbSessionName = new HBox();
    private CallHandler callHandler;
    private ImageView ivArrowImage;
    private Node fx_lbSessionName;
    private final Label fx_lbCallDateTime;
    private final IRemovebleCellInterface iCallCellInterface;
    private HBox secondLine;
    private final VBox vbItemContent = new VBox();
    private final ChangeListener<? super String> lastCallDurationTextListener = (observable, oldValue, newValue) -> this.setCallDateWidth(newValue != null && !newValue.isEmpty());

    public void bindCallHandler(CallHandler callHandler) {
        super.setInfoCell(callHandler.getSessionInfo());
        this.callHandler = callHandler;
        this.fx_lbCallDateTime.setText(this.getTimeString());
        this.setArrowImage();
        this.setName();
        this.addLastCallDuration();
        if (this.iCallCellInterface != null && this.iCallCellInterface.isMultiSelectionMode()) {
            this.addMyRadioButton(this.getMyRadioButtonAction(callHandler));
            this.setRadioButtonVisibility(true);
            this.setTitlesStyle(this.iCallCellInterface.isMultiSelectionMode() && this.iCallCellInterface.isSelectedForDelete(this.getCellObjectId()));
        } else {
            this.resetMultiSelectionMode();
            this.setRadioButtonVisibility(false);
        }
        this.layoutChildren();
    }

    public CallCellView(BaseCell.ITEM_MODE item_mode, IRemovebleCellInterface iCellSelection, CallHandler callHandler, INewMessagesNotification iNewMessagesNotification) {
        super(item_mode, iCellSelection, callHandler.getSessionInfo(), iNewMessagesNotification);
        this.iCallCellInterface = iCellSelection;
        this.callHandler = callHandler;
        super.setContainerPadding(new Insets(5.0, 5.0, 5.0, 0.0));
        this.vbItemContent.setPadding(new Insets(5.0, 0.0, 5.0, 10.0));
        HBox.setHgrow((Node)this.vbItemContent, (Priority)Priority.ALWAYS);
        this.fx_hbSessionName.setAlignment(Pos.CENTER_LEFT);
        HBox.setHgrow((Node)this.fx_hbSessionName, (Priority)Priority.ALWAYS);
        this.addToContainerView((Node)this.vbItemContent);
        this.vbItemContent.getChildren().add((Object)this.fx_hbSessionName);
        this.ivArrowImage = new ImageView();
        this.ivArrowImage.setFitWidth(13.0);
        this.ivArrowImage.setFitWidth(10.0);
        this.ivArrowImage.setPickOnBounds(true);
        this.ivArrowImage.setPreserveRatio(true);
        this.addSessionTextFlow();
        VBox vBox = new VBox();
        vBox.setAlignment(Pos.CENTER_RIGHT);
        HBox.setHgrow((Node)vBox, (Priority)Priority.ALWAYS);
        this.fx_lbCallDateTime = new Label();
        this.fx_lbCallDateTime.setStyle("-fx-font-size: 9pt;-fx-line-height: 1.19;-fx-text-fill: " + this.regularColor + ";-fx-font-family: \"Arial\";");
        vBox.setMinWidth(60.0);
        vBox.getChildren().add((Object)this.fx_lbCallDateTime);
        this.fx_hbSessionName.getChildren().add((Object)vBox);
        super.setOnMouseEnteredAction(() -> vBox.getChildren().remove((Object)this.fx_lbCallDateTime));
        super.setOnMouseExitedAction(() -> {
            if (!vBox.getChildren().contains((Object)this.fx_lbCallDateTime)) {
                vBox.getChildren().add((Object)this.fx_lbCallDateTime);
            }
        });
        this.setMinWidth(205.0);
        this.fx_lbCallDateTime.setText(this.getTimeString());
        this.setArrowImage();
        VBox.setMargin((Node)this, (Insets)new Insets(3.0, 0.0, 3.0, 0.0));
        this.setName();
        this.makeCallDetail();
        this.addLastCallDuration();
        if (this.iCallCellInterface != null && this.iCallCellInterface.isMultiSelectionMode()) {
            this.addMyRadioButton(this.getMyRadioButtonAction(callHandler));
            this.setRadioButtonVisibility(true);
            this.setTitlesStyle(this.iCallCellInterface.isMultiSelectionMode() && this.iCallCellInterface.isSelectedForDelete(this.getCellObjectId()));
        } else {
            this.resetMultiSelectionMode();
        }
    }

    private void resetMultiSelectionMode() {
        this.setTitlesStyle(false);
        if (this.iNewMessagesNotification.getInputTextFromSearch().isEmpty()) {
            this.setSessionNameLabelColor(Color.web((String)this.regularColor));
        }
    }

    private void setSessionNameLabelColor(Color color) {
        if (this.fx_lbSessionName instanceof TextFlow) {
            for (Node node : ((TextFlow)this.fx_lbSessionName).getChildren()) {
                ((Text)node).setFill((Paint)color);
            }
        } else {
            ((Label)this.fx_lbSessionName).setTextFill((Paint)color);
        }
    }

    private MyAction getMyRadioButtonAction(CallHandler callHandler) {
        return () -> {
            boolean isSelect = !this.getMyRadioButton().isSelected();
            this.iCallCellInterface.selectCallCell(isSelect, this.getCellId());
            if (!isSelect && this.iCallCellInterface.isSelectedDateForDelete(callHandler.getDateSessionId())) {
                this.iCallCellInterface.unselectDateCellTitle(callHandler.getDateSessionId());
            }
            this.setTitlesStyle(isSelect);
        };
    }

    public void setTitlesStyle(boolean mode) {
        Optional<String> optional = ClientSingleton.getInstance().getStyle(Constants.TAB_CELL_TEXT_FILL);
        String sc = mode ? "#c2c5d2" : optional.orElse("#646a7e");
        Color currentColor = Color.web((String)sc);
        this.fx_lbCallDateTime.setTextFill((Paint)currentColor);
        if (this.iNewMessagesNotification.getInputTextFromSearch().isEmpty() || this.isMultiSelectionMode()) {
            Node child;
            this.setSessionNameLabelColor(currentColor);
            if (this.secondLine != null && this.secondLine.getChildren().size() > 1 && (child = (Node)this.secondLine.getChildren().get(1)) instanceof TextFlow) {
                TextFlow textFlow = (TextFlow)child;
                for (Node node : textFlow.getChildren()) {
                    ((Text)node).setFill((Paint)currentColor);
                }
            }
        }
        if (this.lastCallDuration != null) {
            this.lastCallDuration.setTextFill((Paint)currentColor);
        }
        this.setRadioButtonBorder(sc, mode);
    }

    private void addLastCallDuration() {
        HBox.setMargin((Node)this.lastCallDuration, (Insets)new Insets(0.0, 0.0, 0.0, 5.0));
        this.lastCallDuration.prefHeightProperty().bind((ObservableValue)this.fx_hbSessionName.heightProperty());
        this.lastCallDuration.textProperty().addListener(this.lastCallDurationTextListener);
        this.lastCallDuration.setStyle("-fx-font-size: 9pt;-fx-line-height: 1.19;-fx-text-fill:" + Constants.colorForSmallFont + ";-fx-font-family: \"Arial\";");
        HBox hBox = new HBox();
        hBox.setAlignment(Pos.CENTER_RIGHT);
        HBox.setHgrow((Node)hBox, (Priority)Priority.ALWAYS);
        hBox.getChildren().add((Object)this.lastCallDuration);
        this.getSecondLine().getChildren().add((Object)hBox);
        if (this.callHandler.getLastCall() != null && this.callHandler.getLastCall().getStatus() != 12) {
            int duration = this.callHandler.getLastCall().getCallDuration();
            if (duration > 0) {
                this.lastCallDuration.setText("(" + ClientSingleton.getInstance().getTimeDuration((long)duration * 1000L) + ")");
            } else {
                this.lastCallDuration.setText("");
            }
        }
    }

    private void setCallDateWidth(boolean mode) {
        int width = mode ? 40 : 0;
        this.lastCallDuration.setMinWidth((double)width);
        this.lastCallDuration.setMaxWidth((double)width);
        this.lastCallDuration.setPrefWidth((double)width);
    }

    @Override
    public void setName() {
        if (this.fx_lbSessionName != null) {
            if (this.fx_lbSessionName instanceof TextFlow) {
                TextFlow textFlow = (TextFlow)this.fx_lbSessionName;
                if (textFlow.getChildren().size() == 1 && this.iNewMessagesNotification.getInputTextFromSearch().isEmpty()) {
                    ((Text)textFlow.getChildren().get(0)).setText(this.callHandler.toString());
                } else {
                    ClientSingleton.getInstance().releaseViewResources((Pane)textFlow);
                    this.addSessionTextFlow();
                }
            } else {
                ((Label)this.fx_lbSessionName).setText(this.callHandler.toString());
            }
        } else {
            this.addSessionTextFlow();
        }
    }

    private void addSessionTextFlow() {
        if (this.iNewMessagesNotification.getInputTextFromSearch().isEmpty()) {
            this.fx_lbSessionName = new Label(this.callHandler.toString());
            this.setCellTextStyle((Label)this.fx_lbSessionName, false);
            ((Label)this.fx_lbSessionName).setPadding(new Insets(0.0, 0.0, 0.0, 5.0));
        } else {
            this.removeFromContainerView(this.fx_lbSessionName);
            this.fx_lbSessionName = ClientSingleton.getInstance().addStyledTextArea(this.callHandler.toString(), this.iNewMessagesNotification.getInputTextFromSearch(), this.regularColor, 11);
            ((TextFlow)this.fx_lbSessionName).setPadding(new Insets(0.0, 0.0, 0.0, 5.0));
        }
        this.fx_hbSessionName.getChildren().add(0, (Object)this.fx_lbSessionName);
    }

    private void setArrowImage() {
        if (this.ivArrowImage != null) {
            ClientSingleton.getInstance().setArrowPngName(this.ivArrowImage, this.callHandler.getLastCall());
        }
    }

    private String getTimeString() {
        try {
            return ClientSingleton.getInstance().getTimeLabel(this.callHandler.getLastCall().getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getDateSessionId() {
        return this.callHandler.getDateSessionId();
    }

    @Override
    public void updateNewMessages() {
        this.bind(this.callHandler);
        if (this.iCallCellInterface.isMultiSelectionMode()) {
            this.addMyRadioButton(this.getMyRadioButtonAction(this.callHandler));
        }
        this.setRadioButtonVisibility(this.iCallCellInterface.isMultiSelectionMode());
        if (!this.iCallCellInterface.isMultiSelectionMode()) {
            this.resetMultiSelectionMode();
        }
    }

    @Override
    public SessionInfo getSessionInfo() {
        return this.callHandler.getSessionInfo();
    }

    @Override
    public String getCellObjectId() {
        return this.callHandler.getSessionInfo().getSessionId();
    }

    public void setSelectCallCell() {
        this.setTitlesStyle(this.iCallCellInterface.isMultiSelectionMode() && this.iCallCellInterface.isSelectedForDelete(this.getCellObjectId()));
    }

    public void bind(CallHandler callHandler) {
        this.callHandler = callHandler;
        if (callHandler.getLastCall() != null && callHandler.getLastCall().getStatus() != 12) {
            try {
                Pair<String, Integer> pair = JsonMessageParser.getMessageString(callHandler.getLastCall().getContent(), callHandler.getLastCall().getStatus(), false);
                int duration = (Integer)pair.getValue();
                if (duration > 0) {
                    this.lastCallDuration.setText("(" + ClientSingleton.getInstance().getTimeDuration((long)duration * 1000L) + ")");
                } else {
                    this.lastCallDuration.setText("");
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        this.setArrowImage();
        this.fx_lbCallDateTime.setText(this.getTimeString());
        this.setName();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.ivArrowImage != null) {
            this.ivArrowImage.setImage(null);
            this.ivArrowImage = null;
        }
        if (this.lastCallDuration != null) {
            this.lastCallDuration.prefHeightProperty().unbind();
            this.lastCallDuration.textProperty().removeListener(this.lastCallDurationTextListener);
        }
        if (this.secondLine != null) {
            this.secondLine.prefWidthProperty().unbind();
        }
    }

    private void makeCallDetail() {
        String inputText = this.iNewMessagesNotification.getInputTextFromSearch();
        this.removeIconContainer();
        if (!inputText.isEmpty()) {
            TextFlow textFlow = ClientSingleton.getInstance().addStyledTextArea(this.getCallTitle(), inputText, Constants.colorForSmallFont, 10);
            textFlow.setPadding(new Insets(5.0, 0.0, 0.0, 0.0));
            HBox.setMargin((Node)textFlow, (Insets)new Insets(0.0, 0.0, 0.0, 5.0));
            this.getSecondLine().getChildren().addAll((Object[])new Node[]{this.ivArrowImage, textFlow});
        } else {
            this.fx_hbSessionName.getChildren().add(0, (Object)this.ivArrowImage);
            Label label = new Label(this.getCallTitle());
            String style = "-fx-text-fill:" + Constants.colorForSmallFont + ";-fx-font-family: \"Arial\";-fx-font-size: 10pt;";
            label.setStyle(style);
            this.getSecondLine().getChildren().add(0, (Object)label);
        }
    }

    private HBox getSecondLine() {
        if (this.secondLine == null) {
            this.secondLine = new HBox();
            this.secondLine.prefWidthProperty().bind((ObservableValue)this.prefWidthProperty());
            this.secondLine.setAlignment(Pos.CENTER_LEFT);
            this.vbItemContent.getChildren().add((Object)this.secondLine);
        }
        return this.secondLine;
    }

    private String getCallTitle() {
        return ClientSingleton.getInstance().getCallTitle(this.callHandler.getSessionInfo().toString(), this.callHandler.getLastCall());
    }
}

