/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.tabs.calls.flow;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.views.tabs.TabBaseView;
import net.sipsnet.client.views.tabs.UpdateLists;
import net.sipsnet.client.views.tabs.calls.flow.CallCell;
import net.sipsnet.client.views.tabs.calls.flow.utils.CallSessionHeader;
import net.sipsnet.client.views.tabs.utils.BaseCell;
import net.sipsnet.client.views.tabs.utils.ICallsTabActions;
import net.sipsnet.client.views.tabs.utils.INewMessagesNotification;
import net.sipsnet.client.views.tabs.utils.IRemovebleCellInterface;
import net.sipsnet.client.views.tabs.utils.TabBaseViewWithRemoveCells;
import smile.cti.client.ClientConnector;
import smile.cti.client.SessionInfo;

public class TabCallsController
extends TabBaseViewWithRemoveCells<SessionInfo>
implements ICallsTabActions,
IRemovebleCellInterface {
    private CallSessionHeader callSessionHeader;
    private AnchorPane anchorScrollPane;

    public TabCallsController(INewMessagesNotification iNewMessagesNotification) {
        super(4, iNewMessagesNotification);
        AnchorPane.setTopAnchor((Node)this.fx_bvMainBox, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)this.fx_bvMainBox, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)this.fx_bvMainBox, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.fx_bvMainBox, (Double)0.0);
        this.getChildren().add((Object)this.fx_bvMainBox);
        Theme.getInstance().applyTo(Constants.TABS_VIRTUALIZED_SCROLL, (Pane)this);
        this.setCellFactory(sessionInfo -> new CallCell((SessionInfo)sessionInfo, this, iNewMessagesNotification), integer -> {
            if (integer == CLEAR_CALLS) {
                ClientSingleton.getInstance().getClientConnector().ifPresent(ClientConnector::clearMissedCallsIndication);
            }
            iNewMessagesNotification.invalidateCallsNewMessages();
            if (iNewMessagesNotification.getInputTextFromSearch().isEmpty()) {
                return UpdateLists.updateCallsList(this.callSessionHeader);
            }
            return UpdateLists.updateCallsList(iNewMessagesNotification.getInputTextFromSearch());
        });
        this.addScrollPane();
    }

    @Override
    public void addScrollPane() {
        this.releaseScrollPane();
        this.anchorScrollPane = new AnchorPane();
        super.addScrollPane((Pane)this.anchorScrollPane);
        this.anchorScrollPane.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        VBox.setVgrow((Node)this.anchorScrollPane, (Priority)Priority.ALWAYS);
        this.fx_bvMainBox.getChildren().add((Object)this.anchorScrollPane);
    }

    private void releaseScrollPane() {
        if (!this.fx_bvMainBox.getChildren().isEmpty()) {
            this.fx_bvMainBox.getChildren().remove((Object)this.anchorScrollPane);
            if (this.anchorScrollPane != null) {
                this.anchorScrollPane.prefWidthProperty().unbind();
            }
        }
    }

    @Override
    public void updateList(int mode) {
        if (this.isDeletingSessions) {
            return;
        }
        Optional<ClientConnector> optionalClientConnector = ClientSingleton.getInstance().getClientConnector();
        if (!optionalClientConnector.isPresent()) {
            return;
        }
        if (this.callSessionHeader == null) {
            this.callSessionHeader = new CallSessionHeader();
        }
        super.updateListItems(mode);
    }

    @Override
    public List<SessionInfo> getListOnSearch(String prefix) {
        Optional<ClientConnector> optionalClientConnector = ClientSingleton.getInstance().getClientConnector();
        if (optionalClientConnector.isEmpty()) {
            return new ArrayList<SessionInfo>();
        }
        if (this.callSessionHeader == null) {
            this.callSessionHeader = new CallSessionHeader();
        }
        return UpdateLists.updateCallsList(prefix);
    }

    public void updateHandler(SessionInfo sessionInfo) {
        BaseCell callCell = this.getItemCell(sessionInfo.getSessionId());
        if (callCell != null) {
            callCell.updateNewMessages();
        }
    }

    @Override
    public void refreshCallList() {
        this.updateList(TabBaseView.SCROLL_TO_TOP);
    }

    @Override
    public void updateList() {
        this.updateList(SCROLL_TO_TOP);
    }

    public void switchToCallsTab() {
        this.updateList(CLEAR_CALLS);
    }
}

