/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.tabs.calls.flow.utils;

import java.util.List;
import net.sipsnet.client.connector.ClientSingleton;
import smile.cti.client.ContactInfo;
import smile.cti.client.MessageInfo;
import smile.cti.client.SessionInfo;

public class CallHandler
extends SessionInfo {
    private final SessionInfo sessionInfo;
    private final String dateSessionId;

    public CallHandler(SessionInfo sessionInfo) {
        this.sessionInfo = sessionInfo;
        this.dateSessionId = ClientSingleton.getInstance().getDateWMonthString(this.getLastCallTime(sessionInfo));
    }

    public CallHandler(SessionInfo sessionInfo, String dateSessionId) {
        this.sessionInfo = sessionInfo;
        this.dateSessionId = dateSessionId;
    }

    public List<ContactInfo> getParties() {
        return this.sessionInfo.getParties();
    }

    public String toString() {
        return this.sessionInfo.toString();
    }

    public SessionInfo getSessionInfo() {
        return this.sessionInfo;
    }

    public String getDateSessionId() {
        return this.dateSessionId;
    }

    public MessageInfo getLastCall() {
        return this.sessionInfo.getLastCall();
    }

    public int getMissedCallsCount() {
        return (int)ClientSingleton.getInstance().getMissedCallsCount(this.sessionInfo);
    }

    public String getSessionId() {
        return this.sessionInfo.getSessionId();
    }

    private long getLastCallTime(SessionInfo sessionInfo) {
        if (sessionInfo.getLastCall() != null) {
            return sessionInfo.getLastCall().getTime();
        }
        return 0L;
    }
}

