/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.tabs.contacts.flow;

import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.MyAction;
import net.sipsnet.client.utils.viewers.statespane.StatesPane;
import net.sipsnet.client.views.profiles.utils.DetailValue;
import net.sipsnet.client.views.profiles.utils.TypeConstantsRT;
import net.sipsnet.client.views.tabs.utils.BaseCell;
import net.sipsnet.client.views.tabs.utils.IContactsTabActions;
import net.sipsnet.client.views.tabs.utils.INewMessagesNotification;
import smile.cti.client.ContactInfo;

public class ContactCellView
extends BaseCell
implements Comparable<ContactInfo> {
    private StatesPane statesPane;
    private ContactInfo contactInfo;
    private TextFlow fx_lbContactName;
    private final VBox vbItemContent = new VBox();
    private final HBox hbItemTitlePane = new HBox();
    private final HBox hbState = new HBox();
    private Label fx_lbDndTitle;
    private final boolean isTitle2Style = false;
    private final IContactsTabActions iContactsTabActions;
    private VBox secondLine;
    private TextFlow extentionTextArea;
    private TextFlow phoneTextArea;
    private final List<TextFlow> dataListTextArea = new ArrayList<TextFlow>();
    private final BaseCell.ITEM_MODE item_mode;
    private final Collator usCollator = Collator.getInstance();

    public ContactCellView(BaseCell.ITEM_MODE item_mode, IContactsTabActions iContactsTabActions, ContactInfo contactInfo, INewMessagesNotification iNewMessagesNotification) {
        super(item_mode, iContactsTabActions, contactInfo, iNewMessagesNotification);
        this.item_mode = item_mode;
        this.contactInfo = contactInfo;
        this.iContactsTabActions = iContactsTabActions;
        this.removeIconContainer();
        HBox.setHgrow((Node)this.vbItemContent, (Priority)Priority.ALWAYS);
        this.vbItemContent.getChildren().add((Object)this.hbItemTitlePane);
        this.vbItemContent.setPadding(new Insets(5.0, 0.0, 5.0, item_mode == BaseCell.ITEM_MODE.AUTORIZED_CONTACT_ITEM ? 0.0 : 10.0));
        this.hbItemTitlePane.setAlignment(Pos.CENTER_LEFT);
        this.hbItemTitlePane.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        this.hbState.prefHeightProperty().bind((ObservableValue)this.hbItemTitlePane.heightProperty());
        this.hbState.setAlignment(Pos.CENTER);
        this.hbState.setMaxWidth(20.0);
        this.hbState.setMinWidth(20.0);
        this.initContent();
        this.addToContainerView((Node)this.vbItemContent);
        if (item_mode == BaseCell.ITEM_MODE.NOT_AUTORIZED_CONTACT_ITEM) {
            this.addDetails(contactInfo, iNewMessagesNotification);
        }
    }

    private void addDetails(ContactInfo contactInfo, INewMessagesNotification iNewMessagesNotification) {
        String inputText = iNewMessagesNotification.getInputTextFromSearch().toLowerCase();
        if (!inputText.isEmpty()) {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "addDetails contactInfo = " + contactInfo);
            this.checkDetails();
        } else {
            this.vbItemContent.setVisible(false);
            if (this.extentionTextArea != null && !this.extentionTextArea.getChildren().isEmpty()) {
                this.secondLine.getChildren().remove((Object)this.extentionTextArea);
                ClientSingleton.getInstance().releaseViewResources((Pane)this.extentionTextArea);
            }
            if (this.phoneTextArea != null && !this.phoneTextArea.getChildren().isEmpty()) {
                this.secondLine.getChildren().remove((Object)this.phoneTextArea);
                ClientSingleton.getInstance().releaseViewResources((Pane)this.phoneTextArea);
            }
            if (!this.dataListTextArea.isEmpty()) {
                for (TextFlow Label2 : this.dataListTextArea) {
                    this.secondLine.getChildren().remove((Object)Label2);
                }
                this.dataListTextArea.clear();
            }
            if (this.secondLine != null) {
                this.secondLine.prefWidthProperty().unbind();
                ClientSingleton.getInstance().releaseViewResources((Pane)this.secondLine);
                this.vbItemContent.getChildren().remove((Object)this.secondLine);
            }
            this.vbItemContent.setVisible(true);
        }
        this.setManaged(false);
        this.requestLayout();
    }

    public void bind(ContactInfo contactInfo) {
        super.setInfoCell(contactInfo);
        this.contactInfo = contactInfo;
        this.setState();
        this.setTitle();
        if (this.iContactsTabActions != null && this.iContactsTabActions.isMultiSelectionMode()) {
            this.addMyRadioButton(this.getMyRadioButtonAction());
            this.setRadioButtonVisibility(true);
            this.setTitlesStyle(this.iContactsTabActions.isMultiSelectionMode() && this.iContactsTabActions.isSelectedForDelete(this.getCellObjectId()));
        } else {
            this.setRadioButtonVisibility(false);
        }
        this.addDetails(contactInfo, this.iNewMessagesNotification);
    }

    private void setTitle() {
        if (this.iNewMessagesNotification.getInputTextFromSearch().isEmpty() && this.fx_lbContactName.getChildren().size() == 1) {
            Text text = (Text)this.fx_lbContactName.getChildren().get(0);
            text.setText(this.contactInfo.toString());
            this.setTitlesStyle(false);
        } else {
            this.hbItemTitlePane.getChildren().remove((Object)this.fx_lbContactName);
            this.addContactNameTextFlow();
        }
    }

    @Override
    public ContactInfo getContactInfo() {
        return this.contactInfo;
    }

    public void setDnDState(boolean visible) {
        if (this.fx_lbDndTitle == null) {
            return;
        }
        if (!visible) {
            this.fx_lbDndTitle.setText("");
            this.fx_lbDndTitle.setMaxWidth(0.0);
            this.fx_lbDndTitle.setPrefWidth(0.0);
        } else {
            double width = new Text("DnD").getLayoutBounds().getWidth() + 8.0;
            this.fx_lbDndTitle.setText("DnD");
            this.fx_lbDndTitle.setMaxWidth(width);
            this.fx_lbDndTitle.setPrefWidth(width);
        }
    }

    private void setState() {
        if (!ClientSingleton.getInstance().isContactInfoApproved(this.contactInfo)) {
            this.setIvStateInvisible();
            this.setIconViewContainerVisible(false);
        } else {
            this.setIconViewContainerVisible(true);
            this.setDnDState(this.contactInfo.getState() == 3);
            this.addStateView();
            this.statesPane.setState(this.contactInfo.getState());
        }
    }

    private void setIvStateInvisible() {
        if (this.statesPane != null) {
            this.statesPane.setPaneVisibility(false);
        }
        if (this.fx_lbDndTitle != null) {
            this.fx_lbDndTitle.setVisible(false);
        }
    }

    private void addStateView() {
        if (this.statesPane == null) {
            this.statesPane = StatesPane.getInstance(StatesPane.VIEW_MODE.HANDLER_MODE);
            this.hbState.getChildren().add((Object)this.statesPane);
            this.setIconViewContainerVisible(false);
            this.hbItemTitlePane.getChildren().add(0, (Object)this.hbState);
        }
    }

    private void initContent() {
        this.setState();
        this.addContactNameTextFlow();
        if (this.contactInfo != null && this.iContactsTabActions != null && this.iContactsTabActions.isMultiSelectionMode()) {
            this.addMyRadioButton(this.getMyRadioButtonAction());
            this.setRadioButtonVisibility(true);
            this.setTitlesStyle(this.iContactsTabActions.isMultiSelectionMode() && this.iContactsTabActions.isSelectedForDelete(this.getCellObjectId()));
        }
        this.addDND();
        VBox.setMargin((Node)this, (Insets)new Insets(3.0, 0.0, 3.0, 0.0));
    }

    private void addContactNameTextFlow() {
        this.fx_lbContactName = ClientSingleton.getInstance().addStyledTextArea(this.contactInfo.toString(), this.iNewMessagesNotification.getInputTextFromSearch(), this.regularColor, 11);
        this.fx_lbContactName.setPadding(new Insets(3.0, 0.0, 0.0, 0.0));
        this.fx_lbContactName.setPrefHeight(25.0);
        this.hbItemTitlePane.getChildren().add(this.hbItemTitlePane.getChildren().isEmpty() ? 0 : 1, (Object)this.fx_lbContactName);
    }

    private void addDND() {
        this.fx_lbDndTitle = new Label();
        this.fx_lbDndTitle.setAlignment(Pos.CENTER);
        this.fx_lbDndTitle.setMinHeight(14.0);
        this.fx_lbDndTitle.setMaxHeight(14.0);
        this.fx_lbDndTitle.setFont(Font.font((String)"Roboto", (FontWeight)FontWeight.BOLD, (double)10.0));
        this.fx_lbDndTitle.setAlignment(Pos.CENTER);
        HBox.setMargin((Node)this.fx_lbDndTitle, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
        int radius = 7;
        this.fx_lbDndTitle.setTextFill((Paint)Color.WHITE);
        this.fx_lbDndTitle.setStyle("-fx-background-color: #e65d5d;-fx-border-radius: " + radius + " " + radius + " " + radius + " " + radius + "; -fx-background-radius: " + radius + " " + radius + " " + radius + " " + radius + "; ");
        this.hbItemTitlePane.getChildren().add((Object)this.fx_lbDndTitle);
    }

    private MyAction getMyRadioButtonAction() {
        return () -> {
            boolean isSelect = !this.getMyRadioButton().isSelected();
            this.iContactsTabActions.selectCallCell(isSelect, this.getCellId());
            this.setTitlesStyle(isSelect);
        };
    }

    private void setTitlesStyle(boolean mode) {
        String sc = mode ? "#c2c5d2" : this.regularColor;
        Color color = Color.web((String)sc);
        for (Node node : this.fx_lbContactName.getChildren()) {
            ((Text)node).setFill((Paint)color);
        }
        this.setRadioButtonBorder(sc, mode);
    }

    public void setSelectContactCell() {
        this.setTitlesStyle(this.iContactsTabActions.isMultiSelectionMode() && this.iContactsTabActions.isSelectedForDelete(this.getCellObjectId()));
    }

    @Override
    public String getCellObjectId() {
        return ClientSingleton.getInstance().getUserID(this.contactInfo);
    }

    @Override
    public void update() {
        this.setState();
        this.setTitle();
        this.addDetails(this.contactInfo, this.iNewMessagesNotification);
        super.update();
    }

    private boolean isMember() {
        return this.contactInfo.getState() != -1 && this.contactInfo.getStatus() != 3 && this.contactInfo.getStatus() >= 1 && this.contactInfo.getStatus() <= 5 || this.contactInfo.isAdmin();
    }

    private boolean isLatin(String str) {
        char c = str.charAt(0);
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '!' && c <= '9';
    }

    @Override
    public int compareTo(ContactInfo contactInfo2) {
        this.usCollator.setStrength(0);
        if (this.isLatin(this.contactInfo.toString()) && !this.isLatin(contactInfo2.toString())) {
            return 1;
        }
        if (!this.isLatin(this.contactInfo.toString()) && this.isLatin(contactInfo2.toString())) {
            return -1;
        }
        return this.usCollator.compare(this.contactInfo.toString(), contactInfo2.toString());
    }

    @Override
    public String toString() {
        return this.contactInfo.toString();
    }

    @Override
    public void updateNewMessages() {
        this.setState();
        this.addMyRadioButton(this.getMyRadioButtonAction());
        this.setRadioButtonVisibility(this.iContactsTabActions.isMultiSelectionMode());
        if (!this.iContactsTabActions.isMultiSelectionMode()) {
            this.setTitlesStyle(false);
        }
    }

    @Override
    public void dispose() {
        this.hbItemTitlePane.prefWidthProperty().unbind();
        this.hbState.prefHeightProperty().unbind();
        this.dataListTextArea.clear();
        if (this.secondLine != null) {
            this.secondLine.prefWidthProperty().unbind();
        }
        super.dispose();
    }

    private void checkDetails() {
        String inputText = this.iNewMessagesNotification.getInputTextFromSearch();
        this.addDetailPane(inputText);
        if (this.secondLine != null && !this.secondLine.getChildren().isEmpty()) {
            super.setContainerPadding(new Insets(5.0, 0.0, 5.0, 0.0));
        }
    }

    private void addDetailPane(String inputText) {
        ArrayList<ContactInfo.Detail> details = new ArrayList<ContactInfo.Detail>(this.contactInfo.getUserDetails());
        details.addAll(this.contactInfo.getCustomDetails());
        for (TextFlow Label2 : this.dataListTextArea) {
            this.secondLine.getChildren().remove((Object)Label2);
        }
        this.dataListTextArea.clear();
        List<DetailValue> userDetails = TypeConstantsRT.getDetails(details, this.contactInfo);
        userDetails.forEach(detailValue -> {
            String value = detailValue.getValue();
            if (value != null && !value.isEmpty()) {
                String val = value.toLowerCase();
                String label = detailValue.getLabel();
                ClientSingleton.toLog(this.getClass().getSimpleName(), "addDetailPane contactInfo = " + this.contactInfo + " label = " + label + " contains = " + TypeConstantsRT.tagsOfPhones.contains(label));
                if (TypeConstantsRT.tagsOfPhones.contains(label) || label.equals("Organization")) {
                    TextFlow detailTextFlow = ClientSingleton.getInstance().addStyledTextArea(detailValue.getLabel() + " : " + val, inputText, Constants.colorForSmallFont, 10);
                    this.getSecondLine().getChildren().add((Object)detailTextFlow);
                    this.dataListTextArea.add(detailTextFlow);
                }
            }
        });
        ClientSingleton.toLog(this.getClass().getSimpleName(), "addDetailPane dataListTextArea.isEmpty = " + this.dataListTextArea.isEmpty());
        if (this.dataListTextArea.isEmpty()) {
            String number = ClientSingleton.getInstance().getNumberByPrefix(this.contactInfo, inputText);
            ClientSingleton.toLog(this.getClass().getSimpleName(), "addDetailPane contactInfo = " + this.contactInfo + " number = " + number);
            if (!number.isEmpty()) {
                TextFlow detailTextFlow = ClientSingleton.getInstance().addStyledTextArea(number, inputText, Constants.colorForSmallFont, 10);
                this.getSecondLine().getChildren().add((Object)detailTextFlow);
                this.dataListTextArea.add(detailTextFlow);
            }
        }
    }

    private VBox getSecondLine() {
        if (this.secondLine == null) {
            this.secondLine = new VBox();
            this.secondLine.prefWidthProperty().bind((ObservableValue)this.vbItemContent.prefWidthProperty());
            this.vbItemContent.getChildren().add((Object)this.secondLine);
        }
        return this.secondLine;
    }
}

