/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.tabs.contacts.flow.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.utils.MyPair;
import smile.cti.client.ContactInfo;

public class ContactInfoHeader
extends ContactInfo {
    public static final int FAVORITES = 0;
    public static final int FAVORITES_EXT = 6;
    public static final int MEMBERS = 1;
    public static final int EXTERNALS = 2;
    public static final int CONTACTS = 3;
    public static final int SERVICES = 4;
    public static final int GROUP = 5;
    private static final String FAVORITES_COLLAPSED_TAG = "favorites_collapsed";
    private static final String EX_FAVORITES_COLLAPSED_TAG = "ex_favorites_collapsed";
    private static final String MEMBERS_COLLAPSED_TAG = "members_collapsed";
    private static final String EX_MEMBERS_COLLAPSED_TAG = "ex_members_collapsed";
    private static final String EXTERNALS_COLLAPSED_TAG = "externals_collapsed";
    private static final String EX_EXTERNALS_COLLAPSED_TAG = "ex_externals_collapsed";
    private final List<ContactInfo> memberLists = new ArrayList<ContactInfo>();
    private boolean isCollapse = false;
    private String title;
    private final int type;
    private final boolean isAuthorized;
    private String serviceId;
    public static final int LIMIT_ITEMS_FOR_VIEW = 1000;

    public boolean isCollapse() {
        return this.isCollapse;
    }

    public void setCollapse(boolean collapse) {
        this.isCollapse = collapse;
    }

    public void setCollapse() {
        boolean bl = this.isCollapse = !this.isCollapse;
        if (this.isAuthorized) {
            ClientSingleton.getInstance().setProperty(this.getType() == 0 ? FAVORITES_COLLAPSED_TAG : (this.getType() == 1 ? MEMBERS_COLLAPSED_TAG : EXTERNALS_COLLAPSED_TAG), this.isCollapse);
        } else if (this.getType() == 1) {
            ClientSingleton.getInstance().setProperty(EX_MEMBERS_COLLAPSED_TAG, this.isCollapse);
        } else if (this.getType() == 0) {
            ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "setCollapse EX_EXTERNALS_COLLAPSED_TAG=ex_externals_collapsed isCollapse=" + this.isCollapse);
            ClientSingleton.getInstance().setProperty(EX_EXTERNALS_COLLAPSED_TAG, this.isCollapse);
        } else {
            ClientSingleton.getInstance().setProperty(this.toString(), this.isCollapse);
        }
    }

    private void getCollapseParameter() {
        if (this.getType() == 0) {
            if (this.isAuthorized) {
                Optional<Boolean> ic = ClientSingleton.getInstance().getBooleanProperty(FAVORITES_COLLAPSED_TAG);
                ic.ifPresent(aBoolean -> {
                    this.isCollapse = aBoolean;
                });
            } else {
                Optional<Boolean> ic = ClientSingleton.getInstance().getBooleanProperty(EX_EXTERNALS_COLLAPSED_TAG);
                ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "getCollapseParameter EX_EXTERNALS_COLLAPSED_TAG=ex_externals_collapsed isCollapse=" + ic);
                ic.ifPresent(aBoolean -> {
                    this.isCollapse = aBoolean;
                });
            }
        } else if (this.getType() == 1 || this.getType() == 2) {
            if (this.isAuthorized) {
                Optional<Boolean> ic = ClientSingleton.getInstance().getBooleanProperty(this.getType() == 0 ? FAVORITES_COLLAPSED_TAG : (this.getType() == 1 ? MEMBERS_COLLAPSED_TAG : EXTERNALS_COLLAPSED_TAG));
                ic.ifPresent(aBoolean -> {
                    this.isCollapse = aBoolean;
                });
            } else {
                Optional<Boolean> ic = this.getType() == 1 ? ClientSingleton.getInstance().getBooleanProperty(EX_MEMBERS_COLLAPSED_TAG) : ClientSingleton.getInstance().getBooleanProperty(this.title);
                ic.ifPresent(aBoolean -> {
                    this.isCollapse = aBoolean;
                });
            }
            ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "contactInfoHeader title " + this.title + " isCollapse=" + this.isCollapse);
        } else {
            this.isCollapse = true;
        }
    }

    public ContactInfoHeader(boolean isAuthorized, int type, String title) {
        super(title);
        this.title = title;
        this.type = type;
        this.isAuthorized = isAuthorized;
        this.getCollapseParameter();
    }

    public int getType() {
        return this.type;
    }

    public void setMemberLists(List<ContactInfo> membersList) {
        this.memberLists.clear();
        if (!membersList.isEmpty()) {
            for (int i = 0; i < membersList.size(); ++i) {
                if (membersList.get(i) != null) continue;
                try {
                    throw new Exception("setMemberLists");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        this.memberLists.addAll(membersList);
        if (this.memberLists.size() > 1000 && !this.title.contains("+)")) {
            this.title = this.title + " (1000+)";
        }
    }

    public List<ContactInfo> getMemberLists() {
        if (this.memberLists.size() > 1000) {
            return new ArrayList<ContactInfo>(this.memberLists.subList(0, 1000));
        }
        return this.memberLists;
    }

    public List<ContactInfo> getMemberAllItems() {
        return this.memberLists;
    }

    public boolean isLargeMemberList() {
        return this.memberLists.size() > 1000;
    }

    public void clearMembers() {
        this.memberLists.clear();
    }

    public List<ContactInfo> getMemberViewers(String prefix) {
        return this.memberLists.stream().filter(pane -> pane.toString().toLowerCase().contains(prefix.toLowerCase())).collect(Collectors.toList());
    }

    public List<ContactInfo> findMemberViewers(String prefix) {
        Predicate<ContactInfo> find = contactInfo -> {
            AtomicBoolean isFind = new AtomicBoolean(contactInfo.toString().toLowerCase().contains(prefix.toLowerCase()));
            if (!isFind.get()) {
                Optional<Object> prop = Optional.ofNullable(contactInfo.getProperty("extension"));
                if (prop.isPresent()) {
                    prop.ifPresent(o -> isFind.set(o.toString().toLowerCase().contains(prefix.toLowerCase())));
                }
                if (!isFind.get()) {
                    prop = Optional.ofNullable(contactInfo.getProperty("ext"));
                    prop.ifPresent(o -> isFind.set(o.toString().toLowerCase().contains(prefix.toLowerCase())));
                }
                if (!isFind.get()) {
                    prop = Optional.ofNullable(contactInfo.getNumber());
                    prop.ifPresent(o -> isFind.set(o.toString().toLowerCase().contains(prefix.toLowerCase())));
                }
            }
            return isFind.get();
        };
        return this.memberLists.stream().filter(find).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMembers(List<String> list) {
        List<ContactInfo> list2 = this.memberLists;
        synchronized (list2) {
            for (int i = this.memberLists.size() - 1; i >= 0; --i) {
                ContactInfo contactInfo = this.memberLists.get(i);
                if (!list.contains(ClientSingleton.getInstance().getUserID(contactInfo))) continue;
                this.memberLists.remove(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMember(ContactInfo contactInfo) {
        if (contactInfo == null) {
            return;
        }
        List<ContactInfo> list = this.memberLists;
        synchronized (list) {
            for (int i = this.memberLists.size() - 1; i >= 0; --i) {
                ContactInfo contactInfo1 = this.memberLists.get(i);
                if (!ClientSingleton.getInstance().getUserID(contactInfo).equals(ClientSingleton.getInstance().getUserID(contactInfo1))) continue;
                this.memberLists.remove(i);
            }
        }
    }

    public ContactInfo getMemberById(String id) {
        List list = this.memberLists.stream().filter(contactInfo -> id.equals(ClientSingleton.getInstance().getUserID((ContactInfo)contactInfo))).collect(Collectors.toList());
        if (list.isEmpty()) {
            return null;
        }
        return (ContactInfo)list.get(0);
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        MyPair<Long, List<ContactInfo>> myPair;
        this.serviceId = serviceId;
        Optional<Boolean> ic = ClientSingleton.getInstance().getBooleanProperty(this.toString());
        if (ic.isPresent() && Boolean.FALSE.equals(ic.get()) && !(myPair = ClientSingleton.getInstance().getServiceContacts(serviceId, "")).hasLastException() && myPair.getSecond() != null) {
            this.setMemberLists(myPair.getSecond());
            this.isCollapse = false;
        }
    }

    public boolean equalsHeader(Object o) {
        ContactInfoHeader contactInfoHeader = (ContactInfoHeader)((Object)o);
        return contactInfoHeader.toString().equals(this.title) && contactInfoHeader.getServiceId().equals(this.serviceId);
    }

    public String toString() {
        return this.title;
    }

    public void setServiceCollapsedParameter(boolean mode) {
        if (mode) {
            Optional<Boolean> optional = ClientSingleton.getInstance().getBooleanProperty(this.toString());
            optional.ifPresent(aBoolean -> {
                this.isCollapse = aBoolean;
            });
        }
    }

    public void setSavedServiceCollapsedParameter() {
        Optional<Boolean> optional = ClientSingleton.getInstance().getBooleanProperty(this.toString());
        optional.ifPresent(aBoolean -> {
            this.isCollapse = aBoolean;
        });
        ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "setSavedServiceCollapsedParameter isCollapse=" + this.isCollapse);
    }
}

