/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.tabs.menu;

import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.viewers.imageview.MyImageView;

public class MenuItemBox
extends HBox {
    private String tag;

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public static MenuItemBox getInstance(String title, String imagePath, EventHandler<MouseEvent> eventHandler) {
        return new MenuItemBox(title, imagePath, eventHandler);
    }

    private MenuItemBox(String title, String imagePath, EventHandler<MouseEvent> eventHandler) {
        VBox.setMargin((Node)this, (Insets)new Insets(5.0, 0.0, 0.0, 0.0));
        this.setMaxWidth(218.0);
        this.setPrefHeight(24.0);
        HBox.setHgrow((Node)this, (Priority)Priority.ALWAYS);
        HBox hBox = new HBox();
        hBox.setPrefHeight(24.0);
        hBox.setAlignment(Pos.CENTER);
        if (imagePath != null) {
            MyImageView myImageView = MyImageView.getInstance(imagePath, 20, 20);
            HBox.setMargin((Node)myImageView, (Insets)new Insets(0.0, 40.0, 0.0, 20.0));
            hBox.getChildren().add((Object)myImageView);
        }
        this.getChildren().add((Object)hBox);
        Label myLabel = new Label();
        myLabel.prefHeightProperty().bind((ObservableValue)this.prefHeightProperty());
        myLabel.setText(title);
        Theme.getInstance().applyTabCellTo((Pane)this, false);
        Theme.getInstance().applyTo(Constants.TAB_CELL_TEXT_FILL, (Labeled)myLabel);
        myLabel.setAlignment(Pos.CENTER_LEFT);
        HBox.setHgrow((Node)myLabel, (Priority)Priority.ALWAYS);
        this.getChildren().add((Object)myLabel);
        ClientSingleton.getInstance().setMouseCursor((Node)myLabel);
        ClientSingleton.getInstance().setMouseCursor((Node)this);
        EventHandler enteredEventHandler = mouseEvent -> {
            Theme.getInstance().applyTabCellTo((Pane)this, true);
            Theme.getInstance().applyTo(Constants.TAB_CELL_TEXT_FILL, (Labeled)myLabel);
        };
        EventHandler exitedEventHandler = mouseEvent -> {
            Theme.getInstance().applyTabCellTo((Pane)this, false);
            Theme.getInstance().applyTo(Constants.TAB_CELL_TEXT_FILL, (Labeled)myLabel);
        };
        this.addEventFilter(MouseEvent.MOUSE_CLICKED, eventHandler);
        this.addEventFilter(MouseEvent.MOUSE_ENTERED, enteredEventHandler);
        this.addEventFilter(MouseEvent.MOUSE_EXITED, exitedEventHandler);
    }
}

