/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.tabs.menu;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.WhiteLabels;
import net.sipsnet.client.connector.observer.IGUIObservable;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.threadpool.MyThreadPoolManager;
import net.sipsnet.client.utils.viewers.MyAlert;
import net.sipsnet.client.utils.viewers.avatar.AvatarPane;
import net.sipsnet.client.utils.viewers.combobox.MyComboBox;
import net.sipsnet.client.utils.viewers.label.MyLabel;
import net.sipsnet.client.utils.viewers.statespane.StatesPane;
import net.sipsnet.client.views.changepassword.ChangePasswordController;
import net.sipsnet.client.views.profiles.userprofile.UserProfileEditorController;
import net.sipsnet.client.views.settings.SettingsController;
import net.sipsnet.client.views.tabs.menu.ILoadCustomPage;
import net.sipsnet.client.views.tabs.menu.MenuItemBox;
import smile.cti.client.ContactInfo;

public class TabMenuController
implements Initializable,
IGUIObservable {
    private final String FOCUSED_BACKGROUND = "-fx-background-color: #dce0ec;-fx-border-radius: 8 8 8 8;-fx-background-radius: 8 8 8 8;";
    private final String NOT_FOCUSED_BACKGROUND = "-fx-background-color: #f1f2f5;";
    public HBox fx_AvatarImage;
    public Label fx_lbUserName;
    public Label fx_lbExtendsLabel;
    public Label fx_lbExtends;
    public VBox fx_MenuPane;
    public static final double MAX_MENU_WIDTH = 218.0;
    public static final int MAX_ITEM_HEIGHT = 24;
    public MyComboBox fx_cbState;
    public ScrollPane fx_ScrollPaneMenu;
    public MyLabel fx_lbVersion;
    public StackPane fx_spStatePane;
    private UserProfileEditorController userProfileEditorController;
    private ILoadCustomPage iLoadCustomPage;
    private StatesPane statesPane;
    private Timer dndTimer;
    private TimerTask dndTimerTask;
    private ImageView fx_img30min;
    private ImageView fx_imgDuration;
    private TextField fx_etTextDuration;

    private void initMenuPane() {
        this.fx_MenuPane.prefWidthProperty().bind((ObservableValue)this.fx_ScrollPaneMenu.widthProperty());
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            List list = clientConnector.getCustomPages();
            if (list != null && !list.isEmpty()) {
                for (int i = 0; i < list.size(); ++i) {
                    HashMap pair = (HashMap)list.get(i);
                    String url = (String)pair.get("url");
                    String title = (String)pair.get("title");
                    MenuItemBox hBox = MenuItemBox.getInstance(title, "tab/menu/custom_webview.png", (EventHandler<MouseEvent>)((EventHandler)event -> {
                        ClientSingleton.toLog(this.getClass().getSimpleName(), "event.getSource() = " + event.getSource());
                        boolean isSwitched = this.iLoadCustomPage.switchViewModeForBrowser();
                        HBox hBox1 = (HBox)event.getSource();
                        boolean isOpenUrlInExternalBrowser = false;
                        if (clientConnector.getProperty(Constants.OPEN_URL_IN_EB) != null) {
                            isOpenUrlInExternalBrowser = (Boolean)clientConnector.getProperty(Constants.OPEN_URL_IN_EB);
                        }
                        if (!isOpenUrlInExternalBrowser && this.iLoadCustomPage != null) {
                            this.iLoadCustomPage.loadCustomPage(hBox1, isSwitched);
                        } else {
                            ClientSingleton.getInstance().openWebBrowser(hBox1.getId());
                        }
                    }));
                    hBox.setId(url);
                    hBox.setTag(url);
                    this.fx_MenuPane.getChildren().add((Object)hBox);
                }
                this.fx_MenuPane.getChildren().add((Object)this.addLine());
            }
        });
        this.fx_MenuPane.getChildren().add((Object)MenuItemBox.getInstance(ClientSingleton.getInstance().getString("tab_menu_info"), "tab/menu/menu_profile.png", (EventHandler<MouseEvent>)((EventHandler)event -> {
            this.userProfileEditorController = new UserProfileEditorController();
            this.userProfileEditorController.show();
        })));
        this.fx_MenuPane.getChildren().add((Object)MenuItemBox.getInstance(ClientSingleton.getInstance().getString("tab_menu_settings"), "tab/menu/menu_options.png", (EventHandler<MouseEvent>)((EventHandler)event -> {
            SettingsController settingsController = new SettingsController();
            settingsController.show();
        })));
        this.fx_MenuPane.getChildren().add((Object)MenuItemBox.getInstance(ClientSingleton.getInstance().getString("tab_menu_password"), "tab/menu/menu_password.png", (EventHandler<MouseEvent>)((EventHandler)event -> new ChangePasswordController())));
        this.fx_MenuPane.getChildren().add((Object)MenuItemBox.getInstance(ClientSingleton.getInstance().getString("tab_menu_exit"), "tab/menu/menu_exit.png", (EventHandler<MouseEvent>)((EventHandler)event -> {
            MyAlert myMessageAlert = new MyAlert();
            myMessageAlert.setMessage(ClientSingleton.getInstance().getString("onExitMessage")).addPositiveButton(ClientSingleton.getInstance().getString("tab_menu_exit"), (EventHandler<MouseEvent>)((EventHandler)mouseEvent -> {
                myMessageAlert.hide();
                ClientSingleton.getInstance().doNotify("ON_EXIT");
            })).addNegativeButton(ClientSingleton.getInstance().getString("cancel"), (EventHandler<MouseEvent>)((EventHandler)event1 -> myMessageAlert.close())).setAlwaysOnTop(true).buildDialogAndShow();
        })));
        this.fx_MenuPane.setPrefHeight((double)(this.fx_MenuPane.getChildren().size() * 24 + 20));
    }

    private Pane addLine() {
        Pane pane = new Pane();
        pane.prefWidth(150.0);
        pane.maxWidth(150.0);
        pane.setPrefHeight(15.0);
        VBox.setMargin((Node)pane, (Insets)new Insets(0.0, 23.0, 0.0, 23.0));
        pane.setStyle("-fx-border-color: #dce0ec; -fx-border-width: 0 0 1 0;");
        return pane;
    }

    public void initialize(URL url, ResourceBundle resourceBundle) {
        VBox.setMargin((Node)this.fx_AvatarImage, (Insets)new Insets(0.0, 0.0, 35.0, 0.0));
        String[] actions = new String[]{Constants.PROFILE_UPDATED};
        ClientSingleton.getInstance().addObserver(this, actions);
        Theme.getInstance().applyTo(Constants.BASE_COLOR, (Control)this.fx_ScrollPaneMenu);
        Theme.getInstance().applyTo(Constants.SCROLL_PANE_STYLE, (Control)this.fx_ScrollPaneMenu);
        Theme.getInstance().applyTo(Constants.BASE_COLOR, (Pane)this.fx_MenuPane);
        Theme.getInstance().applyTo(Constants.TABS_TITLE_TEXT_FILL, (Labeled)this.fx_lbUserName);
        Theme.getInstance().applyTo(Constants.TABS_TITLE_TEXT_FILL, (Labeled)this.fx_lbExtends);
        Theme.getInstance().applyTo(Constants.TAB_CELL_TEXT_FILL, (Labeled)this.fx_lbExtendsLabel);
        this.loadMenuTab();
        this.fx_lbVersion.setText(ClientSingleton.VERSION);
    }

    public void loadMenuTab() {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "loadMenuTab");
        this.setAvatarAndExt();
        this.fx_MenuPane.getChildren().clear();
        this.initMenuPane();
        this.fx_cbState.clearePopUp();
        this.initComboBox();
    }

    private void initComboBox() {
        this.fx_cbState.addStateLabel((Pane)this.statesPane).setShowEnabled(WhiteLabels.isChangeStateEnabled()).setArrowPosition(Pos.CENTER_RIGHT).build();
        this.fx_cbState.addMenuItem((Object)ClientSingleton.getInstance().getString("state_online"), eventAction -> {
            this.fx_cbState.hide();
            this.sendState(1);
        });
        this.fx_cbState.addMenuItem((Object)ClientSingleton.getInstance().getString("state_busy"), eventAction -> {
            this.fx_cbState.hide();
            this.sendState(3);
        });
        this.fx_cbState.addMenuItem((Object)ClientSingleton.getInstance().getString("state_at_the_desk"), eventAction -> {
            this.fx_cbState.hide();
            this.sendState(4);
        });
        this.fx_cbState.setLabelStyle("-fx-text-fill: #656a7c;-fx-font-size: 12px;-fx-font-weight: bold");
        ContactInfo contactInfo = ClientSingleton.getInstance().getUserInfo();
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            String sipDevice = clientConnector.getSIPDevice();
            ClientSingleton.toLog(this.getClass().getSimpleName(), "sipDevice " + sipDevice);
            if (sipDevice != null) {
                this.fx_cbState.addMenuItem((Object)sipDevice, eventAction -> {
                    this.fx_cbState.hide();
                    this.sendState(5);
                });
            }
            if (sipDevice != null && ClientSingleton.getInstance().isPhoneConnected()) {
                this.fx_cbState.setSelectedItem(sipDevice);
            } else {
                ClientSingleton.getInstance().getStateString(contactInfo).ifPresent(name -> this.fx_cbState.setSelectedItem(ClientSingleton.getInstance().getString((String)name)));
            }
            this.fx_spStatePane.getChildren().remove((Object)this.statesPane);
            this.statesPane = StatesPane.getInstance(StatesPane.VIEW_MODE.MENU_MODE);
            if (ClientSingleton.getInstance().isPhoneConnected()) {
                this.statesPane.setState(4);
            } else {
                this.statesPane.setState(ClientSingleton.getInstance().getCurrentClientState());
            }
            StackPane.setMargin((Node)this.statesPane, (Insets)new Insets(0.0, 0.0, 0.0, 5.0));
            this.fx_spStatePane.getChildren().add((Object)this.statesPane);
            StackPane.setAlignment((Node)this.statesPane, (Pos)Pos.CENTER_LEFT);
        });
        this.fx_cbState.setNotFocusedStyle();
        ClientSingleton.toLog(this.getClass().getSimpleName(), "Menu get : " + this.fx_cbState.get());
    }

    private void sendState(int state) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "sendState state " + state);
        MyThreadPoolManager.getInstance().execute(() -> ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            try {
                clientConnector.setState(state, "");
                ClientSingleton.toLog(this.getClass().getSimpleName(), "sendState done");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }));
    }

    public void setClientState(int clientState) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "setClientState clientState " + clientState + " ClientSingleton.getInstance().getCurrentClientState()=" + ClientSingleton.getInstance().getCurrentClientState());
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            ContactInfo contactInfo = clientConnector.getUserInfo(false);
            int state = clientState == -1 ? ClientSingleton.getInstance().getCurrentClientState() : clientState;
            ClientSingleton.getInstance().runLater(() -> {
                try {
                    this.statesPane.setState(state);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                String sipDevice = clientConnector.getSIPDevice();
                String title = null;
                if (clientState == 4 && sipDevice != null && ClientSingleton.getInstance().isPhoneConnected()) {
                    this.fx_cbState.setSelectedItem(sipDevice);
                } else {
                    title = ClientSingleton.getInstance().getStateString(state);
                    if (title == null && this.fx_cbState.getSelectedIndex() == -1) {
                        title = "state_away";
                    }
                    if (title != null) {
                        this.fx_cbState.setSelectedItem(ClientSingleton.getInstance().getString(title));
                    }
                }
                ClientSingleton.toLog(this.getClass().getSimpleName(), "setClientState sipDevice " + sipDevice + " state = " + state + " title=" + title);
                if (clientConnector.hasActiveCalls() && clientState >= 6 && clientState <= 8) {
                    this.fx_cbState.changeLabel(ClientSingleton.getInstance().getString(ClientSingleton.getInstance().getStateString(clientState)));
                    this.fx_cbState.setShowEnabled(false);
                } else {
                    this.fx_cbState.setShowEnabled(true);
                }
                this.fx_lbUserName.setText(contactInfo.toString());
            });
        });
    }

    public void setAssistanceDeviceState() {
        this.fx_cbState.clearePopUp();
        this.initComboBox();
    }

    public void setILoadCustomPage(ILoadCustomPage iLoadCustomPage) {
        this.iLoadCustomPage = iLoadCustomPage;
    }

    @Override
    public void onNotifiedMessage(String action, Map<String, Object> data) {
        if (Constants.PROFILE_UPDATED.equals(action)) {
            ClientSingleton.getInstance().runLater(this::setAvatarAndExt);
        }
        if (data != null) {
            data.clear();
        }
    }

    private void setAvatarAndExt() {
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            ContactInfo contactInfo = clientConnector.getUserInfo(false);
            ClientSingleton.getInstance().runLater(() -> {
                this.fx_AvatarImage.getChildren().clear();
                this.fx_AvatarImage.getChildren().add((Object)AvatarPane.getInstance(contactInfo, 128, 42, true));
                this.fx_lbUserName.setText(contactInfo.toString());
                Optional<String> ext = Optional.ofNullable(Optional.ofNullable((String)contactInfo.getProperty("extension")).orElse((String)contactInfo.getProperty("ext")));
                ClientSingleton.toLog(this.getClass().getSimpleName(), "setAvatarAndExt contactInfo " + contactInfo + " " + contactInfo.getUserID() + " extension = " + contactInfo.getProperty("extension") + " ext=" + contactInfo.getProperty("ext"));
                ext.ifPresent(s -> this.fx_lbExtends.setText(s));
                ClientSingleton.getInstance().getMainViewModel().onUsersAvatarUpdated();
            });
        });
    }

    private void setDndTimer(int duration) {
        if (this.dndTimerTask != null) {
            this.dndTimerTask.cancel();
            this.dndTimer.cancel();
            this.dndTimer.purge();
        }
        this.dndTimerTask = new TimerTask(){

            @Override
            public void run() {
                TabMenuController.this.sendState(1);
                TabMenuController.this.dndTimerTask.cancel();
                TabMenuController.this.dndTimer.cancel();
                TabMenuController.this.dndTimer.purge();
            }
        };
        this.dndTimer = new Timer();
        this.dndTimer.schedule(this.dndTimerTask, (long)duration * 60000L);
    }

    private void makeRememberMe(boolean is30min) {
        ClientSingleton.getInstance().setImageToImageView(this.fx_img30min, is30min ? "login/ic_login_check_on.png" : "login/ic_login_check_off.png");
        ClientSingleton.getInstance().setImageToImageView(this.fx_imgDuration, !is30min ? "login/ic_login_check_on.png" : "login/ic_login_check_off.png");
        this.fx_etTextDuration.setEditable(!is30min);
        if (!is30min) {
            this.fx_etTextDuration.requestFocus();
        }
    }
}

