/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.tabs.numpad.flow;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.rxjavafx.observables.JavaFxObservable;
import io.reactivex.rxjavafx.schedulers.JavaFxScheduler;
import io.reactivex.subjects.PublishSubject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.connector.utils.AudioCaller;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.viewers.combobox.MaxSizedContextMenu;
import net.sipsnet.client.utils.viewers.textfieldwithsearch.TextFieldWithSearch;
import net.sipsnet.client.views.keypad.KeyPadPane;
import net.sipsnet.client.views.tabs.UpdateLists;
import net.sipsnet.client.views.tabs.calls.flow.CallCellView;
import net.sipsnet.client.views.tabs.calls.flow.utils.CallHandler;
import net.sipsnet.client.views.tabs.contacts.flow.ContactCellView;
import net.sipsnet.client.views.tabs.contacts.flow.util.ContactInfoHeader;
import net.sipsnet.client.views.tabs.utils.BaseCell;
import net.sipsnet.client.views.tabs.utils.IContactsTabActions;
import net.sipsnet.client.views.tabs.utils.INewMessagesNotification;
import net.sipsnet.client.views.tabs.utils.IRemovebleCellInterface;
import org.fxmisc.flowless.Cell;
import org.fxmisc.flowless.VirtualFlow;
import org.fxmisc.flowless.VirtualizedScrollPane;
import smile.cti.client.ContactInfo;
import smile.cti.client.SessionInfo;

public class TabNumpadController
extends VBox {
    public static final int MIN_NUMPAD_HEIGHT = 450;
    private final TextFieldWithSearch textFieldWithSearch;
    private final KeyPadPane keyPadPane;
    private MenuItem dialAsItem;
    protected VirtualFlow<CallItem, ?> virtualFlow;
    protected VirtualizedScrollPane<VirtualFlow<CallItem, ?>> scrollPane;
    protected Function<CallItem, Cell<CallItem, Node>> cellFactory;
    protected final ObservableList<CallItem> dataInfoList = FXCollections.observableArrayList();
    private final INewMessagesNotification iNewMessagesNotification;

    public TabNumpadController(INewMessagesNotification iNewMessagesNotification) {
        this.iNewMessagesNotification = iNewMessagesNotification;
        Theme.getInstance().applyTo(Constants.TABS_VIRTUALIZED_SCROLL, (Pane)this);
        HBox hBox = new HBox();
        hBox.setAlignment(Pos.CENTER);
        hBox.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        this.keyPadPane = new KeyPadPane(false, true);
        this.keyPadPane.setSize(300);
        Pane vBox = this.keyPadPane.getPane();
        vBox.setMaxHeight(320.0);
        this.setMinHeight(380.0);
        vBox.setMinHeight(vBox.getMaxHeight());
        vBox.setPadding(new Insets(10.0, 10.0, 0.0, 10.0));
        this.textFieldWithSearch = this.keyPadPane.getTextField();
        this.textFieldWithSearch.setTextAlignment(Pos.CENTER);
        this.textFieldWithSearch.setPromptText("enter_number");
        this.textFieldWithSearch.setTextFontSize(32);
        this.textFieldWithSearch.setTextWidth(220);
        this.textFieldWithSearch.setFocusInTextField();
        this.textFieldWithSearch.setTextPadding();
        MaxSizedContextMenu myContextMenu = new MaxSizedContextMenu();
        myContextMenu.setMaxHeight(300.0);
        myContextMenu.setMinWidth(150.0);
        myContextMenu.setPrefWidth(150.0);
        myContextMenu.setMaxWidth(150.0);
        List trunks = ClientSingleton.getInstance().getClientConnector().get().getTrunks(null);
        if (trunks != null && trunks.size() > 1) {
            this.dialAsItem = new MenuItem(ClientSingleton.getInstance().getString("call_menu_dial_as"));
            this.dialAsItem.setOnAction(event1 -> AudioCaller.makeAudioCallToExternal(ClientSingleton.getInstance().getString("call_menu_dial_as"), List.of(this.textFieldWithSearch.getText()), trunks));
            myContextMenu.getItems().add((Object)this.dialAsItem);
        }
        MenuItem copyItem = new MenuItem(ClientSingleton.getInstance().getString("context_menu_copy"));
        copyItem.setOnAction(event1 -> {
            Clipboard clipboard = Clipboard.getSystemClipboard();
            ClipboardContent content = new ClipboardContent();
            content.putString(this.textFieldWithSearch.getText());
            clipboard.setContent((Map)content);
        });
        myContextMenu.getItems().add((Object)copyItem);
        MenuItem pasteItem = new MenuItem(ClientSingleton.getInstance().getString("context_menu_past"));
        pasteItem.setOnAction(event1 -> this.keyPadPane.insertFromClipboard(true));
        myContextMenu.addEventHandler(Menu.ON_SHOWING, e -> {
            if (this.dialAsItem != null) {
                this.dialAsItem.setDisable(this.textFieldWithSearch.getText().isEmpty());
            }
            copyItem.setDisable(this.textFieldWithSearch.getText().isEmpty());
            Clipboard clipboard = Clipboard.getSystemClipboard();
            pasteItem.setDisable(clipboard == null || clipboard.getString() == null);
        });
        myContextMenu.getItems().add((Object)pasteItem);
        this.textFieldWithSearch.setContextMenu(myContextMenu);
        hBox.getChildren().add((Object)this.textFieldWithSearch);
        hBox.prefHeightProperty().bind((ObservableValue)this.textFieldWithSearch.heightProperty().add(20));
        this.textFieldWithSearch.setBackgroundColor("transparent");
        this.textFieldWithSearch.setTextStyle(this.getTextStyle(true));
        this.textFieldWithSearch.setStyle("-fx-border-color: transparent transparent grey transparent;");
        this.textFieldWithSearch.setPadding(new Insets(0.0, 0.0, 10.0, 0.0));
        this.getChildren().addAll((Object[])new Node[]{hBox, vBox});
        Label fx_lbTitle = new Label();
        VBox.setMargin((Node)fx_lbTitle, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
        fx_lbTitle.setText(ClientSingleton.getInstance().getString("numpad_list_title"));
        fx_lbTitle.prefHeight(30.0);
        fx_lbTitle.setStyle("    -fx-text-fill: #969aae;    -fx-font-family: \"HelveticaNeue\";    -fx-font-size: 12px;    -fx-line-height: 1.19;");
        this.getChildren().add(0, (Object)fx_lbTitle);
        this.initListView();
        PublishSubject inputedText = PublishSubject.create();
        inputedText.observeOn(UpdateLists.scheduler).debounce(200L, TimeUnit.MILLISECONDS).switchMap(input -> {
            if (input.isEmpty() || AudioCaller.hasConnectedOrConferenceLine()) {
                return Observable.just(new ArrayList());
            }
            ArrayList callItems = new ArrayList();
            List<SessionInfo> calledSessions = ClientSingleton.getInstance().getCalls((String)input);
            List<String> calledContactIds = calledSessions.stream().filter(sessionInfo -> sessionInfo.getParties() != null && sessionInfo.getParties().size() == 1).map(sessionInfo -> ClientSingleton.getInstance().getUserID((ContactInfo)sessionInfo.getParties().get(0))).collect(Collectors.toList());
            callItems.addAll(calledSessions.stream().map(x$0 -> new CallItem(x$0)).collect(Collectors.toList()));
            callItems.addAll(this.getContacts(true, (String)input, calledContactIds).stream().map(contactInfo -> new CallItem(contactInfo, 1)).collect(Collectors.toList()));
            callItems.addAll(this.getContacts(false, (String)input, calledContactIds).stream().map(contactInfo -> new CallItem(contactInfo, 2)).collect(Collectors.toList()));
            return Observable.just(callItems);
        }).observeOn((Scheduler)JavaFxScheduler.platform()).doOnError(throwable -> {
            ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "ERROR1237");
            throwable.printStackTrace();
        }).subscribe(arg_0 -> this.dataInfoList.setAll(arg_0));
        JavaFxObservable.valuesOf((ObservableValue)this.textFieldWithSearch.getTextProperty()).subscribe((Observer)inputedText);
        this.textFieldWithSearch.getTextProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.isEmpty()) {
                this.textFieldWithSearch.setTextStyle(this.getTextStyle(true));
            } else {
                this.textFieldWithSearch.setTextStyle(this.getTextStyle(false));
            }
        });
        this.textFieldWithSearch.setAlignment(Pos.CENTER_LEFT);
    }

    private String getTextStyle(boolean isEmptyTextField) {
        return " -fx-control-inner-background: transparent;    -fx-font-family:Roboto-Regular;    -fx-font-size: " + (isEmptyTextField ? "18" : "32") + "px ;    -fx-text-fill: #656a7c;   -fx-text-box-border: transparent;    -fx-padding: 0;-fx-background-insets: 0;   -fx-background-color: transparent, transparent, transparent, transparent;   -fx-prompt-text-fill: #848794;";
    }

    private void initListView() {
        this.cellFactory = x$0 -> new CallCell((CallItem)x$0);
        this.virtualFlow = VirtualFlow.createVertical(this.dataInfoList, this.cellFactory);
        this.scrollPane = new VirtualizedScrollPane(this.virtualFlow, ScrollPane.ScrollBarPolicy.NEVER, ScrollPane.ScrollBarPolicy.AS_NEEDED);
        AnchorPane anchorPane = new AnchorPane();
        anchorPane.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        VBox.setVgrow((Node)anchorPane, (Priority)Priority.ALWAYS);
        anchorPane.getChildren().add(this.scrollPane);
        AnchorPane.setTopAnchor(this.scrollPane, (Double)0.0);
        AnchorPane.setLeftAnchor(this.scrollPane, (Double)0.0);
        AnchorPane.setBottomAnchor(this.scrollPane, (Double)0.0);
        AnchorPane.setRightAnchor(this.scrollPane, (Double)0.0);
        VBox.setMargin((Node)anchorPane, (Insets)new Insets(0.0, 0.0, 10.0, 0.0));
        this.getChildren().add(1, (Object)anchorPane);
    }

    public void setNumpadMode() {
        String prompt;
        boolean hasActiveLine = AudioCaller.hasConnectedOrConferenceLine();
        if (hasActiveLine) {
            prompt = "enter_digit";
            UnaryOperator unaryOperator = change -> {
                String newText = change.getControlNewText();
                if (newText.matches("-?([1-9][0-9]*)?")) {
                    return change;
                }
                return null;
            };
        } else {
            prompt = "enter_number";
        }
        this.keyPadPane.setDialButtonMode(!hasActiveLine);
        this.textFieldWithSearch.setText("");
        this.textFieldWithSearch.setPromptText(prompt);
        this.keyPadPane.dispose();
    }

    public boolean isDataListEmpty() {
        return this.dataInfoList.isEmpty();
    }

    public void setFocus() {
        this.textFieldWithSearch.setFocusInTextField();
    }

    private List<ContactInfo> getContacts(boolean isAutorizedContacts, String prefix, List<String> calledContactIds) {
        ArrayList<ContactInfo> items = new ArrayList<ContactInfo>();
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            Stream<ContactInfo> stream1 = ClientSingleton.getInstance().getContactInfoStream();
            List contactsList = stream1.distinct().filter(isAutorizedContacts ? UpdateLists.getAutorizedContacts() : UpdateLists.getNotAutorizedContacts()).filter(contactInfo -> !calledContactIds.contains(ClientSingleton.getInstance().getUserID((ContactInfo)contactInfo))).collect(Collectors.toList());
            items.addAll(contactsList.stream().filter(contactInfo -> ClientSingleton.getInstance().isContactInfoInTheList((ContactInfo)contactInfo, prefix)).collect(Collectors.toList()));
        });
        return items;
    }

    public void dispose() {
        if (this.dataInfoList.isEmpty()) {
            ArrayList<CallItem> calls = new ArrayList<CallItem>((Collection<CallItem>)this.dataInfoList);
            IntStream.range(0, calls.size()).forEach(i -> this.virtualFlow.getCellIfVisible(i).ifPresent(cell -> {
                try {
                    cell.dispose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }));
        }
        if (!this.textFieldWithSearch.getText().isEmpty()) {
            this.textFieldWithSearch.setText("");
        }
    }

    private class CallCell
    implements Cell<CallItem, Node> {
        private Pane itemPane;
        private final EventHandler<MouseEvent> eventHandler = event -> ClientSingleton.toLog(this.getClass().getSimpleName(), "Item click");

        public CallCell(CallItem callItem) {
            try {
                this.itemPane = callItem.isSessionItem() ? new CallCellView(BaseCell.ITEM_MODE.CALL_ITEM, new CallListener(), new CallHandler((SessionInfo)callItem.getItem()), TabNumpadController.this.iNewMessagesNotification) : new ContactCellView(callItem.isAutorizedContact() ? BaseCell.ITEM_MODE.AUTORIZED_CONTACT_ITEM : BaseCell.ITEM_MODE.NOT_AUTORIZED_CONTACT_ITEM, new CallContactListener(), (ContactInfo)callItem.getItem(), TabNumpadController.this.iNewMessagesNotification);
                this.itemPane.addEventHandler(MouseEvent.MOUSE_PRESSED, this.eventHandler);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public Pane getNode() {
            return this.itemPane;
        }

        public boolean isReusable() {
            return false;
        }

        public void dispose() {
            if (this.itemPane != null) {
                this.itemPane.prefWidthProperty().unbind();
                this.itemPane.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.eventHandler);
                ClientSingleton.getInstance().releaseViewResources(this.itemPane);
                this.itemPane = null;
            }
        }
    }

    class CallItem {
        private final Object item;
        private final int IS_SESSION = 0;
        private int itemType = 0;

        public CallItem(Object item) {
            this.item = item;
        }

        public CallItem(Object item, int type) {
            this.item = item;
            this.itemType = type;
        }

        public boolean isSessionItem() {
            return this.itemType == 0;
        }

        public boolean isAutorizedContact() {
            int IS_AUTORIZED_CONTACT = 1;
            return this.itemType == IS_AUTORIZED_CONTACT;
        }

        public boolean isNotAutorizedContact() {
            int IS_NOT_AUTORIZED_CONTACT = 2;
            return this.itemType == IS_NOT_AUTORIZED_CONTACT;
        }

        public Object getItem() {
            return this.item;
        }
    }

    class CallListener
    implements IRemovebleCellInterface {
        CallListener() {
        }

        @Override
        public void setSelectedTabCell(BaseCell selectedCell, MouseEvent mouseEvent) {
            TabNumpadController.this.iNewMessagesNotification.openSession(selectedCell);
        }

        @Override
        public void showContextMenu(BaseCell selectedCell, MouseEvent mouseEvent) {
        }

        @Override
        public void hideContextMenu(BaseCell baseCell) {
        }

        @Override
        public boolean isContextMenuShowing() {
            return false;
        }

        @Override
        public void setMultiselectMode() {
        }

        @Override
        public void removeMultiSelectionMode() {
        }

        @Override
        public void selectCallCell(boolean mode, String sessionId) {
        }

        @Override
        public void selectDateCell(boolean mode, String dateSessionId) {
        }

        @Override
        public void unselectDateCellTitle(String dateSessionId) {
        }

        @Override
        public boolean isMultiSelectionMode() {
            return false;
        }

        @Override
        public boolean isSelectedDateForDelete(String sessionId) {
            return false;
        }

        @Override
        public boolean isSelectedForDelete(String sessionId) {
            return false;
        }
    }

    class CallContactListener
    implements IContactsTabActions {
        CallContactListener() {
        }

        @Override
        public void setSelectedTabCell(BaseCell selectedCell, MouseEvent mouseEvent) {
            TabNumpadController.this.iNewMessagesNotification.openSession(selectedCell);
        }

        @Override
        public void showContextMenu(BaseCell selectedCell, MouseEvent mouseEvent) {
        }

        @Override
        public void hideContextMenu(BaseCell baseCell) {
        }

        @Override
        public boolean isContextMenuShowing() {
            return false;
        }

        @Override
        public void removeCells(ContactInfoHeader contactInfoHeader) {
        }

        @Override
        public void addCells(ContactInfoHeader contactInfoHeader) {
        }

        @Override
        public void setMultiselectMode() {
        }

        @Override
        public void removeMultiSelectionMode() {
        }

        @Override
        public void selectCallCell(boolean mode, String sessionId) {
        }

        @Override
        public void selectDateCell(boolean mode, String dateSessionId) {
        }

        @Override
        public void unselectDateCellTitle(String dateSessionId) {
        }

        @Override
        public boolean isMultiSelectionMode() {
            return false;
        }

        @Override
        public boolean isSelectedDateForDelete(String sessionId) {
            return false;
        }

        @Override
        public boolean isSelectedForDelete(String sessionId) {
            return false;
        }
    }
}

