/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.tabs.searchwithtextflow.search;

import io.reactivex.Observable;
import io.reactivex.Scheduler;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.rxjavafx.schedulers.JavaFxScheduler;
import io.reactivex.subjects.PublishSubject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.MyAction;
import net.sipsnet.client.utils.MyPair;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.views.tabs.TabBaseView;
import net.sipsnet.client.views.tabs.UpdateLists;
import net.sipsnet.client.views.tabs.searchwithtextflow.search.ISearchSelectionItem;
import net.sipsnet.client.views.tabs.searchwithtextflow.search.base.MyMessageInfo;
import net.sipsnet.client.views.tabs.searchwithtextflow.search.base.SearchCell;
import net.sipsnet.client.views.tabs.searchwithtextflow.search.base.SearchObject;
import net.sipsnet.client.views.tabs.utils.INewMessagesNotification;
import org.fxmisc.flowless.Cell;
import org.fxmisc.flowless.VirtualFlow;
import org.fxmisc.flowless.VirtualizedScrollPane;
import smile.cti.client.ContactInfo;
import smile.cti.client.SessionInfo;

public class TabSearchViewWithTextFlow
extends AnchorPane
implements ISearchSelectionItem {
    protected final ObservableList<SearchObject> dataInfoList = FXCollections.observableArrayList();
    protected VirtualFlow<SearchObject, ?> virtualFlow;
    protected VirtualizedScrollPane<VirtualFlow<SearchObject, ?>> scrollPane;
    private long lastTick = System.currentTimeMillis();
    private final Supplier<String> supplier;
    private final MyAction myAction;
    private PublishSubject<String> updateObserver;
    private CompositeDisposable updateResize;
    private TimerExecutor timerExecutor;
    private final SimpleIntegerProperty lastScrollMode = new SimpleIntegerProperty(-1);
    private final INewMessagesNotification iNewMessagesNotification;
    private int scrollCounter = 0;
    private SEARCH_MODE searchMode = SEARCH_MODE.ALL_LISTS;

    public void setSearchMode(int tab) {
        SEARCH_MODE mode = null;
        switch (tab) {
            case 1: {
                mode = SEARCH_MODE.LIST_OF_CONTACTS;
                break;
            }
            case 2: {
                mode = SEARCH_MODE.LIST_OF_EXTERNAL_CONTACTS;
                break;
            }
            case 3: {
                mode = SEARCH_MODE.LIST_OF_SESSIONS;
                break;
            }
            case 4: {
                mode = SEARCH_MODE.LIST_OF_CALLS;
                break;
            }
            default: {
                mode = SEARCH_MODE.ALL_LISTS;
            }
        }
        this.searchMode = mode;
        ClientSingleton.toLog(this.getClass().getSimpleName(), "Search setSearchMode tab=" + tab + " searchMode=" + this.searchMode);
    }

    public SEARCH_MODE getSearchMode() {
        return this.searchMode;
    }

    public TabSearchViewWithTextFlow(Supplier<String> supplier, MyAction myAction, INewMessagesNotification iNewMessagesNotification) {
        this.supplier = supplier;
        this.myAction = myAction;
        this.iNewMessagesNotification = iNewMessagesNotification;
        this.initUpdateObserver();
        this.addScrollPane(item -> new SearchCell((SearchObject)item, this));
    }

    public void setInputText(String inputText, boolean isSendRequest) {
        if (this.updateResize == null) {
            this.initUpdateObserver();
        }
        this.lastTick = System.currentTimeMillis();
        if (inputText.isEmpty()) {
            this.clearSearchList();
        } else {
            TimerExecutor.getInstance().start(() -> {
                ClientSingleton.toLog(this.getClass().getSimpleName(), "Search setInputText=" + inputText + " searchMode=" + this.searchMode);
                ArrayList<SearchObject> list = new ArrayList<SearchObject>();
                list.addAll(this.searchInContacts(SEARCH_MODE.LIST_OF_CONTACTS));
                list.addAll(this.searchInContacts(SEARCH_MODE.LIST_OF_EXTERNAL_CONTACTS));
                list.addAll(this.searchInCalls(isSendRequest));
                list.addAll(this.searchInSessions(isSendRequest));
                this.refreshList(list);
            });
        }
    }

    private void clearSearchList() {
        this.dataInfoList.clear();
        this.scrollCounter = 0;
        this.clearFoundedLists();
    }

    public void clearFoundedLists() {
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            clientConnector.findInCalls("", false);
            clientConnector.findInChats("", false);
        });
    }

    public void setHeadersCollapse() {
        TimerExecutor.getInstance().start(() -> {
            ClientSingleton.getInstance().setProperty("searchContactsHeaderTag", false);
            ClientSingleton.getInstance().setProperty("searchSessionsHeaderTag", false);
            ClientSingleton.getInstance().setProperty("searchCallsHeaderTag", false);
        });
    }

    private void refreshList(List<SearchObject> list) {
        this.refreshList(list, 0);
    }

    private void refreshList(List<SearchObject> list, int index) {
        ClientSingleton.getInstance().runLater(() -> {
            if (index != -1) {
                this.setOpacity(0.0);
            }
            this.dataInfoList.clear();
            this.dataInfoList.addAll((Collection)list);
            if (index != -1) {
                TimerExecutor.getInstance().setMyAction(() -> {
                    try {
                        this.virtualFlow.getCell(index);
                        this.virtualFlow.showAsFirst(index);
                        if (index == 0) {
                            this.setLastScrollMode(TabBaseView.SCROLL_TO_TOP);
                        }
                    }
                    catch (Throwable throwable) {
                        ClientSingleton.toLog(this.getClass().getSimpleName(), "Error : search virtualFlow.resize dataInfoList dataInfoList.size() =" + this.dataInfoList.size() + " virtualFlow.visibleCells().size()=" + this.virtualFlow.visibleCells().size());
                    }
                    if (!this.virtualFlow.isVisible()) {
                        this.virtualFlow.setVisible(true);
                    }
                    this.setOpacity(1.0);
                }).startWithDelayInGUIThread(200L);
            }
        });
    }

    public void setLastScrollMode(int lastScrollMode) {
        if (this.timerExecutor != null) {
            try {
                this.timerExecutor.cancel();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.timerExecutor = null;
        }
        this.lastScrollMode.set(lastScrollMode);
    }

    public void searchUpdated() {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "searchUpdated getInputText() =" + this.getInputText());
        this.updateObserver.onNext((Object)this.getInputText());
    }

    private List<SearchObject> searchInContacts(SEARCH_MODE searchMode) {
        Predicate<ContactInfo> predicate;
        String searchTitle = "contacts_contacts";
        SearchObject.ITEM_MODE headerMode = SearchObject.ITEM_MODE.EXT_CONTACTS_HEADER;
        switch (searchMode) {
            case LIST_OF_CONTACTS: {
                predicate = UpdateLists::isContactAutirized;
                searchTitle = "contacts_users";
                headerMode = SearchObject.ITEM_MODE.CONTACTS_HEADER;
                break;
            }
            case LIST_OF_EXTERNAL_CONTACTS: {
                predicate = UpdateLists::isContactNotAutirized;
                break;
            }
            default: {
                predicate = contactInfo -> UpdateLists.isContactAutirized(contactInfo) || UpdateLists.isContactNotAutirized(contactInfo);
            }
        }
        List members = ClientSingleton.getInstance().getContactInfoStream().distinct().filter(predicate).filter(contactInfo -> !contactInfo.isFeature() && ClientSingleton.getInstance().isContactInfoInTheList((ContactInfo)contactInfo, this.getInputText())).collect(Collectors.toList());
        ClientSingleton.toLog(this.getClass().getSimpleName(), "searchInContact getInputText() " + this.getInputText() + " members=" + members.size() + " searchTitle=" + searchTitle);
        if (searchMode == SEARCH_MODE.LIST_OF_EXTERNAL_CONTACTS) {
            members.addAll(this.addServices());
        }
        if (members.isEmpty()) {
            return new ArrayList<SearchObject>();
        }
        return this.addItems(members.stream().sorted(Comparator.comparing(ContactInfo::toString)).map(contactInfo -> new SearchObject(contactInfo, SearchObject.ITEM_MODE.CONTACT_ITEM)).collect(Collectors.toList()), searchTitle, headerMode);
    }

    private List<SearchObject> searchInCalls(boolean isSendRequest) {
        ArrayList<SessionInfo> calls = new ArrayList<SessionInfo>(ClientSingleton.getInstance().getClientConnector().get().findInCalls(this.getInputText(), isSendRequest));
        return this.collectCalls(calls);
    }

    private List<SearchObject> collectCalls(List<SessionInfo> calls) {
        ArrayList<SearchObject> messages = new ArrayList<SearchObject>();
        ArrayList<String> sessagesIdList = new ArrayList<String>();
        calls.forEach(sessionInfo -> messages.addAll(sessionInfo.getMessages().stream().map(messageInfo -> {
            sessagesIdList.add(messageInfo.getId());
            SearchObject searchObject = new SearchObject(messageInfo, SearchObject.ITEM_MODE.CALL_ITEM);
            searchObject.setSessionNameAndGroupMarker((SessionInfo)sessionInfo);
            return searchObject;
        }).collect(Collectors.toList())));
        messages.addAll(this.searchLocalCalls(this.getInputText(), sessagesIdList));
        if (messages.isEmpty()) {
            return new ArrayList<SearchObject>();
        }
        return this.addItems(messages.stream().filter(searchObject -> searchObject.isContains(this.getInputText())).sorted().collect(Collectors.toList()), "tab_calls", SearchObject.ITEM_MODE.CALLS_HEADER);
    }

    private List<SearchObject> searchInSessions(boolean isSendRequest) {
        ArrayList<SessionInfo> sessions = new ArrayList<SessionInfo>(ClientSingleton.getInstance().getClientConnector().get().findInChats(this.getInputText(), isSendRequest));
        return this.collectChats(sessions);
    }

    private List<SearchObject> collectChats(List<SessionInfo> sessions) {
        ArrayList<SearchObject> list = new ArrayList<SearchObject>();
        ArrayList sessionInfoList = new ArrayList();
        sessions.forEach(sessionInfo -> {
            if (!sessionInfoList.contains(sessionInfo.getSessionId())) {
                sessionInfoList.add(sessionInfo.getSessionId());
            }
            list.addAll(sessionInfo.getMessages().stream().map(messageInfo -> {
                SearchObject searchObject = new SearchObject(messageInfo, SearchObject.ITEM_MODE.MESSAGE_ITEM);
                Optional<SessionInfo> optional = ClientSingleton.getInstance().getSessionInfo(sessionInfo.getSessionId());
                if (optional.isPresent()) {
                    searchObject.setSessionNameAndGroupMarker(optional.get());
                } else {
                    searchObject.setSessionNameAndGroupMarker((SessionInfo)sessionInfo);
                }
                return searchObject;
            }).collect(Collectors.toList()));
        });
        Collections.sort(list);
        Collections.reverse(list);
        if (list.isEmpty()) {
            return list;
        }
        SearchObject searchObjectTitle = new SearchObject(ClientSingleton.getInstance().getString("tab_sessions"), SearchObject.ITEM_MODE.SESSIONS_HEADER);
        searchObjectTitle.setChildItems(new ArrayList<SearchObject>(list));
        list.add(0, searchObjectTitle);
        if (searchObjectTitle.isCollapse()) {
            list.clear();
            list.add(searchObjectTitle);
            return list;
        }
        ClientSingleton.toLog(this.getClass().getSimpleName(), "collectChats getInputText() getInputText() " + this.getInputText() + " findInCalls sessions = " + sessions.size() + " list=" + list.size());
        sessionInfoList.clear();
        return list;
    }

    protected void addScrollPane(Function<SearchObject, Cell<SearchObject, Node>> cellFactory) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "addScrollPane start ");
        Theme.getInstance().applyTo(Constants.TABS_VIRTUALIZED_SCROLL, (Pane)this);
        this.virtualFlow = VirtualFlow.createVertical(this.dataInfoList, cellFactory);
        this.virtualFlow.setVisible(false);
        this.scrollPane = new VirtualizedScrollPane(this.virtualFlow, ScrollPane.ScrollBarPolicy.NEVER, ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.lastScrollMode.addListener((observableValue, oldValue, newValue) -> {
            if (newValue.intValue() != -1 && this.timerExecutor == null) {
                this.timerExecutor = TimerExecutor.getInstance();
                this.timerExecutor.setMyAction(() -> this.setLastScrollMode(-1)).startWithDelay(300L);
            }
        });
        this.getChildren().add(this.scrollPane);
        AnchorPane.setTopAnchor(this.scrollPane, (Double)0.0);
        AnchorPane.setLeftAnchor(this.scrollPane, (Double)0.0);
        AnchorPane.setBottomAnchor(this.scrollPane, (Double)0.0);
        AnchorPane.setRightAnchor(this.scrollPane, (Double)0.0);
        ClientSingleton.toLog(this.getClass().getSimpleName(), "addScrollPane done");
    }

    public void disposeTab() {
        try {
            this.dataInfoList.clear();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (this.updateResize != null) {
            this.updateResize.dispose();
            this.updateResize.clear();
            this.updateResize = null;
        }
        ClientSingleton.toLog(this.getClass().getSimpleName(), "disposeTab");
    }

    protected List<SearchObject> addItems(List<SearchObject> members, String title, SearchObject.ITEM_MODE itemMode) {
        SearchObject searchObject = new SearchObject(ClientSingleton.getInstance().getString(title), itemMode);
        ArrayList<SearchObject> tmpList = new ArrayList<SearchObject>();
        for (SearchObject searchObject1 : members) {
            tmpList.add(0, searchObject1);
        }
        if (!tmpList.isEmpty()) {
            searchObject.setChildItems(new ArrayList<SearchObject>(tmpList));
            tmpList.add(0, searchObject);
            if (searchObject.isCollapse()) {
                ArrayList<SearchObject> list = new ArrayList<SearchObject>();
                list.add(searchObject);
                return list;
            }
        }
        return tmpList;
    }

    public static void setItemsStyle(List<SearchObject> tmpList) {
        if (tmpList.isEmpty()) {
            return;
        }
        if (tmpList.size() == 1) {
            tmpList.get(0).setStyleMode(SearchObject.STYLE_MODE.SINGLE);
        } else {
            tmpList.get(0).setStyleMode(SearchObject.STYLE_MODE.FIRST);
            tmpList.get(tmpList.size() - 1).setStyleMode(SearchObject.STYLE_MODE.LAST);
        }
    }

    @Override
    public void onAction(Object item) {
    }

    @Override
    public String getInputText() {
        return this.iNewMessagesNotification.getInputTextFromSearch().toLowerCase();
    }

    @Override
    public ReadOnlyDoubleProperty tabWidthProperty() {
        return this.widthProperty();
    }

    @Override
    public void chatFireScrollEvent(ScrollEvent scrollEvent) {
        this.virtualFlow.fireEvent((Event)scrollEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCells(SearchObject searchObject) {
        ObservableList<SearchObject> observableList = this.dataInfoList;
        synchronized (observableList) {
            List<?> list = searchObject.getChildItems();
            if (!list.isEmpty()) {
                for (Object object : list) {
                    SearchObject searchObject1 = (SearchObject)object;
                    this.dataInfoList.remove((Object)searchObject1);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCells(SearchObject searchObject) {
        ObservableList<SearchObject> observableList = this.dataInfoList;
        synchronized (observableList) {
            List<?> list = searchObject.getChildItems();
            if (!list.isEmpty()) {
                SearchObject searchObject1;
                int index;
                for (index = 0; index < this.dataInfoList.size() && !(searchObject1 = (SearchObject)this.dataInfoList.get(index)).getId().equals(searchObject.getId()); ++index) {
                }
                for (Object object : list) {
                    SearchObject searchObject12 = (SearchObject)object;
                    if (this.dataInfoList.contains((Object)searchObject12)) continue;
                    this.dataInfoList.add(++index, (Object)searchObject12);
                }
            }
        }
    }

    private void initUpdateObserver() {
        this.updateObserver = PublishSubject.create();
        if (this.updateResize == null) {
            this.updateResize = new CompositeDisposable();
        }
        this.updateResize.add(this.updateObserver.debounce((long)Constants.INPUT_TEXT_TICK, TimeUnit.MILLISECONDS).doOnError(Throwable::printStackTrace).switchMap(Observable::just).observeOn((Scheduler)JavaFxScheduler.platform()).subscribe(str -> {
            this.setInputText((String)str, false);
            this.myAction.execute();
        }, Throwable::printStackTrace));
    }

    private List<SearchObject> searchLocalCalls(String inputText, List<String> messageIdList) {
        List<SessionInfo> calls = ClientSingleton.getInstance().getCalls();
        List<Object> members = new ArrayList();
        List<SearchObject> ret = new ArrayList<SearchObject>();
        if (!calls.isEmpty()) {
            members = calls.stream().flatMap(sessionInfo -> sessionInfo.getMessages().stream()).filter(messageInfo -> messageInfo.getType() == 8 && !messageIdList.contains(messageInfo.getId()) && messageInfo.getContent().contains(inputText)).collect(Collectors.toList());
            ret = members.stream().map(messageInfo -> {
                MyMessageInfo myMessageInfo = new MyMessageInfo(messageInfo.getId(), messageInfo.getContent(), messageInfo.getType(), 8, messageInfo.getTime());
                SearchObject searchObject = new SearchObject(messageInfo, SearchObject.ITEM_MODE.CALL_ITEM);
                ClientSingleton.getInstance().getSessionInfo(messageInfo.getSessionId()).ifPresent(sessionInfo -> {
                    myMessageInfo.setMySessionId(sessionInfo.getSessionId());
                    searchObject.setSessionNameAndGroupMarker((SessionInfo)sessionInfo);
                });
                return searchObject;
            }).collect(Collectors.toList());
        }
        ClientSingleton.toLog(this.getClass().getSimpleName(), "searchLocalCalls ret" + ret.size());
        return ret;
    }

    private List<SearchObject> searchLocalSessions(List<String> sessionInfoList) {
        return ClientSingleton.getInstance().getSessionInfoStream().filter(sessionInfo -> sessionInfo.getSessionId() != null && sessionInfo.getStatus() != 10 && sessionInfo.getStatus() != 5 && sessionInfo.getStatus() != 4 && !sessionInfo.isSlot() && !sessionInfoList.contains(sessionInfo.getSessionId())).filter(ClientSingleton.getInstance().distinctByKey(SessionInfo::getSessionId)).filter(sessionInfo -> {
            if (sessionInfo.isGroup()) {
                return true;
            }
            return sessionInfo.getLastChatMessage() != null;
        }).filter(sessionInfo -> sessionInfo.toString().toLowerCase().contains(this.getInputText().toLowerCase())).sorted(Comparator.comparing(SessionInfo::toString)).map(sessionInfo -> new SearchObject(sessionInfo, SearchObject.ITEM_MODE.SESSION_ITEM)).collect(Collectors.toList());
    }

    private List<SessionInfo> searchLocalSessions() {
        return ClientSingleton.getInstance().getSessionInfoStream().filter(sessionInfo -> sessionInfo.getSessionId() != null && sessionInfo.getStatus() != 10 && sessionInfo.getStatus() != 5 && sessionInfo.getStatus() != 4 && !sessionInfo.isSlot()).filter(ClientSingleton.getInstance().distinctByKey(SessionInfo::getSessionId)).filter(sessionInfo -> {
            if (sessionInfo.isGroup()) {
                return true;
            }
            return sessionInfo.getLastChatMessage() != null;
        }).filter(sessionInfo -> sessionInfo.toString().toLowerCase().contains(this.getInputText().toLowerCase())).sorted(Comparator.comparing(SessionInfo::toString)).collect(Collectors.toList());
    }

    private boolean isHasInMessage(SessionInfo sessionInfo, String inputText) {
        return sessionInfo.getMessages() != null && sessionInfo.getMessages().stream().anyMatch(messageInfo -> messageInfo.getType() != 8 && messageInfo.getContent().toLowerCase().contains(inputText.toLowerCase()));
    }

    private List<ContactInfo> addServices() {
        ArrayList<ContactInfo> contactInfoList = new ArrayList<ContactInfo>();
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            try {
                List list = clientConnector.getServices();
                ClientSingleton.toLog(this.getClass().getSimpleName(), "addServices list=" + list);
                if (list != null && !list.isEmpty()) {
                    for (int i = 0; i < list.size(); ++i) {
                        HashMap pair = (HashMap)list.get(i);
                        String title = (String)pair.get("name");
                        String serviceId = (String)pair.get("serviceid");
                        ClientSingleton.toLog(this.getClass().getSimpleName(), "addServices title=" + title + " serviceId=" + serviceId);
                        MyPair<Long, List<ContactInfo>> myPair = ClientSingleton.getInstance().getServiceContacts(serviceId, this.getInputText().toLowerCase());
                        if (myPair.hasLastException() || myPair.getSecond() == null) continue;
                        contactInfoList.addAll((Collection)myPair.getSecond());
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
        return contactInfoList;
    }

    public static enum SEARCH_MODE {
        ALL_LISTS,
        LIST_OF_CONTACTS,
        LIST_OF_EXTERNAL_CONTACTS,
        LIST_OF_SESSIONS,
        LIST_OF_CALLS;

    }
}

