/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.tabs.searchwithtextflow.search.base;

import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.views.tabs.searchwithtextflow.search.ISearchSelectionItem;
import net.sipsnet.client.views.tabs.searchwithtextflow.search.base.SearchBaseViewWithTextFlow;
import net.sipsnet.client.views.tabs.searchwithtextflow.search.base.SearchObject;
import net.sipsnet.client.views.tabs.searchwithtextflow.search.views.SearchCallInfoCellView;
import net.sipsnet.client.views.tabs.searchwithtextflow.search.views.SearchContactInfoCellView;
import net.sipsnet.client.views.tabs.searchwithtextflow.search.views.SearchHeaderCellView;
import net.sipsnet.client.views.tabs.searchwithtextflow.search.views.SearchMessageInfoCellView;
import net.sipsnet.client.views.tabs.searchwithtextflow.search.views.SearchSessionInfoCellView;
import net.sipsnet.client.views.tabs.searchwithtextflow.search.views.SearchShowMoreCellView;
import org.fxmisc.flowless.Cell;

public class SearchCell
implements Cell<SearchObject, Node> {
    private final ISearchSelectionItem iSearchSelectionItem;
    private Pane itemCell;
    private SearchObject searchObject;

    public SearchCell(SearchObject searchObject, ISearchSelectionItem iSearchSelectionItem) {
        this.iSearchSelectionItem = iSearchSelectionItem;
        this.initCell(searchObject);
    }

    private void initCell(SearchObject searchObject) {
        this.searchObject = searchObject;
        this.itemCell = searchObject.getType() == SearchObject.ITEM_MODE.EXT_CONTACTS_HEADER || searchObject.getType() == SearchObject.ITEM_MODE.CONTACTS_HEADER || searchObject.getType() == SearchObject.ITEM_MODE.CALLS_HEADER || searchObject.getType() == SearchObject.ITEM_MODE.SESSIONS_HEADER ? new SearchHeaderCellView(this.iSearchSelectionItem, searchObject) : (searchObject.getType() == SearchObject.ITEM_MODE.CONTACT_ITEM ? new SearchContactInfoCellView(this.iSearchSelectionItem, searchObject) : (searchObject.getType() == SearchObject.ITEM_MODE.CALL_ITEM ? new SearchCallInfoCellView(this.iSearchSelectionItem, searchObject) : (searchObject.getType() == SearchObject.ITEM_MODE.SESSION_ITEM ? new SearchSessionInfoCellView(this.iSearchSelectionItem, searchObject) : (searchObject.getType() == SearchObject.ITEM_MODE.SHOW_MORE_SESSIONS_ITEM || searchObject.getType() == SearchObject.ITEM_MODE.SHOW_MORE_CALLS_ITEM ? new SearchShowMoreCellView(this.iSearchSelectionItem, searchObject) : new SearchMessageInfoCellView(this.iSearchSelectionItem, searchObject)))));
        ClientSingleton.getInstance().setFocusNotTraversable(this.itemCell);
        this.itemCell.prefWidthProperty().bind((ObservableValue)this.iSearchSelectionItem.tabWidthProperty().subtract(10));
    }

    public Pane getNode() {
        return this.itemCell;
    }

    public boolean isReusable() {
        return true;
    }

    public void updateItem(SearchObject searchObject) {
        if (this.itemCell == null || this.searchObject == null) {
            this.initCell(searchObject);
        } else if (this.searchObject.getType() == searchObject.getType() && searchObject.getType() != SearchObject.ITEM_MODE.SHOW_MORE_SESSIONS_ITEM && searchObject.getType() != SearchObject.ITEM_MODE.SHOW_MORE_CALLS_ITEM) {
            this.searchObject = searchObject;
            if (this.itemCell instanceof SearchBaseViewWithTextFlow) {
                ((SearchBaseViewWithTextFlow)this.itemCell).update(searchObject);
            } else {
                ((SearchHeaderCellView)this.itemCell).update(searchObject);
            }
            this.itemCell.setManaged(false);
            this.itemCell.applyCss();
        } else {
            this.initCell(searchObject);
        }
    }

    public void dispose() {
        if (this.itemCell != null) {
            if (this.searchObject != null) {
                this.searchObject.dispose();
            }
            this.itemCell.prefWidthProperty().unbind();
            if (this.itemCell instanceof SearchContactInfoCellView) {
                ((SearchContactInfoCellView)this.itemCell).dispose();
            }
            ClientSingleton.getInstance().releaseViewResources(this.itemCell);
            this.itemCell = null;
        }
    }
}

