/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.tabs.searchwithtextflow.search.base;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javafx.util.Pair;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.utils.JsonMessageParser;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.views.chat.messageutil.MessageInfoCellLabels;
import smile.cti.client.ContactInfo;
import smile.cti.client.FileInfo;
import smile.cti.client.MessageInfo;
import smile.cti.client.SessionInfo;

public class SearchObject
implements Comparable<SearchObject> {
    public static final String EXT_CONTACTS_HEADER_TAG = "searchExtContactsHeaderTag";
    public static final String CONTACTS_HEADER_TAG = "searchContactsHeaderTag";
    public static final String CALLS_HEADER_TAG = "searchCallsHeaderTag";
    public static final String SESSIONS_HEADER_TAG = "searchSessionsHeaderTag";
    private boolean isCollapse;
    private final Object item;
    private final ITEM_MODE itemMode;
    private STYLE_MODE styleMode = STYLE_MODE.REGULAR;
    private List<?> childItems = new ArrayList();
    private String sessionName = null;
    private boolean isGroupSession;
    private int viewHeight;
    private String messageTime;
    private String title;
    private String messageContent;

    @Override
    public int compareTo(SearchObject o) {
        if (this.getType() == ITEM_MODE.CALL_ITEM || this.getType() == ITEM_MODE.MESSAGE_ITEM) {
            MessageInfo messageInfo1 = (MessageInfo)this.item;
            MessageInfo messageInfo2 = (MessageInfo)o.getItem();
            return messageInfo1.compareTo((Object)messageInfo2);
        }
        return 0;
    }

    public STYLE_MODE getStyleMode() {
        return this.styleMode;
    }

    public void setStyleMode(STYLE_MODE styleMode) {
        this.styleMode = styleMode;
    }

    public Object getItem() {
        return this.item;
    }

    public ITEM_MODE getType() {
        return this.itemMode;
    }

    public List<?> getChildItems() {
        return this.childItems;
    }

    public void setChildItems(List<?> childItems) {
        this.childItems = childItems;
    }

    public void removeChildItem(Object item) {
        this.childItems.remove(item);
    }

    public void clearChildItems() {
        this.childItems.clear();
    }

    public int getViewHeight() {
        return this.viewHeight;
    }

    public void setViewHeight(int viewHeight) {
        this.viewHeight = viewHeight;
    }

    public String getMessageTime() {
        return this.messageTime;
    }

    private void setMessageTime() {
        if (this.getType() == ITEM_MODE.CALL_ITEM || this.getType() == ITEM_MODE.MESSAGE_ITEM) {
            MessageInfo messageInfo = (MessageInfo)this.item;
            this.messageTime = ClientSingleton.getInstance().getDateTimeString(messageInfo.getTime());
        }
    }

    public String getTitle() {
        return this.title;
    }

    private void setTitle() {
        if (this.getType() == ITEM_MODE.CALL_ITEM) {
            this.title = ClientSingleton.getInstance().getCallTitle(this.sessionName, (MessageInfo)this.item);
        } else if (this.getType() == ITEM_MODE.MESSAGE_ITEM) {
            AtomicReference<String> name = new AtomicReference<String>(ClientSingleton.getInstance().getString("my_message"));
            MessageInfo messageInfo = (MessageInfo)this.item;
            String from = null;
            if (messageInfo.getType() == 20) {
                from = JsonMessageParser.getJsonFrom(messageInfo.getContent());
                String number = JsonMessageParser.getJsonNumber(messageInfo.getContent());
                name.set((String)(!from.isEmpty() ? from + " \u2794 " : "") + number);
            } else if (messageInfo.getType() != 5) {
                ClientSingleton.getInstance().getContactInfoByUserId(messageInfo.getSenderId()).ifPresent(contactInfo -> name.set(contactInfo.toString().trim()));
            } else {
                Pair<String, Integer> pair = MessageInfoCellLabels.getSenderName(messageInfo);
                name.set((String)pair.getKey());
            }
            this.title = name.get();
        }
    }

    public String getSenderName() {
        AtomicReference<String> senderName = new AtomicReference<String>("");
        if (this.isGroupSession && (this.getType() == ITEM_MODE.CALL_ITEM || this.getType() == ITEM_MODE.MESSAGE_ITEM)) {
            MessageInfo messageInfo = (MessageInfo)this.item;
            ClientSingleton.getInstance().getContactInfoByUserId(messageInfo.getSenderId()).ifPresent(contactInfo -> senderName.set(contactInfo.toString().trim()));
        }
        return senderName.get();
    }

    public String getMessageContent() {
        return this.messageContent;
    }

    private void setMessageContent() {
        if (this.getType() == ITEM_MODE.CALL_ITEM || this.getType() == ITEM_MODE.MESSAGE_ITEM) {
            MessageInfo messageInfo = (MessageInfo)this.item;
            this.messageContent = MessageInfoCellLabels.setContentLabel(messageInfo);
        }
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public String getId() {
        if (this.item instanceof ContactInfo) {
            return ClientSingleton.getInstance().getUserID((ContactInfo)this.item);
        }
        if (this.item instanceof SessionInfo) {
            return ((SessionInfo)this.item).getSessionId();
        }
        if (this.item instanceof MessageInfo) {
            return ((MessageInfo)this.item).getId();
        }
        return this.toString();
    }

    public boolean isCollapse() {
        return this.isCollapse;
    }

    public void setCollapse(boolean isCollapse) {
        if (!Objects.equals(isCollapse, this.isCollapse)) {
            this.isCollapse = isCollapse;
            TimerExecutor.getInstance().start(() -> {
                String key = this.getHeaderTag();
                ClientSingleton.getInstance().setProperty(key, isCollapse);
            });
        }
    }

    public SearchObject(Object item, ITEM_MODE itemMode) {
        this.item = item;
        this.itemMode = itemMode;
        if (itemMode == ITEM_MODE.CONTACTS_HEADER || itemMode == ITEM_MODE.SESSIONS_HEADER || itemMode == ITEM_MODE.CALLS_HEADER) {
            String key = this.getHeaderTag();
            Optional<Boolean> isCollapsed = ClientSingleton.getInstance().getBooleanProperty(key);
            this.isCollapse = isCollapsed.orElse(false);
        }
        this.setMessageTime();
        this.setMessageContent();
    }

    public void setSessionNameAndGroupMarker(SessionInfo sessionInfo) {
        this.sessionName = sessionInfo.toString();
        this.isGroupSession = sessionInfo.isGroup();
        this.setTitle();
    }

    private String getHeaderTag() {
        String key = this.getType() == ITEM_MODE.CONTACTS_HEADER ? CONTACTS_HEADER_TAG : (this.getType() == ITEM_MODE.EXT_CONTACTS_HEADER ? EXT_CONTACTS_HEADER_TAG : (this.getType() == ITEM_MODE.SESSIONS_HEADER ? SESSIONS_HEADER_TAG : CALLS_HEADER_TAG));
        return key;
    }

    public String toString() {
        if (this.item instanceof MessageInfo) {
            MessageInfo messageInfo = (MessageInfo)this.item;
            if (messageInfo instanceof FileInfo) {
                return messageInfo.getContent();
            }
            return MessageInfoCellLabels.setContentLabel(messageInfo);
        }
        return this.item.toString();
    }

    public boolean equals(Object obj) {
        SearchObject searchObject = (SearchObject)obj;
        return this.getId().equals(searchObject.getId());
    }

    public void dispose() {
        this.setCollapse(false);
    }

    public boolean isContains(String text) {
        return this.title != null && this.title.contains(text) || this.messageContent != null && this.messageContent.contains(text) || this.sessionName != null && this.sessionName.contains(text);
    }

    public static enum ITEM_MODE {
        EXT_CONTACTS_HEADER,
        CONTACTS_HEADER,
        CONTACT_ITEM,
        SESSIONS_HEADER,
        SESSION_ITEM,
        MESSAGE_ITEM,
        CALLS_HEADER,
        CALL_ITEM,
        SHOW_MORE_CALLS_ITEM,
        SHOW_MORE_SESSIONS_ITEM;

    }

    public static enum STYLE_MODE {
        FIRST,
        REGULAR,
        LAST,
        SINGLE;

    }
}

