/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.tabs.searchwithtextflow.search.views;

import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.views.tabs.searchwithtextflow.search.ISearchSelectionItem;
import net.sipsnet.client.views.tabs.searchwithtextflow.search.base.SearchBaseViewWithTextFlow;
import net.sipsnet.client.views.tabs.searchwithtextflow.search.base.SearchObject;

public class SearchShowMoreCellView
extends SearchBaseViewWithTextFlow {
    private HBox sessionInfoPane;
    private Text titleText;

    public SearchShowMoreCellView(ISearchSelectionItem iSearchSelectionItem, SearchObject searchObject) {
        super(searchObject, iSearchSelectionItem, "transparent");
        this.setStyle("-fx-background-color: transparent;");
        this.setPadding(new Insets(0.0, 0.0, 5.0, 0.0));
        this.initComponents();
    }

    public SearchObject.ITEM_MODE getType() {
        return this.searchObject.getType();
    }

    public String toString() {
        return this.getSessionId();
    }

    public String getSessionId() {
        return this.getType().toString();
    }

    private void initComponents() {
        this.sessionInfoPane = new HBox();
        this.sessionInfoPane.setAlignment(Pos.CENTER_LEFT);
        this.addMousePressedEvent((EventHandler<MouseEvent>)((EventHandler)mouseEvent -> ClientSingleton.getInstance().doNotify(this.getType() == SearchObject.ITEM_MODE.SHOW_MORE_CALLS_ITEM ? Constants.SEARCH_CALLS_EXT : Constants.SEARCH_SESSIONS_EXT)));
        this.setItemStyle("transparent");
        this.titleText = new Text(this.searchObject.toString());
        try {
            ClientSingleton.getInstance().setStyledTextFont(this.titleText, true, "#0a5ca1", 8);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        HBox.setHgrow((Node)this.titleText, (Priority)Priority.ALWAYS);
        this.sessionInfoPane.getChildren().add((Object)this.titleText);
        this.sessionInfoPane.prefWidthProperty().bind((ObservableValue)this.prefWidthProperty());
        VBox.setMargin((Node)this.sessionInfoPane, (Insets)new Insets(5.0, 0.0, 0.0, 0.0));
        this.sessionInfoPane.setPadding(new Insets(10.0, 5.0, 10.0, 15.0));
        this.addChild((Pane)this.sessionInfoPane);
    }

    @Override
    public void setItemStyle(String color) {
        String style = this.getStyle(color);
        this.sessionInfoPane.setStyle(style);
    }
}

