/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.tabs.sessions.flow;

import java.util.concurrent.atomic.AtomicReference;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.viewers.statespane.StatesPane;
import net.sipsnet.client.views.chat.messageutil.MessageInfoCellLabels;
import net.sipsnet.client.views.tabs.sessions.flow.TabSessionsController;
import net.sipsnet.client.views.tabs.utils.BaseCell;
import net.sipsnet.client.views.tabs.utils.INewMessagesNotification;
import smile.cti.client.ContactInfo;
import smile.cti.client.FileInfo;
import smile.cti.client.MessageInfo;
import smile.cti.client.SessionInfo;

public class SessionCellView
extends BaseCell
implements Comparable<SessionCellView> {
    private Node fx_lbSessionName;
    private final HBox fx_hbSessionName = new HBox();
    private Label fx_lbNewMessageCount;
    private Label fx_lbDndTitle;
    private SessionInfo sessionInfo;
    private ImageView fx_ivState;
    private HBox fx_MutePane;
    private StatesPane statesPane;
    private HBox secondLine;
    private final VBox vbItemContent = new VBox();
    private ImageView ivArrowImage;
    private Label lastMessageLabel;
    private final HBox hbState = new HBox();
    private final HBox hbArrow = new HBox();
    private final Label fx_lbDateTime = new Label();
    private final HBox otherStatesPane = new HBox();
    private final HBox dndPane = new HBox();
    private final double FONT_CHAR_WIDTH = 6.5;

    public SessionCellView(BaseCell.ITEM_MODE item_mode, TabSessionsController tabSessionsController, SessionInfo sessionInfo, INewMessagesNotification iNewMessagesNotification) {
        super(item_mode, tabSessionsController, sessionInfo, iNewMessagesNotification);
        this.sessionInfo = sessionInfo;
        this.removeIconContainer();
        this.initComponents();
    }

    @Override
    public void setName() {
        if (this.fx_lbSessionName != null) {
            if (this.fx_lbSessionName instanceof TextFlow) {
                TextFlow textFlow = (TextFlow)this.fx_lbSessionName;
                if (textFlow.getChildren().size() == 1 && this.iNewMessagesNotification.getInputTextFromSearch().isEmpty()) {
                    ((Text)textFlow.getChildren().get(0)).setText(this.sessionInfo.toString());
                } else {
                    ClientSingleton.getInstance().releaseViewResources((Pane)textFlow);
                    this.addSessionTextFlow();
                }
            } else {
                ((Label)this.fx_lbSessionName).setText(this.sessionInfo.toString());
            }
        } else {
            this.addSessionTextFlow();
        }
    }

    private void setLastMessageContent() {
        Object mContent = "";
        MessageInfo messageInfo = this.sessionInfo.getLastChatMessage();
        if (messageInfo != null) {
            String senderName;
            if (messageInfo instanceof FileInfo) {
                FileInfo lastMessageInfo = (FileInfo)messageInfo;
                if (lastMessageInfo.isImage()) {
                    mContent = ClientSingleton.getInstance().getString("last_message_image_1");
                } else if (lastMessageInfo.isSound() || lastMessageInfo.isAudio()) {
                    mContent = ClientSingleton.getInstance().getString("last_message_image_2");
                } else if (lastMessageInfo.isVideo()) {
                    mContent = ClientSingleton.getInstance().getString("last_message_image_3");
                } else {
                    mContent = MessageInfoCellLabels.setContentLabel(messageInfo);
                    mContent = MessageInfoCellLabels.checkFileName((String)mContent);
                }
            } else {
                mContent = MessageInfoCellLabels.setContentLabel(messageInfo);
                if (((String)mContent).contains("\n")) {
                    int index = ((String)mContent).indexOf("\n");
                    mContent = ((String)mContent).substring(0, index) + "...";
                }
            }
            this.setArrowImage();
            this.fx_lbDateTime.setText(this.getDateTime(messageInfo));
            if (this.sessionInfo.isGroup() && !(senderName = this.getSenderName(messageInfo)).isEmpty()) {
                mContent = senderName + ": " + (String)mContent;
            }
        }
        if (this.lastMessageLabel == null) {
            this.lastMessageLabel = new Label((String)mContent);
            String style = "-fx-text-fill:" + Constants.colorForSmallFont + ";-fx-font-family: \"Arial\";-fx-font-size: 10pt;";
            this.lastMessageLabel.setStyle(style);
            this.lastMessageLabel.setPadding(new Insets(0.0, 0.0, 0.0, 5.0));
            this.getSecondLine().getChildren().add((Object)this.lastMessageLabel);
        } else {
            this.lastMessageLabel.setText((String)mContent);
        }
    }

    private String getSenderName(MessageInfo messageInfo) {
        AtomicReference<String> senderName = new AtomicReference<String>("");
        ClientSingleton.getInstance().getContactInfoByUserId(messageInfo.getSenderId()).ifPresent(contactInfo -> senderName.set(contactInfo.toString().trim()));
        return senderName.get();
    }

    private void addSessionTextFlow() {
        this.fx_hbSessionName.getChildren().remove((Object)this.fx_lbSessionName);
        if (this.iNewMessagesNotification.getInputTextFromSearch().isEmpty()) {
            this.fx_lbSessionName = new Label(this.sessionInfo.toString());
            this.setCellTextStyle((Label)this.fx_lbSessionName, false);
            ((Label)this.fx_lbSessionName).setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
        } else {
            this.removeFromContainerView(this.fx_lbSessionName);
            this.fx_lbSessionName = ClientSingleton.getInstance().addStyledTextArea(this.sessionInfo.toString(), this.iNewMessagesNotification.getInputTextFromSearch(), this.regularColor, 11);
            ((TextFlow)this.fx_lbSessionName).setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
        }
        this.fx_hbSessionName.setId("fx_hbSessionName");
        this.fx_hbSessionName.getChildren().add(this.fx_hbSessionName.getChildren().isEmpty() ? 0 : 1, (Object)this.fx_lbSessionName);
        if (!this.vbItemContent.getChildren().contains((Object)this.fx_hbSessionName)) {
            this.vbItemContent.getChildren().add(0, (Object)this.fx_hbSessionName);
        }
    }

    private void initComponents() {
        HBox.setHgrow((Node)this.vbItemContent, (Priority)Priority.ALWAYS);
        this.addToContainerView((Node)this.vbItemContent);
        super.setContainerPadding(new Insets(5.0, 0.0, 5.0, 0.0));
        this.vbItemContent.setPadding(new Insets(5.0, 0.0, 5.0, 10.0));
        this.fx_hbSessionName.setAlignment(Pos.CENTER_LEFT);
        this.fx_hbSessionName.prefWidthProperty().bind((ObservableValue)this.vbItemContent.widthProperty());
        this.hbState.prefHeightProperty().bind((ObservableValue)this.fx_hbSessionName.heightProperty());
        this.hbState.setAlignment(Pos.CENTER);
        this.hbState.setMaxWidth(20.0);
        this.hbState.setMinWidth(20.0);
        this.hbArrow.prefHeightProperty().bind((ObservableValue)this.fx_hbSessionName.heightProperty());
        this.hbArrow.setAlignment(Pos.CENTER);
        this.hbArrow.setMaxWidth(20.0);
        this.hbArrow.setMinWidth(20.0);
        this.ivArrowImage = new ImageView();
        this.ivArrowImage.setFitWidth(13.0);
        this.ivArrowImage.setFitHeight(10.0);
        this.ivArrowImage.setPickOnBounds(true);
        this.ivArrowImage.setPreserveRatio(true);
        this.hbArrow.getChildren().add(0, (Object)this.ivArrowImage);
        this.getSecondLine().getChildren().add(0, (Object)this.hbArrow);
        this.fx_hbSessionName.getChildren().add(0, (Object)this.hbState);
        HBox vBox = new HBox();
        vBox.setAlignment(Pos.CENTER);
        HBox.setHgrow((Node)vBox, (Priority)Priority.ALWAYS);
        vBox.setMaxWidth(2.147483647E9);
        this.fx_lbDateTime.setStyle("-fx-font-size:9pt;-fx-text-fill: " + this.regularColor + ";-fx-font-family: \"Arial\";");
        this.fx_lbDateTime.setTextAlignment(TextAlignment.RIGHT);
        this.fx_lbDateTime.textProperty().addListener((observable, oldValue, newValue) -> {
            this.fx_lbDateTime.setMinWidth((double)newValue.length() * 6.5);
            this.fx_lbDateTime.setMaxWidth((double)newValue.length() * 6.5);
            this.fx_lbDateTime.setPrefWidth((double)newValue.length() * 6.5);
            vBox.setMinWidth((double)newValue.length() * 6.5);
        });
        HBox.setHgrow((Node)this.dndPane, (Priority)Priority.ALWAYS);
        vBox.getChildren().add((Object)this.dndPane);
        vBox.getChildren().add((Object)this.fx_lbDateTime);
        this.fx_hbSessionName.getChildren().add((Object)vBox);
        this.fx_hbSessionName.getChildren().add((Object)this.otherStatesPane);
        this.otherStatesPane.setAlignment(Pos.CENTER);
        this.otherStatesPane.prefHeightProperty().bind((ObservableValue)this.fx_hbSessionName.heightProperty());
        int radius = 7;
        this.fx_lbNewMessageCount = new Label();
        this.fx_lbNewMessageCount.setAlignment(Pos.CENTER);
        HBox.setMargin((Node)this.fx_lbNewMessageCount, (Insets)new Insets(0.0, 3.0, 0.0, 3.0));
        this.fx_lbNewMessageCount.setPadding(new Insets(0.0, 3.0, 0.0, 3.0));
        this.fx_lbNewMessageCount.setStyle("-fx-background-color: #f7bd40;-fx-font-size:9pt;-fx-text-fill:#646a7e;-fx-border-radius: " + radius + " " + radius + " " + radius + " " + radius + "; -fx-background-radius: " + radius + " " + radius + " " + radius + " " + radius + "; ");
        this.fx_lbDndTitle = new Label();
        this.fx_lbDndTitle.setAlignment(Pos.CENTER);
        HBox.setMargin((Node)this.fx_lbDndTitle, (Insets)new Insets(0.0, 5.0, 0.0, 0.0));
        this.fx_lbDndTitle.setStyle("-fx-font-size:9pt;-fx-text-fill: white;-fx-font-family: \"Arial\";-fx-background-color: #e65d5d;-fx-border-radius: " + radius + " " + radius + " " + radius + " " + radius + "; -fx-background-radius: " + radius + " " + radius + " " + radius + " " + radius + "; ");
        this.addSessionTextFlow();
        this.bind(this.sessionInfo);
    }

    private void addGroupStateImageView() {
        this.fx_ivState = new ImageView();
        this.fx_ivState.setFitWidth(10.0);
        this.fx_ivState.setFitHeight(10.0);
        this.fx_ivState.setPickOnBounds(true);
        this.fx_ivState.setPreserveRatio(true);
        this.hbState.getChildren().add(0, (Object)this.fx_ivState);
    }

    private void addStateImageView() {
        this.statesPane = StatesPane.getInstance(StatesPane.VIEW_MODE.HANDLER_MODE);
        VBox.setVgrow((Node)this.statesPane, (Priority)Priority.ALWAYS);
        this.hbState.getChildren().add(0, (Object)this.statesPane);
    }

    public void setMute() {
        if (this.fx_MutePane == null) {
            this.fx_MutePane = new HBox();
            this.fx_MutePane.setAlignment(Pos.CENTER);
            HBox.setMargin((Node)this.fx_MutePane, (Insets)new Insets(0.0, 2.0, 0.0, 2.0));
            ImageView imageView = new ImageView();
            imageView.setFitHeight(10.0);
            imageView.setFitWidth(10.0);
            ClientSingleton.getInstance().setCachedImage(imageView, "group/not_disturb.png");
            this.fx_MutePane.getChildren().add((Object)imageView);
        }
        boolean check = false;
        if (this.sessionInfo.getProperty("nodisturb") != null) {
            check = (Boolean)this.sessionInfo.getProperty("nodisturb");
        }
        if (check) {
            if (!this.otherStatesPane.getChildren().contains((Object)this.fx_MutePane)) {
                this.otherStatesPane.getChildren().add((Object)this.fx_MutePane);
            }
        } else {
            this.otherStatesPane.getChildren().remove((Object)this.fx_MutePane);
        }
    }

    private void setNewMessages() {
        if (this.fx_lbNewMessageCount == null) {
            return;
        }
        long count = ClientSingleton.getInstance().getNewMessagesCount(this.sessionInfo);
        if (count == 0L) {
            if (!this.fx_lbNewMessageCount.getText().isEmpty()) {
                this.fx_lbNewMessageCount.setText("");
                this.fx_lbNewMessageCount.setMaxWidth(0.0);
                this.fx_lbNewMessageCount.setPrefWidth(0.0);
                this.otherStatesPane.getChildren().remove((Object)this.fx_lbNewMessageCount);
            }
        } else {
            String sCount = String.valueOf(count);
            if (!this.fx_lbNewMessageCount.getText().equals(sCount)) {
                double width = sCount.length() * 8 + 10;
                this.fx_lbNewMessageCount.setText(sCount);
                this.fx_lbNewMessageCount.setMinWidth(width);
                this.fx_lbNewMessageCount.setMaxWidth(width);
                this.fx_lbNewMessageCount.setPrefWidth(width);
            }
            if (!this.otherStatesPane.getChildren().contains((Object)this.fx_lbNewMessageCount)) {
                this.otherStatesPane.getChildren().add(0, (Object)this.fx_lbNewMessageCount);
            }
        }
    }

    public void setDnDState(boolean visible) {
        if (this.fx_lbDndTitle == null) {
            return;
        }
        if (visible && this.sessionInfo.isGroup()) {
            visible = false;
        }
        if (!visible) {
            if (!this.fx_lbDndTitle.getText().isEmpty()) {
                this.fx_lbDndTitle.setText("");
                this.fx_lbDndTitle.setMaxWidth(0.0);
                this.fx_lbDndTitle.setPrefWidth(0.0);
            }
            this.fx_hbSessionName.getChildren().remove((Object)this.fx_lbDndTitle);
        } else {
            if (this.fx_lbDndTitle.getText().isEmpty()) {
                double width = new Text("DnD").getLayoutBounds().getWidth() + 8.0;
                this.fx_lbDndTitle.setText("DnD");
                this.fx_lbDndTitle.setMaxWidth(width);
                this.fx_lbDndTitle.setPrefWidth(width);
            }
            if (!this.dndPane.getChildren().contains((Object)this.fx_lbDndTitle)) {
                this.dndPane.getChildren().add((Object)this.fx_lbDndTitle);
            }
        }
    }

    public void setState() {
        ContactInfo contactInfo = null;
        if (!this.sessionInfo.isGroup() && this.sessionInfo.getParties() != null && !this.sessionInfo.getParties().isEmpty()) {
            contactInfo = (ContactInfo)this.sessionInfo.getParties().get(0);
        }
        if (contactInfo == null) {
            return;
        }
        this.setDnDState(contactInfo.getState() == 3);
        if (this.statesPane != null) {
            if (!ClientSingleton.getInstance().isContactInfoApproved(contactInfo)) {
                this.statesPane.setPaneVisibility(false);
            } else {
                this.statesPane.setState(contactInfo.getState());
            }
        }
    }

    private void setIvState() {
        if (this.fx_ivState != null) {
            ClientSingleton.getInstance().setCachedImage(this.fx_ivState, this.sessionInfo.isChannel() ? "tab/sessions/list_channel.png" : "tab/sessions/list_group.png");
        }
    }

    private String getDateTime(MessageInfo messageInfo) {
        try {
            return ClientSingleton.getInstance().getDateTimeString(messageInfo.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public int compareTo(SessionCellView sessionCellView) {
        SessionInfo rSessionInfo = this.sessionInfo;
        SessionInfo lSessionInfo = sessionCellView.getSessionInfo();
        if (this.isPinnedChat() && sessionCellView.isPinnedChat()) {
            return (int)((lSessionInfo.getLastChatMessage() != null ? lSessionInfo.getLastChatMessage().getTime() : -1L) - (rSessionInfo.getLastChatMessage() != null ? rSessionInfo.getLastChatMessage().getTime() : -1L));
        }
        if (this.isPinnedChat() && !sessionCellView.isPinnedChat()) {
            return -1;
        }
        if (!this.isPinnedChat() && sessionCellView.isPinnedChat()) {
            return 1;
        }
        if (rSessionInfo.getLastChatMessage() == null && lSessionInfo.getLastChatMessage() == null) {
            return 0;
        }
        if (rSessionInfo.getLastChatMessage() != null && lSessionInfo.getLastChatMessage() == null) {
            return -1;
        }
        if (rSessionInfo.getLastChatMessage() == null && lSessionInfo.getLastChatMessage() != null) {
            return 1;
        }
        if (rSessionInfo.getLastChatMessage() != null && lSessionInfo.getLastChatMessage() != null) {
            return Long.compare(lSessionInfo.getLastChatMessage().getTime(), rSessionInfo.getLastChatMessage().getTime());
        }
        return rSessionInfo.compareTo((Object)lSessionInfo);
    }

    @Override
    public SessionInfo getSessionInfo() {
        return this.sessionInfo;
    }

    @Override
    public String toString() {
        return this.sessionInfo.toString();
    }

    @Override
    public void update() {
        if (!this.sessionInfo.isGroup()) {
            this.setState();
        }
        super.update();
    }

    @Override
    public void updateNewMessages() {
        this.setNewMessages();
        this.setLastMessageContent();
        this.setState();
    }

    public boolean isPinnedChat() {
        boolean isPin = false;
        if (this.sessionInfo.getProperty("PinChat") != null) {
            isPin = (Boolean)this.sessionInfo.getProperty("PinChat");
        }
        return isPin;
    }

    public void bind(SessionInfo sessionInfo) {
        super.setInfoCell(sessionInfo);
        this.sessionInfo = sessionInfo;
        if (sessionInfo.isGroup()) {
            if (this.statesPane != null) {
                this.hbState.getChildren().remove((Object)this.statesPane);
            }
            if (this.fx_ivState == null) {
                this.addGroupStateImageView();
            } else if (!this.hbState.getChildren().contains((Object)this.fx_ivState)) {
                this.hbState.getChildren().add(0, (Object)this.fx_ivState);
            }
            this.setIvState();
            this.setDnDState(false);
        } else {
            if (this.fx_ivState != null) {
                this.hbState.getChildren().remove((Object)this.fx_ivState);
            }
            if (this.statesPane == null) {
                this.addStateImageView();
            } else if (!this.hbState.getChildren().contains((Object)this.statesPane)) {
                this.hbState.getChildren().add(0, (Object)this.statesPane);
            }
            this.setState();
            if (!this.statesPane.isPaneVisibility()) {
                this.hbState.getChildren().remove((Object)this.statesPane);
                if (this.fx_ivState == null) {
                    this.addGroupStateImageView();
                } else if (!this.hbState.getChildren().contains((Object)this.fx_ivState)) {
                    this.hbState.getChildren().add(0, (Object)this.fx_ivState);
                }
                this.setDnDState(false);
                ClientSingleton.getInstance().setCachedImage(this.fx_ivState, "tab/sessions/external_chat_icon.png");
            }
        }
        this.setName();
        this.setNewMessages();
        this.setMute();
        this.update();
        this.setLastMessageContent();
    }

    private HBox getSecondLine() {
        if (this.secondLine == null) {
            this.secondLine = new HBox();
            this.secondLine.prefWidthProperty().bind((ObservableValue)this.vbItemContent.prefWidthProperty());
            this.secondLine.setAlignment(Pos.CENTER_LEFT);
            this.vbItemContent.getChildren().add((Object)this.secondLine);
        }
        return this.secondLine;
    }

    private void setArrowImage() {
        MessageInfo messageInfo;
        if (this.ivArrowImage != null && (messageInfo = this.sessionInfo.getLastChatMessage()) != null) {
            ClientSingleton.getInstance().setArrowPngName(this.ivArrowImage, messageInfo);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.fx_hbSessionName.prefWidthProperty().unbind();
        if (this.sessionInfo != null) {
            this.secondLine.prefWidthProperty().unbind();
        }
        this.hbState.prefHeightProperty().unbind();
        this.hbArrow.prefHeightProperty().unbind();
        this.otherStatesPane.prefHeightProperty().unbind();
    }
}

