/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.tabs.sessions.flow;

import java.util.List;
import java.util.Optional;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ArrowImageButton;
import net.sipsnet.client.views.tabs.sessions.flow.utils.SessionInfoHeader;
import net.sipsnet.client.views.tabs.utils.ISessionsTabActions;
import smile.cti.client.SessionInfo;

public class SessionHeaderCellView
extends HBox {
    private Label fx_lbTitle;
    private final ISessionsTabActions iSessionsTabActions;
    private final Label fx_lbNewMessageCount = new Label();
    private SessionInfoHeader sessionInfoHeader;
    private ArrowImageButton fx_ivArrow;

    public double computeMinWidth(double height) {
        return 280.0;
    }

    public double computePrefWidth(double height) {
        return 280.0;
    }

    public double computePrefHeight(double height) {
        return 32.0;
    }

    public SessionHeaderCellView(ISessionsTabActions iSessionsTabActions, SessionInfoHeader sessionInfoHeader) {
        this.iSessionsTabActions = iSessionsTabActions;
        this.sessionInfoHeader = sessionInfoHeader;
        this.setStyle("-fx-background-color: transparent;");
        this.setPadding(new Insets((double)(sessionInfoHeader.getType() == 0 ? 0 : 5), 0.0, 5.0, 12.0));
        Optional<Boolean> isCollapsed = ClientSingleton.getInstance().getBooleanProperty(sessionInfoHeader.getType() == 0 ? "groups_collapsed" : "direct_session_collapsed");
        sessionInfoHeader.setCollapse(isCollapsed.orElse(false));
        this.initComponents();
        this.setTitle();
        this.setNewMessagesLabel();
    }

    public int getType() {
        return this.sessionInfoHeader.getType();
    }

    private void setTitle() {
        this.fx_lbTitle.setText(this.sessionInfoHeader.getTitle());
    }

    public String getTitle() {
        return ((Object)((Object)this)).hashCode() + " " + this.fx_lbTitle.getText();
    }

    public String toString() {
        return this.getSessionId();
    }

    public String getSessionId() {
        if (this.getType() == 0) {
            return "groups";
        }
        return "direct_sessions";
    }

    public void setMemberViewers(List<SessionInfo> sessionInfos) {
        this.sessionInfoHeader.setMemberLists(sessionInfos);
        this.setNewMessagesLabel();
    }

    public void setNewMessagesLabel() {
        boolean isVisible = this.sessionInfoHeader.isHasNewMessages();
        if (this.fx_lbNewMessageCount.isVisible() && !isVisible || !this.fx_lbNewMessageCount.isVisible() && isVisible) {
            ClientSingleton.getInstance().runLater(() -> this.fx_lbNewMessageCount.setVisible(isVisible));
        }
    }

    private void initComponents() {
        this.prefHeight(50.0);
        this.minHeight(50.0);
        this.maxHeight(50.0);
        this.setAlignment(Pos.CENTER_LEFT);
        this.fx_lbTitle = new Label();
        this.fx_lbTitle.prefHeight(40.0);
        Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)this.fx_lbTitle);
        this.fx_lbTitle.setStyle("-fx-font-size: 13px;");
        this.getChildren().add((Object)this.fx_lbTitle);
        HBox hBox = new HBox();
        hBox.setAlignment(Pos.CENTER);
        hBox.setPrefWidth(30.0);
        hBox.setMinWidth(30.0);
        this.fx_ivArrow = new ArrowImageButton(!this.sessionInfoHeader.isCollapse());
        HBox.setMargin((Node)this.fx_ivArrow, (Insets)new Insets(0.0, 10.0, 0.0, 10.0));
        this.fx_ivArrow.setSize(14, 14);
        this.fx_ivArrow.setBackgroundColor("transparent");
        this.fx_ivArrow.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> this.fx_ivArrow.makeClick()));
        this.fx_lbNewMessageCount.setMaxWidth(6.0);
        this.fx_lbNewMessageCount.setMaxHeight(6.0);
        this.fx_lbNewMessageCount.setMinWidth(6.0);
        this.fx_lbNewMessageCount.setMinHeight(6.0);
        this.fx_lbNewMessageCount.setStyle("-fx-background-color: #f7bd40;-fx-border-radius: 3 3 3 3; -fx-background-radius: 3 3 3 3; ");
        this.fx_lbNewMessageCount.setVisible(false);
        hBox.getChildren().add((Object)this.fx_ivArrow);
        hBox.getChildren().add((Object)this.fx_lbNewMessageCount);
        this.getChildren().add((Object)hBox);
        ClientSingleton.getInstance().setMouseCursor((Node)hBox);
        ClientSingleton.getInstance().setMouseCursor((Node)this.fx_lbTitle);
        hBox.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> this.makeClick());
        this.fx_lbTitle.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> this.makeClick());
    }

    private void collapse() {
        boolean isCollapse = !this.sessionInfoHeader.isCollapse();
        ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "collapse isCollapse=" + isCollapse);
        this.sessionInfoHeader.setCollapse(isCollapse);
        if (isCollapse) {
            this.iSessionsTabActions.removeCells(this.sessionInfoHeader);
        } else {
            this.iSessionsTabActions.addCells(this.sessionInfoHeader);
        }
    }

    public void makeClick() {
        ClientSingleton.getInstance().runLater(this::click);
    }

    public void click() {
        this.collapse();
        this.fx_ivArrow.makeClick();
    }

    public void bind(SessionInfoHeader sessionInfoHeader) {
        this.sessionInfoHeader = sessionInfoHeader;
        this.setTitle();
        this.setNewMessagesLabel();
    }
}

