/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.tabs.speeddial.flow;

import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.MenuItem;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.connector.utils.AudioCaller;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.constants.IntentConstants;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.utils.viewers.combobox.MaxSizedContextMenu;
import net.sipsnet.client.views.tabs.speeddial.flow.utils.AvatarViewHolder;
import net.sipsnet.client.views.tabs.speeddial.flow.utils.BaseViewHolder;
import net.sipsnet.client.views.tabs.speeddial.flow.utils.BlfViewHolder;
import net.sipsnet.client.views.tabs.speeddial.flow.utils.ThreeObjects;
import smile.cti.client.ContactInfo;
import smile.cti.client.LineInfo;

public class SpeedDialCellView
extends HBox {
    private final double width = 96.66666412353516;
    private final double height = 100.0;
    private final ThreeObjects<ContactInfo, ContactInfo, ContactInfo> contactsPair;
    private final GridPane grid = new GridPane();

    public double computeMinWidth(double height) {
        return 280.0;
    }

    public double computePrefWidth(double height) {
        return 280.0;
    }

    public double computePrefHeight(double height) {
        return this.height;
    }

    public SpeedDialCellView(ThreeObjects<ContactInfo, ContactInfo, ContactInfo> contactsPair) {
        BaseViewHolder firstBaseViewHolder;
        this.contactsPair = contactsPair;
        this.grid.setHgap(5.0);
        this.grid.setVgap(5.0);
        BaseViewHolder secondBaseViewHolder = null;
        BaseViewHolder thirdBaseViewHolder = null;
        ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "SpeedDialCellView " + contactsPair.getFirst() + " " + contactsPair.getSecond() + " " + contactsPair.getThird());
        if (contactsPair.getFirst().isBlf()) {
            firstBaseViewHolder = this.addBLFContactInfo(contactsPair.getFirst(), 70.0);
            if (contactsPair.getSecond() != null) {
                secondBaseViewHolder = this.addBLFContactInfo(contactsPair.getSecond(), 70.0);
            }
            if (contactsPair.getThird() != null) {
                thirdBaseViewHolder = this.addBLFContactInfo(contactsPair.getThird(), 70.0);
            }
        } else {
            firstBaseViewHolder = this.addContactInfo(contactsPair.getFirst());
            if (contactsPair.getSecond() != null) {
                secondBaseViewHolder = this.addContactInfo(contactsPair.getSecond());
            }
            if (contactsPair.getThird() != null) {
                thirdBaseViewHolder = this.addContactInfo(contactsPair.getThird());
            }
        }
        GridPane.setColumnIndex((Node)firstBaseViewHolder, (Integer)0);
        GridPane.setRowIndex((Node)firstBaseViewHolder, (Integer)0);
        this.grid.getChildren().add((Object)firstBaseViewHolder);
        if (secondBaseViewHolder != null) {
            GridPane.setColumnIndex((Node)secondBaseViewHolder, (Integer)1);
            GridPane.setRowIndex((Node)secondBaseViewHolder, (Integer)0);
            this.grid.getChildren().add((Object)secondBaseViewHolder);
        }
        if (thirdBaseViewHolder != null) {
            GridPane.setColumnIndex((Node)thirdBaseViewHolder, (Integer)2);
            GridPane.setRowIndex((Node)thirdBaseViewHolder, (Integer)0);
            this.grid.getChildren().add((Object)thirdBaseViewHolder);
        }
        this.getChildren().add((Object)this.grid);
        HBox.setHgrow((Node)this.grid, (Priority)Priority.ALWAYS);
        this.setMinHeight(100.0);
        this.setMaxHeight(100.0);
        ClientSingleton.getInstance().setFocusNotTraversable((Pane)this);
    }

    public boolean setSpeedDialCellState(ContactInfo contactInfo) {
        ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "setCellState contactInfo=" + contactInfo + " BLF " + this.contactsPair.getFirst() + "contactInfo.getState() = " + contactInfo.getState());
        if (this.contactsPair.getFirst().isBlf() && this.contactsPair.getFirst().getUserID().equals(ClientSingleton.getInstance().getUserID(contactInfo))) {
            ((BlfViewHolder)((Object)this.grid.getChildren().get(0))).setBLFState(contactInfo.getState());
            return true;
        }
        if (this.contactsPair.getSecond() != null && this.contactsPair.getSecond().isBlf() && this.contactsPair.getSecond().getUserID().equals(ClientSingleton.getInstance().getUserID(contactInfo))) {
            ((BlfViewHolder)((Object)this.grid.getChildren().get(1))).setBLFState(contactInfo.getState());
            return true;
        }
        if (this.contactsPair.getThird() != null && this.contactsPair.getThird().isBlf() && this.contactsPair.getThird().getUserID().equals(ClientSingleton.getInstance().getUserID(contactInfo))) {
            ((BlfViewHolder)((Object)this.grid.getChildren().get(2))).setBLFState(contactInfo.getState());
            return true;
        }
        return false;
    }

    private BlfViewHolder addBLFContactInfo(ContactInfo contactInfo, double height) {
        ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "addBLFContactInfo contactInfo=" + contactInfo + " BLF contactInfo.getState() = " + contactInfo.getState());
        BlfViewHolder blfViewHolder = new BlfViewHolder(contactInfo);
        blfViewHolder.setMinHeight(height);
        blfViewHolder.setMaxHeight(height);
        blfViewHolder.setPrefHeight(height);
        blfViewHolder.setMinWidth(96.66666412353516);
        blfViewHolder.setMinWidth(96.66666412353516);
        blfViewHolder.setPrefWidth(96.66666412353516);
        return blfViewHolder;
    }

    private AvatarViewHolder addContactInfo(ContactInfo contactInfo) {
        AvatarViewHolder avatarViewHolder = new AvatarViewHolder(contactInfo, 100.0f);
        ClientSingleton.getInstance().setMouseCursor((Node)avatarViewHolder);
        avatarViewHolder.addEventHandler(MouseEvent.MOUSE_ENTERED, mouseEvent -> avatarViewHolder.setSelected(true));
        avatarViewHolder.addEventHandler(MouseEvent.MOUSE_EXITED, mouseEvent -> avatarViewHolder.setSelected(false));
        avatarViewHolder.addEventHandler(MouseEvent.MOUSE_PRESSED, mouseEvent -> {
            if (mouseEvent.isSecondaryButtonDown()) {
                MaxSizedContextMenu myContextMenu = this.addMenu(contactInfo);
                myContextMenu.show((Node)avatarViewHolder, mouseEvent.getScreenX(), mouseEvent.getScreenY());
            } else {
                AudioCaller.makeCall(contactInfo.getSpeedDialNumber(), false);
            }
        });
        avatarViewHolder.setMinHeight(100.0);
        avatarViewHolder.setMaxHeight(100.0);
        avatarViewHolder.setPrefHeight(100.0);
        avatarViewHolder.setMinWidth(96.66666412353516);
        avatarViewHolder.setMinWidth(96.66666412353516);
        avatarViewHolder.setPrefWidth(96.66666412353516);
        return avatarViewHolder;
    }

    private MaxSizedContextMenu addMenu(ContactInfo contactInfo) {
        LineInfo lineInfo;
        boolean hasNotActiveLine;
        MaxSizedContextMenu myContextMenu = new MaxSizedContextMenu();
        myContextMenu.setMaxHeight(300.0);
        myContextMenu.setMinWidth(150.0);
        myContextMenu.setPrefWidth(150.0);
        myContextMenu.setMaxWidth(150.0);
        Theme.getInstance().applyTo(Constants.CONTEXT_MENU, (Pane)this);
        MenuItem menuItem = new MenuItem(ClientSingleton.getInstance().getString("call_menu_dial"));
        menuItem.setOnAction(event -> AudioCaller.makeCall(contactInfo.getSpeedDialNumber(), false));
        myContextMenu.getItems().add((Object)menuItem);
        List trunks = ClientSingleton.getInstance().getClientConnector().get().getTrunks(null);
        if (trunks != null && trunks.size() > 1) {
            menuItem = new MenuItem(ClientSingleton.getInstance().getString("call_menu_dial_as"));
            menuItem.setOnAction(event1 -> AudioCaller.makeAudioCallToExternal(contactInfo.toString(), List.of(contactInfo.getSpeedDialNumber()), trunks));
            myContextMenu.getItems().add((Object)menuItem);
        }
        boolean bl = hasNotActiveLine = (lineInfo = AudioCaller.getActiveLine()) != null && (lineInfo.getState() == 2 || lineInfo.getState() == 1 || lineInfo.getState() == 15);
        if (lineInfo != null && !hasNotActiveLine) {
            menuItem = new MenuItem(ClientSingleton.getInstance().getString("call_menu_blind_tr"));
            menuItem.setOnAction(event -> {
                if (lineInfo.getState() != 4) {
                    AudioCaller.setHoldLine(lineInfo);
                }
                TimerExecutor.getInstance().setMyAction(() -> ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> clientConnector.transferCall(contactInfo))).startWithDelay(300L);
            });
            myContextMenu.getItems().add((Object)menuItem);
            menuItem = new MenuItem(ClientSingleton.getInstance().getString("call_menu_attended_tr"));
            menuItem.setOnAction(event -> {
                if (lineInfo.getState() != 4) {
                    AudioCaller.setHoldLine(lineInfo);
                }
                TimerExecutor.getInstance().setMyAction(() -> AudioCaller.makeCall(contactInfo)).startWithDelay(300L);
            });
            myContextMenu.getItems().add((Object)menuItem);
            menuItem = new MenuItem(ClientSingleton.getInstance().getString("call_menu_conference"));
            menuItem.setOnAction(event -> AudioCaller.makeCall(contactInfo));
            myContextMenu.getItems().add((Object)menuItem);
        }
        ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "SpeedDial contactInfo=" + contactInfo + " isCustomSpeedDial=" + contactInfo.isCustomSpeedDial());
        if (contactInfo.isCustomSpeedDial()) {
            menuItem = new MenuItem(ClientSingleton.getInstance().getString("speed_dial_delete"));
            menuItem.setOnAction(event -> ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                ClientSingleton.getInstance().addLoadingPane(ClientSingleton.getInstance().getString("speed_dial_deleting"));
                TimerExecutor.getInstance().start(() -> {
                    try {
                        clientConnector.deleteSpeedDialContact(contactInfo);
                        Thread.sleep(300L);
                    }
                    catch (Exception e) {
                        ClientSingleton.getInstance().removeLoadingPane();
                        e.printStackTrace();
                    }
                    ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "speed_dial_delete " + contactInfo + " IntentConstants.CONTACT_REMOVED");
                    ClientSingleton.getInstance().doNotify(IntentConstants.CONTACT_REMOVED);
                });
            }));
            myContextMenu.getItems().add((Object)menuItem);
        }
        return myContextMenu;
    }
}

