/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.tabs.speeddial.flow;

import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ArrowImageButton;
import net.sipsnet.client.views.tabs.speeddial.flow.utils.SpeedDialHeader;
import net.sipsnet.client.views.tabs.utils.ISpeedDialTabActions;

public class SpeedDialHeaderCellView
extends HBox {
    private Label fx_lbTitle;
    private ArrowImageButton fx_ivArrow;
    private final ISpeedDialTabActions iTabActions;
    private final SpeedDialHeader speedDialHeader;

    public double computeMinWidth(double height) {
        return 280.0;
    }

    public double computePrefWidth(double height) {
        return 280.0;
    }

    public double computePrefHeight(double height) {
        return 32.0;
    }

    public SpeedDialHeaderCellView(ISpeedDialTabActions iTabActions, SpeedDialHeader speedDialHeader) {
        this.speedDialHeader = speedDialHeader;
        this.iTabActions = iTabActions;
        this.setStyle("-fx-background-color: transparent;");
        this.setPadding(new Insets(0.0, 0.0, 0.0, 18.0));
        this.initComponents();
        this.fx_lbTitle.setText(speedDialHeader.getTitle());
        ClientSingleton.getInstance().setFocusNotTraversable((Pane)this);
    }

    private void initComponents() {
        this.setPadding(new Insets(5.0, 0.0, 5.0, 18.0));
        this.fx_lbTitle = new Label();
        this.fx_lbTitle.prefHeight(40.0);
        Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)this.fx_lbTitle);
        this.fx_lbTitle.setStyle("-fx-font-size: 13px;");
        this.getChildren().add((Object)this.fx_lbTitle);
        HBox hBox = new HBox();
        hBox.setAlignment(Pos.CENTER);
        hBox.setPrefWidth(30.0);
        hBox.setMinWidth(30.0);
        VBox.setMargin((Node)hBox, (Insets)new Insets(10.0, 0.0, 10.0, 0.0));
        this.fx_ivArrow = new ArrowImageButton(!this.speedDialHeader.isCollapse());
        this.fx_ivArrow.setSize(14, 14);
        this.fx_ivArrow.setBackgroundColor("transparent");
        this.fx_ivArrow.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> this.fx_ivArrow.makeClick()));
        hBox.getChildren().add((Object)this.fx_ivArrow);
        this.getChildren().add((Object)hBox);
        ClientSingleton.getInstance().setMouseCursor((Node)hBox);
        ClientSingleton.getInstance().setMouseCursor((Node)this.fx_lbTitle);
        hBox.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            this.collapse();
            this.fx_ivArrow.makeClick();
        });
        this.fx_lbTitle.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            this.collapse();
            this.fx_ivArrow.makeClick();
        });
    }

    private void collapse() {
        this.speedDialHeader.setCollapse(!this.speedDialHeader.isCollapse());
        if (this.speedDialHeader.isCollapse()) {
            this.iTabActions.removeCells(this.speedDialHeader);
        } else {
            this.iTabActions.addCells(this.speedDialHeader);
        }
    }
}

