/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.tabs.speeddial.flow;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.observer.IGUIObservable;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.constants.IntentConstants;
import net.sipsnet.client.utils.threadpool.UpdateListThreadPoolManager;
import net.sipsnet.client.views.tabs.speeddial.flow.SpeedDialCellView;
import net.sipsnet.client.views.tabs.speeddial.flow.SpeedDialHeaderCellView;
import net.sipsnet.client.views.tabs.speeddial.flow.utils.SpeedDialHeader;
import net.sipsnet.client.views.tabs.speeddial.flow.utils.ThreeObjects;
import net.sipsnet.client.views.tabs.speeddial.flow.utils.UpdateSpeedDialListTask;
import net.sipsnet.client.views.tabs.utils.ISpeedDialTabActions;
import org.fxmisc.flowless.Cell;
import org.fxmisc.flowless.VirtualFlow;
import org.fxmisc.flowless.VirtualizedScrollPane;
import smile.cti.client.ContactInfo;

public class TabSpeedDialController
extends AnchorPane
implements IGUIObservable,
ISpeedDialTabActions {
    private final ObservableList<ThreeObjects<ContactInfo, ContactInfo, ContactInfo>> contactInfoPairList = FXCollections.observableArrayList();
    private SpeedDialHeader speedDialBLFHeader;
    private SpeedDialHeader speedDialHeader;
    private final VirtualFlow<ThreeObjects<ContactInfo, ContactInfo, ContactInfo>, ?> virtualFlow = VirtualFlow.createVertical(this.contactInfoPairList, contactInfoPair -> {
        ContactInfo contactInfo = (ContactInfo)contactInfoPair.getFirst();
        HBox cell = contactInfo instanceof SpeedDialHeader ? new SpeedDialHeaderCellView(this, (SpeedDialHeader)contactInfo) : new SpeedDialCellView((ThreeObjects<ContactInfo, ContactInfo, ContactInfo>)contactInfoPair);
        ClientSingleton.toLog(this.getClass().getSimpleName(), "speed cell=" + cell);
        cell.prefWidthProperty().bind((ObservableValue)this.widthProperty().subtract(10));
        cell.applyCss();
        cell.layout();
        return Cell.wrapNode((Node)cell);
    });
    private final VirtualizedScrollPane<VirtualFlow<ThreeObjects<ContactInfo, ContactInfo, ContactInfo>, ?>> scrollPane = new VirtualizedScrollPane(this.virtualFlow, ScrollPane.ScrollBarPolicy.NEVER, ScrollPane.ScrollBarPolicy.AS_NEEDED);

    public TabSpeedDialController() {
        this.getChildren().add(this.scrollPane);
        AnchorPane.setTopAnchor(this.scrollPane, (Double)0.0);
        AnchorPane.setLeftAnchor(this.scrollPane, (Double)0.0);
        AnchorPane.setBottomAnchor(this.scrollPane, (Double)0.0);
        AnchorPane.setRightAnchor(this.scrollPane, (Double)0.0);
        Theme.getInstance().applyTo(Constants.TABS_VIRTUALIZED_SCROLL, (Pane)this);
        String[] actions = new String[]{IntentConstants.CONTACT_ADDED, IntentConstants.CONTACT_REMOVED};
        ClientSingleton.getInstance().addObserver(this, actions);
    }

    public void refreshList() {
        this.refreshList(null);
    }

    public void refreshList(String prefix) {
        UpdateListThreadPoolManager executorService = UpdateListThreadPoolManager.getInstance();
        UpdateSpeedDialListTask getSelectedContacts = new UpdateSpeedDialListTask(prefix);
        getSelectedContacts.setOnSucceeded(event -> {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "setList setOnSchedulerSucceeded=" + getSelectedContacts.getValue());
            this.setList((List)getSelectedContacts.getValue());
        });
        executorService.execute((Runnable)((Object)getSelectedContacts));
    }

    private void setList(List<ThreeObjects<ContactInfo, ContactInfo, ContactInfo>> members) {
        this.contactInfoPairList.clear();
        this.contactInfoPairList.addAll(members);
        this.virtualFlow.showAsFirst(0);
        this.virtualFlow.visibleCells();
        this.virtualFlow.applyCss();
        this.virtualFlow.layout();
    }

    @Override
    public void onNotifiedMessage(String action, Map<String, Object> data) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "notifyMessage_ action=" + action + " data=" + data);
        if (action.equals(IntentConstants.CONTACT_REMOVED) || action.equals(IntentConstants.CONTACT_ADDED)) {
            ContactInfo contactInfo;
            if (action.equals(IntentConstants.CONTACT_ADDED) && (contactInfo = (ContactInfo)data.get("contactInfo")) != null && !contactInfo.isSpeedDial() && !contactInfo.isBlf()) {
                return;
            }
            this.refreshList();
        }
    }

    public void updateSpeedDialHandler(ContactInfo contactInfo) {
        if (contactInfo != null && contactInfo.isBlf()) {
            ClientSingleton.getInstance().runLater(() -> this.onUpdateHandler(contactInfo));
        }
    }

    private void onUpdateHandler(ContactInfo contactInfo) {
        boolean changed;
        Cell cell;
        Optional optional;
        for (int index = 0; !(index >= this.contactInfoPairList.size() || (optional = this.virtualFlow.getCellIfVisible(index)).isPresent() && (cell = (Cell)optional.get()).getNode() instanceof SpeedDialCellView && (changed = ((SpeedDialCellView)cell.getNode()).setSpeedDialCellState(contactInfo))); ++index) {
        }
    }

    @Override
    public void refreshSpeedDialList() {
    }

    @Override
    public void removeCells(SpeedDialHeader speedDialHeader) {
        int i = Collections.indexOfSubList(this.contactInfoPairList, speedDialHeader.getMemberLists());
        if (i != -1) {
            this.contactInfoPairList.subList(i, i + speedDialHeader.getMemberLists().size()).clear();
        }
    }

    @Override
    public void addCells(SpeedDialHeader speedDialHeader) {
        for (int index = 0; index < this.contactInfoPairList.size(); ++index) {
            ContactInfo contactInfo = (ContactInfo)((ThreeObjects)this.contactInfoPairList.get(index)).getFirst();
            if (!(contactInfo instanceof SpeedDialHeader) || !speedDialHeader.equals(contactInfo)) continue;
            this.contactInfoPairList.addAll(index + 1, speedDialHeader.getMemberLists());
            break;
        }
    }
}

