/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.tabs.speeddial.flow.utils;

import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.constants.Constants;
import smile.cti.client.ContactInfo;

public class BaseViewHolder
extends VBox {
    private final ContactInfo contactInfo;
    private final float avatarWidth = 50.0f;
    private final Label myLabel;

    public float getAvatarWidth() {
        return this.contactInfo.isBlf() ? 25.0f : 50.0f;
    }

    public BaseViewHolder(ContactInfo contactInfo) {
        this.contactInfo = contactInfo;
        this.setAlignment(Pos.CENTER);
        this.setMaxWidth(50.0);
        this.setMinWidth(50.0);
        HBox hBox = new HBox();
        VBox.setVgrow((Node)hBox, (Priority)Priority.ALWAYS);
        hBox.setAlignment(Pos.CENTER);
        hBox.setPadding(new Insets(0.0, 10.0, 5.0, 10.0));
        hBox.prefWidthProperty().bind((ObservableValue)this.widthProperty().subtract(10));
        this.myLabel = new Label();
        Theme.getInstance().applyTo(Constants.TABS_TITLE_TEXT_FILL, (Labeled)this.myLabel);
        this.myLabel.setWrapText(true);
        this.myLabel.setText(contactInfo.toString());
        this.myLabel.setTextAlignment(TextAlignment.CENTER);
        HBox.setHgrow((Node)this.myLabel, (Priority)Priority.ALWAYS);
        hBox.getChildren().add((Object)this.myLabel);
        this.getChildren().add((Object)hBox);
        this.setSelected(false);
    }

    public void setSelected(boolean mode) {
        String color = ClientSingleton.getInstance().getStyleValue(Constants.SECOND_BASE_COLOR);
        String style = "-fx-background-color:" + (mode ? (Theme.getInstance().isDarkTheme() ? "#595959" : "#d9e0ef") : color) + ";-fx-border-radius: 8 8 8 8;-fx-background-radius: 8 8 8 8;-fx-background-insets: 4 4 4 4;";
        this.setStyle(style);
        this.myLabel.setStyle("-fx-background-color:" + (String)(mode ? (Theme.getInstance().isDarkTheme() ? "#595959" : "#d9e0ef") : color + ";"));
    }
}

