/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Consumer;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.geometry.Bounds;
import javafx.scene.shape.Path;
import javafx.util.Duration;
import org.fxmisc.richtext.Caret;
import org.fxmisc.richtext.CustomCssMetaData;
import org.fxmisc.richtext.CustomStyleableProperty;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.ParagraphBox;
import org.fxmisc.richtext.model.PlainTextChange;
import org.fxmisc.richtext.model.TwoDimensional;
import org.reactfx.EventStream;
import org.reactfx.EventStreams;
import org.reactfx.StateMachine;
import org.reactfx.Subscription;
import org.reactfx.Suspendable;
import org.reactfx.SuspendableNo;
import org.reactfx.value.SuspendableVal;
import org.reactfx.value.Val;
import org.reactfx.value.Var;

public class CaretNode
extends Path
implements Caret,
Comparable<CaretNode> {
    private static final Duration HALF_A_SECOND = Duration.millis((double)500.0);
    private static final EventStream<Boolean> ALWAYS_FALSE = Val.constant(false).values();
    private static final EventStream<Boolean> ALWAYS_TRUE = Val.constant(true).values();
    private final StyleableObjectProperty<Duration> blinkRate = new CustomStyleableProperty<Duration>(HALF_A_SECOND, "blinkRate", this, BLINK_RATE);
    private final SuspendableVal<Integer> position;
    private final SuspendableVal<Integer> paragraphIndex;
    private final SuspendableVal<OptionalInt> lineIndex;
    private final SuspendableVal<Integer> columnPosition;
    private final Var<Caret.CaretVisibility> showCaret = Var.newSimpleVar(Caret.CaretVisibility.AUTO);
    private final SuspendableVal<Optional<Bounds>> bounds;
    private Optional<ParagraphBox.CaretOffsetX> targetOffset = Optional.empty();
    private final SuspendableNo beingUpdated = new SuspendableNo();
    private final GenericStyledArea<?, ?, ?> area;
    private final String name;
    private final SuspendableNo dependentBeingUpdated;
    private final EventStream<?> dirty;
    private final Var<Integer> internalTextPosition;
    private Subscription subscriptions = () -> {};
    private static final CssMetaData<CaretNode, Duration> BLINK_RATE = new CustomCssMetaData<CaretNode, Duration>("-rtfx-blink-rate", StyleConverter.getDurationConverter(), Duration.millis((double)500.0), s -> s.blinkRate);
    private static final List<CssMetaData<? extends Styleable, ?>> CSS_META_DATA_LIST;

    public ObjectProperty<Duration> blinkRateProperty() {
        return this.blinkRate;
    }

    @Override
    public Duration getBlinkRate() {
        return (Duration)this.blinkRate.getValue();
    }

    @Override
    public void setBlinkRate(Duration rate) {
        this.blinkRate.set((Object)rate);
    }

    @Override
    public final int getPosition() {
        return (Integer)this.position.getValue();
    }

    @Override
    public final ObservableValue<Integer> positionProperty() {
        return this.position;
    }

    @Override
    public final int getParagraphIndex() {
        return (Integer)this.paragraphIndex.getValue();
    }

    @Override
    public final ObservableValue<Integer> paragraphIndexProperty() {
        return this.paragraphIndex;
    }

    @Override
    public final OptionalInt getLineIndex() {
        return (OptionalInt)this.lineIndex.getValue();
    }

    @Override
    public final ObservableValue<OptionalInt> lineIndexProperty() {
        return this.lineIndex;
    }

    @Override
    public final int getColumnPosition() {
        return (Integer)this.columnPosition.getValue();
    }

    @Override
    public final ObservableValue<Integer> columnPositionProperty() {
        return this.columnPosition;
    }

    @Override
    public final Caret.CaretVisibility getShowCaret() {
        return (Caret.CaretVisibility)((Object)this.showCaret.getValue());
    }

    @Override
    public final void setShowCaret(Caret.CaretVisibility value) {
        this.showCaret.setValue((Object)value);
    }

    @Override
    public final Var<Caret.CaretVisibility> showCaretProperty() {
        return this.showCaret;
    }

    @Override
    public final Optional<Bounds> getCaretBounds() {
        return (Optional)this.bounds.getValue();
    }

    @Override
    public final ObservableValue<Optional<Bounds>> caretBoundsProperty() {
        return this.bounds;
    }

    @Override
    public final void clearTargetOffset() {
        this.targetOffset = Optional.empty();
    }

    @Override
    public final ParagraphBox.CaretOffsetX getTargetOffset() {
        if (!this.targetOffset.isPresent()) {
            this.targetOffset = Optional.of(this.area.getCaretOffsetX(this));
        }
        return this.targetOffset.get();
    }

    @Override
    public final boolean isBeingUpdated() {
        return this.beingUpdated.get();
    }

    public final SuspendableNo beingUpdatedProperty() {
        return this.beingUpdated;
    }

    @Override
    public GenericStyledArea<?, ?, ?> getArea() {
        return this.area;
    }

    @Override
    public final String getCaretName() {
        return this.name;
    }

    public CaretNode(String name, GenericStyledArea<?, ?, ?> area) {
        this(name, area, 0);
    }

    public CaretNode(String name, GenericStyledArea<?, ?, ?> area, int startingPosition) {
        this(name, area, area.beingUpdatedProperty(), startingPosition);
    }

    public CaretNode(String name, GenericStyledArea<?, ?, ?> area, SuspendableNo dependentBeingUpdated, int startingPosition) {
        this.name = name;
        this.area = area;
        this.dependentBeingUpdated = dependentBeingUpdated;
        this.getStyleClass().add((Object)"caret");
        this.setManaged(false);
        this.internalTextPosition = Var.newSimpleVar(startingPosition);
        this.position = this.internalTextPosition.suspendable();
        Val<TwoDimensional.Position> caretPosition2D = Val.create(() -> area.offsetToPosition((Integer)this.internalTextPosition.getValue(), TwoDimensional.Bias.Forward), new Observable[]{this.internalTextPosition, area.getParagraphs()});
        this.paragraphIndex = caretPosition2D.map(TwoDimensional.Position::getMajor).suspendable();
        this.columnPosition = caretPosition2D.map(TwoDimensional.Position::getMinor).suspendable();
        this.manageSubscription(area.multiPlainChanges(), list -> {
            int finalPosition = this.getPosition();
            for (PlainTextChange plainTextChange : list) {
                int netLength = plainTextChange.getNetLength();
                if (netLength == 0) continue;
                int indexOfChange = plainTextChange.getPosition();
                int endOfChange = indexOfChange + Math.abs(netLength);
                if (indexOfChange == finalPosition && netLength > 0) {
                    finalPosition += netLength;
                    continue;
                }
                if (indexOfChange >= finalPosition) continue;
                finalPosition = finalPosition < endOfChange ? indexOfChange : finalPosition + netLength;
            }
            if (finalPosition != this.getPosition()) {
                this.moveTo(finalPosition);
            }
        });
        EventStream blinkCaret = this.showCaret.values().flatMap(mode -> {
            switch (mode) {
                case ON: {
                    return ALWAYS_TRUE;
                }
                case OFF: {
                    return ALWAYS_FALSE;
                }
            }
            return area.autoCaretBlink();
        });
        this.dirty = EventStreams.merge(EventStreams.invalidationsOf(this.positionProperty()), EventStreams.invalidationsOf((Observable)area.getParagraphs()));
        EventStream<Duration> nonNullBlinkRates = EventStreams.valuesOf(this.blinkRate).filter(i -> i != null);
        this.manageSubscription(EventStreams.combine(blinkCaret, nonNullBlinkRates).flatMap(tuple -> {
            Boolean blink = (Boolean)tuple.get1();
            Duration rate = (Duration)tuple.get2();
            if (blink.booleanValue()) {
                return rate.lessThanOrEqualTo(Duration.ZERO) ? Val.constant(true).values() : CaretNode.booleanPulse(rate, this.dirty);
            }
            return Val.constant(false).values();
        }).feedTo(this.visibleProperty()));
        this.bounds = Val.create(() -> area.getCaretBoundsOnScreen(this), EventStreams.merge(area.viewportDirtyEvents(), this.dirty)).suspendable();
        this.lineIndex = Val.create(() -> OptionalInt.of(area.lineIndex(this.getParagraphIndex(), this.getColumnPosition())), this.dirty).suspendable();
        Suspendable omniSuspendable = Suspendable.combine(this.beingUpdated, this.lineIndex, this.bounds, this.paragraphIndex, this.columnPosition, this.position);
        this.manageSubscription(omniSuspendable.suspendWhen(dependentBeingUpdated));
    }

    @Override
    public void moveTo(int paragraphIndex, int columnPosition) {
        this.moveTo(this.textPosition(paragraphIndex, columnPosition));
    }

    @Override
    public void moveTo(int position) {
        Runnable updatePos = () -> this.internalTextPosition.setValue(position);
        if (this.isBeingUpdated()) {
            updatePos.run();
        } else {
            this.dependentBeingUpdated.suspendWhile(updatePos);
        }
    }

    @Override
    public void moveToParStart() {
        this.moveTo(this.getPosition() - this.getColumnPosition());
    }

    @Override
    public void moveToParEnd() {
        this.moveTo(this.getPosition() - this.getColumnPosition() + this.area.getParagraphLength(this.getParagraphIndex()));
    }

    @Override
    public void moveToAreaEnd() {
        this.moveTo(this.area.getLength());
    }

    @Override
    public void moveToNextChar() {
        this.moveTo(this.getPosition() + 1);
    }

    @Override
    public void moveToPrevChar() {
        this.moveTo(this.getPosition() - 1);
    }

    @Override
    public void moveBreaksBackwards(int numOfBreaks, BreakIterator breakIterator) {
        this.moveContentBreaks(numOfBreaks, breakIterator, false);
    }

    @Override
    public void moveBreaksForwards(int numOfBreaks, BreakIterator breakIterator) {
        this.moveContentBreaks(numOfBreaks, breakIterator, true);
    }

    @Override
    public int compareTo(CaretNode o) {
        return Integer.compare(this.hashCode(), o.hashCode());
    }

    @Override
    public void dispose() {
        this.subscriptions.unsubscribe();
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return String.format("CaretNode(name=%s position=%s paragraphIndex=%s columnPosition=%s %s)", this.getCaretName(), this.getPosition(), this.getParagraphIndex(), this.getColumnPosition(), super.toString());
    }

    private int textPosition(int row, int col) {
        return this.area.position(row, col).toOffset();
    }

    private <T> void manageSubscription(EventStream<T> stream, Consumer<T> subscriber) {
        this.manageSubscription(stream.subscribe(subscriber));
    }

    private void manageSubscription(Subscription s) {
        this.subscriptions = this.subscriptions.and(s);
    }

    private static EventStream<Boolean> booleanPulse(Duration javafxDuration, EventStream<?> restartImpulse) {
        java.time.Duration duration = java.time.Duration.ofMillis(Math.round(javafxDuration.toMillis()));
        EventStream<?> ticks = EventStreams.restartableTicks(duration, restartImpulse);
        return StateMachine.init(false).on(restartImpulse.withDefaultEvent(null)).transition((state, impulse) -> true).on(ticks).transition((state, tick) -> state == false).toStateStream();
    }

    private void moveContentBreaks(int numOfBreaks, BreakIterator breakIterator, boolean followingNotPreceding) {
        if (this.area.getLength() == 0) {
            return;
        }
        breakIterator.setText(this.area.getText());
        if (followingNotPreceding) {
            breakIterator.following(this.getPosition());
        } else {
            breakIterator.preceding(this.getPosition());
        }
        for (int i = 1; i < numOfBreaks; ++i) {
            breakIterator.next();
        }
        this.moveTo(breakIterator.current());
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return CSS_META_DATA_LIST;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return CSS_META_DATA_LIST;
    }

    static {
        ArrayList<CssMetaData<CaretNode, Duration>> styleables = new ArrayList<CssMetaData<CaretNode, Duration>>(Path.getClassCssMetaData());
        styleables.add(BLINK_RATE);
        CSS_META_DATA_LIST = Collections.unmodifiableList(styleables);
    }
}

