/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.util.function.Predicate;
import javafx.event.Event;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.IndexRange;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.KeyCharacterCombination;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import org.fxmisc.richtext.CharacterHit;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.NavigationActions;
import org.fxmisc.richtext.model.TwoDimensional;
import org.fxmisc.wellbehaved.event.EventPattern;
import org.fxmisc.wellbehaved.event.InputHandler;
import org.fxmisc.wellbehaved.event.template.InputMapTemplate;
import org.reactfx.EventStream;
import org.reactfx.EventStreams;
import org.reactfx.value.Val;
import org.reactfx.value.Var;

class GenericStyledAreaBehavior {
    private static final boolean isMac;
    private static final boolean isWindows;
    private static final InputMapTemplate<GenericStyledAreaBehavior, ? super Event> EVENT_TEMPLATE;
    private static final Predicate<KeyEvent> controlKeysFilter;
    private final GenericStyledArea<?, ?, ?> view;
    private DragState dragSelection = DragState.NO_DRAG;
    private DragState dragNewSelection = DragState.NO_DRAG;
    private final Var<Point2D> autoscrollTo = Var.newSimpleVar(null);

    GenericStyledAreaBehavior(GenericStyledArea<?, ?, ?> area) {
        this.view = area;
        InputMapTemplate.installFallback(EVENT_TEMPLATE, this, b -> b.view);
        Val<Point2D> projection = Val.combine(this.autoscrollTo, area.layoutBoundsProperty(), GenericStyledAreaBehavior::project);
        Val<Point2D> distance = Val.combine(this.autoscrollTo, projection, Point2D::subtract);
        EventStream<Point2D> deltas = EventStreams.nonNullValuesOf(distance).emitBothOnEach(EventStreams.animationFrames()).map(t -> t.map((ds, nanos) -> ds.multiply((double)nanos.longValue() / 1.0E8)));
        EventStreams.valuesOf(this.autoscrollTo).flatMap(p -> p == null ? EventStreams.never() : deltas).subscribe(ds -> {
            area.scrollBy((Point2D)ds);
            projection.ifPresent(this::dragTo);
        });
    }

    private void keyTyped(KeyEvent event) {
        String text = event.getCharacter();
        int n = text.length();
        if (n == 0) {
            return;
        }
        this.view.replaceSelection(text);
    }

    private void deleteBackward(KeyEvent ignore) {
        IndexRange selection = this.view.getSelection();
        if (selection.getLength() == 0) {
            this.view.deletePreviousChar();
        } else {
            this.view.replaceSelection("");
        }
    }

    private void deleteForward(KeyEvent ignore) {
        IndexRange selection = this.view.getSelection();
        if (selection.getLength() == 0) {
            this.view.deleteNextChar();
        } else {
            this.view.replaceSelection("");
        }
    }

    private void left(KeyEvent ignore) {
        IndexRange sel = this.view.getSelection();
        if (sel.getLength() == 0) {
            this.view.previousChar(NavigationActions.SelectionPolicy.CLEAR);
        } else {
            this.view.moveTo(sel.getStart(), NavigationActions.SelectionPolicy.CLEAR);
        }
    }

    private void right(KeyEvent ignore) {
        IndexRange sel = this.view.getSelection();
        if (sel.getLength() == 0) {
            this.view.nextChar(NavigationActions.SelectionPolicy.CLEAR);
        } else {
            this.view.moveTo(sel.getEnd(), NavigationActions.SelectionPolicy.CLEAR);
        }
    }

    private void selectLeft(KeyEvent ignore) {
        this.view.previousChar(NavigationActions.SelectionPolicy.ADJUST);
    }

    private void selectRight(KeyEvent ignore) {
        this.view.nextChar(NavigationActions.SelectionPolicy.ADJUST);
    }

    private void deletePrevWord(KeyEvent ignore) {
        int end = this.view.getCaretPosition();
        if (end > 0) {
            this.view.wordBreaksBackwards(2, NavigationActions.SelectionPolicy.CLEAR);
            int start = this.view.getCaretPosition();
            this.view.replaceText(start, end, "");
        }
    }

    private void deleteNextWord(KeyEvent ignore) {
        int start = this.view.getCaretPosition();
        if (start < this.view.getLength()) {
            this.view.wordBreaksForwards(2, NavigationActions.SelectionPolicy.CLEAR);
            int end = this.view.getCaretPosition();
            this.view.replaceText(start, end, "");
        }
    }

    private void downLines(NavigationActions.SelectionPolicy selectionPolicy, int nLines) {
        TwoDimensional.Position targetLine;
        TwoDimensional.Position currentLine = this.view.currentLine();
        if (!currentLine.sameAs(targetLine = currentLine.offsetBy(nLines, TwoDimensional.Bias.Forward).clamp())) {
            CharacterHit hit = this.view.hit(this.view.getTargetCaretOffset(), targetLine);
            this.view.moveTo(hit.getInsertionIndex(), selectionPolicy);
        }
    }

    private void prevLine(NavigationActions.SelectionPolicy selectionPolicy) {
        this.downLines(selectionPolicy, -1);
    }

    private void nextLine(NavigationActions.SelectionPolicy selectionPolicy) {
        this.downLines(selectionPolicy, 1);
    }

    private void skipToPrevWord(NavigationActions.SelectionPolicy selectionPolicy) {
        int caretPos = this.view.getCaretPosition();
        if (1 <= caretPos) {
            boolean prevCharIsWhiteSpace = Character.isWhitespace(this.view.getText(caretPos - 1, caretPos).charAt(0));
            this.view.wordBreaksBackwards(prevCharIsWhiteSpace ? 2 : 1, selectionPolicy);
        }
    }

    private void skipToNextWord(NavigationActions.SelectionPolicy selectionPolicy) {
        int length;
        int caretPos = this.view.getCaretPosition();
        if (caretPos <= (length = this.view.getLength()) - 1) {
            boolean nextCharIsWhiteSpace = Character.isWhitespace(this.view.getText(caretPos, caretPos + 1).charAt(0));
            this.view.wordBreaksForwards(nextCharIsWhiteSpace ? 2 : 1, selectionPolicy);
        }
    }

    private void showContextMenu(ContextMenuEvent e) {
        this.view.requestFocus();
        if (this.view.isContextMenuPresent()) {
            ContextMenu menu = this.view.getContextMenu();
            double x = e.getScreenX() + this.view.getContextMenuXOffset();
            double y = e.getScreenY() + this.view.getContextMenuYOffset();
            menu.show(this.view, x, y);
        }
    }

    private void handleShiftPress(MouseEvent e) {
        this.view.requestFocus();
        CharacterHit hit = this.view.hit(e.getX(), e.getY());
        this.view.moveTo(hit.getInsertionIndex(), isMac ? NavigationActions.SelectionPolicy.EXTEND : NavigationActions.SelectionPolicy.ADJUST);
    }

    private void handleFirstPrimaryPress(MouseEvent e) {
        this.view.requestFocus();
        CharacterHit hit = this.view.hit(e.getX(), e.getY());
        this.view.clearTargetCaretOffset();
        IndexRange selection = this.view.getSelection();
        if (this.view.isEditable() && selection.getLength() != 0 && hit.getCharacterIndex().isPresent() && hit.getCharacterIndex().getAsInt() >= selection.getStart() && hit.getCharacterIndex().getAsInt() < selection.getEnd()) {
            this.dragSelection = DragState.POTENTIAL_DRAG;
            this.dragNewSelection = DragState.NO_DRAG;
        } else {
            this.dragSelection = DragState.NO_DRAG;
            this.dragNewSelection = DragState.NO_DRAG;
            this.view.getOnOutsideSelectionMousePressed().handle((Event)e);
        }
    }

    private void handleSecondPress(MouseEvent e) {
        this.view.selectWord();
    }

    private void handleThirdPress(MouseEvent e) {
        this.view.selectParagraph();
    }

    private void handlePrimaryOnlyDragDetected() {
        if (this.dragSelection == DragState.POTENTIAL_DRAG) {
            this.dragSelection = DragState.DRAG;
        } else {
            this.dragNewSelection = DragState.DRAG;
        }
    }

    private InputHandler.Result processPrimaryOnlyMouseDragged(MouseEvent e) {
        Point2D p = new Point2D(e.getX(), e.getY());
        if (this.view.getLayoutBounds().contains(p)) {
            this.dragTo(p);
        }
        this.view.setAutoScrollOnDragDesired(true);
        return InputHandler.Result.PROCEED;
    }

    private void continueOrStopAutoScroll(MouseEvent e) {
        if (!this.view.isAutoScrollOnDragDesired()) {
            this.autoscrollTo.setValue(null);
        }
        Point2D p = new Point2D(e.getX(), e.getY());
        if (this.view.getLayoutBounds().contains(p)) {
            this.autoscrollTo.setValue(null);
        } else {
            this.autoscrollTo.setValue(p);
        }
    }

    private void dragTo(Point2D point) {
        if (this.dragSelection == DragState.DRAG || this.dragSelection == DragState.POTENTIAL_DRAG) {
            this.view.getOnSelectionDrag().accept(point);
        } else {
            this.view.getOnNewSelectionDrag().accept(point);
        }
    }

    private InputHandler.Result processMouseReleased(MouseEvent e) {
        if (this.view.isDisabled()) {
            return InputHandler.Result.IGNORE;
        }
        switch (this.dragSelection) {
            case POTENTIAL_DRAG: {
                this.view.getOnInsideSelectionMousePressReleased().handle((Event)e);
            }
            case DRAG: {
                this.view.getOnSelectionDropped().handle((Event)e);
                break;
            }
            case NO_DRAG: {
                if (this.dragNewSelection != DragState.DRAG) break;
                this.view.getOnNewSelectionDragFinished().handle((Event)e);
            }
        }
        this.dragNewSelection = DragState.NO_DRAG;
        this.dragSelection = DragState.NO_DRAG;
        return InputHandler.Result.PROCEED;
    }

    private static Point2D project(Point2D p, Bounds bounds) {
        double x = GenericStyledAreaBehavior.clamp(p.getX(), bounds.getMinX(), bounds.getMaxX());
        double y = GenericStyledAreaBehavior.clamp(p.getY(), bounds.getMinY(), bounds.getMaxY());
        return new Point2D(x, y);
    }

    private static double clamp(double x, double min, double max) {
        return Math.min(Math.max(x, min), max);
    }

    static boolean isControlKeyEvent(KeyEvent event) {
        return controlKeysFilter.test(event);
    }

    private static boolean isLegal(String text) {
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            if (!Character.isISOControl(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static {
        String os = System.getProperty("os.name");
        isMac = os.startsWith("Mac");
        isWindows = os.startsWith("Windows");
        NavigationActions.SelectionPolicy selPolicy = isMac ? NavigationActions.SelectionPolicy.EXTEND : NavigationActions.SelectionPolicy.ADJUST;
        KeyCharacterCombination SHORTCUT_A = new KeyCharacterCombination("a", new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
        KeyCharacterCombination SHORTCUT_C = new KeyCharacterCombination("c", new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
        KeyCharacterCombination SHORTCUT_V = new KeyCharacterCombination("v", new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
        KeyCharacterCombination SHORTCUT_X = new KeyCharacterCombination("x", new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
        KeyCharacterCombination SHORTCUT_Y = new KeyCharacterCombination("y", new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
        KeyCharacterCombination SHORTCUT_Z = new KeyCharacterCombination("z", new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
        KeyCharacterCombination SHORTCUT_SHIFT_Z = new KeyCharacterCombination("z", new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN, KeyCombination.SHIFT_DOWN});
        InputMapTemplate editsBase = InputMapTemplate.sequence(InputMapTemplate.consume(EventPattern.keyPressed(KeyCode.DELETE, new KeyCombination.Modifier[0]), GenericStyledAreaBehavior::deleteForward), InputMapTemplate.consume(EventPattern.keyPressed(KeyCode.BACK_SPACE, new KeyCombination.Modifier[0]), GenericStyledAreaBehavior::deleteBackward), InputMapTemplate.consume(EventPattern.keyPressed(KeyCode.BACK_SPACE, KeyCombination.SHIFT_DOWN), GenericStyledAreaBehavior::deleteBackward), InputMapTemplate.consume(EventPattern.keyPressed(KeyCode.DELETE, KeyCombination.SHORTCUT_DOWN), GenericStyledAreaBehavior::deleteNextWord), InputMapTemplate.consume(EventPattern.keyPressed(KeyCode.BACK_SPACE, KeyCombination.SHORTCUT_DOWN), GenericStyledAreaBehavior::deletePrevWord), InputMapTemplate.consume(EventPattern.anyOf(EventPattern.keyPressed(KeyCode.CUT, new KeyCombination.Modifier[0]), EventPattern.keyPressed((KeyCombination)SHORTCUT_X), EventPattern.keyPressed(KeyCode.DELETE, KeyCombination.SHIFT_DOWN)), (b, e) -> b.view.cut()), InputMapTemplate.consume(EventPattern.anyOf(EventPattern.keyPressed(KeyCode.PASTE, new KeyCombination.Modifier[0]), EventPattern.keyPressed((KeyCombination)SHORTCUT_V), EventPattern.keyPressed(KeyCode.INSERT, KeyCombination.SHIFT_DOWN)), (b, e) -> b.view.paste()), InputMapTemplate.consume(EventPattern.keyPressed(KeyCode.ENTER, new KeyCombination.Modifier[0]), (b, e) -> b.view.replaceSelection("\n")), InputMapTemplate.consume(EventPattern.keyPressed(KeyCode.TAB, new KeyCombination.Modifier[0]), (b, e) -> b.view.replaceSelection("\t")), InputMapTemplate.consume(EventPattern.keyPressed((KeyCombination)SHORTCUT_Z), (b, e) -> b.view.undo()), InputMapTemplate.consume(EventPattern.anyOf(EventPattern.keyPressed((KeyCombination)SHORTCUT_Y), EventPattern.keyPressed((KeyCombination)SHORTCUT_SHIFT_Z)), (b, e) -> b.view.redo()));
        InputMapTemplate edits = InputMapTemplate.when(b -> b.view.isEditable(), editsBase);
        InputMapTemplate verticalNavigation = InputMapTemplate.sequence(InputMapTemplate.consume(EventPattern.anyOf(EventPattern.keyPressed(KeyCode.UP, new KeyCombination.Modifier[0]), EventPattern.keyPressed(KeyCode.KP_UP, new KeyCombination.Modifier[0])), (b, e) -> b.prevLine(NavigationActions.SelectionPolicy.CLEAR)), InputMapTemplate.consume(EventPattern.anyOf(EventPattern.keyPressed(KeyCode.DOWN, new KeyCombination.Modifier[0]), EventPattern.keyPressed(KeyCode.KP_DOWN, new KeyCombination.Modifier[0])), (b, e) -> b.nextLine(NavigationActions.SelectionPolicy.CLEAR)), InputMapTemplate.consume(EventPattern.keyPressed(KeyCode.PAGE_UP, new KeyCombination.Modifier[0]), (b, e) -> b.view.prevPage(NavigationActions.SelectionPolicy.CLEAR)), InputMapTemplate.consume(EventPattern.keyPressed(KeyCode.PAGE_DOWN, new KeyCombination.Modifier[0]), (b, e) -> b.view.nextPage(NavigationActions.SelectionPolicy.CLEAR)), InputMapTemplate.consume(EventPattern.anyOf(EventPattern.keyPressed(KeyCode.UP, KeyCombination.SHIFT_DOWN), EventPattern.keyPressed(KeyCode.KP_UP, KeyCombination.SHIFT_DOWN)), (b, e) -> b.prevLine(NavigationActions.SelectionPolicy.ADJUST)), InputMapTemplate.consume(EventPattern.anyOf(EventPattern.keyPressed(KeyCode.DOWN, KeyCombination.SHIFT_DOWN), EventPattern.keyPressed(KeyCode.KP_DOWN, KeyCombination.SHIFT_DOWN)), (b, e) -> b.nextLine(NavigationActions.SelectionPolicy.ADJUST)), InputMapTemplate.consume(EventPattern.keyPressed(KeyCode.PAGE_UP, KeyCombination.SHIFT_DOWN), (b, e) -> b.view.prevPage(NavigationActions.SelectionPolicy.ADJUST)), InputMapTemplate.consume(EventPattern.keyPressed(KeyCode.PAGE_DOWN, KeyCombination.SHIFT_DOWN), (b, e) -> b.view.nextPage(NavigationActions.SelectionPolicy.ADJUST)));
        InputMapTemplate otherNavigation = InputMapTemplate.sequence(InputMapTemplate.consume(EventPattern.anyOf(EventPattern.keyPressed(KeyCode.RIGHT, new KeyCombination.Modifier[0]), EventPattern.keyPressed(KeyCode.KP_RIGHT, new KeyCombination.Modifier[0])), GenericStyledAreaBehavior::right), InputMapTemplate.consume(EventPattern.anyOf(EventPattern.keyPressed(KeyCode.LEFT, new KeyCombination.Modifier[0]), EventPattern.keyPressed(KeyCode.KP_LEFT, new KeyCombination.Modifier[0])), GenericStyledAreaBehavior::left), InputMapTemplate.consume(EventPattern.keyPressed(KeyCode.HOME, new KeyCombination.Modifier[0]), (b, e) -> b.view.lineStart(NavigationActions.SelectionPolicy.CLEAR)), InputMapTemplate.consume(EventPattern.keyPressed(KeyCode.END, new KeyCombination.Modifier[0]), (b, e) -> b.view.lineEnd(NavigationActions.SelectionPolicy.CLEAR)), InputMapTemplate.consume(EventPattern.anyOf(EventPattern.keyPressed(KeyCode.RIGHT, KeyCombination.SHORTCUT_DOWN), EventPattern.keyPressed(KeyCode.KP_RIGHT, KeyCombination.SHORTCUT_DOWN)), (b, e) -> b.skipToNextWord(NavigationActions.SelectionPolicy.CLEAR)), InputMapTemplate.consume(EventPattern.anyOf(EventPattern.keyPressed(KeyCode.LEFT, KeyCombination.SHORTCUT_DOWN), EventPattern.keyPressed(KeyCode.KP_LEFT, KeyCombination.SHORTCUT_DOWN)), (b, e) -> b.skipToPrevWord(NavigationActions.SelectionPolicy.CLEAR)), InputMapTemplate.consume(EventPattern.keyPressed(KeyCode.HOME, KeyCombination.SHORTCUT_DOWN), (b, e) -> b.view.start(NavigationActions.SelectionPolicy.CLEAR)), InputMapTemplate.consume(EventPattern.keyPressed(KeyCode.END, KeyCombination.SHORTCUT_DOWN), (b, e) -> b.view.end(NavigationActions.SelectionPolicy.CLEAR)), InputMapTemplate.consume(EventPattern.anyOf(EventPattern.keyPressed(KeyCode.RIGHT, KeyCombination.SHIFT_DOWN), EventPattern.keyPressed(KeyCode.KP_RIGHT, KeyCombination.SHIFT_DOWN)), GenericStyledAreaBehavior::selectRight), InputMapTemplate.consume(EventPattern.anyOf(EventPattern.keyPressed(KeyCode.LEFT, KeyCombination.SHIFT_DOWN), EventPattern.keyPressed(KeyCode.KP_LEFT, KeyCombination.SHIFT_DOWN)), GenericStyledAreaBehavior::selectLeft), InputMapTemplate.consume(EventPattern.keyPressed(KeyCode.HOME, KeyCombination.SHIFT_DOWN), (b, e) -> b.view.lineStart(selPolicy)), InputMapTemplate.consume(EventPattern.keyPressed(KeyCode.END, KeyCombination.SHIFT_DOWN), (b, e) -> b.view.lineEnd(selPolicy)), InputMapTemplate.consume(EventPattern.keyPressed(KeyCode.HOME, KeyCombination.SHIFT_DOWN, KeyCombination.SHORTCUT_DOWN), (b, e) -> b.view.start(selPolicy)), InputMapTemplate.consume(EventPattern.keyPressed(KeyCode.END, KeyCombination.SHIFT_DOWN, KeyCombination.SHORTCUT_DOWN), (b, e) -> b.view.end(selPolicy)), InputMapTemplate.consume(EventPattern.anyOf(EventPattern.keyPressed(KeyCode.RIGHT, KeyCombination.SHIFT_DOWN, KeyCombination.SHORTCUT_DOWN), EventPattern.keyPressed(KeyCode.KP_RIGHT, KeyCombination.SHIFT_DOWN, KeyCombination.SHORTCUT_DOWN)), (b, e) -> b.skipToNextWord(selPolicy)), InputMapTemplate.consume(EventPattern.anyOf(EventPattern.keyPressed(KeyCode.LEFT, KeyCombination.SHIFT_DOWN, KeyCombination.SHORTCUT_DOWN), EventPattern.keyPressed(KeyCode.KP_LEFT, KeyCombination.SHIFT_DOWN, KeyCombination.SHORTCUT_DOWN)), (b, e) -> b.skipToPrevWord(selPolicy)), InputMapTemplate.consume(EventPattern.keyPressed((KeyCombination)SHORTCUT_A), (b, e) -> b.view.selectAll()));
        InputMapTemplate<GenericStyledAreaBehavior, KeyEvent> copyAction = InputMapTemplate.consume(EventPattern.anyOf(EventPattern.keyPressed(KeyCode.COPY, new KeyCombination.Modifier[0]), EventPattern.keyPressed((KeyCombination)SHORTCUT_C), EventPattern.keyPressed(KeyCode.INSERT, KeyCombination.SHORTCUT_DOWN)), (b, e) -> b.view.copy());
        controlKeysFilter = e -> {
            if (isWindows) {
                if (e.isControlDown() && e.isAltDown() && !e.isMetaDown() && e.getCharacter().length() == 1 && e.getCharacter().getBytes()[0] != 0) {
                    return true;
                }
                return !e.isControlDown() && !e.isAltDown() && !e.isMetaDown();
            }
            return !e.isControlDown() && !e.isMetaDown();
        };
        Predicate<KeyEvent> isChar = e -> e.getCode().isLetterKey() || e.getCode().isDigitKey() || e.getCode().isWhitespaceKey();
        InputMapTemplate charPressConsumer = InputMapTemplate.consume(EventPattern.keyPressed().onlyIf(isChar.and(controlKeysFilter)));
        InputMapTemplate<GenericStyledAreaBehavior, KeyEvent> keyPressedTemplate = edits.orElse(otherNavigation).ifConsumed((b, e) -> b.view.clearTargetCaretOffset()).orElse(verticalNavigation).orElse(copyAction).ifConsumed((b, e) -> b.view.requestFollowCaret()).orElse(charPressConsumer);
        InputMapTemplate<GenericStyledAreaBehavior, KeyEvent> keyTypedBase = InputMapTemplate.consume(EventPattern.keyTyped().onlyIf(controlKeysFilter.and(e -> GenericStyledAreaBehavior.isLegal(e.getCharacter()))), GenericStyledAreaBehavior::keyTyped).ifConsumed((b, e) -> b.view.requestFollowCaret());
        InputMapTemplate<GenericStyledAreaBehavior, KeyEvent> keyTypedTemplate = InputMapTemplate.when(b -> b.view.isEditable(), keyTypedBase);
        InputMapTemplate mousePressedTemplate = InputMapTemplate.sequence(InputMapTemplate.process(EventPattern.mousePressed(MouseButton.PRIMARY), (b, e) -> b.view.isDisabled() ? InputHandler.Result.IGNORE : InputHandler.Result.PROCEED), InputMapTemplate.process(EventPattern.mousePressed(), (b, e) -> {
            b.view.hideContextMenu();
            return InputHandler.Result.PROCEED;
        }), InputMapTemplate.consume(EventPattern.mousePressed(MouseButton.PRIMARY).onlyIf(MouseEvent::isShiftDown), GenericStyledAreaBehavior::handleShiftPress), InputMapTemplate.consume(EventPattern.mousePressed(MouseButton.PRIMARY).onlyIf(e -> e.getClickCount() == 1), GenericStyledAreaBehavior::handleFirstPrimaryPress), InputMapTemplate.consume(EventPattern.mousePressed(MouseButton.PRIMARY).onlyIf(e -> e.getClickCount() == 2), GenericStyledAreaBehavior::handleSecondPress), InputMapTemplate.consume(EventPattern.mousePressed(MouseButton.PRIMARY).onlyIf(e -> e.getClickCount() == 3), GenericStyledAreaBehavior::handleThirdPress));
        Predicate<MouseEvent> primaryOnlyButton = e -> e.getButton() == MouseButton.PRIMARY && !e.isMiddleButtonDown() && !e.isSecondaryButtonDown();
        InputMapTemplate<GenericStyledAreaBehavior, MouseEvent> mouseDragDetectedTemplate = InputMapTemplate.consume(EventPattern.eventType(MouseEvent.DRAG_DETECTED).onlyIf(primaryOnlyButton), (b, e) -> b.handlePrimaryOnlyDragDetected());
        InputMapTemplate mouseDragTemplate = InputMapTemplate.sequence(InputMapTemplate.process(EventPattern.mouseDragged().onlyIf(primaryOnlyButton), GenericStyledAreaBehavior::processPrimaryOnlyMouseDragged), InputMapTemplate.consume(EventPattern.mouseDragged(), GenericStyledAreaBehavior::continueOrStopAutoScroll));
        InputMapTemplate mouseReleasedTemplate = InputMapTemplate.sequence(InputMapTemplate.process(EventPattern.mouseReleased().onlyIf(primaryOnlyButton), GenericStyledAreaBehavior::processMouseReleased), InputMapTemplate.consume(EventPattern.mouseReleased(), (b, e) -> b.autoscrollTo.setValue(null)));
        InputMapTemplate mouseTemplate = InputMapTemplate.sequence(mousePressedTemplate, mouseDragDetectedTemplate, mouseDragTemplate, mouseReleasedTemplate);
        InputMapTemplate<GenericStyledAreaBehavior, ContextMenuEvent> contextMenuEventTemplate = InputMapTemplate.consumeWhen(EventPattern.eventType(ContextMenuEvent.CONTEXT_MENU_REQUESTED), b -> !b.view.isDisabled(), GenericStyledAreaBehavior::showContextMenu);
        EVENT_TEMPLATE = InputMapTemplate.sequence(mouseTemplate, keyPressedTemplate, keyTypedTemplate, contextMenuEventTemplate);
    }

    private static enum DragState {
        NO_DRAG,
        POTENTIAL_DRAG,
        DRAG;

    }
}

