/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.undo.impl;

import java.time.Duration;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ObservableBooleanValue;
import org.fxmisc.undo.UndoManager;
import org.fxmisc.undo.impl.ChangeQueue;
import org.reactfx.EventSource;
import org.reactfx.EventStream;
import org.reactfx.Subscription;
import org.reactfx.SuspendableNo;
import org.reactfx.value.Val;
import org.reactfx.value.ValBase;

public class UndoManagerImpl<C>
implements UndoManager<C> {
    private final ChangeQueue<C> queue;
    private final Function<? super C, ? extends C> invert;
    private final Consumer<C> apply;
    private final BiFunction<C, C, Optional<C>> merge;
    private final Predicate<C> isIdentity;
    private final Subscription subscription;
    private final SuspendableNo performingAction = new SuspendableNo();
    private final EventSource<Void> invalidationRequests = new EventSource();
    private final Val<C> nextUndo = new ValBase<C>(){

        @Override
        protected Subscription connect() {
            return UndoManagerImpl.this.invalidationRequests.subscribe(x -> this.invalidate());
        }

        @Override
        protected C computeValue() {
            return UndoManagerImpl.this.queue.hasPrev() ? (Object)UndoManagerImpl.this.queue.peekPrev() : null;
        }
    };
    private final Val<C> nextRedo = new ValBase<C>(){

        @Override
        protected Subscription connect() {
            return UndoManagerImpl.this.invalidationRequests.subscribe(x -> this.invalidate());
        }

        @Override
        protected C computeValue() {
            return UndoManagerImpl.this.queue.hasNext() ? (Object)UndoManagerImpl.this.queue.peekNext() : null;
        }
    };
    private final BooleanBinding atMarkedPosition = new BooleanBinding(){
        {
            UndoManagerImpl.this.invalidationRequests.addObserver(x -> this.invalidate());
        }

        protected boolean computeValue() {
            return UndoManagerImpl.this.mark.equals(UndoManagerImpl.this.queue.getCurrentPosition());
        }
    };
    private boolean canMerge;
    private ChangeQueue.QueuePosition mark;
    private C expectedChange = null;

    public UndoManagerImpl(ChangeQueue<C> queue, Function<? super C, ? extends C> invert, Consumer<C> apply, BiFunction<C, C, Optional<C>> merge, Predicate<C> isIdentity, EventStream<C> changeSource) {
        this(queue, invert, apply, merge, isIdentity, changeSource, Duration.ZERO);
    }

    public UndoManagerImpl(ChangeQueue<C> queue, Function<? super C, ? extends C> invert, Consumer<C> apply, BiFunction<C, C, Optional<C>> merge, Predicate<C> isIdentity, EventStream<C> changeSource, Duration preventMergeDelay) {
        this.queue = queue;
        this.invert = invert;
        this.apply = apply;
        this.merge = merge;
        this.isIdentity = isIdentity;
        this.mark = queue.getCurrentPosition();
        Subscription mainSub = changeSource.subscribe(this::changeObserved);
        if (preventMergeDelay.isZero() || preventMergeDelay.isNegative()) {
            this.subscription = mainSub;
        } else {
            Subscription sub2 = changeSource.successionEnds(preventMergeDelay).subscribe(ignore -> this.preventMerge());
            this.subscription = mainSub.and(sub2);
        }
    }

    @Override
    public void close() {
        this.subscription.unsubscribe();
    }

    @Override
    public boolean undo() {
        return this.applyChange(this.isUndoAvailable(), () -> this.invert.apply(this.queue.prev()));
    }

    @Override
    public boolean redo() {
        return this.applyChange(this.isRedoAvailable(), this.queue::next);
    }

    @Override
    public Val<C> nextUndoProperty() {
        return this.nextUndo;
    }

    @Override
    public Val<C> nextRedoProperty() {
        return this.nextRedo;
    }

    @Override
    public boolean isUndoAvailable() {
        return this.nextUndo.isPresent();
    }

    @Override
    public Val<Boolean> undoAvailableProperty() {
        return this.nextUndo.map(c -> true).orElseConst(false);
    }

    @Override
    public boolean isRedoAvailable() {
        return this.nextRedo.isPresent();
    }

    @Override
    public Val<Boolean> redoAvailableProperty() {
        return this.nextRedo.map(c -> true).orElseConst(false);
    }

    @Override
    public boolean isPerformingAction() {
        return this.performingAction.get();
    }

    @Override
    public ObservableBooleanValue performingActionProperty() {
        return this.performingAction;
    }

    @Override
    public boolean isAtMarkedPosition() {
        return this.atMarkedPosition.get();
    }

    @Override
    public ObservableBooleanValue atMarkedPositionProperty() {
        return this.atMarkedPosition;
    }

    @Override
    public UndoManager.UndoPosition getCurrentPosition() {
        return new UndoPositionImpl(this.queue.getCurrentPosition());
    }

    @Override
    public void preventMerge() {
        this.canMerge = false;
    }

    @Override
    public void forgetHistory() {
        this.queue.forgetHistory();
        this.invalidateProperties();
    }

    private boolean applyChange(boolean isChangeAvailable, Supplier<C> changeToApply) {
        if (isChangeAvailable) {
            this.canMerge = false;
            C change = changeToApply.get();
            this.expectedChange = change;
            this.performingAction.suspendWhile(() -> this.apply.accept(change));
            if (this.expectedChange != null) {
                throw new IllegalStateException("Expected change not received:\n" + this.expectedChange);
            }
            this.invalidateProperties();
            return true;
        }
        return false;
    }

    private void changeObserved(C change) {
        if (this.expectedChange == null) {
            if (!this.isIdentity.test(change)) {
                this.addChange(change);
            }
        } else if (this.expectedChange.equals(change)) {
            this.expectedChange = null;
        } else {
            throw new IllegalArgumentException("Unexpected change received.\nExpected:\n" + this.expectedChange + "\nReceived:\n" + change);
        }
    }

    private void addChange(C change) {
        if (this.canMerge && this.queue.hasPrev()) {
            C prev = this.queue.prev();
            Optional<C> merged = this.merge.apply(prev, change);
            if (merged.isPresent()) {
                if (this.isIdentity.test(merged.get())) {
                    this.canMerge = false;
                    this.queue.push(new Object[0]);
                } else {
                    this.canMerge = true;
                    this.queue.push(merged.get());
                }
            } else {
                this.canMerge = true;
                this.queue.next();
                this.queue.push(change);
            }
        } else {
            this.queue.push(change);
            this.canMerge = true;
        }
        this.invalidateProperties();
    }

    private void invalidateProperties() {
        this.invalidationRequests.push(null);
    }

    private class UndoPositionImpl
    implements UndoManager.UndoPosition {
        private final ChangeQueue.QueuePosition queuePos;

        UndoPositionImpl(ChangeQueue.QueuePosition queuePos) {
            this.queuePos = queuePos;
        }

        @Override
        public void mark() {
            UndoManagerImpl.this.mark = this.queuePos;
            UndoManagerImpl.this.canMerge = false;
            UndoManagerImpl.this.atMarkedPosition.invalidate();
        }

        @Override
        public boolean isValid() {
            return this.queuePos.isValid();
        }
    }
}

