/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.callback;

import com.teamdev.jxbrowser.browser.callback.SelectClientCertificateCallback;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.net.tls.Certificate;
import com.teamdev.jxbrowser.net.tls.X509Certificates;
import com.teamdev.jxbrowser.view.javafx.BrowserView;
import com.teamdev.jxbrowser.view.javafx.callback.DefaultCallback;
import com.teamdev.jxbrowser.view.javafx.internal.dialog.SelectDialog;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;

public final class DefaultSelectClientCertificateCallback
extends DefaultCallback
implements SelectClientCertificateCallback {
    public DefaultSelectClientCertificateCallback(BrowserView parent) {
        super(parent);
    }

    public void on(SelectClientCertificateCallback.Params params, SelectClientCertificateCallback.Action tell) {
        List certificates = params.certificates();
        if (certificates.isEmpty()) {
            tell.cancel();
            return;
        }
        Platform.runLater(() -> {
            ArrayList<String> selectionValues = new ArrayList<String>();
            try {
                for (Certificate certificate : certificates) {
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(certificate.derEncodedValue());
                    X509Certificate x509Certificate = X509Certificates.of((InputStream)inputStream);
                    selectionValues.add(x509Certificate.getSubjectDN().getName());
                }
            }
            catch (CertificateException ex) {
                Logger.error((String)"Failed to parse an X509Certificate.", (Throwable)ex);
                tell.cancel();
                return;
            }
            this.window().ifPresent(window -> {
                SelectDialog dialog = (SelectDialog)((SelectDialog.Builder)((SelectDialog.Builder)((SelectDialog.Builder)((SelectDialog.Builder)SelectDialog.newBuilder(window, params.message()).title(params.title())).addAllItems(selectionValues).addButton(params.selectActionText(), d -> {
                    int index = selectionValues.indexOf(d.selectedValue());
                    tell.select(index);
                })).addButton(params.cancelActionText(), () -> ((SelectClientCertificateCallback.Action)tell).cancel())).defaultAction(() -> ((SelectClientCertificateCallback.Action)tell).cancel())).build();
                dialog.open();
            });
        });
    }
}

