/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal;

import java.util.ArrayDeque;
import java.util.Collection;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;

class AncestorsVisibilityTracker {
    private final Node node;
    private final VisibilityListener visibilityListener;
    private final HierarchyListener hierarchyListener;

    private AncestorsVisibilityTracker(Builder builder) {
        this.node = builder.node;
        this.visibilityListener = new VisibilityListener(builder.onShow, builder.onHide);
        this.hierarchyListener = new HierarchyListener();
    }

    static Builder newBuilder() {
        return new Builder();
    }

    void start() {
        this.node.parentProperty().addListener((ChangeListener)this.hierarchyListener);
    }

    void stop() {
        this.node.parentProperty().removeListener((ChangeListener)this.hierarchyListener);
    }

    private static Collection<Node> findAncestorsFor(Node node) {
        ArrayDeque<Node> ancestors = new ArrayDeque<Node>();
        for (Parent parent = node.getParent(); parent != null; parent = parent.getParent()) {
            ancestors.add((Node)parent);
        }
        return ancestors;
    }

    private void updateListenersFor(Collection<Node> nodes) {
        nodes.stream().map(Node::parentProperty).forEach(parentProperty -> {
            parentProperty.removeListener((ChangeListener)this.hierarchyListener);
            parentProperty.addListener((ChangeListener)this.hierarchyListener);
        });
        nodes.stream().map(Node::visibleProperty).forEach(visibleProperty -> {
            visibleProperty.removeListener((ChangeListener)this.visibilityListener);
            visibleProperty.addListener((ChangeListener)this.visibilityListener);
        });
    }

    private void removeListenersFor(Collection<Node> nodes) {
        nodes.stream().map(Node::parentProperty).forEach(parentProperty -> parentProperty.removeListener((ChangeListener)this.hierarchyListener));
        nodes.stream().map(Node::visibleProperty).forEach(visibleProperty -> visibleProperty.removeListener((ChangeListener)this.visibilityListener));
    }

    private class HierarchyListener
    implements ChangeListener<Parent> {
        private HierarchyListener() {
        }

        public void changed(ObservableValue<? extends Parent> observable, Parent oldValue, Parent newValue) {
            Collection ancestors;
            if (oldValue != null) {
                oldValue.visibleProperty().removeListener((ChangeListener)AncestorsVisibilityTracker.this.visibilityListener);
                oldValue.parentProperty().removeListener((ChangeListener)this);
                ancestors = AncestorsVisibilityTracker.findAncestorsFor((Node)oldValue);
                AncestorsVisibilityTracker.this.removeListenersFor(ancestors);
            }
            if (newValue != null) {
                newValue.visibleProperty().addListener((ChangeListener)AncestorsVisibilityTracker.this.visibilityListener);
                newValue.parentProperty().addListener((ChangeListener)this);
                ancestors = AncestorsVisibilityTracker.findAncestorsFor((Node)newValue);
                AncestorsVisibilityTracker.this.updateListenersFor(ancestors);
            }
        }
    }

    private static class VisibilityListener
    implements ChangeListener<Boolean> {
        private final Runnable onShow;
        private final Runnable onHide;

        VisibilityListener(Runnable onShow, Runnable onHide) {
            this.onShow = onShow;
            this.onHide = onHide;
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            Platform.runLater(() -> {
                if (newValue.booleanValue()) {
                    this.onShow.run();
                } else {
                    this.onHide.run();
                }
            });
        }
    }

    static class Builder {
        private Node node;
        private Runnable onShow;
        private Runnable onHide;

        Builder() {
        }

        Builder forNode(Node node) {
            this.node = node;
            return this;
        }

        Builder onShow(Runnable onShow) {
            this.onShow = onShow;
            return this;
        }

        Builder onHide(Runnable onHide) {
            this.onHide = onHide;
            return this;
        }

        AncestorsVisibilityTracker build() {
            return new AncestorsVisibilityTracker(this);
        }
    }
}

