/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal;

import com.teamdev.jxbrowser.browser.event.BrowserClosed;
import com.teamdev.jxbrowser.browser.event.internal.DropDownCreated;
import com.teamdev.jxbrowser.browser.event.internal.DropDownDeleted;
import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.callback.BrowserWidgetCallback;
import com.teamdev.jxbrowser.browser.internal.callback.TakeFocusCallback;
import com.teamdev.jxbrowser.browser.internal.rpc.CursorChanged;
import com.teamdev.jxbrowser.browser.internal.rpc.ImeCompositionCancelled;
import com.teamdev.jxbrowser.browser.internal.rpc.TakeFocus;
import com.teamdev.jxbrowser.browser.internal.rpc.TooltipChanged;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.Display;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.internal.rpc.Protobuf;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.ui.KeyModifiers;
import com.teamdev.jxbrowser.ui.MouseButton;
import com.teamdev.jxbrowser.ui.MouseModifiers;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.Rect;
import com.teamdev.jxbrowser.ui.ScrollType;
import com.teamdev.jxbrowser.ui.event.MouseDragged;
import com.teamdev.jxbrowser.ui.event.MouseEntered;
import com.teamdev.jxbrowser.ui.event.MouseExited;
import com.teamdev.jxbrowser.ui.event.MouseMoved;
import com.teamdev.jxbrowser.ui.event.MousePressed;
import com.teamdev.jxbrowser.ui.event.MouseReleased;
import com.teamdev.jxbrowser.ui.event.MouseWheel;
import com.teamdev.jxbrowser.ui.internal.Geometry;
import com.teamdev.jxbrowser.view.javafx.internal.AncestorsVisibilityTracker;
import com.teamdev.jxbrowser.view.javafx.internal.BrowserNode;
import com.teamdev.jxbrowser.view.javafx.internal.DisplayWatcher;
import com.teamdev.jxbrowser.view.javafx.internal.FocusTraversal;
import com.teamdev.jxbrowser.view.javafx.internal.FxCursorFactory;
import com.teamdev.jxbrowser.view.javafx.internal.HiDpi;
import com.teamdev.jxbrowser.view.javafx.internal.ImeEventHandler;
import com.teamdev.jxbrowser.view.javafx.internal.ImeRequestsHandler;
import com.teamdev.jxbrowser.view.javafx.internal.KeyboardBridge;
import com.teamdev.jxbrowser.view.javafx.internal.NodeVisibility;
import com.teamdev.jxbrowser.view.javafx.internal.OffScreenWindowListeners;
import com.teamdev.jxbrowser.view.javafx.internal.ParentTabTracker;
import com.teamdev.jxbrowser.view.javafx.internal.dnd.DragAndDropHelper;
import com.teamdev.jxbrowser.view.javafx.internal.window.FxPanel;
import com.teamdev.jxbrowser.view.javafx.internal.window.NativeAwareWindow;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.stage.Window;

abstract class OffScreenRenderWidget
extends Canvas
implements BrowserNode {
    private final KeyListener keyListener;
    private final FocusListener focusListener;
    private final MouseListener mouseListener;
    private final ScrollListener scrollListener;
    private final SizeChangedListener sizeChangedListener;
    private final SceneChangeListener sceneChangeListener;
    private final SceneWindowListener sceneWindowListener;
    private final WindowShowingListener windowShowingListener;
    private final AncestorsVisibilityTracker ancestorsVisibilityTracker;
    private final Observer<CursorChanged> cursorChangedListener;
    private final Observer<TooltipChanged> tooltipChangedListener;
    private final OffScreenWindowListeners windowListeners;
    private final MouseEventForwarder mouseEventForwarder;
    private final Tooltip tooltip;
    private final BrowserWidget widget;
    private final Subscription browserClosed;
    private final DisplayWatcher displayWatcher;
    private final FxCursorFactory cursorFactory;
    private final DragAndDropHelper dragAndDropHelper;
    private final NodeVisibility nodeVisibility;
    private final ParentTabTracker tabTracker;
    private Scene scene;
    private Display display;
    protected NativeAwareWindow window;
    private Subscription cursorChanged;
    private Subscription tooltipChanged;
    private Subscription dropDownCreated;
    private Subscription dropDownDeleted;
    private boolean isBrowserWidgetShown;
    private boolean skipUnfocus;
    private boolean isComposingImeText;

    OffScreenRenderWidget(BrowserWidget widget) {
        this.widget = widget;
        this.nodeVisibility = NodeVisibility.newInstance(this);
        this.sizeChangedListener = new SizeChangedListener();
        this.focusListener = new FocusListener();
        this.mouseListener = new MouseListener();
        this.scrollListener = new ScrollListener();
        this.sceneChangeListener = new SceneChangeListener();
        this.sceneWindowListener = new SceneWindowListener();
        this.windowShowingListener = new WindowShowingListener();
        this.ancestorsVisibilityTracker = AncestorsVisibilityTracker.newBuilder().forNode((Node)this).onShow(this::showIfVisible).onHide(this::hide).build();
        this.tooltipChangedListener = new TooltipChangedListener();
        this.cursorChangedListener = new CursorChangedListener();
        this.windowListeners = OffScreenWindowListeners.newInstance(this);
        this.mouseEventForwarder = new MouseEventForwarder();
        this.keyListener = new KeyListener(this);
        this.display = Display.primaryDisplay();
        this.dragAndDropHelper = new DragAndDropHelper(widget, (Node)this, this.display);
        this.cursorFactory = new FxCursorFactory();
        this.displayWatcher = DisplayWatcher.newInstance(this::onDisplayChanged);
        this.tooltip = new Tooltip();
        this.setFocusTraversable(true);
        this.requestFocusOnMousePressed();
        this.setUpMouseEventConsumer();
        this.sceneProperty().addListener((ChangeListener)this.sceneChangeListener);
        this.ancestorsVisibilityTracker.start();
        this.tabTracker = ParentTabTracker.newBuilder().forNode((Node)this).whenTabSelected(this::showIfVisible).whenTabDeselected(this::hide).build();
        this.browserClosed = widget.browser().on(BrowserClosed.class, event -> Platform.runLater(() -> {
            this.sceneProperty().removeListener((ChangeListener)this.sceneChangeListener);
            this.ancestorsVisibilityTracker.stop();
            if (this.scene != null) {
                this.scene.windowProperty().removeListener((ChangeListener)this.sceneWindowListener);
            }
            this.close();
        }));
        this.initializeIme();
    }

    private void cancelImeComposition(boolean notifyEngine) {
        if (Environment.isMac() || Environment.isWindows()) {
            Platform.runLater(() -> this.window.findNativeId().ifPresent(nativeId -> ToolkitLibrary.instance().endImeComposition(nativeId.longValue())));
        }
        this.setComposingImeText(false);
        if (notifyEngine) {
            this.widget().ime().finishComposition();
        }
    }

    private void initializeIme() {
        this.setInputMethodRequests(new ImeRequestsHandler(this));
        this.setOnInputMethodTextChanged(new ImeEventHandler(this));
        this.widget.ime().on(ImeCompositionCancelled.class, event -> this.cancelImeComposition(false));
    }

    private void requestFocusOnMousePressed() {
        this.setOnMousePressed(event -> Platform.runLater(() -> ((OffScreenRenderWidget)this).requestFocus()));
    }

    private void setUpMouseEventConsumer() {
        this.addEventHandler(MouseEvent.ANY, Event::consume);
    }

    void close() {
        if (this.window != null) {
            this.window.toolkitWindow().showingProperty().removeListener((ChangeListener)this.windowShowingListener);
        }
        this.tabTracker.stop();
        this.hide();
        this.sizeChangedListener.stop();
    }

    private void setWindow(Window newWindow) {
        if (this.window != null) {
            this.displayWatcher.detach();
            this.window.removeEventListeners();
            this.window.toolkitWindow().showingProperty().removeListener((ChangeListener)this.windowShowingListener);
            this.windowListeners.stop();
            this.hide();
        }
        if (newWindow != null) {
            this.window = NativeAwareWindow.newInstance(newWindow);
            this.windowListeners.start(newWindow);
            newWindow.showingProperty().addListener((ChangeListener)this.windowShowingListener);
            this.displayWatcher.attach(this.window);
            if (newWindow.isShowing()) {
                this.showIfVisible();
            }
        } else {
            this.window = null;
        }
    }

    final BrowserWidget widget() {
        return this.widget;
    }

    public boolean isResizable() {
        return true;
    }

    public void resize(double width, double height) {
        this.setWidth(width);
        this.setHeight(height);
    }

    public double maxWidth(double height) {
        return Double.MAX_VALUE;
    }

    public double maxHeight(double width) {
        return Double.MAX_VALUE;
    }

    public double prefWidth(double height) {
        return 0.0;
    }

    public double prefHeight(double width) {
        return 0.0;
    }

    @Override
    public void enableDragAndDrop() {
        this.dragAndDropHelper.attach();
    }

    @Override
    public void disableDragAndDrop() {
        this.dragAndDropHelper.detach();
    }

    boolean isBrowserWidgetShown() {
        return this.isBrowserWidgetShown;
    }

    @Override
    public NativeAwareWindow window() {
        return this.window;
    }

    private void showIfVisible() {
        if (this.nodeVisibility.isVisibleOnScene() && this.window != null) {
            this.show();
        }
    }

    void show() {
        this.widget.browser().dragAndDrop().ifEnabled(this.dragAndDropHelper::attach);
        this.windowListeners.start(this.window.toolkitWindow());
        this.displayWatcher.attach(this.window);
        this.sizeChangedListener.start();
        this.focusedProperty().addListener((ChangeListener)this.focusListener);
        this.registerInputListeners();
        this.cursorChanged = this.widget.on(CursorChanged.class, this.cursorChangedListener);
        this.tooltipChanged = this.widget.on(TooltipChanged.class, this.tooltipChangedListener);
        this.widget.set(TakeFocusCallback.class, (BrowserWidgetCallback)((TakeFocusCallback)params -> {
            Platform.runLater(() -> FocusTraversal.traverseFocus((Node)this, params));
            return TakeFocus.Response.newBuilder().setTake(Protobuf.empty()).build();
        }));
        this.widget.show();
        if (this.isFocused()) {
            this.widget.focus();
        }
        this.notifyBoundsUpdated();
        if (Environment.isMac()) {
            this.dropDownCreated = this.widget.on(DropDownCreated.class, event -> {
                this.skipUnfocus = true;
            });
            this.dropDownDeleted = this.widget.on(DropDownDeleted.class, event -> {
                this.skipUnfocus = false;
            });
        }
        this.isBrowserWidgetShown = true;
    }

    void hide() {
        if (!this.isBrowserWidgetShown()) {
            return;
        }
        this.disableDragAndDrop();
        this.widget.remove(TakeFocusCallback.class);
        if (!this.widget.isClosed()) {
            this.widget.hide();
        }
        this.windowListeners.stop();
        this.displayWatcher.detach();
        if (!this.alwaysTrackSize()) {
            this.sizeChangedListener.stop();
        }
        this.focusedProperty().removeListener((ChangeListener)this.focusListener);
        this.unregisterInputListeners();
        this.browserClosed.unsubscribe();
        this.cursorChanged.unsubscribe();
        this.tooltipChanged.unsubscribe();
        if (Environment.isMac()) {
            this.dropDownCreated.unsubscribe();
            this.dropDownDeleted.unsubscribe();
        }
        this.isBrowserWidgetShown = false;
    }

    protected abstract boolean alwaysTrackSize();

    private void registerInputListeners() {
        this.addEventHandler(MouseEvent.ANY, this.mouseListener);
        this.addEventHandler(KeyEvent.ANY, this.keyListener);
        this.addEventHandler(ScrollEvent.ANY, this.scrollListener);
    }

    private void unregisterInputListeners() {
        this.removeEventHandler(MouseEvent.ANY, this.mouseListener);
        this.removeEventHandler(KeyEvent.ANY, this.keyListener);
        this.removeEventHandler(ScrollEvent.ANY, this.scrollListener);
    }

    private void onDisplayChanged(Display display) {
        this.display = display;
        this.dragAndDropHelper.onDisplayChanged(display);
        this.widget.displayId(display.id());
        this.notifyBoundsUpdated();
    }

    void notifyBoundsUpdated() {
        int width = (int)this.getWidth();
        int height = (int)this.getHeight();
        Scene scene = this.getScene();
        if (width > 0 && height > 0 && scene != null) {
            Point2D widgetLocation = this.localToScreen(0.0, 0.0);
            double screenX = widgetLocation.getX();
            double screenY = widgetLocation.getY();
            double sceneX = scene.getX();
            double sceneY = scene.getY();
            Window window = scene.getWindow();
            double windowX = window.getX();
            double windowY = window.getY();
            Point inWindow = Point.of((int)((int)Math.round(screenX - windowX - sceneX)), (int)((int)Math.round(screenY - windowY - sceneY)));
            inWindow = this.adjustForFxPanel(window, inWindow);
            Rect boundsInWindow = Geometry.newRect((double)inWindow.x(), (double)inWindow.y(), (double)width, (double)height);
            Rect boundsInScreen = Geometry.newRect((double)screenX, (double)screenY, (double)width, (double)height);
            if (!HiDpi.isPlatformDpiAware(this.display.scaleFactor())) {
                boundsInWindow = Geometry.scaleDown((Rect)boundsInWindow, (double)this.display.scaleFactor());
                boundsInScreen = Geometry.scaleDown((Rect)boundsInScreen, (double)this.display.scaleFactor());
            }
            this.widget.bounds(boundsInWindow, boundsInScreen);
        }
    }

    Point adjustForFxPanel(Window window, Point point) {
        return FxPanel.findFor(window).map(panel -> panel.toAwtCoordinates(point)).orElse(point);
    }

    void setComposingImeText(boolean isComposing) {
        this.isComposingImeText = isComposing;
    }

    boolean isComposingImeText() {
        return this.isComposingImeText;
    }

    Display display() {
        return this.display;
    }

    private Point createPoint(double x, double y) {
        Optional<FxPanel> jfxPanel = FxPanel.findFor(this.window.toolkitWindow());
        if (jfxPanel.isPresent()) {
            FxPanel panel = jfxPanel.get();
            x -= panel.insets().getLeft();
            y -= panel.insets().getTop();
        }
        return Geometry.newPoint((double)Math.max(0.0, x), (double)Math.max(0.0, y));
    }

    private class WindowShowingListener
    implements ChangeListener<Boolean> {
        private WindowShowingListener() {
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            if (newValue.booleanValue()) {
                OffScreenRenderWidget.this.showIfVisible();
            } else {
                OffScreenRenderWidget.this.hide();
            }
        }
    }

    private class TooltipChangedListener
    implements Observer<TooltipChanged> {
        private TooltipChangedListener() {
        }

        public void on(TooltipChanged event) {
            Platform.runLater(() -> {
                String text = event.getTooltipText();
                if (!text.isEmpty()) {
                    OffScreenRenderWidget.this.tooltip.setText(text);
                    Tooltip.install((Node)OffScreenRenderWidget.this, (Tooltip)OffScreenRenderWidget.this.tooltip);
                } else {
                    Tooltip.uninstall((Node)OffScreenRenderWidget.this, (Tooltip)OffScreenRenderWidget.this.tooltip);
                }
            });
        }
    }

    private class CursorChangedListener
    implements Observer<CursorChanged> {
        private CursorChangedListener() {
        }

        public void on(CursorChanged event) {
            Platform.runLater(() -> OffScreenRenderWidget.this.getParent().setCursor((Cursor)OffScreenRenderWidget.this.cursorFactory.newCursor(event)));
        }
    }

    private final class MouseEventForwarder {
        private final Map<EventType<? extends MouseEvent>, Consumer<MouseEvent>> mouseEventHandlers = new HashMap<EventType<? extends MouseEvent>, Consumer<MouseEvent>>();

        private MouseEventForwarder() {
            this.mouseEventHandlers.put((EventType<? extends MouseEvent>)MouseEvent.MOUSE_PRESSED, this::dispatchMousePressed);
            this.mouseEventHandlers.put((EventType<? extends MouseEvent>)MouseEvent.MOUSE_RELEASED, this::dispatchMouseReleased);
            this.mouseEventHandlers.put((EventType<? extends MouseEvent>)MouseEvent.MOUSE_ENTERED, this::dispatchMouseEntered);
            this.mouseEventHandlers.put((EventType<? extends MouseEvent>)MouseEvent.MOUSE_EXITED, this::dispatchMouseExited);
            this.mouseEventHandlers.put((EventType<? extends MouseEvent>)MouseEvent.MOUSE_MOVED, this::dispatchMouseMoved);
            this.mouseEventHandlers.put((EventType<? extends MouseEvent>)MouseEvent.MOUSE_DRAGGED, this::dispatchMouseDragged);
        }

        void forward(MouseEvent event) {
            EventType eventType = event.getEventType();
            if (this.mouseEventHandlers.containsKey(eventType)) {
                this.mouseEventHandlers.get(eventType).accept(event);
            } else {
                Logger.debug((String)"Handler is not found for the event type: {0}", (Object[])new Object[]{eventType});
            }
        }

        private MouseButton getMouseButton(MouseEvent event) {
            if (event.getButton() == javafx.scene.input.MouseButton.NONE) {
                return MouseButton.NO_BUTTON;
            }
            if (event.getButton() == javafx.scene.input.MouseButton.PRIMARY) {
                return MouseButton.PRIMARY;
            }
            if (event.getButton() == javafx.scene.input.MouseButton.SECONDARY) {
                return MouseButton.SECONDARY;
            }
            if (event.getButton() == javafx.scene.input.MouseButton.MIDDLE) {
                return MouseButton.MIDDLE;
            }
            return MouseButton.MOUSE_BUTTON_UNSPECIFIED;
        }

        private Point getLocalPoint(MouseEvent event) {
            double x = event.getX();
            double y = event.getY();
            Point point = OffScreenRenderWidget.this.createPoint(x, y);
            if (!HiDpi.isPlatformDpiAware(OffScreenRenderWidget.this.display.scaleFactor())) {
                return Geometry.scaleDown((Point)point, (double)OffScreenRenderWidget.this.display.scaleFactor());
            }
            return point;
        }

        private Point getScreenPoint(MouseEvent event) {
            double screenX = event.getScreenX();
            double screenY = event.getScreenY();
            Point point = Geometry.newPoint((double)screenX, (double)screenY);
            if (!HiDpi.isPlatformDpiAware(OffScreenRenderWidget.this.display.scaleFactor())) {
                return Geometry.scaleDown((Point)point, (double)OffScreenRenderWidget.this.display.scaleFactor());
            }
            return point;
        }

        private KeyModifiers getKeyModifiers(MouseEvent event) {
            return KeyModifiers.newBuilder().altDown(event.isAltDown()).shiftDown(event.isShiftDown()).controlDown(event.isControlDown()).metaDown(event.isMetaDown()).build();
        }

        private MouseModifiers getMouseModifiers(MouseEvent event) {
            return MouseModifiers.newBuilder().primaryButtonDown(event.isPrimaryButtonDown()).middleButtonDown(event.isMiddleButtonDown()).secondaryButtonDown(event.isSecondaryButtonDown()).build();
        }

        private void dispatchMouseEntered(MouseEvent event) {
            OffScreenRenderWidget.this.widget.dispatch(MouseEntered.newBuilder((Point)this.getLocalPoint(event)).button(this.getMouseButton(event)).locationOnScreen(this.getScreenPoint(event)).keyModifiers(this.getKeyModifiers(event)).mouseModifiers(this.getMouseModifiers(event)).build());
        }

        private void dispatchMouseExited(MouseEvent event) {
            OffScreenRenderWidget.this.widget.dispatch(MouseExited.newBuilder((Point)this.getLocalPoint(event)).button(this.getMouseButton(event)).locationOnScreen(this.getScreenPoint(event)).keyModifiers(this.getKeyModifiers(event)).mouseModifiers(this.getMouseModifiers(event)).build());
        }

        private void dispatchMouseMoved(MouseEvent event) {
            OffScreenRenderWidget.this.widget.dispatch(MouseMoved.newBuilder((Point)this.getLocalPoint(event)).locationOnScreen(this.getScreenPoint(event)).keyModifiers(this.getKeyModifiers(event)).mouseModifiers(this.getMouseModifiers(event)).build());
        }

        private void dispatchMousePressed(MouseEvent event) {
            if (OffScreenRenderWidget.this.isComposingImeText) {
                OffScreenRenderWidget.this.cancelImeComposition(true);
                return;
            }
            OffScreenRenderWidget.this.widget.dispatch(MousePressed.newBuilder((Point)this.getLocalPoint(event)).button(this.getMouseButton(event)).locationOnScreen(this.getScreenPoint(event)).clickCount(event.getClickCount()).keyModifiers(this.getKeyModifiers(event)).mouseModifiers(this.getMouseModifiers(event)).build());
        }

        private void dispatchMouseReleased(MouseEvent event) {
            OffScreenRenderWidget.this.widget.dispatch(MouseReleased.newBuilder((Point)this.getLocalPoint(event)).button(this.getMouseButton(event)).locationOnScreen(this.getScreenPoint(event)).clickCount(event.getClickCount()).keyModifiers(this.getKeyModifiers(event)).mouseModifiers(this.getMouseModifiers(event)).build());
        }

        private void dispatchMouseDragged(MouseEvent event) {
            OffScreenRenderWidget.this.widget.dispatch(MouseDragged.newBuilder((Point)this.getLocalPoint(event)).button(this.getMouseButton(event)).locationOnScreen(this.getScreenPoint(event)).keyModifiers(this.getKeyModifiers(event)).mouseModifiers(this.getMouseModifiers(event)).build());
        }
    }

    private class SceneChangeListener
    implements ChangeListener<Scene> {
        private SceneChangeListener() {
        }

        public void changed(ObservableValue<? extends Scene> observable, Scene oldValue, Scene newValue) {
            Platform.runLater(() -> this.setScene(newValue));
        }

        private void setScene(Scene newScene) {
            if (OffScreenRenderWidget.this.scene != null) {
                OffScreenRenderWidget.this.scene.windowProperty().removeListener((ChangeListener)OffScreenRenderWidget.this.sceneWindowListener);
                OffScreenRenderWidget.this.setWindow(null);
            }
            OffScreenRenderWidget.this.scene = newScene;
            if (OffScreenRenderWidget.this.scene != null) {
                OffScreenRenderWidget.this.scene.windowProperty().addListener((ChangeListener)OffScreenRenderWidget.this.sceneWindowListener);
                OffScreenRenderWidget.this.setWindow(OffScreenRenderWidget.this.scene.getWindow());
                OffScreenRenderWidget.this.tabTracker.restart();
            }
        }
    }

    private class SceneWindowListener
    implements ChangeListener<Window> {
        private SceneWindowListener() {
        }

        public void changed(ObservableValue<? extends Window> observable, Window oldValue, Window newValue) {
            OffScreenRenderWidget.this.setWindow(newValue);
        }
    }

    private class ScrollListener
    implements EventHandler<ScrollEvent> {
        private ScrollListener() {
        }

        public void handle(ScrollEvent event) {
            double deltaX = event.getDeltaX();
            double deltaY = event.getDeltaY();
            if (event.getTextDeltaXUnits() != ScrollEvent.HorizontalTextScrollUnits.NONE) {
                deltaX *= Math.abs(event.getTextDeltaX());
                deltaY *= Math.abs(event.getTextDeltaY());
            }
            MouseWheel mouseWheel = MouseWheel.newBuilder((Point)this.localPointOf(event)).locationOnScreen(this.localPointOf(event)).deltaX((float)deltaX).deltaY((float)deltaY).scrollType(ScrollType.UNIT_SCROLL).keyModifiers(this.keyModifiers(event)).build();
            OffScreenRenderWidget.this.widget.dispatch(mouseWheel);
        }

        private KeyModifiers keyModifiers(ScrollEvent event) {
            return KeyModifiers.newBuilder().altDown(event.isAltDown()).shiftDown(event.isShiftDown()).controlDown(event.isControlDown()).metaDown(event.isMetaDown()).build();
        }

        private Point localPointOf(ScrollEvent event) {
            double x = event.getX();
            double y = event.getY();
            Point point = OffScreenRenderWidget.this.createPoint(x, y);
            if (!HiDpi.isPlatformDpiAware(OffScreenRenderWidget.this.display.scaleFactor())) {
                return Geometry.scaleDown((Point)point, (double)OffScreenRenderWidget.this.display.scaleFactor());
            }
            return point;
        }
    }

    private static class KeyListener
    implements EventHandler<KeyEvent> {
        private static final List<KeyCode> NOT_TRAVERSIBLES = ImmutableList.of((Object)KeyCode.TAB, (Object)KeyCode.UP, (Object)KeyCode.DOWN, (Object)KeyCode.LEFT, (Object)KeyCode.RIGHT);
        private final KeyboardBridge keyboardBridge;

        KeyListener(OffScreenRenderWidget widget) {
            this.keyboardBridge = KeyboardBridge.newInstance(widget);
        }

        public void handle(KeyEvent event) {
            if (FocusTraversal.isTraversalEvent(event)) {
                return;
            }
            this.suppressTraversalKeys(event);
            this.keyboardBridge.forward(event);
        }

        private void suppressTraversalKeys(KeyEvent event) {
            KeyCode keyCode = event.getCode();
            if (NOT_TRAVERSIBLES.contains(keyCode)) {
                event.consume();
            }
        }
    }

    private class MouseListener
    implements EventHandler<MouseEvent> {
        private MouseListener() {
        }

        public void handle(MouseEvent event) {
            if (OffScreenRenderWidget.this.dragAndDropHelper.handleMouseEvent(event)) {
                return;
            }
            OffScreenRenderWidget.this.mouseEventForwarder.forward(event);
        }
    }

    private class FocusListener
    implements ChangeListener<Boolean> {
        private FocusListener() {
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            if (OffScreenRenderWidget.this.widget.isClosed()) {
                return;
            }
            if (OffScreenRenderWidget.this.isFocused()) {
                OffScreenRenderWidget.this.widget.focus();
            } else if (!OffScreenRenderWidget.this.skipUnfocus) {
                OffScreenRenderWidget.this.widget.unfocus();
                if (OffScreenRenderWidget.this.isComposingImeText) {
                    OffScreenRenderWidget.this.cancelImeComposition(true);
                }
            }
        }
    }

    private class SizeChangedListener {
        private final ChangeListener<Number> listener = (observable, oldValue, newValue) -> OffScreenRenderWidget.this.notifyBoundsUpdated();

        private SizeChangedListener() {
        }

        private void start() {
            OffScreenRenderWidget.this.heightProperty().addListener(this.listener);
            OffScreenRenderWidget.this.widthProperty().addListener(this.listener);
        }

        private void stop() {
            OffScreenRenderWidget.this.heightProperty().removeListener(this.listener);
            OffScreenRenderWidget.this.widthProperty().removeListener(this.listener);
        }
    }
}

