/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal.dialog;

import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.view.javafx.internal.dialog.FxDialog;
import java.util.Collection;
import javafx.collections.FXCollections;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.layout.Pane;
import javafx.stage.Window;

public final class SelectDialog
extends FxDialog<SelectDialog> {
    private final ListView<String> listView;
    private final ImmutableList<String> items;

    public static Builder newBuilder(Window owner, String message) {
        return new Builder(owner, message);
    }

    private SelectDialog(Builder builder) {
        super(builder);
        this.items = builder.items.build();
        this.listView = new ListView();
    }

    @Override
    protected void fillContentPanel(Pane contentPane) {
        this.listView.setItems(FXCollections.observableArrayList(this.items));
        this.listView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.listView.getSelectionModel().select(0);
        contentPane.getChildren().add(this.listView);
    }

    public String selectedValue() {
        return (String)this.listView.getSelectionModel().getSelectedItem();
    }

    protected SelectDialog self() {
        return this;
    }

    public static final class Builder
    extends FxDialog.FxDialogBuilder<SelectDialog, Builder> {
        private final ImmutableList.Builder<String> items = ImmutableList.builder();

        private Builder(Window owner, String message) {
            super(owner, message);
        }

        public Builder addAllItems(Collection<String> items) {
            this.items.addAll(items);
            return this.self();
        }

        public SelectDialog createDialog() {
            return new SelectDialog(this);
        }

        protected Builder self() {
            return this;
        }
    }
}

