/*
 * Decompiled with CFR 0.152.
 */
package de.jangassen.listener;

import java.util.List;
import javafx.collections.ListChangeListener;
import javafx.stage.Window;

public class WindowShowingEventListener
implements ListChangeListener<Window> {
    private final Runnable action;

    public WindowShowingEventListener(Runnable action) {
        this.action = action;
    }

    public void onChanged(ListChangeListener.Change<? extends Window> change) {
        while (change.next()) {
            this.watchWindows(change.getAddedSubList());
        }
    }

    private void watchWindows(List<? extends Window> windows) {
        windows.forEach(this::handleWindowAdded);
    }

    private void handleWindowAdded(Window added) {
        if (added.isShowing()) {
            this.action.run();
        } else {
            added.showingProperty().addListener((observableValue, oldValue, newValue) -> {
                if (Boolean.TRUE.equals(newValue)) {
                    this.action.run();
                }
            });
        }
    }
}

