/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.json;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.io.IOException;

public class JCardPrettyPrinter
extends DefaultPrettyPrinter {
    private static final long serialVersionUID = 1L;
    public static final Object PROPERTY_VALUE = "vcard-property";
    private static final DefaultPrettyPrinter.Indenter NEWLINE_INDENTER = DefaultIndenter.SYSTEM_LINEFEED_INSTANCE;
    private static final DefaultPrettyPrinter.Indenter INLINE_INDENTER = new DefaultPrettyPrinter.FixedSpaceIndenter();
    private DefaultPrettyPrinter.Indenter propertyIndenter;
    private DefaultPrettyPrinter.Indenter arrayIndenter;
    private DefaultPrettyPrinter.Indenter objectIndenter;

    public JCardPrettyPrinter() {
        this.propertyIndenter = INLINE_INDENTER;
        this.indentArraysWith(NEWLINE_INDENTER);
        this.indentObjectsWith(NEWLINE_INDENTER);
    }

    public JCardPrettyPrinter(JCardPrettyPrinter base) {
        super(base);
        this.propertyIndenter = base.propertyIndenter;
        this.indentArraysWith(base.arrayIndenter);
        this.indentObjectsWith(base.objectIndenter);
    }

    @Override
    public JCardPrettyPrinter createInstance() {
        return new JCardPrettyPrinter(this);
    }

    @Override
    public void indentArraysWith(DefaultPrettyPrinter.Indenter indenter) {
        this.arrayIndenter = indenter;
        super.indentArraysWith(indenter);
    }

    @Override
    public void indentObjectsWith(DefaultPrettyPrinter.Indenter indenter) {
        this.objectIndenter = indenter;
        super.indentObjectsWith(indenter);
    }

    public void indentVCardPropertiesWith(DefaultPrettyPrinter.Indenter indenter) {
        this.propertyIndenter = indenter;
    }

    protected static boolean isInVCardProperty(JsonStreamContext context) {
        if (context == null) {
            return false;
        }
        Object currentValue = context.getCurrentValue();
        if (currentValue == PROPERTY_VALUE) {
            return true;
        }
        return JCardPrettyPrinter.isInVCardProperty(context.getParent());
    }

    private void updateIndenter(JsonStreamContext context) {
        boolean inVCardProperty = JCardPrettyPrinter.isInVCardProperty(context);
        super.indentArraysWith(inVCardProperty ? this.propertyIndenter : this.arrayIndenter);
        super.indentObjectsWith(inVCardProperty ? this.propertyIndenter : this.objectIndenter);
    }

    @Override
    public void writeStartArray(JsonGenerator gen) throws IOException, JsonGenerationException {
        this.updateIndenter(gen.getOutputContext().getParent());
        super.writeStartArray(gen);
    }

    @Override
    public void writeEndArray(JsonGenerator gen, int numValues) throws IOException, JsonGenerationException {
        this.updateIndenter(gen.getOutputContext().getParent());
        super.writeEndArray(gen, numValues);
    }

    @Override
    public void writeArrayValueSeparator(JsonGenerator gen) throws IOException {
        this.updateIndenter(gen.getOutputContext().getParent());
        super.writeArrayValueSeparator(gen);
    }
}

