/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.scribe;

import com.github.mangstadt.vinnie.io.VObjectPropertyValues;
import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.io.ParseContext;
import ezvcard.io.json.JCardValue;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.io.text.WriteContext;
import ezvcard.io.xml.XCardElement;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.ListProperty;
import ezvcard.property.TextListProperty;
import java.util.List;

public abstract class ListPropertyScribe<T extends TextListProperty>
extends VCardPropertyScribe<T> {
    public ListPropertyScribe(Class<T> clazz, String propertyName) {
        super(clazz, propertyName);
    }

    @Override
    protected VCardDataType _defaultDataType(VCardVersion version) {
        return VCardDataType.TEXT;
    }

    @Override
    protected String _writeText(T property, WriteContext context) {
        return VObjectPropertyValues.writeList(((ListProperty)property).getValues());
    }

    @Override
    protected T _parseText(String value, VCardDataType dataType, VCardParameters parameters, ParseContext context) {
        List<String> values = VObjectPropertyValues.parseList(value);
        return this.parse(values);
    }

    @Override
    protected void _writeXml(T property, XCardElement parent) {
        parent.append(VCardDataType.TEXT.getName().toLowerCase(), ((ListProperty)property).getValues());
    }

    @Override
    protected T _parseXml(XCardElement element, VCardParameters parameters, ParseContext context) {
        List<String> values = element.all(VCardDataType.TEXT);
        if (!values.isEmpty()) {
            return this.parse(values);
        }
        throw ListPropertyScribe.missingXmlElements(VCardDataType.TEXT);
    }

    @Override
    protected JCardValue _writeJson(T property) {
        List values = ((ListProperty)property).getValues();
        if (values.isEmpty()) {
            return JCardValue.single("");
        }
        return JCardValue.multi(values);
    }

    @Override
    protected T _parseJson(JCardValue value, VCardDataType dataType, VCardParameters parameters, ParseContext context) {
        List<String> values = value.asMulti();
        return this.parse(values);
    }

    private T parse(List<String> values) {
        T property = this._newInstance();
        ((ListProperty)property).getValues().addAll(values);
        return property;
    }

    protected abstract T _newInstance();
}

