/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.text;

import com.github.mangstadt.vinnie.VObjectProperty;
import com.github.mangstadt.vinnie.io.Context;
import com.github.mangstadt.vinnie.io.SyntaxRules;
import com.github.mangstadt.vinnie.io.VObjectDataListener;
import com.github.mangstadt.vinnie.io.VObjectPropertyValues;
import com.github.mangstadt.vinnie.io.VObjectReader;
import com.github.mangstadt.vinnie.io.Warning;
import ezvcard.VCard;
import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.io.CannotParseException;
import ezvcard.io.EmbeddedVCardException;
import ezvcard.io.ParseWarning;
import ezvcard.io.SkipMeException;
import ezvcard.io.StreamReader;
import ezvcard.io.scribe.RawPropertyScribe;
import ezvcard.parameter.Encoding;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.Address;
import ezvcard.property.Label;
import ezvcard.property.VCardProperty;
import ezvcard.util.IOUtils;
import ezvcard.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class VCardReader
extends StreamReader {
    private final VObjectReader reader;
    private final VCardVersion defaultVersion;

    public VCardReader(String str) {
        this(str, VCardVersion.V2_1);
    }

    public VCardReader(String str, VCardVersion defaultVersion) {
        this(new StringReader(str), defaultVersion);
    }

    public VCardReader(InputStream in) {
        this(in, VCardVersion.V2_1);
    }

    public VCardReader(InputStream in, VCardVersion defaultVersion) {
        this(new InputStreamReader(in), defaultVersion);
    }

    public VCardReader(Path file) throws IOException {
        this(file, VCardVersion.V2_1);
    }

    public VCardReader(Path file, VCardVersion defaultVersion) throws IOException {
        this(Files.newBufferedReader(file), defaultVersion);
    }

    public VCardReader(Reader reader) {
        this(reader, VCardVersion.V2_1);
    }

    public VCardReader(Reader reader, VCardVersion defaultVersion) {
        SyntaxRules rules = SyntaxRules.vcard();
        rules.setDefaultSyntaxStyle(defaultVersion.getSyntaxStyle());
        this.reader = new VObjectReader(reader, rules);
        this.defaultVersion = defaultVersion;
    }

    public boolean isCaretDecodingEnabled() {
        return this.reader.isCaretDecodingEnabled();
    }

    public void setCaretDecodingEnabled(boolean enable) {
        this.reader.setCaretDecodingEnabled(enable);
    }

    public Charset getDefaultQuotedPrintableCharset() {
        return this.reader.getDefaultQuotedPrintableCharset();
    }

    public void setDefaultQuotedPrintableCharset(Charset charset) {
        this.reader.setDefaultQuotedPrintableCharset(charset);
    }

    @Override
    protected VCard _readNext() throws IOException {
        VObjectDataListenerImpl listener = new VObjectDataListenerImpl();
        this.reader.parse(listener);
        return listener.root;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    private static class VCardStack {
        private final List<Item> stack = new ArrayList<Item>();

        private VCardStack() {
        }

        public void push(VCard vcard) {
            this.stack.add(new Item(vcard, new ArrayList<Label>()));
        }

        public Item pop() {
            return this.isEmpty() ? null : this.stack.remove(this.stack.size() - 1);
        }

        public Item peek() {
            return this.isEmpty() ? null : this.stack.get(this.stack.size() - 1);
        }

        public boolean isEmpty() {
            return this.stack.isEmpty();
        }

        private static class Item {
            public final VCard vcard;
            public final List<Label> labels;

            public Item(VCard vcard, List<Label> labels) {
                this.vcard = vcard;
                this.labels = labels;
            }
        }
    }

    private class VObjectDataListenerImpl
    implements VObjectDataListener {
        private VCard root;
        private final VCardStack stack = new VCardStack();
        private EmbeddedVCardException embeddedVCardException;

        private VObjectDataListenerImpl() {
        }

        @Override
        public void onComponentBegin(String name, Context context) {
            if (!this.isVCardComponent(name)) {
                return;
            }
            VCard vcard = new VCard(VCardReader.this.defaultVersion);
            if (this.stack.isEmpty()) {
                this.root = vcard;
            }
            this.stack.push(vcard);
            if (this.embeddedVCardException != null) {
                this.embeddedVCardException.injectVCard(vcard);
                this.embeddedVCardException = null;
            }
        }

        @Override
        public void onComponentEnd(String name, Context context) {
            if (!this.isVCardComponent(name)) {
                return;
            }
            VCardStack.Item item = this.stack.pop();
            VCardReader.this.assignLabels(item.vcard, item.labels);
            if (this.stack.isEmpty()) {
                context.stop();
            }
        }

        @Override
        public void onProperty(VObjectProperty vobjectProperty, Context vobjectContext) {
            VCard curVCard;
            VCardVersion version;
            VCardProperty property;
            if (!this.inVCardComponent(vobjectContext.getParentComponents())) {
                return;
            }
            if (this.embeddedVCardException != null) {
                this.embeddedVCardException.injectVCard(null);
                this.embeddedVCardException = null;
            }
            if ((property = this.parseProperty(vobjectProperty, version = (curVCard = this.stack.peek().vcard).getVersion(), vobjectContext.getLineNumber())) != null) {
                curVCard.addProperty(property);
            }
        }

        private VCardProperty parseProperty(VObjectProperty vobjectProperty, VCardVersion version, int lineNumber) {
            Object property;
            String group = vobjectProperty.getGroup();
            String name = vobjectProperty.getName();
            VCardParameters parameters = new VCardParameters(vobjectProperty.getParameters().getMap());
            String value = vobjectProperty.getValue();
            VCardReader.this.context.getWarnings().clear();
            VCardReader.this.context.setVersion(version);
            VCardReader.this.context.setLineNumber(lineNumber);
            VCardReader.this.context.setPropertyName(name);
            this.processNamelessParameters(parameters);
            this.processQuotedMultivaluedTypeParams(parameters, version);
            RawPropertyScribe scribe = VCardReader.this.index.getPropertyScribe(name);
            if (scribe == null) {
                scribe = new RawPropertyScribe(name);
            }
            VCardDataType dataType = parameters.getValue();
            parameters.setValue(null);
            if (dataType == null) {
                dataType = scribe.defaultDataType(version);
            }
            try {
                property = scribe.parseText(value, dataType, parameters, VCardReader.this.context);
                VCardReader.this.warnings.addAll(VCardReader.this.context.getWarnings());
            }
            catch (SkipMeException e) {
                this.handleSkippedProperty(name, lineNumber, e);
                return null;
            }
            catch (CannotParseException e) {
                property = this.handleUnparseableProperty(name, parameters, value, dataType, lineNumber, version, e);
            }
            catch (EmbeddedVCardException e) {
                this.handledEmbeddedVCard(name, value, lineNumber, e);
                property = e.getProperty();
            }
            ((VCardProperty)property).setGroup(group);
            if (property instanceof Label) {
                Label label = (Label)property;
                this.stack.peek().labels.add(label);
                return null;
            }
            this.handleLabelParameter((VCardProperty)property);
            return property;
        }

        private void handleSkippedProperty(String propertyName, int lineNumber, SkipMeException e) {
            VCardReader.this.warnings.add(new ParseWarning.Builder(VCardReader.this.context).message(22, e.getMessage()).build());
        }

        private VCardProperty handleUnparseableProperty(String name, VCardParameters parameters, String value, VCardDataType dataType, int lineNumber, VCardVersion version, CannotParseException e) {
            VCardReader.this.warnings.add(new ParseWarning.Builder(VCardReader.this.context).message(e).build());
            RawPropertyScribe scribe = new RawPropertyScribe(name);
            return scribe.parseText(value, dataType, parameters, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handledEmbeddedVCard(String name, String value, int lineNumber, EmbeddedVCardException exception) {
            if (value.trim().isEmpty()) {
                this.embeddedVCardException = exception;
                return;
            }
            value = VObjectPropertyValues.unescape(value);
            VCardReader agentReader = new VCardReader(value);
            agentReader.setCaretDecodingEnabled(VCardReader.this.isCaretDecodingEnabled());
            agentReader.setDefaultQuotedPrintableCharset(VCardReader.this.getDefaultQuotedPrintableCharset());
            agentReader.setScribeIndex(VCardReader.this.index);
            try {
                VCard nestedVCard = agentReader.readNext();
                if (nestedVCard != null) {
                    exception.injectVCard(nestedVCard);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                VCardReader.this.warnings.addAll(agentReader.getWarnings());
                IOUtils.closeQuietly(agentReader);
            }
        }

        private void handleLabelParameter(VCardProperty property) {
            if (!(property instanceof Address)) {
                return;
            }
            Address adr = (Address)property;
            String label = adr.getLabel();
            if (label == null) {
                return;
            }
            label = label.replace("\\n", StringUtils.NEWLINE);
            adr.setLabel(label);
        }

        @Override
        public void onVersion(String value, Context vobjectContext) {
            VCardVersion version = VCardVersion.valueOfByStr(value);
            VCardReader.this.context.setVersion(version);
            this.stack.peek().vcard.setVersion(version);
        }

        @Override
        public void onWarning(Warning warning, VObjectProperty property, Exception thrown, Context vobjectContext) {
            if (!this.inVCardComponent(vobjectContext.getParentComponents())) {
                return;
            }
            VCardReader.this.warnings.add(new ParseWarning.Builder(VCardReader.this.context).lineNumber(vobjectContext.getLineNumber()).propertyName(property == null ? null : property.getName()).message(27, warning.getMessage(), vobjectContext.getUnfoldedLine()).build());
        }

        private boolean inVCardComponent(List<String> parentComponents) {
            if (parentComponents.isEmpty()) {
                return false;
            }
            String last = parentComponents.get(parentComponents.size() - 1);
            return this.isVCardComponent(last);
        }

        private boolean isVCardComponent(String componentName) {
            return "VCARD".equals(componentName);
        }

        private void processNamelessParameters(VCardParameters parameters) {
            List namelessValues = parameters.removeAll(null);
            for (String value : namelessValues) {
                String name = this.guessParameterName(value);
                parameters.put(name, value);
            }
        }

        private String guessParameterName(String value) {
            if (VCardDataType.find(value) != null) {
                return "VALUE";
            }
            if (Encoding.find(value) != null) {
                return "ENCODING";
            }
            return "TYPE";
        }

        private void processQuotedMultivaluedTypeParams(VCardParameters parameters, VCardVersion version) {
            int cur;
            if (version == VCardVersion.V2_1) {
                return;
            }
            List<String> types = parameters.getTypes();
            if (types.isEmpty()) {
                return;
            }
            String valueWithComma = null;
            for (String value : types) {
                if (value.indexOf(44) < 0) continue;
                valueWithComma = value;
                break;
            }
            if (valueWithComma == null) {
                return;
            }
            types.clear();
            int prev = -1;
            while ((cur = valueWithComma.indexOf(44, prev + 1)) >= 0) {
                types.add(valueWithComma.substring(prev + 1, cur));
                prev = cur;
            }
            types.add(valueWithComma.substring(prev + 1));
        }
    }
}

