/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.xml;

import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.io.StreamWriter;
import ezvcard.parameter.VCardParameters;
import java.util.HashMap;
import java.util.Map;

abstract class XCardWriterBase
extends StreamWriter {
    protected final VCardVersion targetVersion = VCardVersion.V4_0;
    protected final Map<String, VCardDataType> parameterDataTypes = new HashMap<String, VCardDataType>();

    XCardWriterBase() {
        this.registerParameterDataType("ALTID", VCardDataType.TEXT);
        this.registerParameterDataType("CALSCALE", VCardDataType.TEXT);
        this.registerParameterDataType("GEO", VCardDataType.URI);
        this.registerParameterDataType("INDEX", VCardDataType.INTEGER);
        this.registerParameterDataType("LABEL", VCardDataType.TEXT);
        this.registerParameterDataType("LANGUAGE", VCardDataType.LANGUAGE_TAG);
        this.registerParameterDataType("LEVEL", VCardDataType.TEXT);
        this.registerParameterDataType("MEDIATYPE", VCardDataType.TEXT);
        this.registerParameterDataType("PID", VCardDataType.TEXT);
        this.registerParameterDataType("PREF", VCardDataType.INTEGER);
        this.registerParameterDataType("SORT-AS", VCardDataType.TEXT);
        this.registerParameterDataType("TYPE", VCardDataType.TEXT);
        this.registerParameterDataType("TZ", VCardDataType.URI);
    }

    @Override
    protected VCardVersion getTargetVersion() {
        return this.targetVersion;
    }

    protected void removeUnsupportedParameters(VCardParameters parameters) {
        parameters.setCharset(null);
        parameters.setEncoding(null);
        parameters.setValue(null);
    }

    public void registerParameterDataType(String parameterName, VCardDataType dataType) {
        parameterName = parameterName.toLowerCase();
        if (dataType == null) {
            this.parameterDataTypes.remove(parameterName);
        } else {
            this.parameterDataTypes.put(parameterName, dataType);
        }
    }
}

