/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.util;

import ezvcard.Messages;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.DateTimeException;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PartialDate {
    private static final int YEAR = 0;
    private static final int MONTH = 1;
    private static final int DATE = 2;
    private static final int HOUR = 3;
    private static final int MINUTE = 4;
    private static final int SECOND = 5;
    private static final int OFFSET_HOUR = 6;
    private static final int OFFSET_MINUTE = 7;
    private static final Format[] dateFormats = new Format[]{new Format("(\\d{4})", 0), new Format("(\\d{4})-(\\d{2})", 0, 1), new Format("(\\d{4})-?(\\d{2})-?(\\d{2})", 0, 1, 2), new Format("--(\\d{2})-?(\\d{2})", 1, 2), new Format("--(\\d{2})", 1), new Format("---(\\d{2})", 2)};
    private static final String offsetRegex = "(([-+]\\d{1,2}):?(\\d{2})?)?";
    private static final Format[] timeFormats = new Format[]{new Format("(\\d{2})(([-+]\\d{1,2}):?(\\d{2})?)?", 3, null, 6, 7), new Format("(\\d{2}):?(\\d{2})(([-+]\\d{1,2}):?(\\d{2})?)?", 3, 4, null, 6, 7), new Format("(\\d{2}):?(\\d{2}):?(\\d{2})(([-+]\\d{1,2}):?(\\d{2})?)?", 3, 4, 5, null, 6, 7), new Format("-(\\d{2}):?(\\d{2})(([-+]\\d{1,2}):?(\\d{2})?)?", 4, 5, null, 6, 7), new Format("-(\\d{2})(([-+]\\d{1,2}):?(\\d{2})?)?", 4, null, 6, 7), new Format("--(\\d{2})(([-+]\\d{1,2}):?(\\d{2})?)?", 5, null, 6, 7)};
    private final Integer[] components;

    private PartialDate(Integer[] components) {
        this.components = components;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PartialDate orig) {
        return new Builder(orig);
    }

    public static PartialDate parse(String string) {
        boolean success;
        String afterT;
        String beforeT;
        int t = string.indexOf(84);
        if (t < 0) {
            beforeT = string;
            afterT = null;
        } else {
            beforeT = string.substring(0, t);
            afterT = t < string.length() - 1 ? string.substring(t + 1) : null;
        }
        Builder builder = new Builder();
        if (afterT == null) {
            success = PartialDate.parseDate(beforeT, builder) || PartialDate.parseTime(beforeT, builder);
        } else if (beforeT.isEmpty()) {
            success = PartialDate.parseTime(afterT, builder);
        } else {
            boolean bl = success = PartialDate.parseDate(beforeT, builder) && PartialDate.parseTime(afterT, builder);
        }
        if (!success) {
            throw Messages.INSTANCE.getIllegalArgumentException(36, string);
        }
        return builder.build();
    }

    private static boolean parseDate(String value, Builder builder) {
        return PartialDate.parseFormats(value, builder, dateFormats);
    }

    private static boolean parseTime(String value, Builder builder) {
        return PartialDate.parseFormats(value, builder, timeFormats);
    }

    private static boolean parseFormats(String value, Builder builder, Format[] formats) {
        for (Format regex : formats) {
            if (!regex.parse(builder, value)) continue;
            return true;
        }
        return false;
    }

    public Integer getYear() {
        return this.components[0];
    }

    private boolean hasYear() {
        return this.getYear() != null;
    }

    public Integer getMonth() {
        return this.components[1];
    }

    private boolean hasMonth() {
        return this.getMonth() != null;
    }

    public Integer getDate() {
        return this.components[2];
    }

    private boolean hasDate() {
        return this.getDate() != null;
    }

    public Integer getHour() {
        return this.components[3];
    }

    private boolean hasHour() {
        return this.getHour() != null;
    }

    public Integer getMinute() {
        return this.components[4];
    }

    private boolean hasMinute() {
        return this.getMinute() != null;
    }

    public Integer getSecond() {
        return this.components[5];
    }

    private boolean hasSecond() {
        return this.getSecond() != null;
    }

    public ZoneOffset getUtcOffset() {
        Integer hour = this.components[6];
        if (hour == null) {
            return null;
        }
        Integer minute = this.components[7];
        if (minute == null) {
            return ZoneOffset.ofHours(hour);
        }
        return ZoneOffset.ofHoursMinutes(hour, minute);
    }

    public boolean hasDateComponent() {
        return this.hasYear() || this.hasMonth() || this.hasDate();
    }

    public boolean hasTimeComponent() {
        return this.hasHour() || this.hasMinute() || this.hasSecond();
    }

    public String toISO8601(boolean extended) {
        String dash;
        int maxPossibleLength = 25;
        StringBuilder sb = new StringBuilder(25);
        DecimalFormat nf = new DecimalFormat("00", DecimalFormatSymbols.getInstance(Locale.ROOT));
        String yearStr = this.hasYear() ? this.getYear().toString() : null;
        String monthStr = this.hasMonth() ? nf.format(this.getMonth()) : null;
        String dateStr = this.hasDate() ? nf.format(this.getDate()) : null;
        String string = dash = extended ? "-" : "";
        if (this.hasYear() && !this.hasMonth() && !this.hasDate()) {
            sb.append(yearStr);
        } else if (!this.hasYear() && this.hasMonth() && !this.hasDate()) {
            sb.append("--").append(monthStr);
        } else if (!this.hasYear() && !this.hasMonth() && this.hasDate()) {
            sb.append("---").append(dateStr);
        } else if (this.hasYear() && this.hasMonth() && !this.hasDate()) {
            sb.append(yearStr).append("-").append(monthStr);
        } else if (!this.hasYear() && this.hasMonth() && this.hasDate()) {
            sb.append("--").append(monthStr).append(dash).append(dateStr);
        } else {
            if (this.hasYear() && !this.hasMonth() && this.hasDate()) {
                throw new IllegalStateException(Messages.INSTANCE.getExceptionMessage(38, new Object[0]));
            }
            if (this.hasYear() && this.hasMonth() && this.hasDate()) {
                sb.append(yearStr).append(dash).append(monthStr).append(dash).append(dateStr);
            }
        }
        if (this.hasTimeComponent()) {
            sb.append('T');
            String hourStr = this.hasHour() ? nf.format(this.getHour()) : null;
            String minuteStr = this.hasMinute() ? nf.format(this.getMinute()) : null;
            String secondStr = this.hasSecond() ? nf.format(this.getSecond()) : null;
            String string2 = dash = extended ? ":" : "";
            if (this.hasHour() && !this.hasMinute() && !this.hasSecond()) {
                sb.append(hourStr);
            } else if (!this.hasHour() && this.hasMinute() && !this.hasSecond()) {
                sb.append("-").append(minuteStr);
            } else if (!this.hasHour() && !this.hasMinute() && this.hasSecond()) {
                sb.append("--").append(secondStr);
            } else if (this.hasHour() && this.hasMinute() && !this.hasSecond()) {
                sb.append(hourStr).append(dash).append(minuteStr);
            } else if (!this.hasHour() && this.hasMinute() && this.hasSecond()) {
                sb.append("-").append(minuteStr).append(dash).append(secondStr);
            } else {
                if (this.hasHour() && !this.hasMinute() && this.hasSecond()) {
                    throw new IllegalStateException(Messages.INSTANCE.getExceptionMessage(39, new Object[0]));
                }
                if (this.hasHour() && this.hasMinute() && this.hasSecond()) {
                    sb.append(hourStr).append(dash).append(minuteStr).append(dash).append(secondStr);
                }
            }
            Integer offsetHour = this.components[6];
            if (offsetHour != null) {
                Integer offsetMinute = this.components[7];
                String offsetHourStr = nf.format(Math.abs(offsetHour));
                String offsetMinuteStr = nf.format(Math.abs(offsetMinute));
                sb.append((char)(offsetHour < 0 || offsetMinute < 0 ? 45 : 43));
                sb.append(offsetHourStr).append(dash).append(offsetMinuteStr);
            }
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode((Object[])this.components);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PartialDate other = (PartialDate)obj;
        return Arrays.equals((Object[])this.components, (Object[])other.components);
    }

    public String toString() {
        return this.toISO8601(true);
    }

    public static class Builder {
        private final Integer[] components;

        public Builder() {
            this.components = new Integer[8];
        }

        public Builder(PartialDate original) {
            this.components = (Integer[])original.components.clone();
        }

        public Builder year(Integer year) {
            this.components[0] = year;
            return this;
        }

        public Builder month(Integer month) {
            if (month != null && (month < 1 || month > 12)) {
                throw Messages.INSTANCE.getIllegalArgumentException(37, "Month", 1, 12);
            }
            this.components[1] = month;
            return this;
        }

        public Builder date(Integer date) {
            if (date != null && (date < 1 || date > 31)) {
                throw Messages.INSTANCE.getIllegalArgumentException(37, "Date", 1, 31);
            }
            this.components[2] = date;
            return this;
        }

        public Builder hour(Integer hour) {
            if (hour != null && (hour < 0 || hour > 23)) {
                throw Messages.INSTANCE.getIllegalArgumentException(37, "Hour", 0, 23);
            }
            this.components[3] = hour;
            return this;
        }

        public Builder minute(Integer minute) {
            if (minute != null && (minute < 0 || minute > 59)) {
                throw Messages.INSTANCE.getIllegalArgumentException(37, "Minute", 0, 59);
            }
            this.components[4] = minute;
            return this;
        }

        public Builder second(Integer second) {
            if (second != null && (second < 0 || second > 59)) {
                throw Messages.INSTANCE.getIllegalArgumentException(37, "Second", 0, 59);
            }
            this.components[5] = second;
            return this;
        }

        public Builder offset(ZoneOffset offset) {
            if (offset == null) {
                this.components[6] = null;
                this.components[7] = null;
            } else {
                this.components[6] = offset.getTotalSeconds() / 3600;
                this.components[7] = offset.getTotalSeconds() % 3600 / 60;
            }
            return this;
        }

        public PartialDate build() {
            if (this.components[0] != null && this.components[1] == null && this.components[2] != null) {
                throw Messages.INSTANCE.getIllegalArgumentException(38, new Object[0]);
            }
            if (this.components[3] != null && this.components[4] == null && this.components[5] != null) {
                throw Messages.INSTANCE.getIllegalArgumentException(39, new Object[0]);
            }
            return new PartialDate(this.components);
        }
    }

    private static class Format {
        private Pattern regex;
        private Integer[] componentIndexes;

        public Format(String regex, Integer ... componentIndexes) {
            this.regex = Pattern.compile('^' + regex + '$');
            this.componentIndexes = componentIndexes;
        }

        public boolean parse(Builder builder, String value) {
            Matcher m = this.regex.matcher(value);
            if (!m.find()) {
                return false;
            }
            boolean offsetPositive = false;
            Integer offsetHour = null;
            Integer offsetMinute = null;
            for (int i = 0; i < this.componentIndexes.length; ++i) {
                int group;
                String groupStr;
                Integer index = this.componentIndexes[i];
                if (index == null || (groupStr = m.group(group = i + 1)) == null) continue;
                boolean startsWithPlus = groupStr.startsWith("+");
                if (startsWithPlus) {
                    groupStr = groupStr.substring(1);
                }
                int component = Integer.parseInt(groupStr);
                if (index == 0) {
                    builder.year(component);
                    continue;
                }
                if (index == 1) {
                    builder.month(component);
                    continue;
                }
                if (index == 2) {
                    builder.date(component);
                    continue;
                }
                if (index == 3) {
                    builder.hour(component);
                    continue;
                }
                if (index == 4) {
                    builder.minute(component);
                    continue;
                }
                if (index == 5) {
                    builder.second(component);
                    continue;
                }
                if (index == 6) {
                    offsetHour = component;
                    offsetPositive = startsWithPlus;
                    continue;
                }
                if (index != 7) continue;
                offsetMinute = component;
            }
            if (offsetHour != null) {
                ZoneOffset offset;
                if (offsetMinute == null) {
                    offsetMinute = 0;
                }
                if (!offsetPositive) {
                    offsetMinute = offsetMinute * -1;
                }
                try {
                    offset = ZoneOffset.ofHoursMinutes(offsetHour, offsetMinute);
                }
                catch (DateTimeException e) {
                    throw new IllegalArgumentException(e);
                }
                builder.offset(offset);
            }
            return true;
        }
    }
}

