/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.click2dial;

import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.nio.charset.StandardCharsets;
import net.sipsnet.client.click2dial.Click2Dial;
import net.sipsnet.client.connector.ClientSingleton;

public class Kernel32NamedPipe {
    final int MAX_BUFFER_SIZE = 1024;
    private final String TAG = this.getClass().getSimpleName();
    private WinNT.HANDLE hNamedPipe = null;
    private final boolean down = false;

    private Kernel32NamedPipe() {
    }

    public static Kernel32NamedPipe getInstance() {
        return new Kernel32NamedPipe();
    }

    private WinNT.HANDLE createNamedPipeServer() {
        WinNT.SECURITY_DESCRIPTOR sd = new WinNT.SECURITY_DESCRIPTOR(65536);
        WinBase.SECURITY_ATTRIBUTES g_sa = null;
        if (Advapi32.INSTANCE.InitializeSecurityDescriptor(sd, 1) && Advapi32.INSTANCE.SetSecurityDescriptorDacl(sd, true, null, false)) {
            g_sa = new WinBase.SECURITY_ATTRIBUTES();
            g_sa.lpSecurityDescriptor = sd.getPointer();
            g_sa.bInheritHandle = true;
        }
        ClientSingleton.toLog(this.TAG, "Kernel32NamedPipeTest g_sa " + g_sa);
        String pipeName = this.getCurrentPipeName();
        WinNT.HANDLE hNamedPipe = Kernel32.INSTANCE.CreateNamedPipe(pipeName, 3, 0, 1, 127, 127, -1, g_sa);
        ClientSingleton.toLog(this.TAG, "Kernel32NamedPipeTest hNamedPipe " + hNamedPipe);
        if (WinBase.INVALID_HANDLE_VALUE.equals((Object)hNamedPipe)) {
            ClientSingleton.toLog(this.TAG, "Kernel32NamedPipeTest WinBase.INVALID_HANDLE_VALUE " + Kernel32.INSTANCE.GetLastError());
            return null;
        }
        return hNamedPipe;
    }

    public void shutDownPipeServer() {
        ClientSingleton.toLog(this.TAG, "shutDownPipeServer hNamedPipe=" + this.hNamedPipe);
        new Thread(() -> {
            if (this.hNamedPipe != null) {
                ClientSingleton.toLog(this.TAG, "Named pipe handle close");
                Kernel32.INSTANCE.CloseHandle(this.hNamedPipe);
            }
        }).start();
    }

    public Kernel32NamedPipe startPipeServer() {
        ClientSingleton.toLog(this.TAG, "startPipeServer");
        new Thread(() -> {
            ClientSingleton.toLog(this.TAG, "run hNamedPipe=" + this.hNamedPipe + " !down : true");
            while (true) {
                if (this.hNamedPipe == null) {
                    this.hNamedPipe = this.createNamedPipeServer();
                }
                if (this.hNamedPipe == null) {
                    return;
                }
                Kernel32.INSTANCE.ConnectNamedPipe(this.hNamedPipe, null);
                byte[] readBuffer = new byte[1024];
                IntByReference lpNumberOfBytesRead = new IntByReference(0);
                Kernel32.INSTANCE.ReadFile(this.hNamedPipe, readBuffer, readBuffer.length, lpNumberOfBytesRead, null);
                int readSize = lpNumberOfBytesRead.getValue();
                ClientSingleton.toLog(this.TAG, "Received client data - length=" + readSize);
                ClientSingleton.toLog(this.TAG, "No data receieved from client" + (readSize > 0));
                if (readSize > 0) {
                    byte[] array = new String(readBuffer).replaceAll("\u0000", "").getBytes();
                    String number = new String(array, StandardCharsets.UTF_8);
                    ClientSingleton.toLog(this.TAG, "Data receieved from client : " + number);
                    if ("TO_FRONT".equals(number)) {
                        ClientSingleton.getInstance().showWindow();
                    } else {
                        if ("Close".equals(number)) break;
                        Click2Dial.makeCall(number);
                    }
                }
                Kernel32.INSTANCE.FlushFileBuffers(this.hNamedPipe);
                ClientSingleton.toLog(this.TAG, "Disconnecting");
                Kernel32.INSTANCE.DisconnectNamedPipe(this.hNamedPipe);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            Kernel32.INSTANCE.FlushFileBuffers(this.hNamedPipe);
            ClientSingleton.toLog(this.TAG, "Disconnecting");
            Kernel32.INSTANCE.DisconnectNamedPipe(this.hNamedPipe);
            ClientSingleton.toLog(this.TAG, "Disconnected");
            ClientSingleton.toLog(this.TAG, "Named pipe handle close");
            Kernel32.INSTANCE.CloseHandle(this.hNamedPipe);
        }).start();
        return this;
    }

    private String getCurrentPipeName() {
        return "\\\\.\\pipe\\UC_RINGOTEL_PIPE";
    }
}

