/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.connector.clientlisteners;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.clientlisteners.listeners.ClientListener;
import net.sipsnet.client.connector.clientlisteners.listeners.ContactListener;
import net.sipsnet.client.connector.clientlisteners.listeners.SessionListener;
import net.sipsnet.client.connector.observer.ClientObserver;
import net.sipsnet.client.connector.observer.IGUIObservable;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.constants.IntentConstants;
import net.sipsnet.client.views.calls.audiocontrolls.ILineListener;
import net.sipsnet.client.views.calls.audiocontrolls.LineInfoPane;
import smile.cti.client.ClientConnector;
import smile.cti.client.ContactEventListener;
import smile.cti.client.ContactInfo;
import smile.cti.client.LineEventListener;
import smile.cti.client.LineInfo;
import smile.cti.client.SessionEventListener;
import smile.cti.client.SessionInfo;

public class ClientListenersModel {
    private ClientListener clientListener;
    private ContactListener contactListener;
    private SessionListener sessionListener;
    private final int CLIENT_OBSERVER = 3;
    private final ObservableList<LineInfoPane> lineInfoPanes = FXCollections.observableArrayList();
    private final List<ClientObserver> observers = new ArrayList<ClientObserver>();
    private final List<List<String>> observersActions = new ArrayList<List<String>>();
    private final String TAG = this.getClass().getSimpleName();
    private final int notificationDelay = 200;

    public ClientListenersModel() {
        this.initObservers();
    }

    public ClientListener initClientListener() {
        if (this.clientListener == null) {
            this.clientListener = new ClientListener(this);
        }
        return this.clientListener;
    }

    public void initLineInfoListeners(ILineListener iLineListener) {
        Optional<ClientConnector> optionalClientConnector = ClientSingleton.getInstance().getClientConnector();
        if (optionalClientConnector.isEmpty()) {
            return;
        }
        List lineInfoList = optionalClientConnector.get().getLines();
        ClientSingleton.toLog(this.TAG, "initLineInfoListeners setListeners lines=" + lineInfoList);
        int currentViewPaneMode = 0;
        if (optionalClientConnector.get().getProperty(Constants.CURRENT_VIEW_MODE) != null) {
            currentViewPaneMode = (Integer)optionalClientConnector.get().getProperty(Constants.CURRENT_VIEW_MODE);
        }
        ClientSingleton.toLog(this.getClass().getSimpleName(), "onStart currentViewPaneMode " + currentViewPaneMode);
        boolean count = false;
        for (LineInfo lineInfo : lineInfoList) {
            ClientSingleton.toLog(this.TAG, "initLineInfoListeners lineiNFO: " + lineInfo + " lineInfo.getState()=" + lineInfo.getState());
            LineInfoPane lineInfoPane = new LineInfoPane(lineInfo, iLineListener, currentViewPaneMode);
            this.lineInfoPanes.add((Object)lineInfoPane);
            lineInfo.addLineEventListener((LineEventListener)lineInfoPane);
        }
        ClientSingleton.toLog(this.TAG, System.currentTimeMillis() + ": initLineInfoListeners done ");
    }

    public ObservableList<LineInfoPane> getLineInfoPanes() {
        return this.lineInfoPanes;
    }

    public int getCurrentState() {
        return this.clientListener.getCurrentClientState();
    }

    private void setSessionListeners() throws Exception {
        Optional<ClientConnector> optionalClientConnector;
        ClientSingleton.toLog(this.TAG, "setSessionListeners");
        if (this.sessionListener == null) {
            this.sessionListener = new SessionListener(this);
            ClientSingleton.toLog(this.TAG, "create sessionListener=" + this.sessionListener.hashCode());
        }
        if ((optionalClientConnector = ClientSingleton.getInstance().getClientConnector()).isEmpty()) {
            return;
        }
        AtomicInteger atomicInteger = new AtomicInteger();
        ClientSingleton.getInstance().getSessionInfoStream().filter(sessionInfo -> sessionInfo.getStatus() != 10).forEach(sessionInfo -> {
            for (Object object : sessionInfo.getSessionEventListeners()) {
                if (!(object instanceof SessionListener)) continue;
                sessionInfo.removeSessionEventListener((SessionEventListener)((SessionListener)object));
            }
            atomicInteger.addAndGet(1);
            this.addSessionListener((SessionInfo)sessionInfo);
        });
        ClientSingleton.toLog(this.TAG, "setSessionListeners initiated=" + atomicInteger);
    }

    private void setContactListeners() throws Exception {
        Optional<ClientConnector> optionalClientConnector;
        ClientSingleton.toLog(this.TAG, "setContactListeners");
        if (this.contactListener == null) {
            this.contactListener = new ContactListener(this);
            ClientSingleton.toLog(this.TAG, "create contactListener=" + this.contactListener.hashCode());
        }
        if ((optionalClientConnector = ClientSingleton.getInstance().getClientConnector()).isEmpty()) {
            return;
        }
        this.iniContactsListeners();
    }

    private void iniContactsListeners() {
        AtomicInteger atomicInteger = new AtomicInteger();
        AtomicBoolean isHasError = new AtomicBoolean();
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            Iterator iterator = clientConnector.getContactInfos();
            while (iterator.hasNext()) {
                ContactInfo contactInfo = (ContactInfo)iterator.next();
                if (contactInfo.toString() == null || contactInfo.toString().isEmpty()) continue;
                try {
                    for (Object object : contactInfo.getContactEventListeners()) {
                        if (!(object instanceof ContactListener)) continue;
                        contactInfo.removeListener((ContactEventListener)((ContactListener)object));
                    }
                    atomicInteger.addAndGet(1);
                    contactInfo.addListener((ContactEventListener)this.contactListener);
                }
                catch (Exception ex) {
                    isHasError.set(true);
                    ex.printStackTrace();
                }
            }
        });
        ClientSingleton.toLog(this.TAG, "setContactListeners initiated=" + atomicInteger);
        isHasError.get();
    }

    public void initObservers() {
        this.observers.clear();
        this.observersActions.clear();
        this.observers.add(ClientObserver.getInstance("chatMessageObserver").startWithScheduled(200));
        this.observers.add(ClientObserver.getInstance("contactsMessageObserver").startWithScheduled(200));
        this.observers.add(ClientObserver.getInstance("sessionsMessageObserver").startWithScheduled(200));
        this.observers.add(ClientObserver.getInstance("clientObserver").startWithScheduled(200));
        this.observersActions.add(Arrays.asList(Constants.EDIT_MESSAGE, Constants.REMOVE_HIDEN_MESSAGE, Constants.REPAINT_CHAT_MESSAGE));
        this.observersActions.add(Arrays.asList(IntentConstants.CONTACT_STATUS_CHANGED, IntentConstants.CONTACT_IMAGE_LOAD, IntentConstants.CONTACT_ADDED, IntentConstants.CONTACT_STATE_CHANGED, IntentConstants.CONTACT_LIST_UPDATED, IntentConstants.CONTACT_IMAGE_CHANGED));
        this.observersActions.add(Arrays.asList(IntentConstants.ON_FOCUSED, IntentConstants.SESSION_IMAGE_LOAD, IntentConstants.SESSION_CREATED, IntentConstants.SESSION_REMOVED, Constants.CHECK_NEW_MESSAGES, Constants.OPEN_SESSION, Constants.OPEN_PROFILE, Constants.OPEN_PROFILE_EDITOR, "clearChatMessagePane", Constants.SEARCH_CALLS_EXT, Constants.SEARCH_SESSIONS_EXT));
        this.observersActions.add(new ArrayList());
    }

    public void shutDown() {
        for (ClientObserver clientObserver : this.observers) {
            clientObserver.shutDown();
        }
    }

    public void initListeners() {
        try {
            this.setSessionListeners();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.setContactListeners();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.notifyMessage(IntentConstants.INIT_OK, null);
    }

    public void addContactListener(ContactInfo contactInfo) {
        contactInfo.addListener((ContactEventListener)this.contactListener);
    }

    public void removeContactListener(ContactInfo contactInfo) {
        contactInfo.removeListener((ContactEventListener)this.contactListener);
    }

    public void addSessionListener(SessionInfo sessionInfo) {
        sessionInfo.addSessionEventListener((SessionEventListener)this.sessionListener);
    }

    public void notifyMessage(String action, Map<String, Object> map) {
        this.getObserver(action).onNotifiedMessage(action, map);
    }

    public void registerObserver(IGUIObservable iguiObservable, String[] actions) {
        for (String action : actions) {
            this.getObserver(action).registerObserver(iguiObservable, action);
        }
    }

    public void removeObserver(IGUIObservable iguiObservable, String[] actions) {
        for (String action : actions) {
            this.getObserver(action).removeObserver(iguiObservable, action);
        }
    }

    private ClientObserver getObserver(String action) {
        int index = 0;
        for (List<String> actions : this.observersActions) {
            if (actions.contains(action)) {
                return this.observers.get(index);
            }
            ++index;
        }
        return this.observers.get(3);
    }

    public void checkObserversStates() {
        for (ClientObserver clientObserver : this.observers) {
            clientObserver.checkForRunning();
        }
    }

    public void releaseAllObservers() {
        this.observers.forEach(ClientObserver::releaseAllObservers);
    }
}

