/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.connector.clientlisteners.listeners;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.clientlisteners.ClientListenersModel;
import net.sipsnet.client.connector.utils.AudioCaller;
import net.sipsnet.client.connector.utils.ClientUtil;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.constants.IntentConstants;
import net.sipsnet.client.views.chat.messageutil.MessageInfoCellLabels;
import smile.cti.client.ClientEventListener;
import smile.cti.client.ContactGroup;
import smile.cti.client.ContactInfo;
import smile.cti.client.FileInfo;
import smile.cti.client.MessageInfo;
import smile.cti.client.SessionInfo;
import smile.cti.phone.DeviceListener;

public class ClientListener
implements ClientEventListener,
DeviceListener {
    private final ClientListenersModel clientListenersModel;

    public ClientListener(ClientListenersModel clientListenersModel) {
        this.clientListenersModel = clientListenersModel;
        ClientSingleton.toLog(this.toString(), "------------------------------------ init ClientListener------------------");
    }

    public void initOk() {
        ClientSingleton.toLog(this.toString(), "initOk");
        ClientSingleton.getInstance().initListeners();
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> clientConnector.getPhoneDevice().setDeviceListener((DeviceListener)this));
        ClientSingleton.getInstance().onRegistrationApp();
        if (ClientUtil.getOS() == ClientUtil.OS.WINDOWS) {
            ClientSingleton.getInstance().startServices();
        }
    }

    public void initError(String s) {
        ClientSingleton.toLog(this.toString(), "initError : " + s);
        String message = s;
        if ("Forbidden".equals(s)) {
            message = ClientSingleton.getInstance().getString("connect_forbidden_warning");
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(Constants.THROW_MESSAGE, message);
        if ("Forbidden".equals(s)) {
            ClientSingleton.getInstance().onNotRegistrationApp(data);
        } else {
            ClientSingleton.getInstance().onInitError(data);
        }
    }

    public void commandReceived(String command, Map parameters) {
        ClientSingleton.toLog("ClientListener", "commandReceived command=" + command + " map=" + parameters);
        if (command.equals("initCall")) {
            AudioCaller.makeCall((String)parameters.get("party_number"), true);
        } else if (command.equals("answerCall")) {
            AudioCaller.answerCall();
        } else if (command.equals("dropCall")) {
            AudioCaller.dropCall(AudioCaller.getActiveLine());
        } else if (command.equals("runApplication")) {
            this.runApplication(parameters);
        }
    }

    public void searchUpdated() {
        ClientSingleton.getInstance().getMainViewModel().searchUpdated();
    }

    public void contactGroupsListChanged() {
        ClientSingleton.toLog("ClientListener", "contactGroupsListChanged");
        ClientSingleton.getInstance().getMainViewModel().contactGroupsListChanged();
    }

    public void contactListUploaded() {
        ClientSingleton.toLog("ClientListener", "contactListUploaded");
        this.clientListenersModel.notifyMessage(IntentConstants.CONTACT_LIST_UPDATED, null);
    }

    private void runApplication(Map map) {
        String url = (String)map.get("url");
        ClientSingleton.toLog("ClientListener", "url = " + url);
        if (url != null) {
            if (MessageInfoCellLabels.isLink(url)) {
                ClientSingleton.getInstance().openWebBrowser(url);
            } else if (ClientUtil.getOS() == ClientUtil.OS.WINDOWS) {
                try {
                    String prefix = url.contains(".exe") ? ".exe" : (url.contains(".bat") ? ".bat" : "");
                    ClientSingleton.toLog("ClientListener", "prefix = " + prefix);
                    if (!prefix.isEmpty()) {
                        int index = url.indexOf(prefix);
                        String apps = url.substring(0, index + 4);
                        String sParams = url.substring(index + 4).trim();
                        String[] aParams = sParams.split(" ");
                        String[] params = new String[aParams.length + 1];
                        params[0] = apps;
                        for (int i = 0; i < aParams.length; ++i) {
                            if (i + 1 > aParams.length) continue;
                            params[i + 1] = aParams[i];
                        }
                        Arrays.stream(params).forEach(s -> ClientSingleton.toLog("ClientListener", "params = " + s));
                        Runtime.getRuntime().exec(params);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public ContactInfo findContact(String s) {
        return null;
    }

    public void contactAdded(ContactInfo contactInfo) {
        ClientSingleton.toLog("ClientListener", "contactAdded getUserID :" + ClientSingleton.getInstance().getUserID(contactInfo) + " contact=" + contactInfo.getName() + " status=" + contactInfo.getStatus() + " isCustom = " + contactInfo.isCustom() + " id=" + ClientSingleton.getInstance().getUserID(contactInfo) + " contactInfo.isSpeedDial()=" + contactInfo.isSpeedDial() + " contactInfo.isBlf()=" + contactInfo.isBlf() + "\ncontactInfo.getUserDetails()" + contactInfo.getUserDetails() + " contactInfo.getCustomDetails()=" + contactInfo.getCustomDetails());
        ClientSingleton.getInstance().addContactListener(contactInfo);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("contactInfo", contactInfo);
        this.clientListenersModel.notifyMessage(IntentConstants.CONTACT_ADDED, data);
    }

    public void contactRemoved(ContactInfo contactInfo) {
        ClientSingleton.toLog("ClientListener", "contactRemoved  getUserID :" + ClientSingleton.getInstance().getUserID(contactInfo) + " contact=" + contactInfo.getName() + " status=" + contactInfo.getStatus() + " isCustom = " + contactInfo.isCustom() + " id=" + ClientSingleton.getInstance().getUserID(contactInfo) + " contactInfo.getState()=" + contactInfo.getState());
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("contactInfo", contactInfo);
        this.clientListenersModel.notifyMessage(IntentConstants.CONTACT_REMOVED, data);
        ClientSingleton.getInstance().removeContactListener(contactInfo);
    }

    public void contactStatusChanged(ContactInfo contactInfo) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("contactInfo", contactInfo);
        this.clientListenersModel.notifyMessage(IntentConstants.CONTACT_STATUS_CHANGED, data);
    }

    public void contactImageChanged(ContactInfo contactInfo) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("contactInfo", contactInfo);
        this.clientListenersModel.notifyMessage(IntentConstants.CONTACT_IMAGE_CHANGED, data);
    }

    public void groupAdded(ContactGroup group) {
        ClientSingleton.toLog(this.toString(), "groupAdded=" + group);
        this.clientListenersModel.notifyMessage(Constants.GROUP_UPDATED, null);
    }

    public void groupRemoved(ContactGroup group) {
        this.clientListenersModel.notifyMessage(Constants.GROUP_REMOVED, null);
    }

    public void stateChanged(int state) {
        ClientSingleton.toLog("ClientListener", "CLIENT_STATE_CHANGED owner  state=" + state);
        ClientSingleton.getInstance().checkObserversStates();
        ClientSingleton.getInstance().getMainViewModel().clientStateChanged(state);
    }

    public int getCurrentClientState() {
        return ClientSingleton.getInstance().getClientConnector().get().getUserState();
    }

    public void sessionCreated(SessionInfo sessionInfo) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "sessionCreated sessionInfo=" + sessionInfo + " sessionInfo.getSessionId() = " + sessionInfo.getSessionId());
        ClientSingleton.getInstance().addSessionListener(sessionInfo);
        sessionInfo.setProperty("messageTTL", (Object)-1);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("sessionInfo", sessionInfo);
        this.clientListenersModel.notifyMessage(IntentConstants.SESSION_CREATED, data);
    }

    public void sessionUpdated(SessionInfo sessionInfo) {
        ClientSingleton.getInstance().getSessionInfo(sessionInfo.getSessionId()).ifPresent(sessionInfo1 -> ClientSingleton.toLog(this.getClass().getSimpleName(), "sessionUpdated sessionInfo1=" + sessionInfo1 + " (" + sessionInfo1.hashCode() + ")"));
        ClientSingleton.toLog(this.getClass().getSimpleName(), "sessionUpdated sessionInfo=" + sessionInfo + " (" + sessionInfo.hashCode() + ") sessionInfo.getSessionId() = " + sessionInfo.getSessionId() + " PIN_CHAT = " + sessionInfo.getProperty("PinChat"));
        ClientSingleton.getInstance().sessionUpdated(sessionInfo);
        ClientSingleton.getInstance().doNotify(Constants.UPDATE_SESSIONS_LIST);
    }

    public void messageReceived(MessageInfo messageInfo, SessionInfo sessionInfo) {
    }

    public void messageDeleted(MessageInfo messageInfo, SessionInfo sessionInfo) {
        ClientSingleton.toLog(this.toString(), "messageDeleted=" + messageInfo);
        ClientSingleton.getInstance().getMainViewModel().onMessageRemoved(sessionInfo, messageInfo);
    }

    public void messageUpdated(MessageInfo messageInfo, SessionInfo sessionInfo) {
    }

    public void messageQueueUpdated(MessageInfo messageInfo) {
        ClientSingleton.toLog(this.toString(), "messageQueueUpdated=" + messageInfo.getContent());
    }

    public void fileLoaded(FileInfo fileInfo) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("messageInfo", fileInfo);
        this.clientListenersModel.notifyMessage(IntentConstants.FILE_LOADED, data);
        this.clientListenersModel.notifyMessage(Constants.REPAINT_CHAT_MESSAGE, data);
    }

    public void sessionDeleted(SessionInfo sessionInfo) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "sessionDeleted " + sessionInfo + " sessionId=" + sessionInfo.getSessionId());
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("sessionInfo", sessionInfo);
        this.clientListenersModel.notifyMessage(IntentConstants.SESSION_REMOVED, data);
    }

    public void assistantStateChanged(int state, String deviceInfo) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "assistantCallState assistantStateChanged = " + state + " SipDevice=" + ClientSingleton.getInstance().getConnectedSipDevice());
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(Constants.DEVICE_INFO, deviceInfo);
        this.clientListenersModel.notifyMessage(state != 0 ? Constants.ASSISTANT_STATUS_REGISTERED : Constants.ASSISTANT_STATUS_UNREGISTERED, data);
    }

    public void assistantCallState(int callState) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "assistantCallState callState = " + callState);
        String notificationState = Constants.ASSISTANT_STATE_EXCEPTION;
        switch (callState) {
            case 0: {
                notificationState = Constants.ASSISTANT_STATE_DIALING;
                break;
            }
            case 2: {
                notificationState = Constants.ASSISTANT_STATE_NO_ANSWERED;
            }
        }
        if (callState != 1) {
            this.clientListenersModel.notifyMessage(notificationState, null);
        }
    }

    public void deviceAdded(String deviceInfo) {
        boolean isSendNotification = this.isSendNotification();
        ClientSingleton.toLog(this.getClass().getSimpleName(), "deviceAdded deviceInfo=" + deviceInfo + " isSendNotification=" + isSendNotification);
        if (isSendNotification) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put(Constants.DEVICE_INFO, deviceInfo);
            this.clientListenersModel.notifyMessage(Constants.PHONE_DEVICE_ADDED, data);
        }
    }

    public void deviceRemoved(String deviceInfo) {
        boolean isSendNotification = this.isSendNotification();
        ClientSingleton.toLog(this.getClass().getSimpleName(), "deviceRemoved deviceInfo=" + deviceInfo + " isSendNotification=" + isSendNotification);
        if (isSendNotification) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put(Constants.DEVICE_INFO, deviceInfo);
            this.clientListenersModel.notifyMessage(Constants.PHONE_DEVICE_REMOVED, data);
        }
    }

    private boolean isSendNotification() {
        AtomicBoolean atomicBoolean = new AtomicBoolean(true);
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            Object property = clientConnector.getProperty(Constants.AUDIO_DEVICES_NOTIFICATION);
            if (property != null) {
                atomicBoolean.set((Boolean)property);
            }
        });
        return atomicBoolean.get();
    }
}

